/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.Vec;
import water.fvec.WrappedVec;

public class SubsetVec
extends WrappedVec {
    final Key _subsetRowsKey;
    transient Vec _rows;

    public SubsetVec(Key key, int rowLayout, Key masterVecKey, Key subsetRowsKey) {
        super((Key<Vec>)key, rowLayout, masterVecKey);
        this._subsetRowsKey = subsetRowsKey;
    }

    public Vec rows() {
        if (this._rows == null) {
            this._rows = (Vec)DKV.get(this._subsetRowsKey).get();
        }
        return this._rows;
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        Chunk crows = this.rows().chunkForChunkIdx(cidx);
        return new SubsetChunk(crows, this, this.masterVec());
    }

    @Override
    public Futures remove_impl(Futures fs, boolean cascade) {
        Keyed.remove(this._subsetRowsKey, fs, true);
        return super.remove_impl(fs, cascade);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putKey(this._subsetRowsKey);
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        ab.getKey(this._subsetRowsKey, fs);
        return super.readAll_impl(ab, fs);
    }

    static class SubsetChunk
    extends Chunk {
        final Chunk _crows;
        final Vec _masterVec;

        protected SubsetChunk(Chunk crows, SubsetVec vec, Vec masterVec) {
            this._vec = vec;
            this._masterVec = masterVec;
            this._len = crows._len;
            this._start = crows._start;
            this._crows = crows;
            this._cidx = crows._cidx;
        }

        @Override
        protected double atd_impl(int idx) {
            long rownum = this._crows.at8_impl(idx);
            return this._masterVec.at(rownum);
        }

        @Override
        protected long at8_impl(int idx) {
            long rownum = this._crows.at8_impl(idx);
            return this._masterVec.at8(rownum);
        }

        @Override
        protected boolean isNA_impl(int idx) {
            long rownum = this._crows.at8_impl(idx);
            return this._masterVec.isNA(rownum);
        }

        @Override
        boolean set_impl(int idx, long l2) {
            return false;
        }

        @Override
        boolean set_impl(int idx, double d2) {
            return false;
        }

        @Override
        boolean set_impl(int idx, float f2) {
            return false;
        }

        @Override
        boolean setNA_impl(int idx) {
            return false;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            throw H2O.unimpl();
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            throw H2O.unimpl();
        }

        @Override
        public boolean hasFloat() {
            return false;
        }

        public static AutoBuffer write_impl(SubsetChunk sc, AutoBuffer bb) {
            throw H2O.fail();
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }
    }
}

