/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.math.BigInteger;

public final class RyuDouble {
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_EXPONENT_BITS = 11;
    private static final int DOUBLE_EXPONENT_MASK = 2047;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int POS_TABLE_SIZE = 326;
    private static final int NEG_TABLE_SIZE = 291;
    private static final BigInteger[] POW5 = new BigInteger[326];
    private static final BigInteger[] POW5_INV = new BigInteger[291];
    private static final int POW5_BITCOUNT = 121;
    private static final int POW5_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[326][4];
    private static final int POW5_INV_BITCOUNT = 122;
    private static final int POW5_INV_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[291][4];

    public static String doubleToString(double value) {
        long output;
        int e10;
        long dm;
        long dp;
        long dv;
        int q2;
        long m22;
        int e2;
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L) {
            return "0.0";
        }
        if (bits == Long.MIN_VALUE) {
            return "-0.0";
        }
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m22 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m22 = ieeeMantissa | 0x10000000000000L;
        }
        boolean sign = bits < 0L;
        boolean even = (m22 & 1L) == 0L;
        long mv = 4L * m22;
        long mp = 4L * m22 + 2L;
        int mmShift = m22 != 0x10000000000000L || ieeeExponent <= 1 ? 1 : 0;
        long mm4 = 4L * m22 - 1L - (long)mmShift;
        boolean dmIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        if ((e2 -= 2) >= 0) {
            q2 = Math.max(0, (e2 * 78913 >>> 18) - 1);
            int k2 = 122 + RyuDouble.pow5bits(q2) - 1;
            int i2 = -e2 + q2 + k2;
            dv = RyuDouble.mulPow5InvDivPow2(mv, q2, i2);
            dp = RyuDouble.mulPow5InvDivPow2(mp, q2, i2);
            dm = RyuDouble.mulPow5InvDivPow2(mm4, q2, i2);
            e10 = q2;
            if (q2 <= 21) {
                if (mv % 5L == 0L) {
                    dvIsTrailingZeros = RyuDouble.multipleOfPowerOf5(mv, q2);
                } else if (even) {
                    dmIsTrailingZeros = RyuDouble.multipleOfPowerOf5(mm4, q2);
                } else if (RyuDouble.multipleOfPowerOf5(mp, q2)) {
                    --dp;
                }
            }
        } else {
            q2 = Math.max(0, (-e2 * 732923 >>> 20) - 1);
            int i3 = -e2 - q2;
            int k3 = RyuDouble.pow5bits(i3) - 121;
            int j2 = q2 - k3;
            dv = RyuDouble.mulPow5divPow2(mv, i3, j2);
            dp = RyuDouble.mulPow5divPow2(mp, i3, j2);
            dm = RyuDouble.mulPow5divPow2(mm4, i3, j2);
            e10 = q2 + e2;
            if (q2 <= 1) {
                dvIsTrailingZeros = true;
                if (even) {
                    dmIsTrailingZeros = mmShift == 1;
                } else {
                    --dp;
                }
            } else if (q2 < 63) {
                dvIsTrailingZeros = (mv & (1L << q2 - 1) - 1L) == 0L;
            }
        }
        int vplength = RyuDouble.decimalLength(dp);
        int exp = e10 + vplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros || dvIsTrailingZeros) {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dvIsTrailingZeros &= lastRemovedDigit == 0;
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            if (dmIsTrailingZeros && even) {
                while (!(dm % 10L != 0L || dp < 100L && scientificNotation)) {
                    dvIsTrailingZeros &= lastRemovedDigit == 0;
                    lastRemovedDigit = (int)(dv % 10L);
                    dp /= 10L;
                    dv /= 10L;
                    dm /= 10L;
                    ++removed;
                }
            }
            if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                lastRemovedDigit = 4;
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        int olength = vplength - removed;
        byte[] result = new byte[24];
        int index = 0;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i4 = 0; i4 < olength - 1; ++i4) {
                int c2 = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i4] = (byte)(48 + c2);
            }
            result[index] = (byte)(48L + output % 10L);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 100) {
                result[index++] = (byte)(48 + exp / 100);
                result[index++] = (byte)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (byte)(48 + exp / 10);
            }
            result[index++] = (byte)(48 + exp % 10);
            return new String(result, 0, index);
        }
        if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i5 = -1; i5 > exp; --i5) {
                result[index++] = 48;
            }
            int current = index;
            for (int i6 = 0; i6 < olength; ++i6) {
                result[current + olength - i6 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i7;
            for (i7 = 0; i7 < olength; ++i7) {
                result[index + olength - i7 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i7 = olength; i7 < exp + 1; ++i7) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            int current = index + 1;
            for (int i8 = 0; i8 < olength; ++i8) {
                if (olength - i8 - 1 == exp) {
                    result[current + olength - i8 - 1] = 46;
                    --current;
                }
                result[current + olength - i8 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        return new String(result, 0, index);
    }

    private static int pow5bits(int e2) {
        return (e2 * 1217359 >>> 19) + 1;
    }

    private static int decimalLength(long v2) {
        if (v2 >= 1000000000000000000L) {
            return 19;
        }
        if (v2 >= 100000000000000000L) {
            return 18;
        }
        if (v2 >= 10000000000000000L) {
            return 17;
        }
        if (v2 >= 1000000000000000L) {
            return 16;
        }
        if (v2 >= 100000000000000L) {
            return 15;
        }
        if (v2 >= 10000000000000L) {
            return 14;
        }
        if (v2 >= 1000000000000L) {
            return 13;
        }
        if (v2 >= 100000000000L) {
            return 12;
        }
        if (v2 >= 10000000000L) {
            return 11;
        }
        if (v2 >= 1000000000L) {
            return 10;
        }
        if (v2 >= 100000000L) {
            return 9;
        }
        if (v2 >= 10000000L) {
            return 8;
        }
        if (v2 >= 1000000L) {
            return 7;
        }
        if (v2 >= 100000L) {
            return 6;
        }
        if (v2 >= 10000L) {
            return 5;
        }
        if (v2 >= 1000L) {
            return 4;
        }
        if (v2 >= 100L) {
            return 3;
        }
        if (v2 >= 10L) {
            return 2;
        }
        return 1;
    }

    private static boolean multipleOfPowerOf5(long value, int q2) {
        return RyuDouble.pow5Factor(value) >= q2;
    }

    private static int pow5Factor(long value) {
        if (value % 5L != 0L) {
            return 0;
        }
        if (value % 25L != 0L) {
            return 1;
        }
        if (value % 125L != 0L) {
            return 2;
        }
        if (value % 625L != 0L) {
            return 3;
        }
        int count2 = 4;
        value /= 625L;
        while (value > 0L) {
            if (value % 5L != 0L) {
                return count2;
            }
            value /= 5L;
            ++count2;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(long m4, int i2, int j2) {
        long mHigh = m4 >>> 31;
        long mLow = m4 & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_SPLIT[i2][0];
        long bits03 = mLow * (long)POW5_SPLIT[i2][0];
        long bits12 = mHigh * (long)POW5_SPLIT[i2][1];
        long bits02 = mLow * (long)POW5_SPLIT[i2][1];
        long bits11 = mHigh * (long)POW5_SPLIT[i2][2];
        long bits01 = mLow * (long)POW5_SPLIT[i2][2];
        long bits10 = mHigh * (long)POW5_SPLIT[i2][3];
        long bits00 = mLow * (long)POW5_SPLIT[i2][3];
        int actualShift = j2 - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    private static long mulPow5InvDivPow2(long m4, int i2, int j2) {
        long mHigh = m4 >>> 31;
        long mLow = m4 & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_INV_SPLIT[i2][0];
        long bits03 = mLow * (long)POW5_INV_SPLIT[i2][0];
        long bits12 = mHigh * (long)POW5_INV_SPLIT[i2][1];
        long bits02 = mLow * (long)POW5_INV_SPLIT[i2][1];
        long bits11 = mHigh * (long)POW5_INV_SPLIT[i2][2];
        long bits01 = mLow * (long)POW5_INV_SPLIT[i2][2];
        long bits10 = mHigh * (long)POW5_INV_SPLIT[i2][3];
        long bits00 = mLow * (long)POW5_INV_SPLIT[i2][3];
        int actualShift = j2 - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    static {
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger invMask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        for (int i2 = 0; i2 < Math.max(POW5.length, POW5_INV.length); ++i2) {
            BigInteger inv;
            int j2;
            BigInteger pow = BigInteger.valueOf(5L).pow(i2);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = RyuDouble.pow5bits(i2);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i2 < POW5.length) {
                RyuDouble.POW5[i2] = pow;
            }
            if (i2 < POW5_SPLIT.length) {
                for (j2 = 0; j2 < 4; ++j2) {
                    RyuDouble.POW5_SPLIT[i2][j2] = pow.shiftRight(pow5len - 121 + (3 - j2) * 31).and(mask).intValueExact();
                }
            }
            if (i2 >= POW5_INV_SPLIT.length) continue;
            j2 = pow5len - 1 + 122;
            RyuDouble.POW5_INV[i2] = inv = BigInteger.ONE.shiftLeft(j2).divide(pow).add(BigInteger.ONE);
            for (int k2 = 0; k2 < 4; ++k2) {
                RyuDouble.POW5_INV_SPLIT[i2][k2] = k2 == 0 ? inv.shiftRight((3 - k2) * 31).intValueExact() : inv.shiftRight((3 - k2) * 31).and(invMask).intValueExact();
            }
        }
    }
}

