/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.Futures;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class RebalanceDataSet
extends H2O.H2OCountedCompleter {
    final Frame _in;
    final int _nchunks;
    Key _okey;
    Frame _out;
    final Key _jobKey;
    final transient Vec.VectorGroup _vg;
    transient long[] _espc;

    public RebalanceDataSet(Frame modelFrame, Frame srcFrame, Key dstKey) {
        this(modelFrame, srcFrame, dstKey, null, null);
    }

    public RebalanceDataSet(Frame modelFrame, Frame srcFrame, Key dstKey, H2O.H2OCountedCompleter cmp, Key jobKey) {
        super(cmp);
        this._in = srcFrame;
        this._jobKey = jobKey;
        this._okey = dstKey;
        this._espc = modelFrame.anyVec().espc();
        this._vg = modelFrame.anyVec().group();
        this._nchunks = modelFrame.anyVec().nChunks();
    }

    public RebalanceDataSet(Frame srcFrame, Key dstKey, int nchunks) {
        this(srcFrame, dstKey, nchunks, null, null);
    }

    public RebalanceDataSet(Frame srcFrame, Key dstKey, int nchunks, H2O.H2OCountedCompleter cmp, Key jobKey) {
        super(cmp);
        this._in = srcFrame;
        this._nchunks = nchunks;
        this._jobKey = jobKey;
        this._okey = dstKey;
        this._vg = new Vec.VectorGroup();
    }

    public Frame getResult() {
        this.join();
        return this._out;
    }

    @Override
    public void compute2() {
        long[] espc;
        if (this._espc != null) {
            espc = this._espc;
        } else {
            int rpc = (int)(this._in.numRows() / (long)this._nchunks);
            int rem = (int)(this._in.numRows() % (long)this._nchunks);
            espc = new long[this._nchunks + 1];
            Arrays.fill(espc, (long)rpc);
            int i2 = 0;
            while (i2 < rem) {
                int n2 = i2++;
                espc[n2] = espc[n2] + 1L;
            }
            long sum = 0L;
            for (int i3 = 0; i3 < espc.length; ++i3) {
                long s2 = espc[i3];
                espc[i3] = sum;
                sum += s2;
            }
            assert (espc[espc.length - 1] == this._in.numRows()) : "unexpected number of rows, expected " + this._in.numRows() + ", got " + espc[espc.length - 1];
        }
        int rowLayout = Vec.ESPC.rowLayout(this._vg._key, espc);
        Vec[] srcVecs = this._in.vecs();
        this._out = new Frame(this._okey, this._in.names(), new Vec(this._vg.addVec(), rowLayout).makeCons(srcVecs.length, 0L, this._in.domains(), this._in.types()));
        this._out.delete_and_lock(this._jobKey);
        new RebalanceTask((H2O.H2OCountedCompleter)this, srcVecs).dfork(this._out);
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        assert (this._out.numRows() == this._in.numRows());
        Vec vec = this._out.anyVec();
        assert (vec.nChunks() == this._nchunks);
        this._out.update(this._jobKey);
        this._out.unlock(this._jobKey);
    }

    @Override
    public boolean onExceptionalCompletion(Throwable t2, CountedCompleter caller) {
        t2.printStackTrace();
        if (this._out != null) {
            this._out.delete(this._jobKey, new Futures(), true).blockForPending();
        }
        return true;
    }

    public static class RebalanceTask
    extends MRTask<RebalanceTask> {
        final Vec[] _srcVecs;

        public RebalanceTask(H2O.H2OCountedCompleter cmp, Vec ... srcVecs) {
            super(cmp);
            this._srcVecs = srcVecs;
        }

        @Override
        public boolean logVerbose() {
            return false;
        }

        private void rebalanceChunk(int i2, Chunk c2, NewChunk nc) {
            int x2;
            Vec srcVec = this._srcVecs[i2];
            int N2 = c2._len;
            int lastId = -1;
            for (int len = 0; N2 > len; len += x2) {
                Chunk srcRaw = srcVec.chunkForRow(c2._start + (long)len);
                assert (lastId == -1 || lastId == srcRaw.cidx() - 1 || srcVec.chunk2StartElem(lastId + 1) == srcVec.chunk2StartElem(srcRaw.cidx()));
                lastId = srcRaw.cidx();
                int off = (int)(c2._start + (long)len - srcRaw._start);
                assert (off >= 0 && off < srcRaw._len);
                x2 = Math.min(N2 - len, srcRaw._len - off);
                srcRaw.extractRows(nc, off, off + x2);
            }
            nc.close(this._fs);
        }

        @Override
        public void map(Chunk[] chks) {
            for (int c2 = 0; c2 < chks.length; ++c2) {
                this.rebalanceChunk(c2, chks[c2], new NewChunk(chks[c2]));
            }
        }
    }
}

