/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.Scope;
import water.Value;
import water.api.FramesHandler;
import water.api.schemas3.KeyV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.RyuDouble;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Merge;
import water.util.ArrayUtils;
import water.util.CompressionFactory;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class Frame
extends Lockable<Frame> {
    public String[] _names;
    private boolean _lastNameBig;
    private Key<Vec>[] _keys;
    private transient Vec[] _vecs;
    private transient Vec _col0;
    private long _naCnt = -1L;
    static final int MAX_EQ2_COLS = 100000;

    public static void deleteTempFrameAndItsNonSharedVecs(Frame tempFrame, Frame baseFrame) {
        Key<Vec>[] keys = tempFrame.keys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            if (baseFrame.find(keys[i2]) != -1) continue;
            Keyed.remove(keys[i2]);
        }
        if (tempFrame._key != null) {
            DKV.remove(tempFrame._key);
        }
    }

    public static Frame[] fetchAll() {
        Key[] frameKeys = KeySnapshot.globalKeysOfClass(Frame.class);
        ArrayList<Frame> frames = new ArrayList<Frame>(frameKeys.length);
        for (Key key : frameKeys) {
            Frame frame = FramesHandler.getFromDKV("(none)", key);
            boolean skip = false;
            for (Vec vec : frame.vecs()) {
                if (vec != null && DKV.get(vec._key) != null) continue;
                Log.warn("Leaked frame: Frame " + frame._key + " points to one or more deleted vecs.");
                skip = true;
                break;
            }
            if (skip) continue;
            frames.add(frame);
        }
        return frames.toArray(new Frame[frames.size()]);
    }

    public boolean hasNAs() {
        for (Vec v2 : this.bulkRollups()) {
            if (v2.naCnt() <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfs() {
        for (Vec v2 : this.bulkRollups()) {
            if (v2.pinfs() <= 0L && v2.ninfs() <= 0L) continue;
            return true;
        }
        return false;
    }

    public synchronized long naCount() {
        if (this._naCnt != -1L) {
            return this._naCnt;
        }
        this._naCnt = 0L;
        for (Vec v2 : this.vecs()) {
            this._naCnt += v2.naCnt();
        }
        return this._naCnt;
    }

    public double naFraction() {
        return this.naCount() / ((long)this.numCols() * this.numRows());
    }

    public Frame(Vec ... vecs) {
        this((String[])null, vecs);
    }

    public Frame(String[] names, Vec[] vecs) {
        this(null, names, vecs);
    }

    public Frame(Key<Frame> key) {
        this(key, null, new Vec[0]);
    }

    public Frame(Key<Frame> key, Vec[] vecs) {
        this(key, null, vecs);
    }

    public Frame(Key<Frame> key, String[] names, Vec[] vecs) {
        super(key);
        int i2;
        for (Vec vec : vecs) {
            DKV.prefetch(vec._key);
        }
        for (i2 = 0; i2 < vecs.length; ++i2) {
            assert (DKV.get(vecs[i2]._key) != null) : " null vec: " + vecs[i2]._key + "; " + (names != null ? "name: " + names[i2] : "index: " + i2);
        }
        if (names == null) {
            this.setNames(new String[vecs.length]);
            this._keys = this.makeVecKeys(vecs.length);
            this._vecs = vecs;
            for (i2 = 0; i2 < vecs.length; ++i2) {
                this._names[i2] = Frame.defaultColName(i2);
            }
            for (i2 = 0; i2 < vecs.length; ++i2) {
                this._keys[i2] = vecs[i2]._key;
            }
            for (i2 = 0; i2 < vecs.length; ++i2) {
                this.checkCompatibility(this._names[i2], vecs[i2]);
            }
            this._lastNameBig = true;
        } else {
            this._names = new String[0];
            this._keys = this.makeVecKeys(0);
            this._vecs = new Vec[0];
            this.add(names, vecs);
        }
        assert (this._names.length == vecs.length);
    }

    void setNamesNoCheck(String[] columns) {
        this._names = columns;
    }

    public final void setNames(String[] columns) {
        if (this._vecs != null && columns.length != this._vecs.length) {
            throw new IllegalArgumentException("Number of column names=" + columns.length + " must be the number of vecs=" + this._vecs.length);
        }
        this._names = columns;
    }

    public Frame(Frame fr) {
        super(Key.make());
        this.setNames((String[])fr._names.clone());
        this._keys = (Key[])fr._keys.clone();
        this._vecs = (Vec[])fr.vecs().clone();
        this._lastNameBig = fr._lastNameBig;
    }

    public static String defaultColName(int col) {
        return "C" + (1 + col);
    }

    private Key<Vec>[] makeVecKeys(int size) {
        return new Key[size];
    }

    private int pint(String name) {
        try {
            return Integer.valueOf(name.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String uniquify(String name) {
        int again;
        String last;
        String n2 = name;
        int lastName = 0;
        if (name.length() > 0 && name.charAt(0) == 'C') {
            lastName = this.pint(name);
        }
        if (this._lastNameBig && this._names.length > 0 && !(last = this._names[this._names.length - 1]).equals("") && last.charAt(0) == 'C' && lastName == this.pint(last) + 1) {
            return name;
        }
        int cnt = 0;
        int max = 0;
        do {
            again = cnt;
            for (String s2 : this._names) {
                if (lastName > 0 && s2.charAt(0) == 'C') {
                    max = Math.max(max, this.pint(s2));
                }
                if (!n2.equals(s2)) continue;
                n2 = name + cnt++;
            }
        } while (again != cnt);
        if (lastName == max + 1) {
            this._lastNameBig = true;
        }
        return n2;
    }

    private void checkCompatibility(String name, Vec vec) {
        if (vec instanceof AppendableVec) {
            return;
        }
        Vec v0 = this.anyVec();
        if (v0 == null) {
            return;
        }
        if (!v0.isCompatibleWith(vec)) {
            if (!Vec.VectorGroup.sameGroup(v0, vec)) {
                Log.err("Unexpected incompatible vector group, " + v0.group() + " != " + vec.group());
            }
            if (!Arrays.equals(v0.espc(), vec.espc())) {
                Log.err("Unexpected incompatible espc, " + Arrays.toString(v0.espc()) + " != " + Arrays.toString(vec.espc()));
            }
            throw new IllegalArgumentException("Vec " + name + " is not compatible with the rest of the frame");
        }
    }

    public boolean isCompatible(Frame fr) {
        if (this.numRows() != fr.numRows()) {
            return false;
        }
        for (int i2 = 0; i2 < this.vecs().length; ++i2) {
            if (this.vecs()[i2].isCompatibleWith(fr.vecs()[i2])) continue;
            return false;
        }
        return true;
    }

    public int numCols() {
        return this._keys == null ? 0 : this._keys.length;
    }

    public long numRows() {
        Vec v2 = this.anyVec();
        return v2 == null ? 0L : v2.length();
    }

    public final Vec anyVec() {
        Vec c0 = this._col0;
        if (c0 != null) {
            return c0;
        }
        for (Vec v2 : this.vecs()) {
            if (!v2.readable()) continue;
            this._col0 = v2;
            return this._col0;
        }
        return null;
    }

    public String[] names() {
        return this._names;
    }

    public String name(int i2) {
        return this._names[i2];
    }

    public Key<Vec>[] keys() {
        return this._keys;
    }

    public Iterable<Key<Vec>> keysList() {
        return Arrays.asList(this._keys);
    }

    public final Vec[] vecs() {
        Vec[] vecArray;
        Vec[] tvecs = this._vecs;
        if (tvecs == null) {
            this._vecs = this.vecs_impl();
            vecArray = this._vecs;
        } else {
            vecArray = tvecs;
        }
        return vecArray;
    }

    public final Vec[] vecs(int[] idxs) {
        Vec[] all = this.vecs();
        Vec[] res = new Vec[idxs.length];
        for (int i2 = 0; i2 < idxs.length; ++i2) {
            res[i2] = all[idxs[i2]];
        }
        return res;
    }

    public Vec[] vecs(String[] names) {
        Vec[] res = new Vec[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            res[i2] = this.vec(names[i2]);
        }
        return res;
    }

    private Vec[] vecs_impl() {
        for (Key<Vec> key : this._keys) {
            DKV.prefetch(key);
        }
        Vec[] vecs = new Vec[this._keys.length];
        for (int i2 = 0; i2 < this._keys.length; ++i2) {
            vecs[i2] = this._keys[i2].get();
        }
        return vecs;
    }

    public Vec lastVec() {
        this.vecs();
        return this._vecs[this._vecs.length - 1];
    }

    public String lastVecName() {
        return this._names[this._names.length - 1];
    }

    public final Vec[] reloadVecs() {
        this._vecs = null;
        return this.vecs();
    }

    public final Vec vec(int idx) {
        return this.vecs()[idx];
    }

    public Vec vec(String name) {
        int idx = this.find(name);
        return idx == -1 ? null : this.vecs()[idx];
    }

    public int find(String name) {
        if (name == null) {
            return -1;
        }
        assert (this._names != null);
        for (int i2 = 0; i2 < this._names.length; ++i2) {
            if (!name.equals(this._names[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated
    public int find(Vec vec) {
        Vec[] vecs = this.vecs();
        if (vec == null) {
            return -1;
        }
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            if (!vec.equals(vecs[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated
    public int find(Key key) {
        for (int i2 = 0; i2 < this._keys.length; ++i2) {
            if (!key.equals(this._keys[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int[] find(String[] names) {
        if (names == null) {
            return null;
        }
        int[] res = new int[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            res[i2] = this.find(names[i2]);
        }
        return res;
    }

    public void insertVec(int i2, String name, Vec vec) {
        String[] names = new String[this._names.length + 1];
        Vec[] vecs = new Vec[this._vecs.length + 1];
        Key<Vec>[] keys = this.makeVecKeys(this._keys.length + 1);
        System.arraycopy(this._names, 0, names, 0, i2);
        System.arraycopy(this._vecs, 0, vecs, 0, i2);
        System.arraycopy(this._keys, 0, keys, 0, i2);
        names[i2] = name;
        vecs[i2] = vec;
        keys[i2] = vec._key;
        System.arraycopy(this._names, i2, names, i2 + 1, this._names.length - i2);
        System.arraycopy(this._vecs, i2, vecs, i2 + 1, this._vecs.length - i2);
        System.arraycopy(this._keys, i2, keys, i2 + 1, this._keys.length - i2);
        this._vecs = vecs;
        this.setNames(names);
        this._keys = keys;
    }

    public byte[] types() {
        Vec[] vecs = this.vecs();
        byte[] bs = new byte[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            bs[i2] = vecs[i2]._type;
        }
        return bs;
    }

    public String[] typesStr() {
        Vec[] vecs = this.vecs();
        String[] s2 = new String[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            s2[i2] = vecs[i2].get_type_str();
        }
        return s2;
    }

    public String[][] domains() {
        Vec[] vecs = this.vecs();
        String[][] ds = new String[vecs.length][];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            ds[i2] = vecs[i2].domain();
        }
        return ds;
    }

    public int[] cardinality() {
        Vec[] vecs = this.vecs();
        int[] card = new int[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            card[i2] = vecs[i2].cardinality();
        }
        return card;
    }

    public Vec[] bulkRollups() {
        Vec[] vecs;
        Futures fs = new Futures();
        for (Vec v2 : vecs = this.vecs()) {
            v2.startRollupStats(fs);
        }
        fs.blockForPending();
        return vecs;
    }

    public int[] modes() {
        Vec[] vecs = this.bulkRollups();
        int[] modes = new int[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            modes[i2] = vecs[i2].isCategorical() ? vecs[i2].mode() : -1;
        }
        return modes;
    }

    public double[] means() {
        Vec[] vecs = this.bulkRollups();
        double[] means = new double[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            means[i2] = vecs[i2].mean();
        }
        return means;
    }

    public double[] mults() {
        Vec[] vecs = this.bulkRollups();
        double[] mults = new double[vecs.length];
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            double sigma = vecs[i2].sigma();
            mults[i2] = Frame.standardize(sigma) ? 1.0 / sigma : 1.0;
        }
        return mults;
    }

    private static boolean standardize(double sigma) {
        return sigma > 1.0E-6;
    }

    public long byteSize() {
        try {
            Vec[] vecs = this.bulkRollups();
            long sum = 0L;
            for (Vec vec : vecs) {
                sum += vec.byteSize();
            }
            return sum;
        }
        catch (RuntimeException ex) {
            Log.debug("Failure to obtain byteSize() - missing chunks?");
            return -1L;
        }
    }

    @Override
    protected long checksum_impl(boolean noCache) {
        Vec[] vecs = this.vecs();
        long _checksum = 0L;
        for (int i2 = 0; i2 < this._names.length; ++i2) {
            long vec_checksum = vecs[i2].checksum(noCache);
            _checksum ^= vec_checksum;
            long tmp = Integer.MAX_VALUE * (long)i2;
            _checksum ^= tmp;
        }
        return _checksum *= (long)(47806 + Arrays.hashCode(this._names));
    }

    public void add(String[] names, Vec[] vecs) {
        this.bulkAdd(names, vecs);
    }

    public void add(String[] names, Vec[] vecs, int cols) {
        if (null == vecs || null == names) {
            return;
        }
        if (cols == names.length && cols == vecs.length) {
            this.bulkAdd(names, vecs);
        } else {
            for (int i2 = 0; i2 < cols; ++i2) {
                this.add(names[i2], vecs[i2]);
            }
        }
    }

    private void bulkAdd(String[] names, Vec[] vecs) {
        String[] tmpnames = (String[])names.clone();
        int N2 = names.length;
        assert (names.length == vecs.length) : "names = " + Arrays.toString(names) + ", vecs len = " + vecs.length;
        for (int i2 = 0; i2 < N2; ++i2) {
            vecs[i2] = vecs[i2] != null ? this.makeCompatible(new Frame(vecs[i2]))[0] : null;
            tmpnames[i2] = this.uniquify(tmpnames[i2]);
            this.checkCompatibility(tmpnames[i2], vecs[i2]);
        }
        int ncols = this._keys.length;
        String[] tmpnam = Arrays.copyOf(this._names, ncols + N2);
        Key<Vec>[] tmpkeys = Arrays.copyOf(this._keys, ncols + N2);
        Vec[] tmpvecs = Arrays.copyOf(this._vecs, ncols + N2);
        for (int i3 = 0; i3 < N2; ++i3) {
            tmpnam[ncols + i3] = tmpnames[i3];
            tmpkeys[ncols + i3] = vecs[i3]._key;
            tmpvecs[ncols + i3] = vecs[i3];
        }
        this._keys = tmpkeys;
        this._vecs = tmpvecs;
        this.setNames(tmpnam);
    }

    public Vec add(String name, Vec vec) {
        vec = this.makeCompatible(new Frame(vec))[0];
        name = this.uniquify(name);
        this.checkCompatibility(name, vec);
        int ncols = this._keys.length;
        String[] names = Arrays.copyOf(this._names, ncols + 1);
        names[ncols] = name;
        Key<Vec>[] keys = Arrays.copyOf(this._keys, ncols + 1);
        keys[ncols] = vec._key;
        Vec[] vecs = Arrays.copyOf(this._vecs, ncols + 1);
        vecs[ncols] = vec;
        this._keys = keys;
        this._vecs = vecs;
        this.setNames(names);
        return vec;
    }

    public Frame add(Frame fr) {
        this.add(fr._names, (Vec[])fr.vecs().clone(), fr.numCols());
        return this;
    }

    public Frame prepend(String name, Vec vec) {
        if (this.find(name) != -1) {
            throw new IllegalArgumentException("Duplicate name '" + name + "' in Frame");
        }
        if (this._vecs.length != 0) {
            if (!this.anyVec().group().equals(vec.group()) && !Arrays.equals(this.anyVec().espc(), vec.espc())) {
                throw new IllegalArgumentException("Vector groups differs - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
            if (this.numRows() != vec.length()) {
                throw new IllegalArgumentException("Vector lengths differ - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
        }
        int len = this._names != null ? this._names.length : 0;
        String[] _names2 = new String[len + 1];
        Vec[] _vecs2 = new Vec[len + 1];
        Key<Vec>[] _keys2 = this.makeVecKeys(len + 1);
        _names2[0] = name;
        _vecs2[0] = vec;
        _keys2[0] = vec._key;
        if (this._names != null) {
            System.arraycopy(this._names, 0, _names2, 1, len);
            System.arraycopy(this._vecs, 0, _vecs2, 1, len);
            System.arraycopy(this._keys, 0, _keys2, 1, len);
        }
        this._vecs = _vecs2;
        this._keys = _keys2;
        this.setNames(_names2);
        return this;
    }

    public void swap(int lo, int hi) {
        assert (0 <= lo && lo < this._keys.length);
        assert (0 <= hi && hi < this._keys.length);
        if (lo == hi) {
            return;
        }
        Vec[] vecs = this.vecs();
        Vec v2 = vecs[lo];
        vecs[lo] = vecs[hi];
        vecs[hi] = v2;
        Key<Vec> k2 = this._keys[lo];
        this._keys[lo] = this._keys[hi];
        this._keys[hi] = k2;
        String n2 = this._names[lo];
        this._names[lo] = this._names[hi];
        this._names[hi] = n2;
    }

    public void reOrder(int[] newOrder) {
        int colIndex;
        assert (newOrder.length == this._keys.length);
        int numCols = this._keys.length;
        Vec[] tmpvecs = (Vec[])this.vecs().clone();
        Key[] tmpkeys = (Key[])this._keys.clone();
        String[] tmpnames = (String[])this._names.clone();
        for (colIndex = 0; colIndex < numCols; ++colIndex) {
            tmpvecs[colIndex] = this._vecs[newOrder[colIndex]];
            tmpkeys[colIndex] = this._keys[newOrder[colIndex]];
            tmpnames[colIndex] = this._names[newOrder[colIndex]];
        }
        for (colIndex = 0; colIndex < numCols; ++colIndex) {
            this._vecs[colIndex] = tmpvecs[colIndex];
            this._keys[colIndex] = tmpkeys[colIndex];
            this._names[colIndex] = tmpnames[colIndex];
        }
    }

    public void moveFirst(int[] cols) {
        int i2;
        boolean[] colsMoved = new boolean[this._keys.length];
        Vec[] tmpvecs = (Vec[])this.vecs().clone();
        Key[] tmpkeys = (Key[])this._keys.clone();
        String[] tmpnames = (String[])this._names.clone();
        for (int i3 = 0; i3 < cols.length; ++i3) {
            int w2 = cols[i3];
            if (colsMoved[w2]) {
                throw new IllegalArgumentException("Duplicates in column numbers passed in");
            }
            if (w2 < 0 || w2 >= this._keys.length) {
                throw new IllegalArgumentException("column number out of 0-based range");
            }
            colsMoved[w2] = true;
            tmpvecs[i3] = this._vecs[w2];
            tmpkeys[i3] = this._keys[w2];
            tmpnames[i3] = this._names[w2];
        }
        int w3 = cols.length;
        for (i2 = 0; i2 < this._keys.length; ++i2) {
            if (colsMoved[i2]) continue;
            tmpvecs[w3] = this._vecs[i2];
            tmpkeys[w3] = this._keys[i2];
            tmpnames[w3] = this._names[i2];
            ++w3;
        }
        for (i2 = 0; i2 < this._keys.length; ++i2) {
            this._vecs[i2] = tmpvecs[i2];
            this._keys[i2] = tmpkeys[i2];
            this._names[i2] = tmpnames[i2];
        }
    }

    public Frame subframe(String[] names) {
        Vec[] vecs = new Vec[names.length];
        this.vecs();
        HashMap<String, Integer> map = new HashMap<String, Integer>((int)((float)names.length / 0.75f + 1.0f));
        for (int i2 = 0; i2 < this._names.length; ++i2) {
            map.put(this._names[i2], i2);
        }
        int missingCnt = 0;
        for (int i3 = 0; i3 < names.length; ++i3) {
            if (map.containsKey(names[i3])) {
                vecs[i3] = this._vecs[(Integer)map.get(names[i3])];
                continue;
            }
            ++missingCnt;
        }
        if (missingCnt > 0) {
            StringBuilder sb = new StringBuilder();
            int maxReported = missingCnt <= 5 ? missingCnt : 5;
            int reported = 0;
            for (int i4 = 0; i4 < names.length && reported < maxReported; ++i4) {
                if (vecs[i4] != null) continue;
                sb.append('\'').append(names[i4]).append('\'');
                if (++reported >= maxReported) continue;
                sb.append(", ");
            }
            if (reported < missingCnt) {
                sb.append(" (and other ").append(missingCnt - reported).append(")");
            }
            throw new IllegalArgumentException("Frame `" + this._key + "` doesn't contain columns: " + sb.toString() + ".");
        }
        return new Frame(Key.make("subframe" + Key.make().toString()), names, vecs);
    }

    public Futures postWrite(Futures fs) {
        for (Vec v2 : this.vecs()) {
            v2.postWrite(fs);
        }
        return fs;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        int n2;
        Vec[] vecs;
        Key[] keys = this._keys;
        if (keys.length == 0) {
            return fs;
        }
        Vec v2 = this._col0;
        if (v2 == null && (vecs = this._vecs) != null) {
            Vec vec;
            Vec[] vecArray = vecs;
            n2 = vecArray.length;
            for (int i2 = 0; i2 < n2 && (v2 = (vec = vecArray[i2])) == null; ++i2) {
            }
        }
        if (v2 == null) {
            Key<Vec> _key1;
            Key<Vec>[] keyArray = this._keys;
            int n3 = keyArray.length;
            for (n2 = 0; n2 < n3 && (v2 = (_key1 = keyArray[n2]).get()) == null; ++n2) {
            }
        }
        if (v2 == null) {
            return fs;
        }
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this._keys = this.makeVecKeys(0);
        Vec.bulk_remove(keys, v2.nChunks());
        return fs;
    }

    public final Futures retain(Futures futures, Set<Key> retainedKeys) {
        int n2;
        Iced[] vecs;
        Key<Vec>[] delCandidateKeys;
        if (this._key != null) {
            DKV.remove(this._key);
        }
        if ((delCandidateKeys = this._keys).length == 0) {
            return futures;
        }
        Iced v2 = this._col0;
        if (v2 == null && (vecs = this._vecs) != null) {
            Iced vec;
            Iced[] icedArray = vecs;
            n2 = icedArray.length;
            for (int i2 = 0; i2 < n2 && (v2 = (vec = icedArray[i2])) == null; ++i2) {
            }
        }
        if (v2 == null) {
            Iced _key1;
            vecs = this._keys;
            int n3 = vecs.length;
            for (n2 = 0; n2 < n3 && (v2 = (Vec)((Key)(_key1 = vecs[n2])).get()) == null; ++n2) {
            }
        }
        if (v2 == null) {
            return futures;
        }
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this._keys = this.makeVecKeys(0);
        ArrayList<Key<Vec>> deletedKeys = new ArrayList<Key<Vec>>();
        for (int i3 = 0; i3 < delCandidateKeys.length; ++i3) {
            if (retainedKeys.contains(delCandidateKeys[i3])) continue;
            deletedKeys.add(delCandidateKeys[i3]);
        }
        Vec.bulk_remove(deletedKeys.toArray(new Key[0]), ((Vec)v2).nChunks());
        return futures;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putA8(this.anyVec().espc());
        for (Key<Vec> k2 : this._keys) {
            ab.putKey(k2);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        long[] espc = ab.getA8();
        this._keys = new Vec.VectorGroup().addVecs(this._keys.length);
        DKV.put(this, fs);
        int rowLayout = Vec.ESPC.rowLayout(this._keys[0], espc);
        for (Key<Vec> key : this._keys) {
            Vec v2 = (Vec)ab.get();
            v2._key = key;
            v2._rowLayout = rowLayout;
            v2.readAll_impl(ab, fs);
            DKV.put(v2, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public Vec replace(int col, Vec nv) {
        Vec rv = this.vecs()[col];
        nv = new Frame(rv).makeCompatible(new Frame(nv))[0];
        DKV.put(nv);
        assert (DKV.get(nv._key) != null);
        assert (rv.isCompatibleWith(nv));
        this._vecs[col] = nv;
        this._keys[col] = nv._key;
        return rv;
    }

    public Frame subframe(int startIdx, int endIdx) {
        return new Frame(Arrays.copyOfRange(this._names, startIdx, endIdx), Arrays.copyOfRange(this.vecs(), startIdx, endIdx));
    }

    public Frame extractFrame(int startIdx, int endIdx) {
        Frame f2 = this.subframe(startIdx, endIdx);
        this.remove(startIdx, endIdx);
        return f2;
    }

    public Vec remove(String name) {
        return this.remove(this.find(name));
    }

    public Frame remove(String[] names) {
        for (String name : names) {
            this.remove(this.find(name));
        }
        return this;
    }

    public Vec[] remove(int[] idxs) {
        for (int i2 : idxs) {
            if (i2 >= 0 && i2 < this.vecs().length) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(idxs);
        Vec[] res = new Vec[idxs.length];
        Vec[] rem = new Vec[this._vecs.length - idxs.length];
        String[] names = new String[rem.length];
        Key<Vec>[] keys = this.makeVecKeys(rem.length);
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int i3 = 0; i3 < this._vecs.length; ++i3) {
            if (j2 < idxs.length && i3 == idxs[j2]) {
                ++j2;
                res[k2++] = this._vecs[i3];
                continue;
            }
            rem[l2] = this._vecs[i3];
            names[l2] = this._names[i3];
            keys[l2] = this._keys[i3];
            ++l2;
        }
        this._vecs = rem;
        this.setNames(names);
        this._keys = keys;
        assert (l2 == rem.length && k2 == idxs.length);
        return res;
    }

    public final Vec remove(int idx) {
        int len = this._names.length;
        if (idx < 0 || idx >= len) {
            return null;
        }
        Vec v2 = this.vecs()[idx];
        if (v2 == this._col0) {
            this._col0 = null;
        }
        this._vecs = ArrayUtils.remove(this._vecs, idx);
        this.setNames(ArrayUtils.remove(this._names, idx));
        this._keys = ArrayUtils.remove(this._keys, idx);
        return v2;
    }

    public Vec[] removeAll() {
        return this.remove(0, this._names.length);
    }

    Vec[] remove(int startIdx, int endIdx) {
        int len = this._names.length;
        int nlen = len - (endIdx - startIdx);
        String[] names = new String[nlen];
        Key<Vec>[] keys = this.makeVecKeys(nlen);
        Vec[] vecs = new Vec[nlen];
        this.vecs();
        if (startIdx > 0) {
            System.arraycopy(this._names, 0, names, 0, startIdx);
            System.arraycopy(this._vecs, 0, vecs, 0, startIdx);
            System.arraycopy(this._keys, 0, keys, 0, startIdx);
        }
        nlen -= startIdx;
        if (endIdx < this._names.length + 1) {
            System.arraycopy(this._names, endIdx, names, startIdx, nlen);
            System.arraycopy(this._vecs, endIdx, vecs, startIdx, nlen);
            System.arraycopy(this._keys, endIdx, keys, startIdx, nlen);
        }
        Vec[] vecX = Arrays.copyOfRange(this._vecs, startIdx, endIdx);
        this._vecs = vecs;
        this._keys = keys;
        this.setNames(names);
        this._col0 = null;
        return vecX;
    }

    public void restructure(String[] names, Vec[] vecs) {
        this.restructure(names, vecs, vecs.length);
    }

    public void restructure(String[] names, Vec[] vecs, int cols) {
        this._keys = this.makeVecKeys(0);
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this.add(names, vecs, cols);
    }

    void preparePartialFrame(String[] names) {
        if (this._keys != null) {
            this.delete_and_lock();
        } else {
            this.write_lock();
        }
        this._keys = new Vec.VectorGroup().addVecs(names.length);
        this.setNamesNoCheck(names);
    }

    static NewChunk[] createNewChunks(String name, byte[] type, int cidx) {
        boolean[] sparse = new boolean[type.length];
        Arrays.fill(sparse, false);
        return Frame.createNewChunks(name, type, cidx, sparse);
    }

    static NewChunk[] createNewChunks(String name, byte[] type, int cidx, boolean[] sparse) {
        Frame fr = (Frame)Key.make(name).get();
        NewChunk[] nchks = new NewChunk[fr.numCols()];
        for (int i2 = 0; i2 < nchks.length; ++i2) {
            nchks[i2] = new NewChunk((Vec)new AppendableVec(fr._keys[i2], type[i2]), cidx, sparse[i2]);
        }
        return nchks;
    }

    static void closeNewChunks(NewChunk[] nchks) {
        Futures fs = new Futures();
        for (NewChunk nchk : nchks) {
            nchk.close(fs);
        }
        fs.blockForPending();
    }

    void finalizePartialFrame(long[] espc, String[][] domains, byte[] types) {
        this.finalizePartialFrame(espc, domains, types, true);
    }

    void finalizePartialFrame(long[] espc, String[][] domains, byte[] types, boolean unlock) {
        int nchunk;
        for (nchunk = espc.length; nchunk > 1 && espc[nchunk - 1] == 0L; --nchunk) {
        }
        long[] espc2 = new long[nchunk + 1];
        long x2 = 0L;
        for (int i2 = 0; i2 < nchunk; ++i2) {
            espc2[i2] = x2;
            x2 += espc[i2];
        }
        espc2[nchunk] = x2;
        Futures fs = new Futures();
        this._vecs = new Vec[this._keys.length];
        for (int i3 = 0; i3 < this._keys.length; ++i3) {
            for (int j2 = nchunk; j2 < espc.length; ++j2) {
                DKV.remove(Vec.chunkKey(this._keys[i3], j2), fs);
            }
            Vec vec = this._vecs[i3] = new Vec(this._keys[i3], Vec.ESPC.rowLayout(this._keys[i3], espc2), domains != null ? domains[i3] : null, types[i3]);
            DKV.put(this._keys[i3], vec, fs);
        }
        fs.blockForPending();
        if (unlock) {
            this.unlock();
        }
    }

    public Frame deepSlice(Object orows, Object ocols) {
        int[] c2;
        long[] cols;
        if (ocols == null) {
            cols = null;
        } else if (ocols instanceof long[]) {
            cols = (long[])ocols;
        } else if (ocols instanceof Frame) {
            Frame fr = (Frame)ocols;
            if (fr.numCols() != 1) {
                throw new IllegalArgumentException("Columns Frame must have only one column (actually has " + fr.numCols() + " columns)");
            }
            long n2 = fr.anyVec().length();
            if (n2 > 100000L) {
                throw new IllegalArgumentException("Too many requested columns (requested " + n2 + ", max " + 100000 + ")");
            }
            cols = new long[(int)n2];
            Vec.Reader v2 = new Vec.Reader(fr.anyVec());
            for (long i2 = 0L; i2 < v2.length(); ++i2) {
                cols[(int)i2] = v2.at8(i2);
            }
        } else {
            throw new IllegalArgumentException("Columns is specified by an unsupported data type (" + ocols.getClass().getName() + ")");
        }
        if (cols == null) {
            c2 = new int[this.numCols()];
            for (int i3 = 0; i3 < c2.length; ++i3) {
                c2[i3] = i3;
            }
        } else if (cols.length == 0) {
            c2 = new int[]{};
        } else if (cols[0] >= 0L) {
            c2 = new int[cols.length];
            for (int i4 = 0; i4 < cols.length; ++i4) {
                c2[i4] = (int)cols[i4];
            }
        } else {
            c2 = new int[this.numCols() - cols.length];
            int j2 = 0;
            for (int i5 = 0; i5 < this.numCols(); ++i5) {
                if (j2 >= cols.length || (long)i5 < -(1L + cols[j2])) {
                    c2[i5 - j2] = i5;
                    continue;
                }
                ++j2;
            }
        }
        for (int aC2 : c2) {
            if (aC2 < this.numCols()) continue;
            throw new IllegalArgumentException("Trying to select column " + (aC2 + 1) + " but only " + this.numCols() + " present.");
        }
        if (c2.length == 0) {
            throw new IllegalArgumentException("No columns selected (did you try to select column 0 instead of column 1?)");
        }
        if (this.numRows() == 0L) {
            return ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                }
            }.doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows == null) {
            return ((DeepSlice)new DeepSlice(null, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows instanceof long[]) {
            long CHK_ROWS = 1000000L;
            final long[] rows = (long[])orows;
            if (this.numRows() == 0L) {
                return this;
            }
            if (rows.length == 0 || rows[0] < 0L) {
                if (rows.length != 0 && rows[0] < 0L) {
                    Vec v0 = this.anyVec().makeZero();
                    Vec v3 = ((MRTask)((MRTask)new MRTask(){

                        @Override
                        public void map(Chunk cs) {
                            for (long er : rows) {
                                if (er >= 0L || (er = Math.abs(er)) < cs._start || er > (long)cs._len + cs._start - 1L) continue;
                                cs.set((int)(er - cs._start), 1L);
                            }
                        }
                    }.doAll((Vec[])new Vec[]{v0})).getResult())._fr.anyVec();
                    Keyed.remove(v0._key);
                    Frame slicedFrame = ((DeepSlice)new DeepSlice(rows, c2, this.vecs()).doAll(this.types(c2), this.add("select_vec", v3))).outputFrame(this.names(c2), this.domains(c2));
                    Keyed.remove(v3._key);
                    Keyed.remove(this.remove((int)(this.numCols() - 1))._key);
                    return slicedFrame;
                }
                return ((DeepSlice)new DeepSlice(rows.length == 0 ? null : rows, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
            }
            Futures fs = new Futures();
            AppendableVec av = new AppendableVec(Vec.newKey(), 3);
            int r2 = 0;
            int c3 = 0;
            while (r2 < rows.length) {
                NewChunk nc = new NewChunk(av, c3);
                long end = Math.min((long)r2 + 1000000L, (long)rows.length);
                while ((long)r2 < end) {
                    nc.addNum(rows[r2]);
                    ++r2;
                }
                nc.close(c3++, fs);
            }
            Vec c0 = av.layout_and_close(fs);
            fs.blockForPending();
            Frame ff = new Frame(new String[]{"rownames"}, new Vec[]{c0});
            Frame fr2 = ((Slice)new Slice(c2, this).doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
            Keyed.remove(c0._key);
            Keyed.remove(av._key);
            ff.delete();
            return fr2;
        }
        Frame frows = (Frame)orows;
        Vec[] vecs = new Vec[c2.length];
        String[] names = new String[c2.length];
        for (int i6 = 0; i6 < c2.length; ++i6) {
            vecs[i6] = this._vecs[c2[i6]];
            names[i6] = this._names[c2[i6]];
        }
        Frame ff = new Frame(names, vecs);
        ff.add("predicate", frows.anyVec());
        return ((DeepSelect)new DeepSelect().doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
    }

    public String toString() {
        return "Frame key: " + this._key + "\n" + "   cols: " + this.numCols() + "\n   rows: " + this.numRows() + "\n chunks: " + (this.anyVec() == null ? "N/A" : Integer.valueOf(this.anyVec().nChunks())) + "\n   size: " + this.byteSize() + "\n";
    }

    public String toString(long off, int len) {
        return this.toTwoDimTable(off, len).toString();
    }

    public String toString(long off, int len, boolean rollups) {
        return this.toTwoDimTable(off, len, rollups).toString();
    }

    public TwoDimTable toTwoDimTable() {
        return this.toTwoDimTable(0L, 10);
    }

    public TwoDimTable toTwoDimTable(long off, int len) {
        return this.toTwoDimTable(off, len, true);
    }

    public TwoDimTable toTwoDimTable(long off, int len, boolean rollups) {
        if (off > this.numRows()) {
            off = this.numRows();
        }
        if (off + (long)len > this.numRows()) {
            len = (int)(this.numRows() - off);
        }
        String[] rowHeaders = new String[len];
        int H2 = 0;
        if (rollups) {
            H2 = 5;
            rowHeaders = new String[len + H2];
            rowHeaders[0] = "min";
            rowHeaders[1] = "mean";
            rowHeaders[2] = "stddev";
            rowHeaders[3] = "max";
            rowHeaders[4] = "missing";
            for (int i2 = 0; i2 < len; ++i2) {
                rowHeaders[i2 + H2] = "" + (off + (long)i2);
            }
        }
        int ncols = this.numCols();
        Vec[] vecs = this.vecs();
        String[] coltypes = new String[ncols];
        String[][] strCells = new String[len + H2][ncols];
        double[][] dblCells = new double[len + H2][ncols];
        BufferedString tmpStr = new BufferedString();
        block9: for (int i3 = 0; i3 < ncols; ++i3) {
            if (DKV.get(this._keys[i3]) == null) {
                int j2;
                coltypes[i3] = "string";
                for (j2 = 0; j2 < len + H2; ++j2) {
                    dblCells[j2][i3] = 9.9E-324;
                }
                for (j2 = 0; j2 < len; ++j2) {
                    strCells[j2 + H2][i3] = "NO_VEC";
                }
                continue;
            }
            Vec vec = vecs[i3];
            if (rollups) {
                dblCells[0][i3] = vec.min();
                dblCells[1][i3] = vec.mean();
                dblCells[2][i3] = vec.sigma();
                dblCells[3][i3] = vec.max();
                dblCells[4][i3] = vec.naCnt();
            }
            switch (vec.get_type()) {
                case 0: {
                    coltypes[i3] = "string";
                    for (int j3 = 0; j3 < len; ++j3) {
                        strCells[j3 + H2][i3] = null;
                        dblCells[j3 + H2][i3] = 9.9E-324;
                    }
                    continue block9;
                }
                case 2: {
                    coltypes[i3] = "string";
                    for (int j4 = 0; j4 < len; ++j4) {
                        strCells[j4 + H2][i3] = vec.isNA(off + (long)j4) ? "" : vec.atStr(tmpStr, off + (long)j4).toString();
                        dblCells[j4 + H2][i3] = 9.9E-324;
                    }
                    continue block9;
                }
                case 4: {
                    coltypes[i3] = "string";
                    for (int j5 = 0; j5 < len; ++j5) {
                        strCells[j5 + H2][i3] = vec.isNA(off + (long)j5) ? "" : vec.factor(vec.at8(off + (long)j5));
                        dblCells[j5 + H2][i3] = 9.9E-324;
                    }
                    continue block9;
                }
                case 5: {
                    int j6;
                    coltypes[i3] = "string";
                    DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
                    for (j6 = 0; j6 < len; ++j6) {
                        strCells[j6 + H2][i3] = vec.isNA(off + (long)j6) ? "" : fmt.print(vec.at8(off + (long)j6));
                        dblCells[j6 + H2][i3] = 9.9E-324;
                    }
                    continue block9;
                }
                case 3: {
                    int j6;
                    coltypes[i3] = vec.isInt() ? "long" : "double";
                    for (j6 = 0; j6 < len; ++j6) {
                        dblCells[j6 + H2][i3] = vec.isNA(off + (long)j6) ? 9.9E-324 : vec.at(off + (long)j6);
                        strCells[j6 + H2][i3] = null;
                    }
                    continue block9;
                }
                case 1: {
                    throw H2O.unimpl();
                }
                default: {
                    System.err.println("bad vector type during debug print: " + vec.get_type());
                    throw H2O.fail();
                }
            }
        }
        return new TwoDimTable("Frame " + this._key, this.numRows() + " rows and " + this.numCols() + " cols", rowHeaders, (String[])this._names.clone(), coltypes, null, "", strCells, dblCells);
    }

    public Frame deepCopy(String keyName) {
        final Vec[] vecs = (Vec[])this.vecs().clone();
        Key<Vec>[] ks = this.anyVec().group().addVecs(vecs.length);
        Futures fs = new Futures();
        for (int i2 = 0; i2 < vecs.length; ++i2) {
            vecs[i2] = new Vec(ks[i2], this.anyVec()._rowLayout, vecs[i2].domain(), this.vecs()[i2]._type);
            DKV.put(vecs[i2], fs);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int cidx = cs[0].cidx();
                for (int i2 = 0; i2 < cs.length; ++i2) {
                    DKV.put(vecs[i2].chunkKey(cidx), cs[i2].deepCopy(), this._fs);
                }
            }
        }.doAll(this);
        fs.blockForPending();
        return new Frame(keyName == null ? null : Key.make(keyName), this.names(), vecs);
    }

    private String[][] domains(int[] cols) {
        Vec[] vecs = this.vecs();
        String[][] res = new String[cols.length][];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            res[i2] = vecs[cols[i2]].domain();
        }
        return res;
    }

    private String[] names(int[] cols) {
        if (this._names == null) {
            return null;
        }
        String[] res = new String[cols.length];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            res[i2] = this._names[cols[i2]];
        }
        return res;
    }

    private byte[] types(int[] cols) {
        Vec[] vecs = this.vecs();
        byte[] res = new byte[cols.length];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            res[i2] = vecs[cols[i2]]._type;
        }
        return res;
    }

    public Vec[] makeCompatible(Frame f2) {
        return this.makeCompatible(f2, false);
    }

    public Vec[] makeCompatible(Frame f2, boolean force) {
        if (this.anyVec() == null) {
            return f2.vecs();
        }
        Vec v1 = this.anyVec();
        Vec v2 = f2.anyVec();
        if (v1 != null && v2 != null && v1.length() != v2.length()) {
            throw new IllegalArgumentException("Can not make vectors of different length compatible!");
        }
        if (v1 == null || v2 == null || !force && v1.isCompatibleWith(v2)) {
            return f2.vecs();
        }
        Key k2 = Key.make();
        H2O.submitTask(new RebalanceDataSet(this, f2, k2)).join();
        Frame f22 = (Frame)k2.get();
        DKV.remove(k2);
        for (Vec v3 : f22.vecs()) {
            Scope.track(v3);
        }
        return f22.vecs();
    }

    public static Job export(Frame fr, String path, String frameName, boolean overwrite, int nParts) {
        return Frame.export(fr, path, frameName, overwrite, nParts, null, new CSVStreamParams());
    }

    public static Job export(Frame fr, String path, String frameName, boolean overwrite, int nParts, String compression, CSVStreamParams csvParms) {
        return Frame.export(fr, path, frameName, overwrite, nParts, false, compression, csvParms);
    }

    public static Job export(Frame fr, String path, String frameName, boolean overwrite, int nParts, boolean parallel, String compression, CSVStreamParams csvParms) {
        boolean forceSingle;
        boolean bl = forceSingle = nParts == 1;
        if (forceSingle) {
            boolean fileExists = H2O.getPM().exists(path);
            if (overwrite && fileExists) {
                Log.warn("File " + path + " exists, but will be overwritten!");
            } else if (!overwrite && fileExists) {
                throw new H2OIllegalArgumentException(path, "exportFrame", "File " + path + " already exists!");
            }
        } else if (!H2O.getPM().isEmptyDirectoryAllNodes(path)) {
            throw new H2OIllegalArgumentException(path, "exportFrame", "Cannot use path " + path + " to store part files! The target needs to be either an existing empty directory or not exist yet.");
        }
        CompressionFactory compressionFactory = compression != null ? CompressionFactory.make(compression) : null;
        Job job = new Job(fr._key, "water.fvec.Frame", "Export dataset");
        FrameUtils.ExportTaskDriver t2 = new FrameUtils.ExportTaskDriver(fr, path, frameName, overwrite, job, nParts, parallel, compressionFactory, csvParms);
        return job.start(t2, fr.anyVec().nChunks());
    }

    public InputStream toCSV(CSVStreamParams parms) {
        return new CSVStream(this, parms);
    }

    @Override
    public Class<KeyV3.FrameKeyV3> makeSchema() {
        return KeyV3.FrameKeyV3.class;
    }

    public Frame sort(int[] cols) {
        return Merge.sort(this, cols);
    }

    public Frame sort(int[] cols, int[] ascending) {
        return Merge.sort(this, cols, ascending);
    }

    public FrameVecRegistry frameVecRegistry() {
        return new FrameVecRegistry();
    }

    public Frame toCategoricalCol(int columIdx) {
        this.write_lock();
        this.replace(columIdx, this.vec(columIdx).toCategoricalVec()).remove();
        this.update();
        this.unlock();
        return this;
    }

    public Frame toCategoricalCol(String column) {
        return this.toCategoricalCol(this.find(column));
    }

    public class FrameVecRegistry {
        private LinkedHashMap<String, Vec> vecMap;

        private FrameVecRegistry() {
            this.vecMap = new LinkedHashMap(Frame.this._vecs.length);
            for (int i2 = 0; i2 < Frame.this._vecs.length; ++i2) {
                this.vecMap.put(Frame.this._names[i2], Frame.this._vecs[i2]);
            }
        }

        public Vec findByColName(String colName) {
            return this.vecMap.get(colName);
        }
    }

    public static class CSVStream
    extends InputStream {
        private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"");
        private static final Set<Character> SPECIAL_CHARS = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'))));
        private final CSVStreamParams _parms;
        private final Pattern escapingPattern;
        private final String escapeReplacement;
        byte[] _line;
        int _position;
        int _chkRow;
        Chunk[] _curChks;
        int _lastChkIdx;
        public volatile int _curChkIdx;
        private final transient String[][] _escapedCategoricalVecDomains;
        private final transient VecEncoder[] _encoders;

        public CSVStream(Frame fr, CSVStreamParams parms) {
            this(CSVStream.firstChunks(fr), parms._headers ? fr.names() : null, fr.anyVec().nChunks(), parms);
        }

        public CSVStream(Chunk[] chks, String[] names, int nChunks, CSVStreamParams parms) {
            int i2;
            if (chks == null) {
                nChunks = 0;
            }
            this._lastChkIdx = chks != null ? chks[0].cidx() + nChunks - 1 : -1;
            this._parms = Objects.requireNonNull(parms);
            if (this._parms._escapeCharacter != '\"') {
                String escapeCharacterEscaped = (SPECIAL_CHARS.contains(Character.valueOf(this._parms._escapeCharacter)) ? "\\" : "") + this._parms._escapeCharacter;
                this.escapingPattern = Pattern.compile("(\"|" + escapeCharacterEscaped + ")");
                this.escapeReplacement = escapeCharacterEscaped + "$1";
            } else {
                this.escapingPattern = DOUBLE_QUOTE_PATTERN;
                this.escapeReplacement = "\"\"";
            }
            StringBuilder sb = new StringBuilder();
            if (names != null) {
                this.appendColumnName(sb, names[0]);
                for (i2 = 1; i2 < names.length; ++i2) {
                    this.appendColumnName(sb.append(this._parms._separator), names[i2]);
                }
                sb.append('\n');
            }
            this._line = StringUtils.bytesOf(sb);
            this._chkRow = -1;
            this._curChks = chks;
            this._escapedCategoricalVecDomains = this.escapeCategoricalVecDomains(this._curChks);
            if (this._curChks != null) {
                this._encoders = new VecEncoder[this._curChks.length];
                for (i2 = 0; i2 < this._curChks.length; ++i2) {
                    Vec v2 = this._curChks[i2]._vec;
                    this._encoders[i2] = v2.isCategorical() ? VecEncoder.CAT : (v2.isUUID() ? VecEncoder.UUID : (v2.isInt() ? VecEncoder.INT : (v2.isString() ? VecEncoder.STRING : VecEncoder.NUM)));
                }
            } else {
                this._encoders = null;
            }
        }

        private void appendColumnName(StringBuilder sb, String name) {
            if (this._parms._quoteColumnNames) {
                sb.append('\"');
            }
            sb.append(name);
            if (this._parms._quoteColumnNames) {
                sb.append('\"');
            }
        }

        private static Chunk[] firstChunks(Frame fr) {
            Vec anyvec = fr.anyVec();
            if (anyvec == null || anyvec.nChunks() == 0 || anyvec.length() == 0L) {
                return null;
            }
            Chunk[] chks = new Chunk[fr.vecs().length];
            for (int i2 = 0; i2 < fr.vecs().length; ++i2) {
                chks[i2] = fr.vec(i2).chunkForRow(0L);
            }
            return chks;
        }

        private String[][] escapeCategoricalVecDomains(Chunk[] chunks) {
            if (chunks == null) {
                return null;
            }
            String[][] localEscapedCategoricalVecDomains = new String[chunks.length][];
            for (int i2 = 0; i2 < chunks.length; ++i2) {
                Vec vec = chunks[i2].vec();
                if (!vec.isCategorical()) continue;
                String[] originalDomain = vec.domain();
                String[] escapedDomain = new String[originalDomain.length];
                for (int level = 0; level < originalDomain.length; ++level) {
                    escapedDomain[level] = '\"' + this.escapeQuotesForCsv(originalDomain[level]) + '\"';
                }
                localEscapedCategoricalVecDomains[i2] = escapedDomain;
            }
            return localEscapedCategoricalVecDomains;
        }

        public int getCurrentRowSize() {
            int av = this.available();
            assert (av > 0);
            return this._line.length;
        }

        byte[] getBytesForRow() {
            StringBuilder sb = new StringBuilder();
            BufferedString unescapedTempStr = new BufferedString();
            block7: for (int i2 = 0; i2 < this._curChks.length; ++i2) {
                if (i2 > 0) {
                    sb.append(this._parms._separator);
                }
                if (this._curChks[i2].isNA(this._chkRow)) continue;
                switch (this._encoders[i2]) {
                    case NUM: {
                        double d2 = this._curChks[i2].atd(this._chkRow);
                        String s2 = this._parms._hexString ? Double.toHexString(d2) : RyuDouble.doubleToString(d2);
                        sb.append(s2);
                        continue block7;
                    }
                    case CAT: {
                        String escapedCat = this._escapedCategoricalVecDomains[i2][(int)this._curChks[i2].at8(this._chkRow)];
                        sb.append(escapedCat);
                        continue block7;
                    }
                    case INT: {
                        sb.append(this._curChks[i2].at8(this._chkRow));
                        continue block7;
                    }
                    case STRING: {
                        String escapedString = this.escapeQuotesForCsv(this._curChks[i2].atStr(unescapedTempStr, this._chkRow).toString());
                        sb.append('\"').append(escapedString).append('\"');
                        continue block7;
                    }
                    case UUID: {
                        sb.append(PrettyPrint.UUID(this._curChks[i2].at16l(this._chkRow), this._curChks[i2].at16h(this._chkRow)));
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unknown encoder " + (Object)((Object)this._encoders[i2]));
                    }
                }
            }
            sb.append('\n');
            return StringUtils.bytesOf(sb);
        }

        private String escapeQuotesForCsv(String unescapedString) {
            if (!this._parms._escapeQuotes) {
                return unescapedString;
            }
            return this.escapingPattern.matcher(unescapedString).replaceAll(this.escapeReplacement);
        }

        @Override
        public int available() {
            if (this._position != this._line.length) {
                return this._line.length - this._position;
            }
            if (this._curChks == null) {
                return -1;
            }
            ++this._chkRow;
            Chunk anyChunk = this._curChks[0];
            if (anyChunk._start + (long)this._chkRow >= anyChunk._vec.length()) {
                return -1;
            }
            if (this._chkRow == anyChunk.len()) {
                this._curChkIdx = anyChunk._vec.elem2ChunkIdx(anyChunk._start + (long)this._chkRow);
                if (this._curChkIdx > this._lastChkIdx) {
                    return -1;
                }
                Chunk[] newChks = new Chunk[this._curChks.length];
                for (int i2 = 0; i2 < this._curChks.length; ++i2) {
                    newChks[i2] = this._curChks[i2]._vec.chunkForChunkIdx(this._curChkIdx);
                    Key oldKey = this._curChks[i2]._vec.chunkKey(this._curChks[i2]._cidx);
                    if (oldKey.home()) continue;
                    H2O.raw_remove(oldKey);
                }
                this._curChks = newChks;
                this._chkRow = 0;
            }
            this._line = this.getBytesForRow();
            this._position = 0;
            return this._line.length;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._line = null;
        }

        @Override
        public int read() throws IOException {
            return this.available() == 0 ? -1 : this._line[this._position++];
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int n2 = this.available();
            if (n2 > 0) {
                n2 = Math.min(n2, len);
                System.arraycopy(this._line, this._position, b2, off, n2);
                this._position += n2;
            }
            return n2;
        }

        static enum VecEncoder {
            CAT,
            UUID,
            INT,
            STRING,
            NUM;

        }
    }

    public static class CSVStreamParams
    extends Iced<CSVStreamParams> {
        public static final char DEFAULT_SEPARATOR = ',';
        public static final char DEFAULT_ESCAPE = '\"';
        boolean _headers = true;
        boolean _quoteColumnNames = true;
        boolean _hexString = false;
        boolean _escapeQuotes = true;
        char _separator = (char)44;
        char _escapeCharacter = (char)34;

        public CSVStreamParams setHeaders(boolean headers) {
            this._headers = headers;
            return this;
        }

        public CSVStreamParams noHeader() {
            this.setHeaders(false);
            return this;
        }

        public CSVStreamParams setQuoteColumnNames(boolean quoteColumnNames) {
            this._quoteColumnNames = quoteColumnNames;
            return this;
        }

        public CSVStreamParams setHexString(boolean hex_string) {
            this._hexString = hex_string;
            return this;
        }

        public CSVStreamParams setSeparator(byte separator) {
            this._separator = (char)separator;
            return this;
        }

        public CSVStreamParams setEscapeQuotes(boolean backslash_escape) {
            this._escapeQuotes = backslash_escape;
            return this;
        }

        public CSVStreamParams setEscapeChar(char escapeChar) {
            this._escapeCharacter = escapeChar;
            return this;
        }
    }

    public static class DeepSelect
    extends MRTask<DeepSelect> {
        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            Chunk pred = chks[chks.length - 1];
            int[] ids = pred.getIntegers(new int[pred._len], 0, pred._len, 0);
            int zeros = 0;
            for (int i2 = 0; i2 < ids.length; ++i2) {
                if (ids[i2] == 1) {
                    ids[i2 - zeros] = i2;
                    continue;
                }
                ++zeros;
            }
            ids = Arrays.copyOf(ids, ids.length - zeros);
            for (int c2 = 0; c2 < chks.length - 1; ++c2) {
                chks[c2].extractRows(nchks[c2], ids);
            }
        }
    }

    private static class DeepSlice
    extends MRTask<DeepSlice> {
        final int[] _cols;
        final long[] _rows;
        final byte[] _isInt;

        DeepSlice(long[] rows, int[] cols, Vec[] vecs) {
            this._cols = cols;
            this._rows = rows;
            this._isInt = new byte[cols.length];
            for (int i2 = 0; i2 < cols.length; ++i2) {
                this._isInt[i2] = (byte)(vecs[cols[i2]].isInt() ? 1 : 0);
            }
        }

        @Override
        public boolean logVerbose() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            long rstart = chks[0]._start;
            int rlen = chks[0]._len;
            int rx = 0;
            int rlo = 0;
            int rhi = rlen;
            while (true) {
                if (this._rows != null) {
                    long r2;
                    if (rx >= this._rows.length) return;
                    if ((r2 = this._rows[rx++]) < rstart) continue;
                    rlo = (int)(r2 - rstart);
                    for (rhi = rlo + 1; rx < this._rows.length && this._rows[rx] - rstart == (long)rhi && rhi < rlen; ++rx, ++rhi) {
                    }
                }
                BufferedString tmpStr = new BufferedString();
                for (int i2 = 0; i2 < this._cols.length; ++i2) {
                    chks[this._cols[i2]].extractRows(nchks[i2], rlo, rhi);
                }
                rlo = rhi;
                if (this._rows == null) return;
            }
        }
    }

    private static class Slice
    extends MRTask<Slice> {
        final Frame _base;
        final int[] _cols;

        Slice(int[] cols, Frame base) {
            this._cols = cols;
            this._base = base;
        }

        @Override
        public void map(Chunk[] ix, NewChunk[] ncs) {
            Vec[] vecs = new Vec[this._cols.length];
            Vec anyv = this._base.anyVec();
            long nrow = anyv.length();
            long r2 = ix[0].at8(0);
            int last_ci = anyv.elem2ChunkIdx(r2 < nrow ? r2 : 0L);
            long last_c0 = anyv.espc()[last_ci];
            long last_c1 = anyv.espc()[last_ci + 1];
            Chunk[] last_cs = new Chunk[vecs.length];
            for (int c2 = 0; c2 < this._cols.length; ++c2) {
                vecs[c2] = this._base.vecs()[this._cols[c2]];
                last_cs[c2] = vecs[c2].chunkForChunkIdx(last_ci);
            }
            for (int i2 = 0; i2 < ix[0]._len; ++i2) {
                int c3;
                r2 = ix[0].at8(i2);
                if (r2 < 0L) continue;
                if (r2 >= nrow) {
                    for (c3 = 0; c3 < vecs.length; ++c3) {
                        ncs[c3].addNA();
                    }
                    continue;
                }
                if (r2 < last_c0 || r2 >= last_c1) {
                    last_ci = anyv.elem2ChunkIdx(r2);
                    last_c0 = anyv.espc()[last_ci];
                    last_c1 = anyv.espc()[last_ci + 1];
                    for (c3 = 0; c3 < vecs.length; ++c3) {
                        last_cs[c3] = vecs[c3].chunkForChunkIdx(last_ci);
                    }
                }
                int ir = (int)(r2 - last_cs[0].start());
                for (int c4 = 0; c4 < vecs.length; ++c4) {
                    last_cs[c4].extractRows(ncs[c4], ir);
                }
            }
        }
    }

    public static class VecSpecifier
    extends Iced
    implements Vec.Holder {
        public Key<Frame> _frame;
        public String _column_name;

        public VecSpecifier() {
        }

        public VecSpecifier(Key<Frame> frame, String column_name) {
            this._frame = frame;
            this._column_name = column_name;
        }

        @Override
        public Vec vec() {
            Value v2 = DKV.get(this._frame);
            if (null == v2) {
                return null;
            }
            Frame f2 = (Frame)v2.get();
            if (null == f2) {
                return null;
            }
            return f2.vec(this._column_name);
        }

        public static String[] vecNames(VecSpecifier[] vecSpecifiers) throws NullPointerException {
            Objects.requireNonNull(vecSpecifiers);
            String[] vecNames = new String[vecSpecifiers.length];
            for (int i2 = 0; i2 < vecSpecifiers.length; ++i2) {
                vecNames[i2] = vecSpecifiers[i2]._column_name;
            }
            return vecNames;
        }
    }
}

