/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.HashMap;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.util.ArrayUtils;

public class CategoricalWrappedVec
extends WrappedVec {
    int[] _map;
    int _p = 0;

    public CategoricalWrappedVec(Key key, int rowLayout, String[] toDomain, Key masterVecKey) {
        super((Key<Vec>)key, rowLayout, masterVecKey);
        this.computeMap(this.masterVec().domain(), toDomain, this.masterVec().isBad());
        DKV.put(this);
    }

    private CategoricalWrappedVec(Key key) {
        super((Key<Vec>)key, Vec.ESPC.rowLayout(key, new long[]{0L}), null, null);
    }

    private static CategoricalWrappedVec makeTransientVec(String[] from, String[] to) {
        Key<Vec> key = Vec.newKey();
        CategoricalWrappedVec tmp = new CategoricalWrappedVec((Key)key);
        tmp.computeMap(from, to, false);
        return tmp;
    }

    public static int[] computeMap(String[] from, String[] to) {
        return CategoricalWrappedVec.makeTransientVec((String[])from, (String[])to)._map;
    }

    public static Vec updateDomain(Vec source, String[] toDomain) {
        CategoricalWrappedVec tv = CategoricalWrappedVec.makeTransientVec(source.domain(), toDomain);
        new RemapTask(tv).doAll(source);
        source.setDomain(tv.domain());
        DKV.put(source);
        return source;
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        return new CategoricalWrappedChunk(this.masterVec().chunkForChunkIdx(cidx), this);
    }

    private void computeMap(String[] from, String[] to, boolean fromIsBad) {
        int extra;
        if (from == to || Arrays.equals(from, to)) {
            this._map = ArrayUtils.seq(0, to.length);
            this.setDomain(to);
            return;
        }
        if (from == null) {
            this.setDomain(to);
            if (fromIsBad) {
                this._map = new int[0];
                return;
            }
            int min2 = Integer.valueOf(to[0]);
            int max = Integer.valueOf(to[to.length - 1]);
            Vec mvec = this.masterVec();
            if (!(mvec.isInt() && mvec.min() >= (double)min2 && mvec.max() <= (double)max)) {
                throw new NumberFormatException();
            }
            if (Integer.valueOf(to[0]) < 0) {
                this._p = Math.max(0, max);
                this._map = new int[this._p + -1 * min2 + 1];
                int i2 = 0;
                while (i2 < to.length) {
                    int v2 = Integer.valueOf(to[i2]);
                    if (v2 < 0) {
                        v2 = -1 * v2 + this._p;
                    }
                    this._map[v2] = i2++;
                }
                return;
            }
            this._map = new int[max + 1];
            for (int i3 = 0; i3 < to.length; ++i3) {
                this._map[Integer.valueOf((String)to[i3]).intValue()] = i3;
            }
            return;
        }
        this._map = new int[from.length];
        if (to == null) {
            for (int i4 = 0; i4 < from.length; ++i4) {
                this._map[i4] = Integer.valueOf(from[i4]);
            }
            return;
        }
        HashMap<String, Integer> h2 = new HashMap<String, Integer>();
        for (int i5 = 0; i5 < to.length; ++i5) {
            h2.put(to[i5], i5);
        }
        String[] ss = to;
        int actualLen = extra = to.length;
        for (int j2 = 0; j2 < from.length; ++j2) {
            Integer x2 = (Integer)h2.get(from[j2]);
            if (x2 != null) {
                this._map[j2] = x2;
                continue;
            }
            this._map[j2] = extra++;
            if (extra > ss.length) {
                ss = Arrays.copyOf(ss, 2 * ss.length);
            }
            ss[extra - 1] = from[j2];
            actualLen = extra;
        }
        this.setDomain(Arrays.copyOf(ss, actualLen));
    }

    @Override
    public Vec doCopy() {
        return new CategoricalWrappedVec((Key)this.group().addVec(), this._rowLayout, this.domain(), this._masterVecKey);
    }

    public static class CategoricalWrappedChunk
    extends Chunk {
        public final transient Chunk _c;
        final transient int[] _map;
        final transient int _p;

        CategoricalWrappedChunk(Chunk c2, CategoricalWrappedVec vec) {
            this(c2, vec, vec._map, vec._p);
        }

        private CategoricalWrappedChunk(Chunk c2, Vec vec, int[] map, int p2) {
            this._c = c2;
            this.set_len(this._c._len);
            this._start = this._c._start;
            this._vec = vec;
            this._cidx = this._c._cidx;
            this._map = map;
            this._p = p2;
        }

        @Override
        protected double atd_impl(int idx) {
            return this._c.isNA_impl(idx) ? Double.NaN : (double)this.at8_impl(idx);
        }

        @Override
        protected long at8_impl(int idx) {
            int at8 = (int)this._c.at8_impl(idx);
            if (at8 >= 0) {
                return this._map[at8];
            }
            return this._map[-1 * at8 + this._p];
        }

        @Override
        protected boolean isNA_impl(int idx) {
            return this._c.isNA_impl(idx);
        }

        @Override
        boolean set_impl(int idx, long l2) {
            return false;
        }

        @Override
        boolean set_impl(int idx, double d2) {
            return false;
        }

        @Override
        boolean set_impl(int idx, float f2) {
            return false;
        }

        @Override
        boolean setNA_impl(int idx) {
            return false;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            for (int i2 = from; i2 < to; ++i2) {
                if (this.isNA(i2)) {
                    nc.addNAs(1);
                    continue;
                }
                nc.addValue(this.at8(i2));
            }
            return nc;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            for (int i2 : rows) {
                if (this.isNA(i2)) {
                    nc.addNAs(1);
                    continue;
                }
                nc.addValue(this.at8(i2));
            }
            return nc;
        }

        public static AutoBuffer write_impl(CategoricalWrappedVec v2, AutoBuffer bb) {
            throw H2O.fail();
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }

        @Override
        public boolean hasNA() {
            return this._c.hasNA();
        }

        @Override
        public Chunk deepCopy() {
            return this.extractRows(new NewChunk(this), 0, this._c._len).compress();
        }
    }

    private static class RemapTask
    extends MRTask<RemapTask> {
        private final int[] _map;
        private final int _p;

        private RemapTask(CategoricalWrappedVec vec) {
            this._map = vec._map;
            this._p = vec._p;
        }

        @Override
        public void map(Chunk c2) {
            CategoricalWrappedChunk wc = new CategoricalWrappedChunk(c2, c2._vec, this._map, this._p);
            assert (wc._len == c2._len);
            for (int i2 = 0; i2 < wc._len; ++i2) {
                if (c2.isNA(i2)) continue;
                c2.set(i2, wc.at8(i2));
            }
        }
    }
}

