/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public final class C8DVolatileChunk
extends Chunk {
    private transient double[] _ds;

    C8DVolatileChunk(double[] ds) {
        this._start = -1L;
        this._len = ds.length;
        this._ds = ds;
    }

    public double[] getValues() {
        return this._ds;
    }

    @Override
    protected final long at8_impl(int i2) {
        double res = this._ds[i2];
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i2) {
        return this._ds[i2];
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return Double.isNaN(this._ds[i2]);
    }

    @Override
    boolean set_impl(int idx, long l2) {
        double d2 = l2;
        if (d2 != (double)l2) {
            return false;
        }
        this._ds[idx] = d2;
        return true;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        this._ds[i2] = d2;
        return true;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        this._ds[i2] = f2;
        return true;
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8d(this._mem, idx << 3, Double.NaN);
        return true;
    }

    @Override
    public final void initFromBytes() {
        this._len = this._mem.length >> 3;
        this._ds = MemoryManager.malloc8d(this._len);
        for (int i2 = 0; i2 < this._ds.length; ++i2) {
            this._ds[i2] = UnsafeUtils.get8d(this._mem, 8 * i2);
        }
        this._mem = null;
    }

    @Override
    public byte[] asBytes() {
        byte[] res = MemoryManager.malloc1(this._len * 8);
        for (int i2 = 0; i2 < this._len; ++i2) {
            UnsafeUtils.set8d(res, 8 * i2, this._ds[i2]);
        }
        return res;
    }

    @Override
    public Futures close(int cidx, Futures fs) {
        if (this.chk2() != null) {
            return this.chk2().close(cidx, fs);
        }
        Value v2 = new Value(this._vec.chunkKey(cidx), this, this._len * 8, 1);
        DKV.put(v2._key, v2, fs);
        return fs;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            v2.addValue(this._ds[i2]);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            v2.addValue(this._ds[i2]);
        }
        return v2;
    }
}

