/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C4Chunk
extends Chunk {
    protected static final int _NA = Integer.MIN_VALUE;

    C4Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 2);
    }

    @Override
    protected final long at8_impl(int i2) {
        long res = UnsafeUtils.get4(this._mem, i2 << 2);
        if (res == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i2) {
        long res = UnsafeUtils.get4(this._mem, i2 << 2);
        return res == Integer.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return UnsafeUtils.get4(this._mem, i2 << 2) == Integer.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l2) {
        if (Integer.MIN_VALUE >= l2 || l2 > Integer.MAX_VALUE) {
            return false;
        }
        UnsafeUtils.set4(this._mem, idx << 2, (int)l2);
        return true;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set4(this._mem, idx << 2, Integer.MIN_VALUE);
        return true;
    }

    private final void processRow(int r2, ChunkVisitor v2) {
        int i2 = UnsafeUtils.get4(this._mem, r2 << 2);
        if (i2 == Integer.MIN_VALUE) {
            v2.addNAs(1);
        } else {
            v2.addValue(i2);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 2);
        assert (this._mem.length == this._len << 2);
    }

    @Override
    public boolean hasFloat() {
        return false;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = UnsafeUtils.get4(this._mem, 4 * i2);
            vals[i2 - from] = x2 == Integer.MIN_VALUE ? NA2 : (double)x2;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k2 = 0;
        for (int i2 : ids) {
            int x2 = UnsafeUtils.get4(this._mem, 4 * i2);
            vals[k2++] = x2 == Integer.MIN_VALUE ? Double.NaN : (double)x2;
        }
        return vals;
    }

    @Override
    public int[] getIntegers(int[] vals, int from, int to, int NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = UnsafeUtils.get4(this._mem, 4 * i2);
            vals[i2 - from] = x2 == Integer.MIN_VALUE ? NA2 : x2;
        }
        return vals;
    }
}

