/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C16Chunk
extends Chunk {
    static final long _LO_NA = Long.MIN_VALUE;
    static final long _HI_NA = 0L;

    C16Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 4);
    }

    @Override
    protected final long at8_impl(int i2) {
        throw new IllegalArgumentException("at8_abs but 16-byte UUID");
    }

    @Override
    protected final double atd_impl(int i2) {
        throw new IllegalArgumentException("atd but 16-byte UUID");
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return C16Chunk.isNA(this.loAt(i2), this.hiAt(i2));
    }

    public static boolean isNA(long lo, long hi) {
        return lo == Long.MIN_VALUE && hi == 0L;
    }

    private long loAt(int idx) {
        return UnsafeUtils.get8(this._mem, idx * 16);
    }

    private long hiAt(int idx) {
        return UnsafeUtils.get8(this._mem, idx * 16 + 8);
    }

    @Override
    protected long at16l_impl(int idx) {
        long lo = this.loAt(idx);
        if (lo == Long.MIN_VALUE && this.hiAt(idx) == 0L) {
            throw new IllegalArgumentException("at16l but value is missing at " + idx);
        }
        return lo;
    }

    @Override
    protected long at16h_impl(int idx) {
        long hi = this.hiAt(idx);
        if (hi == 0L && this.loAt(idx) == Long.MIN_VALUE) {
            throw new IllegalArgumentException("at16h but value is missing at " + idx);
        }
        return hi;
    }

    @Override
    boolean set_impl(int i2, long lo, long hi) {
        if (C16Chunk.isNA(lo, hi)) {
            throw new IllegalArgumentException("Illegal uid value");
        }
        UnsafeUtils.set8(this._mem, i2 * 16, lo);
        UnsafeUtils.set8(this._mem, i2 * 16 + 8, hi);
        return true;
    }

    @Override
    boolean set_impl(int idx, long l2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        return this.set_impl(idx, Long.MIN_VALUE, 0L);
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            if (this.isNA(i2)) {
                v2.addNAs(1);
                continue;
            }
            v2.addValue(UnsafeUtils.get8(this._mem, 16 * i2), UnsafeUtils.get8(this._mem, 16 * i2 + 8));
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            v2.addValue(UnsafeUtils.get8(this._mem, 16 * i2), UnsafeUtils.get8(this._mem, 16 * i2 + 8));
        }
        return v2;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 4);
        assert (this._mem.length == this._len * 16);
    }
}

