/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.leaderboard.Leaderboard;
import water.DKV;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.api.schemas3.TwoDimTableV3;
import water.automl.api.schemas3.LeaderboardV99;
import water.automl.api.schemas3.LeaderboardsV99;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;

public class LeaderboardsHandler
extends Handler {
    public LeaderboardsV99 list(int version, LeaderboardsV99 s2) {
        Leaderboards m4 = (Leaderboards)s2.createAndFillImpl();
        m4.leaderboards = Leaderboards.fetchAll();
        return (LeaderboardsV99)s2.fillFromImpl(m4);
    }

    public LeaderboardV99 fetch(int version, LeaderboardsV99 input) {
        if (null == input.project_name) {
            throw new H2OKeyNotFoundArgumentException("Client must specify a project_name.");
        }
        Leaderboard leaderboard = LeaderboardsHandler.getFromDKV(Key.make(Leaderboard.idForProject(input.project_name)), "project_name");
        LeaderboardV99 lb = new LeaderboardV99().fillFromImpl(leaderboard);
        if (input.extensions != null) {
            lb.table = new TwoDimTableV3().fillFromImpl(leaderboard.toTwoDimTable(input.extensions));
        }
        return lb;
    }

    private static Leaderboard getFromDKV(Key key) {
        return LeaderboardsHandler.getFromDKV(key, "(none)");
    }

    private static Leaderboard getFromDKV(Key key, String argName) {
        Value v2 = DKV.get(key);
        if (v2 == null) {
            throw new H2OKeyNotFoundArgumentException(key.toString());
        }
        Object ice = v2.get();
        if (!(ice instanceof Leaderboard)) {
            throw new H2OKeyWrongTypeArgumentException(argName, key.toString(), Leaderboard.class, ice.getClass());
        }
        return (Leaderboard)ice;
    }

    public static final class Leaderboards
    extends Iced {
        public Leaderboard[] leaderboards;

        public static Leaderboard[] fetchAll() {
            Key[] leaderboardKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                @Override
                public boolean filter(KeySnapshot.KeyInfo k2) {
                    return Value.isSubclassOf(k2._type, Leaderboard.class);
                }
            }).keys();
            Leaderboard[] leaderboards = new Leaderboard[leaderboardKeys.length];
            for (int i2 = 0; i2 < leaderboardKeys.length; ++i2) {
                Leaderboard leaderboard;
                leaderboards[i2] = leaderboard = LeaderboardsHandler.getFromDKV(leaderboardKeys[i2]);
            }
            return leaderboards;
        }
    }
}

