/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.AutoML;
import java.util.stream.Stream;
import water.DKV;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.automl.api.schemas3.AutoMLV99;
import water.exceptions.H2OKeyNotFoundArgumentException;

public class AutoMLHandler
extends Handler {
    public AutoMLV99 fetch(int version, AutoMLV99 autoMLV99) {
        AutoML[] amls;
        AutoML autoML = (AutoML)DKV.getGet(autoMLV99.automl_id.name);
        if (autoML == null && (amls = AutoMLHandler.fetchAllForProject(autoMLV99.automl_id.name)).length > 0) {
            autoML = Stream.of(amls).max(AutoML.byStartTime).get();
        }
        return autoMLV99.fillFromImpl(autoML);
    }

    private static AutoML[] fetchAllForProject(final String project_name) {
        Key[] automlKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

            @Override
            public boolean filter(KeySnapshot.KeyInfo k2) {
                return Value.isSubclassOf(k2._type, AutoML.class) && k2._key.toString().startsWith(project_name + "@@");
            }
        }).keys();
        AutoML[] amls = new AutoML[automlKeys.length];
        for (int i2 = 0; i2 < automlKeys.length; ++i2) {
            AutoML aml;
            amls[i2] = aml = AutoMLHandler.getFromDKV(automlKeys[i2]);
        }
        return amls;
    }

    private static AutoML getFromDKV(Key key) {
        Value v2 = DKV.get(key);
        if (v2 == null) {
            throw new H2OKeyNotFoundArgumentException(key.toString());
        }
        return (AutoML)v2.get();
    }
}

