/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.IcedWrapper;
import water.api.API;
import water.api.schemas3.SchemaV3;
import water.util.TwoDimTable;

public class TwoDimTableV3
extends SchemaV3<TwoDimTable, TwoDimTableV3> {
    @API(help="Table Name", direction=API.Direction.OUTPUT)
    public String name;
    @API(help="Table Description", direction=API.Direction.OUTPUT)
    public String description;
    @API(help="Column Specification", direction=API.Direction.OUTPUT)
    public ColumnSpecsBase[] columns;
    @API(help="Number of Rows", direction=API.Direction.OUTPUT)
    public int rowcount;
    @API(help="Table Data (col-major)", direction=API.Direction.OUTPUT)
    public IcedWrapper[][] data;

    public TwoDimTableV3() {
    }

    public TwoDimTableV3(TwoDimTable impl) {
        super(impl);
    }

    @Override
    public TwoDimTableV3 fillFromImpl(TwoDimTable t2) {
        int cols;
        int rows;
        this.name = t2.getTableHeader();
        this.description = t2.getTableDescription();
        this.rowcount = rows = t2.getRowDim();
        boolean have_row_header_cols = t2.getColHeaderForRowHeaders() != null;
        for (int r2 = 0; r2 < rows && have_row_header_cols; have_row_header_cols &= t2.getRowHeaders()[r2] != null, ++r2) {
        }
        if (have_row_header_cols) {
            cols = t2.getColDim() + 1;
            this.columns = new ColumnSpecsBase[cols];
            this.columns[0] = new ColumnSpecsBase();
            this.columns[0].name = this.pythonify(t2.getColHeaderForRowHeaders());
            this.columns[0].type = "string";
            this.columns[0].format = "%s";
            this.columns[0].description = t2.getColHeaderForRowHeaders();
            for (int c2 = 1; c2 < cols; ++c2) {
                this.columns[c2] = new ColumnSpecsBase();
                this.columns[c2].name = this.pythonify(t2.getColHeaders()[c2 - 1]);
                this.columns[c2].type = t2.getColTypes()[c2 - 1];
                this.columns[c2].format = t2.getColFormats()[c2 - 1];
                this.columns[c2].description = t2.getColHeaders()[c2 - 1];
            }
            this.data = new IcedWrapper[cols][rows];
            this.data[0] = new IcedWrapper[t2.getRowDim()];
            for (int r3 = 0; r3 < t2.getRowDim(); ++r3) {
                this.data[0][r3] = new IcedWrapper(t2.getRowHeaders()[r3]);
            }
            IcedWrapper[][] cellValues = t2.getCellValues();
            for (int c3 = 1; c3 < cols; ++c3) {
                this.data[c3] = new IcedWrapper[rows];
                for (int r4 = 0; r4 < rows; ++r4) {
                    this.data[c3][r4] = cellValues[r4][c3 - 1];
                }
            }
        } else {
            cols = t2.getColDim();
            this.columns = new ColumnSpecsBase[cols];
            for (int c4 = 0; c4 < cols; ++c4) {
                this.columns[c4] = new ColumnSpecsBase();
                this.columns[c4].name = this.pythonify(t2.getColHeaders()[c4]);
                this.columns[c4].type = t2.getColTypes()[c4];
                this.columns[c4].format = t2.getColFormats()[c4];
                this.columns[c4].description = t2.getColHeaders()[c4];
            }
            this.data = new IcedWrapper[cols][rows];
            IcedWrapper[][] cellValues = t2.getCellValues();
            for (int c5 = 0; c5 < cols; ++c5) {
                this.data[c5] = new IcedWrapper[rows];
                for (int r5 = 0; r5 < rows; ++r5) {
                    this.data[c5][r5] = cellValues[r5][c5];
                }
            }
        }
        return this;
    }

    private String pythonify(String n2) {
        if (n2 == null || this.name.toLowerCase().contains("confusion")) {
            return n2;
        }
        StringBuilder sb = new StringBuilder();
        String[] modified = n2.split("[\\s_]+");
        for (int i2 = 0; i2 < modified.length; ++i2) {
            if (i2 != 0) {
                sb.append("_");
            }
            String s2 = modified[i2];
            sb.append(s2.toLowerCase());
        }
        String newString = sb.toString().replaceAll("[^\\w]", "");
        return newString;
    }

    @Override
    public TwoDimTable fillImpl(TwoDimTable impl) {
        int rows = this.data[0].length;
        assert (rows == this.rowcount);
        int cols = this.data.length + 1;
        String tableHeader = this.name;
        String tableDescription = this.description;
        String colHeaderForRowHeaders = this.columns[0].name;
        String[] rowHeaders = new String[rows];
        for (int r2 = 0; r2 < rows; ++r2) {
            rowHeaders[r2] = (String)this.data[0][r2].get();
        }
        String[] colHeaders = new String[cols];
        colHeaders[0] = "";
        for (int c2 = 1; c2 < cols; ++c2) {
            colHeaders[c2] = this.columns[c2].description;
        }
        String[] colTypes = new String[cols];
        colTypes[0] = "";
        for (int c3 = 1; c3 < cols; ++c3) {
            colTypes[c3] = this.columns[c3].type;
        }
        String[] colFormats = new String[cols];
        colFormats[0] = "%s";
        for (int c4 = 1; c4 < cols; ++c4) {
            colFormats[c4] = this.columns[c4].format;
        }
        String[][] strCellValues = new String[rows][cols];
        double[][] dblCellValues = new double[rows][cols];
        for (int r3 = 0; r3 < this.data[0].length; ++r3) {
            for (int c5 = 0; c5 < this.data.length; ++c5) {
                try {
                    if (this.columns[c5].format.equals("string")) {
                        strCellValues[r3][c5] = (String)this.data[c5][r3].get();
                        continue;
                    }
                    if (this.columns[c5].format.equals("double")) {
                        dblCellValues[r3][c5] = (Double)this.data[c5][r3].get();
                        continue;
                    }
                    if (this.columns[c5].format.equals("float")) {
                        dblCellValues[r3][c5] = ((Float)this.data[c5][r3].get()).floatValue();
                        continue;
                    }
                    if (this.columns[c5].format.equals("int")) {
                        dblCellValues[r3][c5] = ((Integer)this.data[c5][r3].get()).intValue();
                        continue;
                    }
                    if (this.columns[c5].format.equals("long")) {
                        dblCellValues[r3][c5] = ((Long)this.data[c5][r3].get()).longValue();
                        continue;
                    }
                    throw H2O.fail();
                }
                catch (ClassCastException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return new TwoDimTable(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders, strCellValues, dblCellValues);
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        int i2;
        ab.putJSONStr("name", this.name);
        ab.put1(44);
        ab.putJSONStr("description", this.description);
        ab.put1(44);
        ab.putJSONStr("columns").put1(58);
        ab.put1(91);
        if (this.columns != null) {
            for (i2 = 0; i2 < this.columns.length; ++i2) {
                this.columns[i2].writeJSON(ab);
                if (i2 >= this.columns.length - 1) continue;
                ab.put1(44);
            }
        }
        ab.put1(93);
        ab.put1(44);
        ab.putJSON4("rowcount", this.rowcount);
        ab.put1(44);
        ab.putJSONStr("data").put1(58);
        ab.put1(91);
        if (this.data != null) {
            for (i2 = 0; i2 < this.data.length; ++i2) {
                ab.put1(91);
                for (int j2 = 0; j2 < this.data[i2].length; ++j2) {
                    if (this.data[i2][j2] == null || this.data[i2][j2].get() == null) {
                        ab.putJNULL();
                    } else {
                        this.data[i2][j2].writeUnwrappedJSON(ab);
                    }
                    if (j2 >= this.data[i2].length - 1) continue;
                    ab.put1(44);
                }
                ab.put1(93);
                if (i2 >= this.data.length - 1) continue;
                ab.put1(44);
            }
        }
        ab.put1(93);
        return ab;
    }

    public static class ColumnSpecsBase
    extends SchemaV3<Iced, ColumnSpecsBase> {
        @API(help="Column Name", direction=API.Direction.OUTPUT)
        public String name;
        @API(help="Column Type", direction=API.Direction.OUTPUT)
        String type;
        @API(help="Column Format (printf)", direction=API.Direction.OUTPUT)
        String format;
        @API(help="Column Description", direction=API.Direction.OUTPUT)
        String description;
    }
}

