/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.ModelMetricsBinomial;
import water.api.API;
import water.api.SchemaServer;
import water.api.schemas3.ConfusionMatrixV3;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.TwoDimTable;

public class ModelMetricsBinomialV3<I extends ModelMetricsBinomial, S extends ModelMetricsBinomialV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="The R^2 for this scoring run.", direction=API.Direction.OUTPUT)
    public double r2;
    @API(help="The logarithmic loss for this scoring run.", direction=API.Direction.OUTPUT)
    public double logloss;
    @API(help="The AUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double AUC;
    @API(help="The precision-recall AUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double pr_auc;
    @API(help="The Gini score for this scoring run.", direction=API.Direction.OUTPUT)
    public double Gini;
    @API(help="The mean misclassification error per class.", direction=API.Direction.OUTPUT)
    public double mean_per_class_error;
    @API(help="The class labels of the response.", direction=API.Direction.OUTPUT)
    public String[] domain;
    @API(help="The ConfusionMatrix at the threshold for maximum F1.", direction=API.Direction.OUTPUT)
    public ConfusionMatrixV3 cm;
    @API(help="The Metrics for various thresholds.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 thresholds_and_metric_scores;
    @API(help="The Metrics for various criteria.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 max_criteria_and_metric_scores;
    @API(help="Gains and Lift table.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 gains_lift_table;

    @Override
    public S fillFromImpl(ModelMetricsBinomial modelMetrics) {
        TwoDimTable t2;
        AUC2 auc;
        super.fillFromImpl(modelMetrics);
        this.r2 = modelMetrics.r2();
        this.logloss = modelMetrics._logloss;
        this.mean_per_class_error = modelMetrics._mean_per_class_error;
        if (null != modelMetrics.cm()) {
            ConfusionMatrix cm = modelMetrics.cm();
            cm.table();
            this.cm = (ConfusionMatrixV3)SchemaServer.schema(this.getSchemaVersion(), cm).fillFromImpl(cm);
        }
        if ((auc = modelMetrics._auc) != null) {
            this.AUC = auc._auc;
            this.Gini = auc._gini;
            this.pr_auc = auc._pr_auc;
            if (!auc.isEmpty()) {
                int i2;
                String[] thresholds = new String[auc._nBins];
                for (int i3 = 0; i3 < auc._nBins; ++i3) {
                    thresholds[i3] = Double.toString(auc._ths[i3]);
                }
                AUC2.ThresholdCriterion[] crits = AUC2.ThresholdCriterion.VALUES;
                String[] colHeaders = new String[crits.length + 2];
                String[] colHeadersMax = new String[crits.length];
                String[] types = new String[crits.length + 2];
                String[] formats = new String[crits.length + 2];
                colHeaders[0] = "Threshold";
                types[0] = "double";
                formats[0] = "%f";
                for (i2 = 0; i2 < crits.length; ++i2) {
                    if (colHeadersMax.length > i2) {
                        colHeadersMax[i2] = "max " + crits[i2].toString();
                    }
                    colHeaders[i2 + 1] = crits[i2].toString();
                    types[i2 + 1] = crits[i2]._isInt ? "long" : "double";
                    formats[i2 + 1] = crits[i2]._isInt ? "%d" : "%f";
                }
                colHeaders[i2 + 1] = "idx";
                types[i2 + 1] = "int";
                formats[i2 + 1] = "%d";
                TwoDimTable thresholdsByMetrics = new TwoDimTable("Metrics for Thresholds", "Binomial metrics as a function of classification thresholds", new String[auc._nBins], colHeaders, types, formats, null);
                for (i2 = 0; i2 < auc._nBins; ++i2) {
                    int j2 = 0;
                    thresholdsByMetrics.set(i2, j2, Double.valueOf(thresholds[i2]));
                    for (j2 = 0; j2 < crits.length; ++j2) {
                        double d2 = crits[j2].exec(auc, i2);
                        thresholdsByMetrics.set(i2, 1 + j2, crits[j2]._isInt ? (Number)((long)d2) : (Number)d2);
                    }
                    thresholdsByMetrics.set(i2, 1 + j2, i2);
                }
                this.thresholds_and_metric_scores = new TwoDimTableV3().fillFromImpl(thresholdsByMetrics);
                TwoDimTable maxMetrics = new TwoDimTable("Maximum Metrics", "Maximum metrics at their respective thresholds", colHeadersMax, new String[]{"Threshold", "Value", "idx"}, new String[]{"double", "double", "long"}, new String[]{"%f", "%f", "%d"}, "Metric");
                for (i2 = 0; i2 < colHeadersMax.length; ++i2) {
                    int idx = crits[i2].max_criterion_idx(auc);
                    maxMetrics.set(i2, 0, idx == -1 ? Double.NaN : auc._ths[idx]);
                    maxMetrics.set(i2, 1, idx == -1 ? Double.NaN : crits[i2].exec(auc, idx));
                    maxMetrics.set(i2, 2, idx);
                }
                this.max_criteria_and_metric_scores = new TwoDimTableV3().fillFromImpl(maxMetrics);
            }
        }
        if (modelMetrics._gainsLift != null && (t2 = modelMetrics._gainsLift.createTwoDimTable()) != null) {
            this.gains_lift_table = new TwoDimTableV3().fillFromImpl(t2);
        }
        return (S)this;
    }
}

