/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Value;
import water.api.API;
import water.api.H2oRestGsonHelper;
import water.api.SchemaMetadata;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelSchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;
import water.util.EnumUtils;
import water.util.IcedHashMapGeneric;
import water.util.Log;
import water.util.MarkdownBuilder;
import water.util.PojoUtils;
import water.util.ReflectionUtils;

public abstract class Schema<I extends Iced, S extends Schema<I, S>>
extends Iced {
    private transient Class<I> _impl_class;
    private transient int _schema_version;
    private transient String _schema_name;
    private transient String _schema_type;
    private static final transient Gson gson = H2oRestGsonHelper.createH2oCompatibleGson();

    public Schema() {
        this.init_meta();
        SchemaServer.checkIfRegistered(this);
    }

    public Schema(I impl) {
        this();
        this.fillFromImpl(impl);
    }

    public void init_meta() {
        if (this._schema_name != null) {
            return;
        }
        this._schema_name = this.getClass().getSimpleName();
        this._schema_version = Schema.extractVersionFromSchemaName(this._schema_name);
        this._schema_type = this.getImplClass().getSimpleName();
    }

    public static int extractVersionFromSchemaName(String clz_name) {
        int idx = clz_name.lastIndexOf(86);
        if (idx == -1) {
            return -1;
        }
        try {
            return Integer.valueOf(clz_name.substring(idx + 1));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int getSchemaVersion() {
        return this._schema_version;
    }

    public String getSchemaName() {
        return this._schema_name;
    }

    public String getSchemaType() {
        return this._schema_type;
    }

    public void setSchemaType_doNotCall(String s2) {
        this._schema_type = s2;
    }

    public I createImpl() {
        try {
            return (I)((Iced)this.getImplClass().newInstance());
        }
        catch (Exception e2) {
            throw H2O.fail("Exception making a newInstance", e2);
        }
    }

    protected I fillImpl(I impl, String[] fieldsToSkip) {
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.CONSISTENT, fieldsToSkip);
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES, fieldsToSkip);
        return impl;
    }

    public I fillImpl(I impl) {
        return this.fillImpl(impl, null);
    }

    public final I createAndFillImpl() {
        return this.fillImpl(this.createImpl());
    }

    public final S fillFromImpl() {
        return this.fillFromImpl(this.createImpl(), null);
    }

    public S fillFromImpl(I impl) {
        return this.fillFromImpl(impl, null);
    }

    protected S fillFromImpl(I impl, String[] fieldsToSkip) {
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, fieldsToSkip);
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.CONSISTENT, fieldsToSkip);
        return (S)this;
    }

    public static Class<? extends Iced> getImplClass(Class<? extends Schema> clz) {
        Class impl_class = ReflectionUtils.findActualClassParameter(clz, 0);
        if (null == impl_class) {
            Log.warn("Failed to find an impl class for Schema: " + clz);
        }
        return impl_class;
    }

    public Class<I> getImplClass() {
        return this._impl_class != null ? this._impl_class : (this._impl_class = ReflectionUtils.findActualClassParameter(this.getClass(), 0));
    }

    public S fillFromParms(Properties parms) {
        return this.fillFromParms(parms, true);
    }

    public S fillFromParms(Properties parms, boolean checkRequiredFields) {
        return this.fillFromParms(parms, null, checkRequiredFields);
    }

    public S fillFromParms(Properties parms, Properties unknownParms, boolean checkRequiredFields) {
        Class<?> thisSchemaClass = this.getClass();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field current = null;
        try {
            Class<?> clz = thisSchemaClass;
            do {
                Field[] some_fields;
                Field[] fieldArray = some_fields = clz.getDeclaredFields();
                int n2 = fieldArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Field f2;
                    current = f2 = fieldArray[i2];
                    if (null != fields.get(f2.getName())) continue;
                    fields.put(f2.getName(), f2);
                }
            } while (Iced.class.isAssignableFrom((clz = clz.getSuperclass()).getSuperclass()));
        }
        catch (SecurityException e2) {
            throw H2O.fail("Exception accessing field: " + current + " in class: " + this.getClass() + ": " + e2);
        }
        for (String key : parms.stringPropertyNames()) {
            try {
                Field f3 = (Field)fields.get(key);
                if (null == f3) {
                    if (unknownParms != null) {
                        unknownParms.put(key, parms.getProperty(key));
                        continue;
                    }
                    throw new H2OIllegalArgumentException("Unknown parameter: " + key, "Unknown parameter in fillFromParms: " + key + " for class: " + this.getClass().toString());
                }
                int mods = f3.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) {
                    throw new H2OIllegalArgumentException("Bad parameter for field: " + key + " for class: " + this.getClass().toString(), "Bad parameter definition for field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was declared static or transient)");
                }
                Annotation[] apis = f3.getAnnotations();
                if (apis.length == 0) {
                    throw H2O.fail("Broken internal schema; missing API annotation for field: " + key);
                }
                API api = (API)apis[0];
                if (api.direction() == API.Direction.OUTPUT) {
                    throw new H2OIllegalArgumentException("Attempting to set output field: " + key + " for class: " + this.getClass().toString(), "Attempting to set output field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was annotated as API.Direction.OUTPUT)");
                }
                Schema.setField(this, f3, key, parms.getProperty(key), api.required(), thisSchemaClass);
            }
            catch (IllegalAccessException iae) {
                throw H2O.fail("Broken internal schema; field cannot be private nor final: " + key);
            }
        }
        if (checkRequiredFields) {
            for (Field f4 : fields.values()) {
                int mods = f4.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                try {
                    API api = (API)f4.getAnnotations()[0];
                    if (!api.required() || parms.getProperty(f4.getName()) != null) continue;
                    IcedHashMapGeneric.IcedHashMapStringObject values = new IcedHashMapGeneric.IcedHashMapStringObject();
                    values.put("schema", this.getClass().getSimpleName());
                    values.put("argument", f4.getName());
                    throw new H2OIllegalArgumentException("Required field " + f4.getName() + " not specified", "Required field " + f4.getName() + " not specified for schema class: " + this.getClass(), values);
                }
                catch (ArrayIndexOutOfBoundsException e3) {
                    throw H2O.fail("Missing annotation for API field: " + f4.getName());
                }
            }
        }
        return (S)this;
    }

    public S fillFromBody(String body) {
        return (S)PojoUtils.fillFromJson(this, body);
    }

    public S fillFromAny(Object o2) {
        throw new IllegalArgumentException("can't convert object of type " + o2.getClass() + " to schema " + this.getSchemaType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Schema> void setField(T o2, Field f2, String key, String value, boolean required, Class thisSchemaClass) throws IllegalAccessException {
        Object parse_result = Schema.parse(key, value, f2.getType(), required, thisSchemaClass);
        if (parse_result != null && f2.getType().isArray() && parse_result.getClass().isArray() && f2.getType().getComponentType() != parse_result.getClass().getComponentType()) {
            if (parse_result.getClass().getComponentType() == Integer.TYPE && f2.getType().getComponentType() == Integer.class) {
                int[] from = (int[])parse_result;
                Integer[] copy = new Integer[from.length];
                for (int i2 = 0; i2 < from.length; ++i2) {
                    copy[i2] = from[i2];
                }
                f2.set(o2, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Integer.class && f2.getType().getComponentType() == Integer.TYPE) {
                Integer[] from = (Integer[])parse_result;
                int[] copy = new int[from.length];
                for (int i3 = 0; i3 < from.length; ++i3) {
                    copy[i3] = from[i3];
                }
                f2.set(o2, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Double.class && f2.getType().getComponentType() == Double.TYPE) {
                Double[] from = (Double[])parse_result;
                double[] copy = new double[from.length];
                for (int i4 = 0; i4 < from.length; ++i4) {
                    copy[i4] = from[i4];
                }
                f2.set(o2, copy);
                return;
            } else {
                if (parse_result.getClass().getComponentType() != Float.class || f2.getType().getComponentType() != Float.TYPE) throw H2O.fail("Don't know how to cast an array of: " + parse_result.getClass().getComponentType() + " to an array of: " + f2.getType().getComponentType());
                Float[] from = (Float[])parse_result;
                float[] copy = new float[from.length];
                for (int i5 = 0; i5 < from.length; ++i5) {
                    copy[i5] = from[i5].floatValue();
                }
                f2.set(o2, copy);
            }
            return;
        } else {
            f2.set(o2, parse_result);
        }
    }

    static <E> Object parsePrimitve(String s2, Class fclz) {
        if (fclz.equals(String.class)) {
            return s2;
        }
        if (fclz.equals(Integer.TYPE)) {
            return Schema.parseInteger(s2, Integer.TYPE);
        }
        if (fclz.equals(Long.TYPE)) {
            return Schema.parseInteger(s2, Long.TYPE);
        }
        if (fclz.equals(Short.TYPE)) {
            return Schema.parseInteger(s2, Short.TYPE);
        }
        if (fclz.equals(Boolean.TYPE)) {
            if (s2.equals("0")) {
                return Boolean.FALSE;
            }
            if (s2.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf(s2);
        }
        if (fclz.equals(Byte.TYPE)) {
            return Schema.parseInteger(s2, Byte.TYPE);
        }
        if (fclz.equals(Double.TYPE)) {
            return Double.valueOf(s2);
        }
        if (fclz.equals(Float.TYPE)) {
            return Float.valueOf(s2);
        }
        throw H2O.fail("Unknown primitive type to parse: " + fclz.getSimpleName());
    }

    static <E> Object parse(String field_name, String s2, Class fclz, boolean required, Class schemaClass) {
        if (fclz.isPrimitive() || String.class.equals((Object)fclz)) {
            try {
                return Schema.parsePrimitve(s2, fclz);
            }
            catch (NumberFormatException ne) {
                String msg = "Illegal argument for field: " + field_name + " of schema: " + schemaClass.getSimpleName() + ": cannot convert \"" + s2 + "\" to type " + fclz.getSimpleName();
                throw new H2OIllegalArgumentException(msg);
            }
        }
        if (fclz.isArray()) {
            String[] splits;
            Class<?> afclz = fclz.getComponentType();
            Object[] a2 = null;
            if (s2.equals("null") || s2.length() == 0) {
                return null;
            }
            if (AutoParseable.class.isAssignableFrom(afclz)) {
                return gson.fromJson(s2, fclz);
            }
            if (s2.startsWith("[") && s2.endsWith("]")) {
                Schema.read(s2, 0, '[', fclz);
                Schema.read(s2, s2.length() - 1, ']', fclz);
                String inside = s2.substring(1, s2.length() - 1).trim();
                splits = inside.length() == 0 ? new String[]{} : Schema.splitArgs(inside);
            } else {
                splits = new String[]{s2.trim()};
            }
            a2 = afclz == Integer.TYPE ? (Object[])Array.newInstance(Integer.class, splits.length) : (afclz == Double.TYPE ? (Object[])Array.newInstance(Double.class, splits.length) : (afclz == Float.TYPE ? (Object[])Array.newInstance(Float.class, splits.length) : (Object[])Array.newInstance(afclz, splits.length)));
            for (int i2 = 0; i2 < splits.length; ++i2) {
                if (String.class == afclz || KeyV3.class.isAssignableFrom(afclz)) {
                    String stripped = splits[i2].trim();
                    if ("null".equals(stripped.toLowerCase()) || "na".equals(stripped.toLowerCase())) {
                        a2[i2] = null;
                        continue;
                    }
                    if (stripped.startsWith("\"") && stripped.endsWith("\"")) {
                        stripped = stripped.substring(1, stripped.length() - 1);
                    }
                    a2[i2] = Schema.parse(field_name, stripped, afclz, required, schemaClass);
                    continue;
                }
                a2[i2] = Schema.parse(field_name, splits[i2].trim(), afclz, required, schemaClass);
            }
            return a2;
        }
        if (!fclz.isAssignableFrom(Schema.class) && s2 != null && s2.startsWith("{") && s2.endsWith("}")) {
            return gson.fromJson(s2, fclz);
        }
        if (fclz.equals(Key.class)) {
            if ((s2 == null || s2.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s2);
            }
            if (!(required || s2 != null && s2.length() != 0)) {
                return null;
            }
            return Key.make(s2.startsWith("\"") ? s2.substring(1, s2.length() - 1) : s2);
        }
        if (KeyV3.class.isAssignableFrom(fclz)) {
            if ((s2 == null || s2.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s2);
            }
            if (!(required || s2 != null && s2.length() != 0)) {
                return null;
            }
            return KeyV3.make(fclz, Key.make(s2.startsWith("\"") ? s2.substring(1, s2.length() - 1) : s2));
        }
        if (Enum.class.isAssignableFrom(fclz)) {
            return EnumUtils.valueOf(fclz, s2);
        }
        if (FrameV3.class.isAssignableFrom(fclz)) {
            if ((s2 == null || s2.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s2);
            }
            if (!(required || s2 != null && s2.length() != 0)) {
                return null;
            }
            Value v2 = DKV.get(s2);
            if (null == v2) {
                return null;
            }
            if (!v2.isFrame()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s2, "Frame", v2.get().getClass());
            }
            return new FrameV3((Frame)v2.get());
        }
        if (JobV3.class.isAssignableFrom(fclz)) {
            if ((s2 == null || s2.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(s2);
            }
            if (!(required || s2 != null && s2.length() != 0)) {
                return null;
            }
            Value v3 = DKV.get(s2);
            if (null == v3) {
                return null;
            }
            if (!v3.isJob()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s2, "Job", v3.get().getClass());
            }
            return new JobV3().fillFromImpl((Job)v3.get());
        }
        if (FrameV3.ColSpecifierV3.class.isAssignableFrom(fclz)) {
            return new FrameV3.ColSpecifierV3(s2);
        }
        if (ModelSchemaV3.class.isAssignableFrom(fclz)) {
            throw H2O.fail("Can't yet take ModelSchemaV3 as input.");
        }
        throw H2O.fail("Unimplemented schema fill from " + fclz.getSimpleName());
    }

    private static <T> T parseInteger(String s2, Class<T> return_type) {
        try {
            BigDecimal num = new BigDecimal(s2);
            Object result = num.getClass().getDeclaredMethod(return_type.getSimpleName() + "ValueExact", new Class[0]).invoke((Object)num, new Object[0]);
            return (T)result;
        }
        catch (InvocationTargetException ite) {
            throw new NumberFormatException("The expression's numeric value is out of the range of type " + return_type.getSimpleName());
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(return_type.getSimpleName() + " is not an integer data type");
        }
        catch (IllegalAccessException iae) {
            throw H2O.fail("Cannot parse expression as " + return_type.getSimpleName() + " (Illegal Access)");
        }
    }

    private static int read(String s2, int x2, char c2, Class fclz) {
        if (Schema.peek(s2, x2, c2)) {
            return x2 + 1;
        }
        throw new IllegalArgumentException("Expected '" + c2 + "' while reading a " + fclz.getSimpleName() + ", but found " + s2);
    }

    private static boolean peek(String s2, int x2, char c2) {
        return x2 < s2.length() && s2.charAt(x2) == c2;
    }

    private static String[] splitArgs(String argStr) {
        StringBuilder sb = new StringBuilder(argStr);
        StringBuilder arg = new StringBuilder();
        ArrayList<String> splitArgList = new ArrayList<String>();
        boolean inDoubleQuotes = false;
        boolean inSquareBrackets = false;
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            if (sb.charAt(i2) == '\"' && !inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = true;
                arg.append(sb.charAt(i2));
                continue;
            }
            if (sb.charAt(i2) == '\"' && inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = false;
                arg.append(sb.charAt(i2));
                continue;
            }
            if (sb.charAt(i2) == ',' && !inDoubleQuotes && !inSquareBrackets) {
                splitArgList.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (sb.charAt(i2) == '[') {
                inSquareBrackets = true;
                arg.append(sb.charAt(i2));
                continue;
            }
            if (sb.charAt(i2) == ']') {
                inSquareBrackets = false;
                arg.append(sb.charAt(i2));
                continue;
            }
            arg.append(sb.charAt(i2));
        }
        if (arg.length() > 0) {
            splitArgList.add(arg.toString());
        }
        return splitArgList.toArray(new String[splitArgList.size()]);
    }

    public static <T extends Schema> T newInstance(Class<T> clz) {
        try {
            return (T)((Schema)clz.newInstance());
        }
        catch (Exception e2) {
            throw H2O.fail("Failed to instantiate schema of class: " + clz.getCanonicalName(), e2);
        }
    }

    protected static Schema newInstance(String schema_name) {
        return Schema.newInstance(SchemaServer.getSchema(schema_name));
    }

    public StringBuffer markdown(boolean include_input_fields, boolean include_output_fields) {
        return this.markdown(new SchemaMetadata(this), include_input_fields, include_output_fields);
    }

    public StringBuffer markdown(SchemaMetadata meta, boolean include_input_fields, boolean include_output_fields) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1("schema ", this.getClass().getSimpleName());
        builder.hline();
        try {
            boolean first;
            if (include_input_fields) {
                first = true;
                builder.heading2("input fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.INPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "required?", "level", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, String.valueOf(field_meta.required), field_meta.level.name(), field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
            if (include_output_fields) {
                first = true;
                builder.heading2("output fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.OUTPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
        }
        catch (Exception e2) {
            IcedHashMapGeneric.IcedHashMapStringObject values = new IcedHashMapGeneric.IcedHashMapStringObject();
            values.put("schema", this);
            throw new H2OIllegalArgumentException("Caught exception using reflection on schema: " + this, "Caught exception using reflection on schema: " + this + ": " + e2, values);
        }
        return builder.stringBuffer();
    }

    public static interface AutoParseable {
    }
}

