/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.DKVManager;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.api.Handler;
import water.api.RapidsHandler;
import water.api.schemas3.KeyV3;
import water.api.schemas3.RemoveAllV3;
import water.fvec.Vec;
import water.util.Log;

public class RemoveAllHandler
extends Handler {
    public RemoveAllV3 remove(int version, RemoveAllV3 u2) {
        Futures fs = new Futures();
        for (Job j2 : Job.jobs()) {
            j2.stop_requested();
            j2.remove(fs);
        }
        if (RapidsHandler.SESSIONS != null) {
            for (String k2 : RapidsHandler.SESSIONS.keySet()) {
                RapidsHandler.SESSIONS.get(k2).endQuietly(null);
            }
            RapidsHandler.SESSIONS.clear();
        }
        fs.blockForPending();
        if (u2.retained_keys != null && u2.retained_keys.length != 0) {
            this.retainKeys(u2.retained_keys);
        } else {
            this.clearAll();
        }
        Log.info("Finished removing objects");
        return u2;
    }

    private void clearAll() {
        Log.info("Removing all objects");
        new MRTask(119){

            @Override
            public void setupLocal() {
                H2O.raw_clear();
                Vec.ESPC.clear();
            }
        }.doAllNodes();
        H2O.getPM().getIce().cleanUp();
        H2O.updateNotIdle();
    }

    private void retainKeys(KeyV3[] retained_keys) {
        Key[] retainedKeys;
        Log.info(String.format("Removing all objects, except for %d provided key(s)", retained_keys.length));
        if (retained_keys == null) {
            retainedKeys = new Key[]{};
        } else {
            retainedKeys = new Key[retained_keys.length];
            for (int i2 = 0; i2 < retainedKeys.length; ++i2) {
                if (retained_keys[i2] == null) {
                    throw new IllegalArgumentException("An attempt to retain a 'null' key detected. Cleaning operation aborted.");
                }
                retainedKeys[i2] = retained_keys[i2].key();
            }
        }
        DKVManager.retain(retainedKeys);
    }
}

