/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.schemas.ModelBuilderSchema;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.ServiceLoader;
import water.BootstrapFreezable;
import water.DTask;
import water.FetchClazz;
import water.FetchId;
import water.Freezable;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.Icer;
import water.MRTask;
import water.Paxos;
import water.TypeMapExtension;
import water.UDPRebooted;
import water.Weaver;
import water.api.Schema;
import water.api.schemas3.AboutEntryV3;
import water.api.schemas3.AboutV3;
import water.api.schemas3.CloudV3;
import water.api.schemas3.H2OErrorV3;
import water.api.schemas3.ModelBuildersV3;
import water.api.schemas3.NodePersistentStorageV3;
import water.api.schemas3.RequestSchemaV3;
import water.api.schemas3.RouteV3;
import water.api.schemas3.SchemaV3;
import water.api.schemas3.TypeaheadV3;
import water.fvec.C1NChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;
import water.util.IcedAtomicInt;
import water.util.IcedBitSet;
import water.util.IcedDouble;
import water.util.IcedHashMap;
import water.util.IcedHashMapBase;
import water.util.IcedHashMapGeneric;
import water.util.IcedHashSet;
import water.util.IcedLong;
import water.util.IcedSortedHashMap;
import water.util.Log;

public class TypeMap {
    public static final short NULL;
    public static final short PRIM_B;
    public static final short ICED;
    public static final short H2OCC;
    public static final short C1NCHUNK;
    public static final short FRAME;
    public static final short VECGROUP;
    public static final short ESPCGROUP;
    private static final String[] BUILTIN_BOOTSTRAP_CLASSES;
    private static final NonBlockingHashMap<String, Integer> MAP;
    static String[] CLAZZES;
    private static Icer[] GOLD;
    private static int IDS;
    static final int BOOTSTRAP_SIZE;
    public static volatile boolean _check_no_locking;

    static synchronized String[] findAllBootstrapClasses() {
        Object[] additionalBootstrapClasses = new String[]{};
        ServiceLoader<TypeMapExtension> extensionsLoader = ServiceLoader.load(TypeMapExtension.class);
        for (TypeMapExtension ext : extensionsLoader) {
            additionalBootstrapClasses = ArrayUtils.append((String[])additionalBootstrapClasses, ext.getBoostrapClasses());
        }
        Arrays.sort(additionalBootstrapClasses);
        return ArrayUtils.append(BUILTIN_BOOTSTRAP_CLASSES, (String[])additionalBootstrapClasses);
    }

    public static String[] bootstrapClasses() {
        return Arrays.copyOf(CLAZZES, BOOTSTRAP_SIZE);
    }

    public static int getIcedId(String className) {
        Integer I2 = MAP.get(className);
        if (I2 != null) {
            return I2;
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Class " + className + " is not known to H2O.", e2);
        }
        return TypeMap.onIce(className);
    }

    static int onIce(Iced ice) {
        return TypeMap.onIce(ice.getClass().getName());
    }

    static int onIce(Freezable ice) {
        return TypeMap.onIce(ice.getClass().getName());
    }

    public static int onIce(String className) {
        Integer I2 = MAP.get(className);
        if (I2 != null) {
            return I2;
        }
        assert (H2O.CLOUD.size() > 0) : "No cloud when getting type id for " + className;
        Paxos.lockCloud(className);
        int id = H2O.CLOUD.leader() == H2O.SELF ? -1 : FetchId.fetchId(className);
        return TypeMap.install(className, id);
    }

    private static Icer goForGold(int id) {
        Icer[] gold = GOLD;
        return id < gold.length ? gold[id] : null;
    }

    static String classNameLocal(int id) {
        if (id == PRIM_B) {
            return "[B";
        }
        String[] clazs = CLAZZES;
        if (id < clazs.length) {
            return clazs[id];
        }
        return null;
    }

    public static String className(int id) {
        String s2 = TypeMap.classNameLocal(id);
        if (s2 != null) {
            return s2;
        }
        Paxos.lockCloud("Class Id=" + id);
        s2 = FetchClazz.fetchClazz(id);
        if (s2 == null) {
            if (H2O.isCI()) {
                new PrintTypeMap().doAllNodes();
            }
            throw new IllegalStateException("Leader has no mapping for id " + id);
        }
        TypeMap.install(s2, id);
        return s2;
    }

    private static synchronized int install(String className, int id) {
        assert (!_check_no_locking) : "Locking cloud to assign typeid to " + className;
        if (id == -1) {
            assert (H2O.CLOUD.leader() == H2O.SELF);
            Integer i2 = MAP.get(className);
            if (i2 != null) {
                return i2;
            }
            id = IDS++;
        } else {
            String localClassName = TypeMap.classNameLocal(id);
            if (localClassName != null) {
                if (localClassName.equals(className)) {
                    return id;
                }
                throw new IllegalStateException("Inconsistent mapping: id=" + id + " is already mapped to " + localClassName + "; was requested to be mapped to " + className + "!");
            }
        }
        MAP.put(className, id);
        if (id >= CLAZZES.length) {
            CLAZZES = Arrays.copyOf(CLAZZES, Math.max(CLAZZES.length << 1, id + 1));
        }
        if (id >= GOLD.length) {
            GOLD = Arrays.copyOf(GOLD, Math.max(CLAZZES.length << 1, id + 1));
        }
        TypeMap.CLAZZES[id] = className;
        return id;
    }

    public static Icer getIcer(Freezable ice) {
        return TypeMap.getIcer(TypeMap.onIce(ice), ice.getClass());
    }

    static Icer getIcer(int id, Iced ice) {
        return TypeMap.getIcer(id, ice.getClass());
    }

    static Icer getIcer(int id, Freezable ice) {
        return TypeMap.getIcer(id, ice.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Icer getIcer(int id, Class ice_clz) {
        Icer f2 = TypeMap.goForGold(id);
        if (f2 != null) {
            return f2;
        }
        Class clazz = ice_clz;
        synchronized (clazz) {
            f2 = TypeMap.goForGold(id);
            if (f2 != null) {
                return f2;
            }
            try {
                f2 = Weaver.genDelegate(id, ice_clz);
            }
            catch (Exception e2) {
                Log.err("Weaver generally only throws if classfiles are not found, e.g. IDE setups running test code from a remote node that is not in the classpath on this node.");
                throw Log.throwErr(e2);
            }
            Class<TypeMap> clazz2 = TypeMap.class;
            synchronized (TypeMap.class) {
                assert (id < BOOTSTRAP_SIZE || !(f2.theFreezable() instanceof BootstrapFreezable)) : "Class " + ice_clz + " is not BootstrapFreezable";
                TypeMap.GOLD[id] = f2;
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return TypeMap.GOLD[id];
            }
        }
    }

    static Iced newInstance(int id) {
        return (Iced)TypeMap.newFreezable(id);
    }

    static <T extends Freezable> T newFreezable(int id, Class<T> tc) {
        Freezable iced = TypeMap.newFreezable(id);
        assert (tc == null || tc.isInstance(iced)) : tc.getName() + " != " + iced.getClass().getName() + ", id = " + id;
        return (T)iced;
    }

    public static Freezable newFreezable(int id) {
        Freezable iced = TypeMap.theFreezable(id);
        assert (iced != null) : "No instance of id " + id + ", class=" + CLAZZES[id];
        return iced.clone();
    }

    public static Freezable newFreezable(String className) {
        return TypeMap.theFreezable(TypeMap.onIce(className)).clone();
    }

    public static Freezable theFreezable(int id) {
        try {
            Icer f2 = TypeMap.goForGold(id);
            return (f2 == null ? TypeMap.getIcer(id, Class.forName(TypeMap.className(id))) : f2).theFreezable();
        }
        catch (ClassNotFoundException e2) {
            throw Log.throwErr(e2);
        }
    }

    public static Freezable getTheFreezableOrThrow(int id) throws ClassNotFoundException {
        Icer f2 = TypeMap.goForGold(id);
        return (f2 == null ? TypeMap.getIcer(id, Class.forName(TypeMap.className(id))) : f2).theFreezable();
    }

    static void printTypeMap(PrintStream ps) {
        String[] clazzes = CLAZZES;
        for (int i2 = 0; i2 < clazzes.length; ++i2) {
            String className = CLAZZES[i2];
            ps.println(i2 + " -> " + className + " (map: " + (className != null ? MAP.get(className) : null) + ")");
        }
    }

    static {
        BUILTIN_BOOTSTRAP_CLASSES = new String[]{" BAD", "[B", Iced.class.getName(), H2O.H2OCountedCompleter.class.getName(), HeartBeat.class.getName(), H2ONode.class.getName(), FetchClazz.class.getName(), FetchId.class.getName(), DTask.class.getName(), Chunk.class.getName(), C1NChunk.class.getName(), Frame.class.getName(), Vec.VectorGroup.class.getName(), Vec.ESPC.class.getName(), Schema.class.getName(), RequestSchemaV3.class.getName(), SchemaV3.Meta.class.getName(), SchemaV3.class.getName(), CloudV3.class.getName(), CloudV3.NodeV3.class.getName(), AboutV3.class.getName(), AboutEntryV3.class.getName(), UDPRebooted.ShutdownTsk.class.getName(), H2OErrorV3.class.getName(), RouteV3.class.getName(), ModelBuildersV3.class.getName(), IcedSortedHashMap.class.getName(), ModelBuilderSchema.IcedHashMapStringModelBuilderSchema.class.getName(), NodePersistentStorageV3.class.getName(), NodePersistentStorageV3.NodePersistentStorageEntryV3.class.getName(), IcedLong.class.getName(), IcedAtomicInt.class.getName(), IcedDouble.class.getName(), IcedBitSet.class.getName(), IcedHashSet.class.getName(), IcedHashMap.class.getName(), IcedHashMapBase.class.getName(), IcedHashMapGeneric.class.getName(), IcedHashMapGeneric.IcedHashMapStringString.class.getName(), IcedHashMapGeneric.IcedHashMapStringObject.class.getName(), TypeaheadV3.class.getName()};
        MAP = new NonBlockingHashMap();
        CLAZZES = TypeMap.findAllBootstrapClasses();
        BOOTSTRAP_SIZE = CLAZZES.length;
        GOLD = new Icer[BOOTSTRAP_SIZE];
        int id = 0;
        for (String s2 : CLAZZES) {
            MAP.put(s2, id++);
        }
        IDS = id;
        assert (IDS == BOOTSTRAP_SIZE);
        NULL = (short)-1;
        PRIM_B = (short)TypeMap.onIce("[B");
        ICED = (short)TypeMap.onIce("water.Iced");
        assert (ICED == 2);
        H2OCC = (short)TypeMap.onIce("water.H2O$H2OCountedCompleter");
        assert (H2OCC == 3);
        C1NCHUNK = (short)TypeMap.onIce("water.fvec.C1NChunk");
        FRAME = (short)TypeMap.onIce("water.fvec.Frame");
        VECGROUP = (short)TypeMap.onIce("water.fvec.Vec$VectorGroup");
        ESPCGROUP = (short)TypeMap.onIce("water.fvec.Vec$ESPC");
    }

    private static class PrintTypeMap
    extends MRTask<PrintTypeMap> {
        private PrintTypeMap() {
        }

        @Override
        protected void setupLocal() {
            System.err.println("TypeMap dump on node " + H2O.SELF);
            TypeMap.printTypeMap(System.err);
        }
    }
}

