/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.ModelBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import water.AbstractH2OExtension;
import water.AutoBuffer;
import water.Cleaner;
import water.ClientDisconnectCheckThread;
import water.ClientRandomDisconnectThread;
import water.DTask;
import water.ExtensionManager;
import water.Freezable;
import water.Futures;
import water.H2ONode;
import water.H2ORuntime;
import water.HeartBeatThread;
import water.Iced;
import water.Icer;
import water.JavaVersionSupport;
import water.Job;
import water.Key;
import water.MultiReceiverThread;
import water.Paxos;
import water.RPC;
import water.RestApiPingCheckThread;
import water.Scope;
import water.TypeMap;
import water.UDPRebooted;
import water.Value;
import water.api.Handler;
import water.api.LogsHandler;
import water.api.RequestServer;
import water.exceptions.H2OFailException;
import water.exceptions.H2OIllegalArgumentException;
import water.init.AbstractBuildVersion;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.EmbeddedConfigProvider;
import water.init.JarHash;
import water.init.NetworkInit;
import water.init.NodePersistentStorage;
import water.nbhm.NonBlockingHashMap;
import water.parser.DecryptionTool;
import water.parser.ParserService;
import water.persist.PersistManager;
import water.server.ServletUtils;
import water.util.ArrayUtils;
import water.util.DistributedException;
import water.util.Log;
import water.util.LogArchiveContainer;
import water.util.NetworkUtils;
import water.util.OSUtils;
import water.util.PrettyPrint;
import water.webserver.iface.WebServer;

public final class H2O {
    public static final String DEFAULT_JKS_PASS = "h2oh2o";
    public static final int H2O_DEFAULT_PORT = 54321;
    public static final OptArgs ARGS = new OptArgs();
    public static volatile AbstractEmbeddedH2OConfig embeddedH2OConfig;
    private static volatile boolean _shutdownRequested;
    public static final AbstractBuildVersion ABV;
    private static boolean _haveInheritedLog4jConfiguration;
    private static ArrayList<AboutEntry> aboutEntries;
    private static final AtomicLong nextModelNum;
    private static volatile long lastTimeSomethingHappenedMillis;
    private static volatile AtomicInteger activeRapidsExecs;
    public static final AtomicLong START_TIME_MILLIS;
    public static final int NUMCPUS;
    public static final long PID;
    private static final ExtensionManager extManager;
    public static final byte MAX_PRIORITY = 126;
    public static final byte ACK_ACK_PRIORITY = 126;
    public static final byte FETCH_ACK_PRIORITY = 125;
    public static final byte ACK_PRIORITY = 124;
    public static final byte DESERIAL_PRIORITY = 123;
    public static final byte INVALIDATE_PRIORITY = 123;
    public static final byte GET_KEY_PRIORITY = 122;
    public static final byte PUT_KEY_PRIORITY = 121;
    public static final byte ATOMIC_PRIORITY = 120;
    public static final byte GUI_PRIORITY = 119;
    public static final byte MIN_HI_PRIORITY = 119;
    public static final byte MIN_PRIORITY = 0;
    private static final PrioritizedForkJoinPool[] FJPS;
    public static int LOW_PRIORITY_API_WORK;
    public static String LOW_PRIORITY_API_WORK_CLASS;
    public static int H2O_PORT;
    public static int API_PORT;
    public static MulticastSocket CLOUD_MULTICAST_SOCKET;
    public static NetworkInterface CLOUD_MULTICAST_IF;
    public static InetAddress CLOUD_MULTICAST_GROUP;
    public static int CLOUD_MULTICAST_PORT;
    public static H2ONode SELF;
    public static InetAddress SELF_ADDRESS;
    static final boolean IS_IPV6;
    public static URI ICE_ROOT;
    private static Set<H2ONode> STATIC_H2OS;
    private static final H2O[] CLOUDS;
    static final String DEBUG_ARG = "h2o.debug";
    static final boolean DEBUG;
    public static final long CLUSTER_ID;
    private static WebServer webServer;
    public static volatile H2O CLOUD;
    public final H2ONode[] _memary;
    private HashMap<String, Integer> _node_ip_to_index;
    final int _hash;
    final char _idx;
    public static final NonBlockingHashMap<Key, Value> STORE;
    private static PersistManager _PM;
    private static NodePersistentStorage NPS;
    private static boolean JAVA_CHECK_PASSED;

    public static void printHelp() {
        String defaultFlowDirMessage = H2O.DEFAULT_FLOW_DIR() == null ? "          (The default is none; saving flows not available.)\n" : "          (The default is '" + H2O.DEFAULT_FLOW_DIR() + "'.)\n";
        String s2 = "\nUsage:  java [-Xmx<size>] -jar h2o.jar [options]\n        (Note that every option has a default and is optional.)\n\n    -h | -help\n          Print this help.\n\n    -version\n          Print version info and exit.\n\n    -name <h2oCloudName>\n          Cloud name used for discovery of other nodes.\n          Nodes with the same cloud name will form an H2O cloud\n          (also known as an H2O cluster).\n\n    -flatfile <flatFileName>\n          Configuration file explicitly listing H2O cloud node members.\n\n    -ip <ipAddressOfNode>\n          IP address of this node.\n\n    -port <port>\n          Port number for this node (note: port+1 is also used by default).\n          (The default port is " + H2O.ARGS.port + ".)\n\n    -network <IPv4network1Specification>[,<IPv4network2Specification> ...]\n          The IP address discovery code will bind to the first interface\n          that matches one of the networks in the comma-separated list.\n          Use instead of -ip when a broad range of addresses is legal.\n          (Example network specification: '10.1.2.0/24' allows 256 legal\n          possibilities.)\n\n    -ice_root <fileSystemPath>\n          The directory where H2O spills temporary data to disk.\n\n    -log_dir <fileSystemPath>\n          The directory where H2O writes logs to disk.\n          (This usually has a good default that you need not change.)\n\n    -log_level <TRACE,DEBUG,INFO,WARN,ERRR,FATAL>\n          Write messages at this logging level, or above.  Default is INFO.\n\n    -max_log_file_size\n          Maximum size of INFO and DEBUG log files. The file is rolled over after a specified size has been reached.\n          (The default is 3MB. Minimum is 1MB and maximum is 99999MB)\n\n    -flow_dir <server side directory or HDFS directory>\n          The directory where H2O stores saved flows.\n" + defaultFlowDirMessage + "\n    -nthreads <#threads>\n          Maximum number of threads in the low priority batch-work queue.\n          (The default is " + (char)H2ORuntime.availableProcessors() + ".)\n\n    -client\n          Launch H2O node in client mode.\n\n    -notify_local <fileSystemPath>\n          Specifies a file to write when the node is up. The file contains one line with the IP and\n          port of the embedded web server. e.g. 192.168.1.100:54321\n\n    -context_path <context_path>\n          The context path for jetty.\n\nAuthentication options:\n\n    -jks <filename>\n          Java keystore file\n\n    -jks_pass <password>\n          (Default is '" + DEFAULT_JKS_PASS + "')\n\n    -jks_alias <alias>\n          (Optional, use if the keystore has multiple certificates and you want to use a specific one.)\n\n    -hostname_as_jks_alias\n          (Optional, use if you want to use the machine hostname as your certificate alias.)\n\n    -hash_login\n          Use Jetty HashLoginService\n\n    -ldap_login\n          Use Jetty Ldap login module\n\n    -kerberos_login\n          Use Jetty Kerberos login module\n\n    -spnego_login\n          Use Jetty SPNEGO login service\n\n    -pam_login\n          Use Jetty PAM login module\n\n    -login_conf <filename>\n          LoginService configuration file\n\n    -spnego_properties <filename>\n          SPNEGO login module configuration file\n\n    -form_auth\n          Enables Form-based authentication for Flow (default is Basic authentication)\n\n    -session_timeout <minutes>\n          Specifies the number of minutes that a session can remain idle before the server invalidates\n          the session and requests a new login. Requires '-form_auth'. Default is no timeout\n\n    -internal_security_conf <filename>\n          Path (absolute or relative) to a file containing all internal security related configurations\n\nCloud formation behavior:\n\n    New H2O nodes join together to form a cloud at startup time.\n    Once a cloud is given work to perform, it locks out new members\n    from joining.\n\nExamples:\n\n    Start an H2O node with 4GB of memory and a default cloud name:\n        $ java -Xmx4g -jar h2o.jar\n\n    Start an H2O node with 6GB of memory and a specify the cloud name:\n        $ java -Xmx6g -jar h2o.jar -name MyCloud\n\n    Start an H2O cloud with three 2GB nodes and a default cloud name:\n        $ java -Xmx2g -jar h2o.jar &\n        $ java -Xmx2g -jar h2o.jar &\n        $ java -Xmx2g -jar h2o.jar &\n\n";
        System.out.print(s2);
        for (AbstractH2OExtension e2 : extManager.getCoreExtensions()) {
            e2.printHelp();
        }
    }

    public static void parseFailed(String message) {
        System.out.println("");
        System.out.println("ERROR: " + message);
        System.out.println("");
        H2O.printHelp();
        H2O.exitQuietly(1);
    }

    public static void clusterInitializationFailed() {
        Log.flushBufferedMessagesToStdout();
        H2O.exitQuietly(1);
    }

    static void parseArguments(String[] args) {
        for (AbstractH2OExtension e2 : extManager.getCoreExtensions()) {
            args = e2.parseArguments(args);
        }
        H2O.parseH2OArgumentsTo(args, ARGS);
    }

    public static OptArgs parseH2OArgumentsTo(String[] args, OptArgs trgt) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String value;
            OptString s2 = new OptString(args[i2]);
            if (s2.matches("h") || s2.matches("help")) {
                trgt.help = true;
                continue;
            }
            if (s2.matches("version")) {
                trgt.version = true;
                continue;
            }
            if (s2.matches("name")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.name = args[i2];
                continue;
            }
            if (s2.matches("flatfile")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.flatfile = args[i2];
                continue;
            }
            if (s2.matches("port")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.port = s2.parsePort(args[i2]);
                continue;
            }
            if (s2.matches("baseport")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.baseport = s2.parsePort(args[i2]);
                continue;
            }
            if (s2.matches("port_offset")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.port_offset = s2.parsePort(args[i2]);
                continue;
            }
            if (s2.matches("ip")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.ip = args[i2];
                continue;
            }
            if (s2.matches("web_ip")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.web_ip = args[i2];
                continue;
            }
            if (s2.matches("network")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.network = args[i2];
                continue;
            }
            if (s2.matches("client")) {
                trgt.client = true;
                continue;
            }
            if (s2.matches("allow_clients")) {
                trgt.allow_clients = true;
                continue;
            }
            if (s2.matches("allow_unsupported_java")) {
                trgt.allow_unsupported_java = true;
                continue;
            }
            if (s2.matches("rest_api_ping_timeout")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.rest_api_ping_timeout = s2.parseInt(args[i2]);
                continue;
            }
            if (s2.matches("notify_local")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.notify_local = args[i2];
                continue;
            }
            if (s2.matches("off_heap_memory_ratio")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.off_heap_memory_ratio = Double.parseDouble(args[i2]);
                continue;
            }
            if (s2.matches("user_name")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.user_name = args[i2];
                continue;
            }
            if (s2.matches("ice_root")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.ice_root = args[i2];
                continue;
            }
            if (s2.matches("log_dir")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.log_dir = args[i2];
                continue;
            }
            if (s2.matches("flow_dir")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.flow_dir = args[i2];
                continue;
            }
            if (s2.matches("disable_web")) {
                trgt.disable_web = true;
                continue;
            }
            if (s2.matches("disable_net")) {
                trgt.disable_net = true;
                continue;
            }
            if (s2.matches("disable_flow")) {
                trgt.disable_flow = true;
                continue;
            }
            if (s2.matches("context_path")) {
                String value2 = args[i2 = s2.incrementAndCheck(i2, args)];
                trgt.context_path = value2.startsWith("/") ? (value2.trim().length() == 1 ? "" : value2) : "/" + value2;
                continue;
            }
            if (s2.matches("nthreads")) {
                int nthreads = s2.parseInt(args[i2 = s2.incrementAndCheck(i2, args)]);
                if (nthreads < 1) continue;
                if (nthreads > Short.MAX_VALUE) {
                    throw H2O.unimpl("Can't handle more than 32767 threads.");
                }
                trgt.nthreads = (short)nthreads;
                continue;
            }
            if (s2.matches("hdfs_config")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.hdfs_config = ArrayUtils.append(trgt.hdfs_config, args[i2]);
                continue;
            }
            if (s2.matches("hdfs_skip")) {
                trgt.hdfs_skip = true;
                continue;
            }
            if (s2.matches("H")) {
                i2 = s2.incrementAndCheck(i2, args);
                String key = args[i2];
                i2 = s2.incrementAndCheck(i2, args);
                value = args[i2];
                trgt.hadoop_properties.setProperty(key, value);
                continue;
            }
            if (s2.matches("aws_credentials")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.aws_credentials = args[i2];
                continue;
            }
            if (s2.matches("configure_s3_using_s3a")) {
                trgt.configure_s3_using_s3a = true;
                continue;
            }
            if (s2.matches("ga_hadoop_ver")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.ga_hadoop_ver = args[i2];
                continue;
            }
            if (s2.matches("ga_opt_out")) {
                if (i2 + 1 >= args.length || !args[i2 + 1].equals("yes")) continue;
                ++i2;
                continue;
            }
            if (s2.matches("auto_recovery_dir")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.auto_recovery_dir = args[i2];
                continue;
            }
            if (s2.matches("log_level")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.log_level = args[i2];
                continue;
            }
            if (s2.matches("max_log_file_size")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.max_log_file_size = s2.checkFileSize(args[i2]);
                continue;
            }
            if (s2.matches("random_udp_drop")) {
                trgt.random_udp_drop = true;
                continue;
            }
            if (s2.matches("md5skip")) {
                trgt.md5skip = true;
                continue;
            }
            if (s2.matches("quiet")) {
                trgt.quiet = true;
                continue;
            }
            if (s2.matches("cleaner")) {
                trgt.cleaner = true;
                continue;
            }
            if (s2.matches("jks")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.jks = args[i2];
                continue;
            }
            if (s2.matches("jks_pass")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.jks_pass = args[i2];
                continue;
            }
            if (s2.matches("jks_alias")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.jks_alias = args[i2];
                continue;
            }
            if (s2.matches("hostname_as_jks_alias")) {
                trgt.hostname_as_jks_alias = true;
                continue;
            }
            if (s2.matches("hash_login")) {
                trgt.hash_login = true;
                continue;
            }
            if (s2.matches("ldap_login")) {
                trgt.ldap_login = true;
                continue;
            }
            if (s2.matches("kerberos_login")) {
                trgt.kerberos_login = true;
                continue;
            }
            if (s2.matches("spnego_login")) {
                trgt.spnego_login = true;
                continue;
            }
            if (s2.matches("pam_login")) {
                trgt.pam_login = true;
                continue;
            }
            if (s2.matches("login_conf")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.login_conf = args[i2];
                continue;
            }
            if (s2.matches("spnego_properties")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.spnego_properties = args[i2];
                continue;
            }
            if (s2.matches("form_auth")) {
                trgt.form_auth = true;
                continue;
            }
            if (s2.matches("session_timeout")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.session_timeout_spec = args[i2];
                try {
                    trgt.session_timeout = Integer.parseInt(args[i2]);
                }
                catch (Exception key) {}
                continue;
            }
            if (s2.matches("internal_security_conf")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.internal_security_conf = args[i2];
                continue;
            }
            if (s2.matches("internal_security_conf_rel_paths")) {
                trgt.internal_security_conf_rel_paths = true;
                continue;
            }
            if (s2.matches("allow_insecure_xgboost")) {
                trgt.allow_insecure_xgboost = true;
                continue;
            }
            if (s2.matches("use_external_xgboost")) {
                trgt.use_external_xgboost = true;
                continue;
            }
            if (s2.matches("decrypt_tool")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.decrypt_tool = args[i2];
                continue;
            }
            if (s2.matches("principal")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.principal = args[i2];
                continue;
            }
            if (s2.matches("keytab")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.keytab_path = args[i2];
                continue;
            }
            if (s2.matches("hdfs_token_refresh_interval")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.hdfs_token_refresh_interval = args[i2];
                continue;
            }
            if (s2.matches("no_latest_check")) {
                Log.trace("Invoked with 'no_latest_check' option (NOOP in current release).");
                continue;
            }
            if (s2.matches("client_disconnect_timeout")) {
                int clientDisconnectTimeout = s2.parseInt(args[i2 = s2.incrementAndCheck(i2, args)]);
                if (clientDisconnectTimeout <= 0) {
                    throw new IllegalArgumentException("Interval for checking if client is disconnected has to be positive (milliseconds).");
                }
                trgt.clientDisconnectTimeout = clientDisconnectTimeout;
                continue;
            }
            if (s2.matches("useUDP")) {
                Log.warn("Support for UDP communication was removed from H2O, using TCP.");
                continue;
            }
            if (s2.matches("watchdog_client_retry_timeout")) {
                H2O.warnWatchdogRemoved("watchdog_client_retry_timeout");
                continue;
            }
            if (s2.matches("watchdog_client")) {
                H2O.warnWatchdogRemoved("watchdog_client");
                continue;
            }
            if (s2.matches("watchdog_client_connect_timeout")) {
                H2O.warnWatchdogRemoved("watchdog_client_connect_timeout");
                continue;
            }
            if (s2.matches("watchdog_stop_without_client")) {
                H2O.warnWatchdogRemoved("watchdog_stop_without_client");
                continue;
            }
            if (s2.matches("features")) {
                i2 = s2.incrementAndCheck(i2, args);
                trgt.features_level = ModelBuilder.BuilderVisibility.valueOfIgnoreCase(args[i2]);
                Log.info(String.format("Limiting algorithms available to level: %s", trgt.features_level.name()));
                continue;
            }
            if (s2.matches("add_http_header")) {
                i2 = s2.incrementAndCheck(i2, args);
                String key = args[i2];
                i2 = s2.incrementAndCheck(i2, args);
                value = args[i2];
                trgt.extra_headers = ArrayUtils.append(trgt.extra_headers, new KeyValueArg(key, value));
                continue;
            }
            if (s2.matches("embedded")) {
                trgt.embedded = true;
                continue;
            }
            H2O.parseFailed("Unknown argument (" + s2 + ")");
        }
        return trgt;
    }

    private static void warnWatchdogRemoved(String param) {
        Log.warn("Support for watchdog client communication was removed and '" + param + "' argument has no longer any effect. It will be removed in the next major release 3.30.");
    }

    private static void validateArguments() {
        if (H2O.ARGS.jks != null && !new File(H2O.ARGS.jks).exists()) {
            H2O.parseFailed("File does not exist: " + H2O.ARGS.jks);
        }
        if (H2O.ARGS.jks_alias != null && H2O.ARGS.hostname_as_jks_alias) {
            H2O.parseFailed("Options -jks_alias and -hostname_as_jks_alias are mutually exclusive, specify only one of them");
        }
        if (H2O.ARGS.login_conf != null && !new File(H2O.ARGS.login_conf).exists()) {
            H2O.parseFailed("File does not exist: " + H2O.ARGS.login_conf);
        }
        int login_arg_count = 0;
        if (H2O.ARGS.hash_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.ldap_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.kerberos_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.spnego_login) {
            ++login_arg_count;
        }
        if (H2O.ARGS.pam_login) {
            ++login_arg_count;
        }
        if (login_arg_count > 1) {
            H2O.parseFailed("Can only specify one of -hash_login, -ldap_login, -kerberos_login, -spnego_login and -pam_login");
        }
        if (H2O.ARGS.hash_login || H2O.ARGS.ldap_login || H2O.ARGS.kerberos_login || H2O.ARGS.pam_login || H2O.ARGS.spnego_login) {
            if (H2O.ARGS.login_conf == null) {
                H2O.parseFailed("Must specify -login_conf argument");
            }
        } else if (H2O.ARGS.form_auth) {
            H2O.parseFailed("No login method was specified. Form-based authentication can only be used in conjunction with of a LoginService.\nPick a LoginService by specifying '-<method>_login' option.");
        }
        if (H2O.ARGS.spnego_login) {
            if (H2O.ARGS.spnego_properties == null) {
                H2O.parseFailed("Must specify -spnego_properties argument");
            }
            if (H2O.ARGS.form_auth) {
                H2O.parseFailed("Form-based authentication not supported when SPNEGO login is enabled.");
            }
        }
        if (H2O.ARGS.session_timeout_spec != null) {
            if (!H2O.ARGS.form_auth) {
                H2O.parseFailed("Session timeout can only be enabled for Form based authentication (use -form_auth)");
            }
            if (H2O.ARGS.session_timeout <= 0) {
                H2O.parseFailed("Invalid session timeout specification (" + H2O.ARGS.session_timeout + ")");
            }
        }
        if (H2O.ARGS.rest_api_ping_timeout < 0) {
            H2O.parseFailed(String.format("rest_api_ping_timeout needs to be 0 or higher, was (%d)", H2O.ARGS.rest_api_ping_timeout));
        }
        for (AbstractH2OExtension e2 : extManager.getCoreExtensions()) {
            e2.validateArguments();
        }
    }

    public static void setEmbeddedH2OConfig(AbstractEmbeddedH2OConfig c2) {
        embeddedH2OConfig = c2;
    }

    public static AbstractEmbeddedH2OConfig getEmbeddedH2OConfig() {
        if (embeddedH2OConfig != null) {
            return embeddedH2OConfig;
        }
        embeddedH2OConfig = H2O.discoverEmbeddedConfigProvider().map(embeddedConfigProvider -> {
            Log.info(String.format("Dynamically loaded '%s' as AbstractEmbeddedH2OConfigProvider.", embeddedConfigProvider.getName()));
            return embeddedConfigProvider.getConfig();
        }).orElse(null);
        return embeddedH2OConfig;
    }

    private static Optional<EmbeddedConfigProvider> discoverEmbeddedConfigProvider() throws IllegalStateException {
        ServiceLoader<EmbeddedConfigProvider> configProviders = ServiceLoader.load(EmbeddedConfigProvider.class);
        EmbeddedConfigProvider provider = null;
        for (EmbeddedConfigProvider candidateProvider : configProviders) {
            candidateProvider.init();
            if (!candidateProvider.isActive()) continue;
            if (provider != null) {
                throw new IllegalStateException("Multiple active EmbeddedH2OConfig providers: " + provider.getName() + " and " + candidateProvider.getName() + " (possibly other as well).");
            }
            provider = candidateProvider;
        }
        return Optional.ofNullable(provider);
    }

    public static void notifyAboutCloudSize(InetAddress ip, int port, InetAddress leaderIp, int leaderPort, int size) {
        if (H2O.ARGS.notify_local != null && !H2O.ARGS.notify_local.trim().isEmpty()) {
            File notifyFile = new File(H2O.ARGS.notify_local);
            File parentDir = notifyFile.getParentFile();
            if (parentDir != null && !parentDir.isDirectory() && !parentDir.mkdirs()) {
                Log.err("Cannot make parent dir for notify file.");
                H2O.exit(-1);
            }
            try (BufferedWriter output = new BufferedWriter(new FileWriter(notifyFile));){
                output.write(SELF_ADDRESS.getHostAddress());
                output.write(58);
                output.write(Integer.toString(API_PORT));
                output.flush();
            }
            catch (IOException e2) {
                Log.err("Unable to write notify file.");
                H2O.exit(-1);
            }
        }
        if (embeddedH2OConfig != null) {
            embeddedH2OConfig.notifyAboutCloudSize(ip, port, leaderIp, leaderPort, size);
        }
    }

    public static void closeAll() {
        try {
            H2O.getWebServer().stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NetworkInit.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistManager PM = H2O.getPM();
        if (PM != null) {
            PM.getIce().cleanUp();
        }
    }

    public static void exit(int status) {
        Log.notifyAboutProcessExiting();
        H2O.exitQuietly(status);
    }

    private static void exitQuietly(int status) {
        if (embeddedH2OConfig != null) {
            embeddedH2OConfig.exit(status);
        }
        System.exit(status);
    }

    public static void shutdown(int status) {
        if (status == 0) {
            H2O.orderlyShutdown();
        }
        UDPRebooted.T.error.send(SELF);
        H2O.exit(status);
    }

    public static int orderlyShutdown() {
        return H2O.orderlyShutdown(-1);
    }

    public static int orderlyShutdown(int timeout) {
        boolean[] confirmations = new boolean[CLOUD.size()];
        if (SELF.index() >= 0) {
            confirmations[H2O.SELF.index()] = true;
        }
        Futures fs = new Futures();
        for (H2ONode n2 : H2O.CLOUD._memary) {
            if (n2 == SELF) continue;
            fs.add(new RPC<UDPRebooted.ShutdownTsk>(n2, new UDPRebooted.ShutdownTsk(SELF, n2.index(), 1000, confirmations, 0)).call());
        }
        if (timeout > 0) {
            try {
                Thread.sleep(timeout);
            }
            catch (Exception exception) {}
        } else {
            fs.blockForPending();
        }
        int failedToShutdown = 0;
        for (boolean b2 : confirmations) {
            if (b2) continue;
            ++failedToShutdown;
        }
        return failedToShutdown;
    }

    public static void requestShutdown() {
        _shutdownRequested = true;
    }

    public static boolean getShutdownRequested() {
        return _shutdownRequested;
    }

    public static boolean haveInheritedLog4jConfiguration() {
        return _haveInheritedLog4jConfiguration;
    }

    public static void configureLogging() {
        if (LogManager.getCurrentLoggers().hasMoreElements()) {
            _haveInheritedLog4jConfiguration = true;
            return;
        }
        if (System.getProperty("log4j.configuration") != null) {
            _haveInheritedLog4jConfiguration = true;
            return;
        }
        Properties p2 = new Properties();
        p2.setProperty("log4j.rootCategory", "WARN, console");
        p2.setProperty("log4j.logger.org.eclipse.jetty", "WARN");
        p2.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        p2.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.console.layout.ConversionPattern", "%m%n");
        PropertyConfigurator.configure((Properties)p2);
        System.setProperty("ai.h2o.org.eclipse.jetty.LEVEL", "WARN");
        System.setProperty("ai.h2o.org.eclipse.jetty.util.log.class", "ai.h2o.org.eclipse.jetty.util.log.StdErrLog");
    }

    public static void addAboutEntry(String name, String value) {
        AboutEntry e2 = new AboutEntry(name, value);
        aboutEntries.add(e2);
    }

    public static ArrayList<AboutEntry> getAboutEntries() {
        return aboutEntries;
    }

    public static String calcNextUniqueModelId(String desc) {
        return H2O.calcNextUniqueObjectId("model", nextModelNum, desc);
    }

    public static synchronized String calcNextUniqueObjectId(String type, AtomicLong sequenceSource, String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append(desc).append('_').append(type).append('_');
        String source = ServletUtils.getUserAgent();
        if (source != null) {
            StringBuilder ua = new StringBuilder();
            if (source.contains("Safari")) {
                ua.append("safari");
            } else if (source.contains("Python")) {
                ua.append("python");
            } else {
                for (int i2 = 0; i2 < source.length(); ++i2) {
                    char c2 = source.charAt(i2);
                    if (c2 >= 'a' && c2 <= 'z') {
                        ua.append(c2);
                        continue;
                    }
                    if (c2 < 'A' || c2 > 'Z') break;
                    ua.append(c2);
                }
            }
            if (ua.toString().length() > 0) {
                sb.append(ua.toString()).append("_");
            }
        }
        long n2 = sequenceSource.addAndGet(1L);
        sb.append(CLUSTER_ID).append("_").append(n2);
        return sb.toString();
    }

    public static long getIdleTimeMillis() {
        long latestEndTimeMillis = -1L;
        if (activeRapidsExecs.get() > 0) {
            H2O.updateNotIdle();
        } else {
            Job[] jobs = Job.jobs();
            for (int i2 = jobs.length - 1; i2 >= 0; --i2) {
                Job j2 = jobs[i2];
                if (j2.isRunning()) {
                    H2O.updateNotIdle();
                    break;
                }
                if (j2.end_time() <= latestEndTimeMillis) continue;
                latestEndTimeMillis = j2.end_time();
            }
        }
        long latestTimeMillis = Math.max(latestEndTimeMillis, lastTimeSomethingHappenedMillis);
        long now = System.currentTimeMillis();
        long deltaMillis = now - latestTimeMillis;
        if (deltaMillis < 0L) {
            deltaMillis = 0L;
        }
        return deltaMillis;
    }

    public static void updateNotIdle() {
        lastTimeSomethingHappenedMillis = System.currentTimeMillis();
    }

    public static void incrementActiveRapidsCounter() {
        H2O.updateNotIdle();
        activeRapidsExecs.incrementAndGet();
    }

    public static void decrementActiveRapidsCounter() {
        H2O.updateNotIdle();
        activeRapidsExecs.decrementAndGet();
    }

    public static String getSysProperty(String name, String def) {
        return System.getProperty("sys.ai.h2o." + name, def);
    }

    public static boolean getSysBoolProperty(String name, boolean def) {
        return Boolean.parseBoolean(H2O.getSysProperty(name, String.valueOf(def)));
    }

    public static H2OIllegalArgumentException unimpl() {
        return new H2OIllegalArgumentException("unimplemented");
    }

    public static H2OIllegalArgumentException unimpl(String msg) {
        return new H2OIllegalArgumentException("unimplemented: " + msg);
    }

    public static H2OFailException fail(String msg, Throwable cause) {
        Log.fatal(msg);
        if (null != cause) {
            Log.fatal(cause);
        }
        Log.fatal("Stacktrace: ");
        Log.fatal(new Exception(msg));
        boolean suppressShutdown = H2O.getSysBoolProperty("suppress.shutdown.on.failure", false);
        if (suppressShutdown) {
            throw new IllegalStateException("Suppressed shutdown for failure: " + msg, cause);
        }
        H2O.shutdown(-1);
        return new H2OFailException(msg);
    }

    public static H2OFailException fail() {
        return H2O.fail("Unknown code failure");
    }

    public static H2OFailException fail(String msg) {
        return H2O.fail(msg, null);
    }

    public static String technote(int number, String message) {
        return message + "\n\nFor more information visit:\n  http://jira.h2o.ai/browse/TN-" + Integer.toString(number);
    }

    public static String technote(int[] numbers, String message) {
        StringBuilder sb = new StringBuilder().append(message).append("\n").append("\n").append("For more information visit:\n");
        for (int number : numbers) {
            sb.append("  http://jira.h2o.ai/browse/TN-").append(Integer.toString(number)).append("\n");
        }
        return sb.toString();
    }

    static int getWrkQueueSize(int i2) {
        return FJPS[i2] == null ? -1 : FJPS[i2].getQueuedSubmissionCount();
    }

    static int getWrkThrPoolSize(int i2) {
        return FJPS[i2] == null ? -1 : FJPS[i2].getPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends H2OCountedCompleter> T submitTask(T task) {
        byte priority = task.priority();
        if (priority < LOW_PRIORITY_API_WORK) {
            LOW_PRIORITY_API_WORK_CLASS = task.getClass().toString();
        }
        if (!$assertionsDisabled) {
            if (0 > priority) throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            if (priority > 126) {
                throw new AssertionError((Object)("priority " + priority + " is out of range, expected range is < " + 0 + "," + 126 + ">"));
            }
        }
        if (FJPS[priority] == null) {
            Class<H2O> clazz = H2O.class;
            // MONITORENTER : water.H2O.class
            if (FJPS[priority] == null) {
                H2O.FJPS[priority] = new PrioritizedForkJoinPool(priority, -1);
            }
            // MONITOREXIT : clazz
        }
        FJPS[priority].submit(task);
        return task;
    }

    public static <T extends RemoteRunnable> T runOnH2ONode(T runnable) {
        H2ONode node = H2O.ARGS.client ? CLOUD.leader() : SELF;
        return H2O.runOnH2ONode(node, runnable);
    }

    public static <T extends RemoteRunnable> T runOnLeaderNode(T runnable) {
        return H2O.runOnH2ONode(CLOUD.leader(), runnable);
    }

    static <T extends RemoteRunnable> T runOnH2ONode(H2ONode node, T runnable) {
        if (node == SELF) {
            runnable.run();
            return runnable;
        }
        RunnableWrapperTask task = new RunnableWrapperTask(runnable, null);
        try {
            return (T)((RunnableWrapperTask)new RPC(node, task).call().get())._runnable;
        }
        catch (DistributedException e2) {
            Log.trace("Exception in calling runnable on a remote node", e2);
            Throwable cause = e2.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : e2;
        }
    }

    public static String getIpPortString() {
        return H2O.ARGS.disable_web ? "" : SELF_ADDRESS.getHostAddress() + ":" + API_PORT;
    }

    public static String getURL(String schema) {
        return H2O.getURL(schema, SELF_ADDRESS, API_PORT, H2O.ARGS.context_path);
    }

    public static String getURL(String schema, InetAddress address, int port, String contextPath) {
        return String.format(address instanceof Inet6Address ? "%s://[%s]:%d%s" : "%s://%s:%d%s", schema, address.getHostAddress(), port, contextPath);
    }

    public static String getURL(String schema, String hostname, int port, String contextPath) {
        return String.format("%s://%s:%d%s", schema, hostname, port, contextPath);
    }

    public static String DEFAULT_ICE_ROOT() {
        String u2;
        String username = System.getProperty("user.name");
        if (username == null) {
            username = "";
        }
        if ((u2 = username.replaceAll(" ", "_")).length() == 0) {
            u2 = "unknown";
        }
        return "/tmp/h2o-" + u2;
    }

    public static String DEFAULT_FLOW_DIR() {
        String flow_dir = null;
        try {
            if (H2O.ARGS.ga_hadoop_ver != null) {
                String s2;
                PersistManager pm = H2O.getPM();
                if (pm != null && pm.exists(s2 = pm.getHdfsHomeDirectory())) {
                    flow_dir = s2;
                }
                if (flow_dir != null) {
                    flow_dir = flow_dir + "/h2oflows";
                }
            } else {
                flow_dir = System.getProperty("user.home") + File.separator + "h2oflows";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flow_dir;
    }

    public static void setWebServer(WebServer value) {
        webServer = value;
    }

    public static WebServer getWebServer() {
        return webServer;
    }

    private static void printAndLogVersion(String[] arguments2) {
        Log.init(H2O.ARGS.log_level, H2O.ARGS.quiet, H2O.ARGS.max_log_file_size);
        Log.info("----- H2O started " + (H2O.ARGS.client ? "(client)" : "") + " -----");
        Log.info("Build git branch: " + ABV.branchName());
        Log.info("Build git hash: " + ABV.lastCommitHash());
        Log.info("Build git describe: " + ABV.describe());
        Log.info("Build project version: " + ABV.projectVersion());
        Log.info("Build age: " + PrettyPrint.toAge(ABV.compiledOnDate(), new Date()));
        Log.info("Built by: '" + ABV.compiledBy() + "'");
        Log.info("Built on: '" + ABV.compiledOn() + "'");
        if (ABV.isTooOld()) {
            Log.warn("\n*** Your H2O version is too old! Please download the latest version from http://h2o.ai/download/ ***");
            Log.warn("");
        }
        Log.info("Found H2O Core extensions: " + extManager.getCoreExtensions());
        Log.info("Processed H2O arguments: ", Arrays.toString(arguments2));
        Runtime runtime = Runtime.getRuntime();
        Log.info("Java availableProcessors: " + H2ORuntime.availableProcessors());
        Log.info("Java heap totalMemory: " + PrettyPrint.bytes(runtime.totalMemory()));
        Log.info("Java heap maxMemory: " + PrettyPrint.bytes(runtime.maxMemory()));
        Log.info("Java version: Java " + System.getProperty("java.version") + " (from " + System.getProperty("java.vendor") + ")");
        List<String> launchStrings = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Log.info("JVM launch parameters: " + launchStrings);
        Log.info("JVM process id: " + ManagementFactory.getRuntimeMXBean().getName());
        Log.info("OS version: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        long totalMemory = OSUtils.getTotalPhysicalMemory();
        Log.info("Machine physical memory: " + (totalMemory == -1L ? "NA" : PrettyPrint.bytes(totalMemory)));
        Log.info("Machine locale: " + Locale.getDefault());
    }

    private static void startLocalNode() {
        NetworkInit.initializeNetworkSockets();
        if (!H2O.ARGS.client && H2O.isFlatfileEnabled() && !H2O.isNodeInFlatfile(SELF)) {
            Log.warn("Flatfile configuration does not include self: " + SELF + ", but contains " + H2O.getFlatfile());
            H2O.addNodeToFlatfile(SELF);
        }
        if (!H2O.ARGS.disable_net) {
            Log.info("H2O cloud name: '" + H2O.ARGS.name + "' on " + SELF + (H2O.isFlatfileEnabled() ? ", static configuration based on -flatfile " + H2O.ARGS.flatfile : ", discovery address " + CLOUD_MULTICAST_GROUP + ":" + CLOUD_MULTICAST_PORT));
        }
        if (!H2O.ARGS.disable_web) {
            Log.info("If you have trouble connecting, try SSH tunneling from your local machine (e.g., via port 55555):\n  1. Open a terminal and run 'ssh -L 55555:localhost:" + API_PORT + " " + System.getProperty("user.name") + "@" + SELF_ADDRESS.getHostAddress() + "'\n  2. Point your browser to " + NetworkInit.h2oHttpView.getScheme() + "://localhost:55555");
        }
        if (H2O.ARGS.rest_api_ping_timeout > 0) {
            Log.info(String.format("Registering REST API Check Thread. If 3/Ping endpoint is not accessed during %d ms, the cluster will be terminated.", H2O.ARGS.rest_api_ping_timeout));
            new RestApiPingCheckThread().start();
        }
        H2O.SELF._heartbeat._jar_md5 = JarHash.JARHASH;
        H2O.SELF._heartbeat._client = H2O.ARGS.client;
        H2O.SELF._heartbeat._cloud_name_hash = H2O.ARGS.name.hashCode();
    }

    private static void startNetworkServices() {
        Cleaner.THE_CLEANER.start();
        if (H2O.ARGS.disable_net) {
            return;
        }
        UDPRebooted.T.reboot.broadcast();
        new MultiReceiverThread().start();
        NetworkInit.makeReceiverThread().start();
    }

    @Deprecated
    public static void register(String method_url, Class<? extends Handler> hclass, String method, String apiName, String summary) {
        Log.warn("The H2O.register method is deprecated and will be removed in the next major release.Please register REST API endpoints as part of their corresponding REST API extensions!");
        RequestServer.registerEndpoint(apiName, method_url, hclass, method, summary);
    }

    public static void registerResourceRoot(File f2) {
        JarHash.registerResourceRoot(f2);
    }

    @Deprecated
    public static void finalizeRegistration() {
        H2O.startServingRestApi();
    }

    public static void startServingRestApi() {
        if (!H2O.ARGS.disable_web) {
            NetworkInit.h2oHttpView.acceptRequests();
        }
    }

    public H2ONode getNodeByIpPort(String ipPort) {
        if (this._node_ip_to_index != null) {
            Integer index = this._node_ip_to_index.get(ipPort);
            if (index != null) {
                if (index == -1) {
                    return SELF;
                }
                if (index <= -1 || index >= this._memary.length) {
                    throw new RuntimeException("Mapping from node id to node index contains: " + index + ", however this nodedoes not exist!");
                }
                return this._memary[index];
            }
            return null;
        }
        return null;
    }

    H2O(H2ONode[] h2os, int hash, int idx) {
        this(h2os, false, hash, idx);
    }

    H2O(H2ONode[] h2os, boolean presorted, int hash, int idx) {
        this._memary = h2os;
        if (!presorted) {
            Arrays.sort(this._memary);
        }
        this._hash = hash;
        this._idx = (char)(idx & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_next_Cloud(H2ONode[] h2os, int hash) {
        H2ONode[] h2ONodeArray = this;
        synchronized (this) {
            int idx = this._idx + '\u0001';
            if (idx == 256) {
                idx = 1;
            }
            H2O.CLOUDS[idx] = CLOUD = new H2O(h2os, hash, idx);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            H2O.SELF._heartbeat._cloud_size = (char)CLOUD.size();
            H2O.CLOUD._node_ip_to_index = new HashMap();
            for (H2ONode node : H2O.CLOUD._memary) {
                H2O.CLOUD._node_ip_to_index.put(node.getIpPortString(), node.index());
            }
            return;
        }
    }

    static boolean larger(int nnn, int old) {
        assert (0 <= nnn && nnn <= 255);
        assert (0 <= old && old <= 255);
        return (nnn - old & 0xFF) < 64;
    }

    public final int size() {
        return this._memary.length;
    }

    public boolean isSingleNode() {
        return this.size() == 1;
    }

    public final H2ONode leader() {
        return this._memary[0];
    }

    public final H2ONode leaderOrNull() {
        return this._memary.length > 0 ? this._memary[0] : null;
    }

    int nidx(H2ONode h2o) {
        return Arrays.binarySearch(this._memary, h2o);
    }

    boolean contains(H2ONode h2o) {
        return this.nidx(h2o) >= 0;
    }

    public String toString() {
        return Arrays.toString(this._memary);
    }

    public H2ONode[] members() {
        return this._memary;
    }

    public long free_mem() {
        long memsz = 0L;
        for (H2ONode h2o : H2O.CLOUD._memary) {
            memsz += h2o._heartbeat.get_free_mem();
        }
        return memsz;
    }

    public boolean healthy() {
        long now = System.currentTimeMillis();
        for (H2ONode node : CLOUD.members()) {
            if (node.isHealthy(now)) continue;
            return false;
        }
        return true;
    }

    public static void waitForCloudSize(int x2, long ms) {
        long start = System.currentTimeMillis();
        if (!H2O.cloudIsReady(x2)) {
            Log.info("Waiting for clouding to finish. Current number of nodes " + CLOUD.size() + ". Target number of nodes: " + x2);
        }
        while (System.currentTimeMillis() - start < ms && !H2O.cloudIsReady(x2)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (CLOUD.size() < x2) {
            throw new RuntimeException("Cloud size " + CLOUD.size() + " under " + x2 + ". Consider to increase `DEFAULT_TIME_FOR_CLOUDING`.");
        }
    }

    private static boolean cloudIsReady(int x2) {
        return CLOUD.size() >= x2 && Paxos._commonKnowledge;
    }

    public static int getCloudSize() {
        if (!Paxos._commonKnowledge) {
            return -1;
        }
        return CLOUD.size();
    }

    public static void joinOthers() {
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= 2000L || CLOUD.size() > 1 && Paxos._commonKnowledge)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void initializePersistence() {
        _PM = new PersistManager(ICE_ROOT);
    }

    public static Value putIfMatch(Key key, Value val, Value old) {
        Value res;
        if (old != null) {
            key = old._key;
        }
        if (val != null) {
            assert (val._key.equals(key));
            if (val._key != key) {
                val._key = key;
            }
        }
        if ((res = STORE.putIfMatchUnlocked(key, val, old)) != old) {
            return res;
        }
        if (old != null && val == null) {
            old.removePersist();
        }
        if (val != null) {
            Cleaner.dirty_store();
            if (old == null) {
                Scope.track_internal(key);
            }
        }
        return old;
    }

    public static void raw_remove(Key key) {
        Value v2 = STORE.remove(key);
        if (v2 != null) {
            v2.removePersist();
        }
    }

    public static void raw_clear() {
        STORE.clear();
    }

    public static boolean containsKey(Key key) {
        return STORE.get(key) != null;
    }

    static Key getk(Key key) {
        return STORE.getk(key);
    }

    public static Set<Key> localKeySet() {
        return STORE.keySet();
    }

    static Collection<Value> values() {
        return STORE.values();
    }

    public static int store_size() {
        return STORE.size();
    }

    public static String STOREtoString() {
        int[] cnts = new int[1];
        Object[] kvs = STORE.raw_array();
        for (int i2 = 2; i2 < kvs.length; i2 += 2) {
            Object ov = kvs[i2 + 1];
            if (!(ov instanceof Value)) continue;
            Value val = (Value)ov;
            if (val.isNull()) {
                Value.STORE_get(val._key);
                continue;
            }
            int t2 = val.type();
            while (t2 >= cnts.length) {
                cnts = Arrays.copyOf(cnts, cnts.length << 1);
            }
            int n2 = t2;
            cnts[n2] = cnts[n2] + 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int t3 = 0; t3 < cnts.length; ++t3) {
            if (cnts[t3] == 0) continue;
            sb.append(String.format("-%30s %5d\n", TypeMap.CLAZZES[t3], cnts[t3]));
        }
        return sb.toString();
    }

    public static PersistManager getPM() {
        return _PM;
    }

    public static NodePersistentStorage getNPS() {
        return NPS;
    }

    public static void gc() {
        for (H2ONode node : H2O.CLOUD._memary) {
            class GCTask
            extends DTask<GCTask> {
                public GCTask() {
                    super((byte)119);
                }

                @Override
                public void compute2() {
                    Log.info("Calling System.gc() now...");
                    System.gc();
                    Log.info("System.gc() finished");
                    this.tryComplete();
                }
            }
            GCTask t2 = new GCTask();
            new RPC<GCTask>(node, t2).call().get();
        }
    }

    public static boolean checkUnsupportedJava(String[] args) {
        if (JAVA_CHECK_PASSED) {
            return false;
        }
        if (Boolean.getBoolean("sys.ai.h2o.debug.noJavaVersionCheck")) {
            return false;
        }
        boolean unsupported = H2O.runCheckUnsupportedJava(args);
        if (!unsupported) {
            JAVA_CHECK_PASSED = true;
        }
        return unsupported;
    }

    static boolean runCheckUnsupportedJava(String[] args) {
        if (!JavaVersionSupport.runningOnSupportedVersion()) {
            Throwable error = null;
            boolean allowUnsupported = ArrayUtils.contains(args, "-allow_unsupported_java");
            if (allowUnsupported) {
                boolean checkPassed = false;
                try {
                    checkPassed = H2O.dynamicallyInvokeJavaSelfCheck();
                }
                catch (Throwable t2) {
                    error = t2;
                }
                if (checkPassed) {
                    Log.warn("H2O is running on a version of Java (" + System.getProperty("java.version") + ") that was not certified at the time of the H2O release. For production use please use a certified Java version (versions " + JavaVersionSupport.describeSupportedVersions() + " are officially supported).");
                    return false;
                }
            }
            System.err.printf("Only Java versions %s are supported, system version is %s%n", JavaVersionSupport.describeSupportedVersions(), System.getProperty("java.version"));
            if (H2O.ARGS.allow_unsupported_java) {
                System.err.println("H2O was invoked with flag -allow_unsupported_java, however, we found out that your Java version doesn't meet the requirements to run H2O. Please use a supported Java version.");
            }
            if (error != null) {
                error.printStackTrace(System.err);
            }
            return true;
        }
        String vmName = System.getProperty("java.vm.name");
        if (vmName != null && vmName.equals("GNU libgcj")) {
            System.err.println("GNU gcj is not supported");
            return true;
        }
        return false;
    }

    static boolean dynamicallyInvokeJavaSelfCheck() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cls = Class.forName("water.JavaSelfCheck");
        Method m4 = cls.getDeclaredMethod("checkCompatibility", new Class[0]);
        return (Boolean)m4.invoke(null, new Object[0]);
    }

    static boolean isArgProperty(String name) {
        String prefix = "ai.h2o.";
        if (!name.startsWith("ai.h2o.")) {
            return false;
        }
        return name.lastIndexOf(46) < "ai.h2o.".length();
    }

    public static void main(String[] args) {
        H2O.configureLogging();
        extManager.registerCoreExtensions();
        extManager.registerListenerExtensions();
        extManager.registerAuthExtensions();
        long time0 = System.currentTimeMillis();
        if (H2O.checkUnsupportedJava(args)) {
            throw new RuntimeException("Unsupported Java version");
        }
        if (!START_TIME_MILLIS.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        ArrayList<String> args2 = new ArrayList<String>(Arrays.asList(args));
        for (Object p2 : System.getProperties().keySet()) {
            String s2 = (String)p2;
            if (!H2O.isArgProperty(s2)) continue;
            args2.add("-" + s2.substring(7));
            if (s2.substring(7).equals("ga_opt_out") || System.getProperty(s2).isEmpty()) continue;
            args2.add(System.getProperty(s2));
        }
        String[] arguments2 = args2.toArray(args);
        H2O.parseArguments(arguments2);
        long time1 = System.currentTimeMillis();
        String ice = H2O.DEFAULT_ICE_ROOT();
        if (H2O.ARGS.ice_root != null) {
            ice = H2O.ARGS.ice_root.replace("\\", "/");
        }
        try {
            ICE_ROOT = new URI(ice);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Invalid ice_root: " + ice + ", " + ex.getMessage());
        }
        long time2 = System.currentTimeMillis();
        H2O.printAndLogVersion(arguments2);
        if (H2O.ARGS.version) {
            Log.flushBufferedMessagesToStdout();
            H2O.exit(0);
        }
        if (H2O.ARGS.help) {
            H2O.printHelp();
            H2O.exit(0);
        }
        H2O.validateArguments();
        Log.info("X-h2o-cluster-id: " + CLUSTER_ID);
        Log.info("User name: '" + H2O.ARGS.user_name + "'");
        long time4 = System.currentTimeMillis();
        Log.info("IPv6 stack selected: " + IS_IPV6);
        SELF_ADDRESS = NetworkInit.findInetAddressForSelf();
        if (!IS_IPV6 && SELF_ADDRESS instanceof Inet6Address) {
            Log.err("IPv4 network stack specified but IPv6 address found: " + SELF_ADDRESS + "\nPlease specify JVM flags -Djava.net.preferIPv6Addresses=true and -Djava.net.preferIPv4Addresses=false to select IPv6 stack");
            H2O.exit(-1);
        }
        if (IS_IPV6 && SELF_ADDRESS instanceof Inet4Address) {
            Log.err("IPv6 network stack specified but IPv4 address found: " + SELF_ADDRESS);
            H2O.exit(-1);
        }
        long time5 = System.currentTimeMillis();
        H2O.startLocalNode();
        long time6 = System.currentTimeMillis();
        for (AbstractH2OExtension ext : extManager.getCoreExtensions()) {
            ext.onLocalNodeStarted();
        }
        try {
            String logDir = Log.getLogDir();
            Log.info("Log dir: '" + logDir + "'");
        }
        catch (Exception e2) {
            Log.info("Log dir: (Log4j configuration inherited)");
        }
        Log.info("Cur dir: '" + System.getProperty("user.dir") + "'");
        long time7 = System.currentTimeMillis();
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        Log.debug("H2O launch parameters: " + ARGS.toString());
        if (rtBean.isBootClassPathSupported()) {
            Log.debug("Boot class path: " + rtBean.getBootClassPath());
        }
        Log.debug("Java class path: " + rtBean.getClassPath());
        Log.debug("Java library path: " + rtBean.getLibraryPath());
        long time8 = System.currentTimeMillis();
        H2O.initializePersistence();
        String flow_dir = H2O.ARGS.flow_dir != null ? H2O.ARGS.flow_dir : H2O.DEFAULT_FLOW_DIR();
        if (flow_dir != null) {
            flow_dir = flow_dir.replace("\\", "/");
            Log.info("Flow dir: '" + flow_dir + "'");
        } else {
            Log.info("Flow dir is undefined; saving flows not available");
        }
        NPS = new NodePersistentStorage(flow_dir);
        long time9 = System.currentTimeMillis();
        H2O.startNetworkServices();
        Log.trace("Network services started");
        long time10 = System.currentTimeMillis();
        Paxos.doHeartbeat(SELF);
        assert (H2O.SELF._heartbeat._cloud_hash != 0 || H2O.ARGS.client);
        new HeartBeatThread().start();
        long time11 = System.currentTimeMillis();
        Log.info("Registered parsers: " + Arrays.toString(ParserService.INSTANCE.getAllProviderNames(true)));
        if (Boolean.getBoolean("sys.ai.h2o.debug.clientDisconnectAttack")) {
            Log.warn("Client Random Disconnect attack is enabled - use only for debugging! More warnings to follow ;)");
            new ClientRandomDisconnectThread().start();
        } else {
            new ClientDisconnectCheckThread().start();
        }
        if (H2O.isGCLoggingEnabled()) {
            Log.info(H2O.technote(16, "GC logging is enabled, you might see messages containing \"GC (Allocation Failure)\". Please note that this is a normal part of GC operations and occurrence of such messages doesn't directly indicate an issue."));
        }
        long time12 = System.currentTimeMillis();
        Log.debug("Timing within H2O.main():");
        Log.debug("    Args parsing & validation: " + (time1 - time0) + "ms");
        Log.debug("    Get ICE root: " + (time2 - time1) + "ms");
        Log.debug("    Print log version: " + (time4 - time2) + "ms");
        Log.debug("    Detect network address: " + (time5 - time4) + "ms");
        Log.debug("    Start local node: " + (time6 - time5) + "ms");
        Log.debug("    Extensions onLocalNodeStarted(): " + (time7 - time6) + "ms");
        Log.debug("    RuntimeMxBean: " + (time8 - time7) + "ms");
        Log.debug("    Initialize persistence layer: " + (time9 - time8) + "ms");
        Log.debug("    Start network services: " + (time10 - time9) + "ms");
        Log.debug("    Cloud up: " + (time11 - time10) + "ms");
        Log.debug("    Start GA: " + (time12 - time11) + "ms");
    }

    private static boolean isGCLoggingEnabled() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        for (String arg : jvmArgs) {
            if (!arg.startsWith("-XX:+PrintGC") && !arg.equals("-verbose:gc") && (!arg.startsWith("-Xlog:") || !arg.contains("gc"))) continue;
            return true;
        }
        return false;
    }

    private static long getCurrentPID() {
        try {
            String n2 = ManagementFactory.getRuntimeMXBean().getName();
            int i2 = n2.indexOf(64);
            if (i2 != -1) {
                return Long.parseLong(n2.substring(0, i2));
            }
            return -1L;
        }
        catch (Throwable ignore) {
            return -1L;
        }
    }

    public static void die(String s2) {
        Log.fatal(s2);
        H2O.exit(-1);
    }

    public static boolean addNodeToFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.add(node);
    }

    public static boolean removeNodeFromFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.remove(node);
    }

    public static boolean isNodeInFlatfile(H2ONode node) {
        assert (H2O.isFlatfileEnabled()) : "Trying to use flatfile, but flatfile is not enabled!";
        return STATIC_H2OS.contains(node);
    }

    public static boolean isFlatfileEnabled() {
        return STATIC_H2OS != null;
    }

    public static void setFlatfile(Set<H2ONode> nodes) {
        if (nodes == null) {
            STATIC_H2OS = null;
        } else {
            STATIC_H2OS = Collections.newSetFromMap(new ConcurrentHashMap());
            STATIC_H2OS.addAll(nodes);
        }
    }

    public static Set<H2ONode> getFlatfile() {
        return new HashSet<H2ONode>(STATIC_H2OS);
    }

    static boolean removeClient(H2ONode client) {
        return client.removeClient();
    }

    public static H2ONode[] getClients() {
        return H2ONode.getClients();
    }

    public static H2ONode getClientByIPPort(String ipPort) {
        return H2ONode.getClientByIPPort(ipPort);
    }

    public static Key<DecryptionTool> defaultDecryptionTool() {
        return H2O.ARGS.decrypt_tool != null ? Key.make(H2O.ARGS.decrypt_tool) : null;
    }

    public static URI downloadLogs(URI destinationDir, LogArchiveContainer logContainer) {
        return LogsHandler.downloadLogs(destinationDir.toString(), logContainer);
    }

    public static URI downloadLogs(URI destinationDir, String logContainer) {
        return LogsHandler.downloadLogs(destinationDir.toString(), LogArchiveContainer.valueOf(logContainer));
    }

    public static URI downloadLogs(String destinationDir, LogArchiveContainer logContainer) {
        return LogsHandler.downloadLogs(destinationDir, logContainer);
    }

    public static URI downloadLogs(String destinationDir, String logContainer) {
        return LogsHandler.downloadLogs(destinationDir, LogArchiveContainer.valueOf(logContainer));
    }

    static boolean isCI() {
        return AbstractBuildVersion.getBuildVersion().isDevVersion() && "jenkins".equals(System.getProperty("user.name"));
    }

    static {
        _shutdownRequested = false;
        ABV = AbstractBuildVersion.getBuildVersion();
        _haveInheritedLog4jConfiguration = false;
        aboutEntries = new ArrayList();
        nextModelNum = new AtomicLong(0L);
        lastTimeSomethingHappenedMillis = System.currentTimeMillis();
        activeRapidsExecs = new AtomicInteger();
        START_TIME_MILLIS = new AtomicLong();
        NUMCPUS = H2ORuntime.availableProcessors();
        PID = H2O.getCurrentPID();
        extManager = ExtensionManager.getInstance();
        FJPS = new PrioritizedForkJoinPool[127];
        H2O.FJPS[126] = new PrioritizedForkJoinPool(126, 1);
        for (int i2 = 120; i2 < 126; ++i2) {
            H2O.FJPS[i2] = new PrioritizedForkJoinPool(i2, 4);
        }
        H2O.FJPS[119] = new PrioritizedForkJoinPool(119, 2);
        SELF = null;
        IS_IPV6 = NetworkUtils.isIPv6Preferred() && !NetworkUtils.isIPv4Preferred();
        STATIC_H2OS = null;
        CLOUDS = new H2O[256];
        DEBUG = System.getProperty(DEBUG_ARG) != null;
        CLUSTER_ID = System.currentTimeMillis();
        CLOUD = new H2O(new H2ONode[0], 0, 0);
        STORE = new NonBlockingHashMap();
        JAVA_CHECK_PASSED = false;
    }

    public static abstract class H2OCallback<T extends H2OCountedCompleter>
    extends H2OCountedCompleter {
        public H2OCallback() {
        }

        public H2OCallback(H2OCountedCompleter cc) {
            super(cc);
        }

        @Override
        public void compute2() {
            throw H2O.fail();
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.callback((H2OCountedCompleter)caller);
        }

        public abstract void callback(T var1);
    }

    public static abstract class H2OCountedCompleter<T extends H2OCountedCompleter>
    extends CountedCompleter
    implements Cloneable,
    Freezable<T> {
        private byte _priority;
        private short _ice_id;

        @Override
        public byte[] asBytes() {
            return new AutoBuffer().put(this).buf();
        }

        @Override
        public T reloadFromBytes(byte[] ary) {
            return (T)this.read(new AutoBuffer(ary));
        }

        public H2OCountedCompleter() {
            this(null);
        }

        private static byte computePriority(H2OCountedCompleter completer) {
            byte currThrPrior = H2OCountedCompleter.currThrPriority();
            if (completer == null) {
                return (byte)(currThrPrior + 1);
            }
            return (byte)Math.max(currThrPrior, completer.priority());
        }

        protected H2OCountedCompleter(H2OCountedCompleter completer) {
            this(completer, H2OCountedCompleter.computePriority(completer));
        }

        protected H2OCountedCompleter(byte prior) {
            this(null, prior);
        }

        protected H2OCountedCompleter(H2OCountedCompleter completer, byte prior) {
            super(completer);
            this._priority = prior;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void compute() {
            block12: {
                FJWThr t2 = (FJWThr)Thread.currentThread();
                int pp = ((PrioritizedForkJoinPool)t2.getPool())._priority;
                ForkJoinTask h2o = null;
                boolean set_t_prior = false;
                try {
                    assert (this.priority() == pp) : " wrong priority for task " + this.getClass().getSimpleName() + ", expected " + this.priority() + ", but got " + pp;
                    assert (t2._priority <= pp);
                    int p2 = Math.max(pp, 119);
                    for (int p3 = 126; p3 > p2; --p3) {
                        if (FJPS[p3] == null || (h2o = FJPS[p3].poll2()) == null) continue;
                        t2._priority = p3++;
                        t2.setPriority(9);
                        set_t_prior = true;
                        ((H2OCountedCompleter)h2o).compute2();
                    }
                }
                catch (Throwable ex) {
                    if (h2o != null) {
                        h2o.completeExceptionally(ex);
                        break block12;
                    }
                    ex.printStackTrace();
                    throw ex;
                }
                finally {
                    t2._priority = pp;
                    if (pp == 0 && set_t_prior) {
                        t2.setPriority(4);
                    }
                }
            }
            if (this instanceof DTask) {
                this.icer().compute1(this);
            } else {
                this.compute2();
            }
        }

        public void compute1() {
            this.compute2();
        }

        public void compute2() {
        }

        protected final byte priority() {
            return this._priority;
        }

        @Override
        public final T clone() {
            try {
                return (T)((H2OCountedCompleter)super.clone());
            }
            catch (CloneNotSupportedException e2) {
                throw Log.throwErr(e2);
            }
        }

        protected static byte currThrPriority() {
            Thread cThr = Thread.currentThread();
            return (byte)(cThr instanceof FJWThr ? ((FJWThr)cThr)._priority : 0);
        }

        protected Icer<T> icer() {
            int tyid;
            short id = this._ice_id;
            if (id != 0 && id != 0) assert (id == (tyid = TypeMap.onIce(this))) : "incorrectly cashed id " + id + ", typemap has " + tyid + ", type = " + this.getClass().getName();
            return TypeMap.getIcer((int)(id != 0 ? id : (this._ice_id = (short)TypeMap.onIce(this))), this);
        }

        @Override
        public final AutoBuffer write(AutoBuffer ab) {
            return this.icer().write(ab, this);
        }

        @Override
        public final AutoBuffer writeJSON(AutoBuffer ab) {
            return this.icer().writeJSON(ab, this);
        }

        @Override
        public final T read(AutoBuffer ab) {
            return (T)this.icer().read(ab, this);
        }

        @Override
        public final T readJSON(AutoBuffer ab) {
            return (T)this.icer().readJSON(ab, this);
        }

        @Override
        public final int frozenType() {
            return this.icer().frozenType();
        }
    }

    public static abstract class RemoteRunnable<T extends RemoteRunnable>
    extends Iced<T> {
        public void setupOnRemote() {
        }

        public abstract void run();
    }

    private static class RunnableWrapperTask<T extends RemoteRunnable>
    extends DTask<RunnableWrapperTask<T>> {
        private final T _runnable;

        private RunnableWrapperTask(T runnable) {
            this._runnable = runnable;
        }

        @Override
        public void compute2() {
            ((RemoteRunnable)this._runnable).setupOnRemote();
            ((RemoteRunnable)this._runnable).run();
            this.tryComplete();
        }

        /* synthetic */ RunnableWrapperTask(RemoteRunnable x0, 1 x1) {
            this(x0);
        }
    }

    private static class PrioritizedForkJoinPool
    extends ForkJoinPool {
        final int _priority;

        private PrioritizedForkJoinPool(int p2, int cap) {
            super(H2O.ARGS.nthreads <= 0 ? NUMCPUS : (int)H2O.ARGS.nthreads, new FJWThrFact(cap), null, p2 >= 119);
            this._priority = p2;
        }

        private H2OCountedCompleter poll2() {
            return (H2OCountedCompleter)this.pollSubmission();
        }
    }

    static class FJWThrFact
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final int _cap;

        FJWThrFact(int cap) {
            this._cap = cap;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            int cap = this._cap == -1 ? 4 * NUMCPUS : this._cap;
            return pool.getPoolSize() <= cap ? new FJWThr(pool) : null;
        }
    }

    public static class FJWThr
    extends ForkJoinWorkerThread {
        public int _priority;

        FJWThr(ForkJoinPool pool) {
            super(pool);
            this._priority = ((PrioritizedForkJoinPool)pool)._priority;
            this.setPriority(this._priority == 1 ? 4 : 9);
            this.setName("FJ-" + this._priority + "-" + this.getPoolIndex());
        }
    }

    public static class AboutEntry {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        AboutEntry(String n2, String v2) {
            this.name = n2;
            this.value = v2;
        }
    }

    public static class OptString {
        final String _s;
        String _lastMatchedFor;

        public OptString(String s2) {
            this._s = s2;
        }

        public boolean matches(String s2) {
            this._lastMatchedFor = s2;
            if (this._s.equals("-" + s2)) {
                return true;
            }
            return this._s.equals("--" + s2);
        }

        public int incrementAndCheck(int i2, String[] args) {
            if (++i2 >= args.length) {
                H2O.parseFailed(this._lastMatchedFor + " not specified");
            }
            return i2;
        }

        public int parseInt(String a2) {
            try {
                return Integer.parseInt(a2);
            }
            catch (Exception exception) {
                H2O.parseFailed("Argument " + this._lastMatchedFor + " must be an integer (was given '" + a2 + "')");
                return 0;
            }
        }

        public int parsePort(String portString) {
            int portNum = this.parseInt(portString);
            if (portNum < 0 || portNum > 65535) {
                H2O.parseFailed("Argument " + this._lastMatchedFor + " must be an integer between 0 and 65535");
                return 0;
            }
            return portNum;
        }

        public String checkFileSize(String fileSizeString) {
            int length = fileSizeString.length();
            if (length > 2 && length < 8 && fileSizeString.substring(length - 2, length).equals("MB")) {
                try {
                    Integer.parseInt(fileSizeString.substring(0, length - 2));
                    return fileSizeString;
                }
                catch (NumberFormatException ex) {
                    H2O.parseFailed("Argument " + this._lastMatchedFor + " must be String value from 1MB to 99999MB.");
                    return null;
                }
            }
            H2O.parseFailed("Argument " + this._lastMatchedFor + " must be String value from 1MB to 99999MB.");
            return null;
        }

        public String toString() {
            return this._s;
        }
    }

    public static class OptArgs
    extends BaseArgs {
        public static final String SYSTEM_PROP_PREFIX = "sys.ai.h2o.";
        public static final String SYSTEM_DEBUG_CORS = "sys.ai.h2o.debug.cors";
        public boolean help = false;
        public boolean version = false;
        public String name = System.getProperty("user.name");
        public String flatfile;
        public String ice_root;
        public boolean cleaner = false;
        public short nthreads = (short)H2ORuntime.availableProcessors();
        public String log_dir;
        public String flow_dir;
        public boolean disable_web = false;
        public boolean disable_net = false;
        public boolean disable_flow = false;
        public boolean client;
        public boolean allow_clients = false;
        public boolean allow_unsupported_java = false;
        public int rest_api_ping_timeout = 0;
        public String notify_local;
        public double off_heap_memory_ratio = 0.0;
        public String[] hdfs_config = null;
        public boolean hdfs_skip = false;
        public String aws_credentials = null;
        public boolean configure_s3_using_s3a = false;
        public String ga_hadoop_ver = null;
        public final Properties hadoop_properties = new Properties();
        public String auto_recovery_dir;
        public String log_level;
        public String max_log_file_size;
        public boolean random_udp_drop;
        public boolean md5skip = false;
        public boolean quiet = false;
        public long clientDisconnectTimeout = 20000L;
        public boolean embedded = false;
        public ModelBuilder.BuilderVisibility features_level = ModelBuilder.BuilderVisibility.Experimental;

        public String toString() {
            StringBuilder result = new StringBuilder();
            Field[] fields = this.getClass().getDeclaredFields();
            result.append("[ ");
            for (Field field : fields) {
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                    result.append(", ");
                }
                catch (IllegalAccessException ex) {
                    Log.err(ex, ex);
                }
            }
            result.deleteCharAt(result.length() - 2);
            result.deleteCharAt(result.length() - 1);
            result.append(" ]");
            return result.toString();
        }

        public boolean launchedWithHadoopJar() {
            return this.hdfs_skip;
        }
    }

    public static class KeyValueArg {
        public final String _key;
        public final String _value;

        private KeyValueArg(String key, String value) {
            this._key = key;
            this._value = value;
        }
    }

    public static class BaseArgs {
        public String jks = null;
        public String jks_pass = "h2oh2o";
        public String jks_alias = null;
        public boolean hostname_as_jks_alias = false;
        public boolean hash_login = false;
        public boolean ldap_login = false;
        public boolean kerberos_login = false;
        public boolean spnego_login = false;
        public boolean pam_login = false;
        public String login_conf = null;
        public String spnego_properties = null;
        public boolean form_auth = false;
        String session_timeout_spec = null;
        public int session_timeout = 0;
        public String user_name = System.getProperty("user.name");
        public String internal_security_conf = null;
        public boolean internal_security_conf_rel_paths = false;
        public boolean internal_security_enabled = false;
        public boolean allow_insecure_xgboost = false;
        public boolean use_external_xgboost = false;
        public String decrypt_tool = null;
        public String principal = null;
        public String keytab_path = null;
        public String hdfs_token_refresh_interval = null;
        public int port;
        public int baseport = 54321;
        public int port_offset = 1;
        public String web_ip = null;
        public String ip;
        public String network;
        public String context_path = "";
        public KeyValueArg[] extra_headers = new KeyValueArg[0];
    }
}

