/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class ComplexDoubleLargeArray
extends LargeArray {
    private static final long serialVersionUID = 15533907580310407L;
    private DoubleLargeArray dataRe;
    private DoubleLargeArray dataIm;

    public ComplexDoubleLargeArray(long length) {
        this(length, true);
    }

    public ComplexDoubleLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.COMPLEX_DOUBLE;
        this.sizeof = 8L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.dataRe = new DoubleLargeArray(length, zeroNativeMemory);
        this.dataIm = new DoubleLargeArray(length, zeroNativeMemory);
    }

    public ComplexDoubleLargeArray(long length, double[] constantValue) {
        this.type = LargeArrayType.COMPLEX_DOUBLE;
        this.sizeof = 8L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        if (constantValue == null || constantValue.length != 2) {
            throw new IllegalArgumentException("constantValue == null || constantValue.length != 2");
        }
        this.length = length;
        this.isConstant = true;
        this.dataRe = new DoubleLargeArray(length, constantValue[0]);
        this.dataIm = new DoubleLargeArray(length, constantValue[1]);
    }

    public ComplexDoubleLargeArray(double[] data) {
        this(new DoubleLargeArray(data));
    }

    public ComplexDoubleLargeArray(DoubleLargeArray data) {
        if (data.length() % 2L != 0L) {
            throw new IllegalArgumentException("The length of the data array must be even.");
        }
        if (data.length() <= 0L) {
            throw new IllegalArgumentException(data.length() + " is not a positive long value");
        }
        this.type = LargeArrayType.COMPLEX_DOUBLE;
        this.sizeof = 8L;
        this.length = data.length / 2L;
        this.isConstant = data.isConstant;
        if (this.isConstant) {
            this.dataRe = new DoubleLargeArray(this.length, data.getDouble(0L));
            this.dataIm = new DoubleLargeArray(this.length, data.getDouble(1L));
        } else {
            this.dataRe = new DoubleLargeArray(this.length, false);
            this.dataIm = new DoubleLargeArray(this.length, false);
            for (long i2 = 0L; i2 < this.length; ++i2) {
                this.dataRe.setDouble(i2, data.getDouble(2L * i2));
                this.dataIm.setDouble(i2, data.getDouble(2L * i2 + 1L));
            }
        }
    }

    public ComplexDoubleLargeArray(double[] dataRe, double[] dataIm) {
        this(new DoubleLargeArray(dataRe), new DoubleLargeArray(dataIm));
    }

    public ComplexDoubleLargeArray(DoubleLargeArray dataRe, DoubleLargeArray dataIm) {
        if (dataRe.length() != dataIm.length()) {
            throw new IllegalArgumentException("The length of the dataRe must be equal to the length of dataIm.");
        }
        if (dataRe.length() <= 0L) {
            throw new IllegalArgumentException(dataRe.length() + " is not a positive long value");
        }
        if (dataRe.isLarge() != dataIm.isLarge()) {
            throw new IllegalArgumentException("dataRe.isLarge() != dataIm.isLarge()");
        }
        this.type = LargeArrayType.COMPLEX_DOUBLE;
        this.sizeof = 8L;
        this.length = dataRe.length();
        this.dataRe = dataRe;
        this.dataIm = dataIm;
    }

    @Override
    public ComplexDoubleLargeArray clone() {
        if (this.isConstant) {
            return new ComplexDoubleLargeArray(this.length, new double[]{this.dataRe.getDouble(0L), this.dataIm.getDouble(0L)});
        }
        ComplexDoubleLargeArray v2 = new ComplexDoubleLargeArray(this.length, false);
        LargeArrayUtils.arraycopy(this, 0L, v2, 0L, this.length);
        return v2;
    }

    @Override
    public boolean equals(Object o2) {
        if (super.equals(o2)) {
            ComplexDoubleLargeArray la = (ComplexDoubleLargeArray)o2;
            return this.dataRe.equals(la.dataRe) && this.dataIm.equals(la.dataIm);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 29 * super.hashCode() + (this.dataRe != null ? this.dataRe.hashCode() : 0);
        return 29 * hash + (this.dataIm != null ? this.dataIm.hashCode() : 0);
    }

    @Override
    public boolean isLarge() {
        return this.dataRe.isLarge();
    }

    public final DoubleLargeArray getRealArray() {
        return this.dataRe;
    }

    public final DoubleLargeArray getImaginaryArray() {
        return this.dataIm;
    }

    public final DoubleLargeArray getAbsArray() {
        DoubleLargeArray out = new DoubleLargeArray(this.length, false);
        for (long i2 = 0L; i2 < this.length; ++i2) {
            double re = this.dataRe.getDouble(i2);
            double im = this.dataIm.getDouble(i2);
            out.setDouble(i2, FastMath.sqrt((double)(re * re + im * im)));
        }
        return out;
    }

    public final DoubleLargeArray getArgArray() {
        DoubleLargeArray out = new DoubleLargeArray(this.length, false);
        for (long i2 = 0L; i2 < this.length; ++i2) {
            double re = this.dataRe.getDouble(i2);
            double im = this.dataIm.getDouble(i2);
            out.setDouble(i2, FastMath.atan2((double)im, (double)re));
        }
        return out;
    }

    public final double[] get(long i2) {
        return this.getComplexDouble(i2);
    }

    public final double[] getFromNative(long i2) {
        return new double[]{this.dataRe.getFromNative(i2), this.dataIm.getFromNative(i2)};
    }

    @Override
    public final boolean getBoolean(long i2) {
        return this.dataRe.getBoolean(i2);
    }

    @Override
    public final byte getByte(long i2) {
        return this.dataRe.getByte(i2);
    }

    @Override
    public final short getUnsignedByte(long i2) {
        return this.dataRe.getUnsignedByte(i2);
    }

    @Override
    public final short getShort(long i2) {
        return this.dataRe.getShort(i2);
    }

    @Override
    public final int getInt(long i2) {
        return this.dataRe.getInt(i2);
    }

    @Override
    public final long getLong(long i2) {
        return this.dataRe.getLong(i2);
    }

    @Override
    public final float getFloat(long i2) {
        return this.dataRe.getFloat(i2);
    }

    @Override
    public final double getDouble(long i2) {
        return this.dataRe.getDouble(i2);
    }

    public final float[] getComplexFloat(long i2) {
        return new float[]{this.dataRe.getFloat(i2), this.dataIm.getFloat(i2)};
    }

    public final double[] getComplexDouble(long i2) {
        return new double[]{this.dataRe.getDouble(i2), this.dataIm.getDouble(i2)};
    }

    public final double[][] getData() {
        if (this.isLarge()) {
            return null;
        }
        return new double[][]{this.dataRe.getData(), this.dataIm.getData()};
    }

    @Override
    public final boolean[] getBooleanData() {
        return this.dataRe.getBooleanData();
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getBooleanData(a2, startPos, endPos, step);
    }

    @Override
    public final byte[] getByteData() {
        return this.dataRe.getByteData();
    }

    @Override
    public final byte[] getByteData(byte[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getByteData(a2, startPos, endPos, step);
    }

    @Override
    public final short[] getShortData() {
        return this.dataRe.getShortData();
    }

    @Override
    public final short[] getShortData(short[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getShortData(a2, startPos, endPos, step);
    }

    @Override
    public final int[] getIntData() {
        return this.dataRe.getIntData();
    }

    @Override
    public final int[] getIntData(int[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getIntData(a2, startPos, endPos, step);
    }

    @Override
    public final long[] getLongData() {
        return this.dataRe.getLongData();
    }

    @Override
    public final long[] getLongData(long[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getLongData(a2, startPos, endPos, step);
    }

    @Override
    public final float[] getFloatData() {
        return this.dataRe.getFloatData();
    }

    @Override
    public final float[] getFloatData(float[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getFloatData(a2, startPos, endPos, step);
    }

    @Override
    public final double[] getDoubleData() {
        return this.dataRe.getDoubleData();
    }

    @Override
    public final double[] getDoubleData(double[] a2, long startPos, long endPos, long step) {
        return this.dataRe.getDoubleData(a2, startPos, endPos, step);
    }

    public final double[] getComplexData() {
        if (2L * this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)(2L * this.length)];
        int i2 = 0;
        while ((long)i2 < this.length) {
            out[2 * i2] = this.dataRe.getDouble(i2);
            out[2 * i2 + 1] = this.dataIm.getDouble(i2);
            ++i2;
        }
        return out;
    }

    public final double[] getComplexData(double[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = 2L * (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        double[] out = a2 != null && (long)a2.length >= len ? a2 : new double[(int)len];
        int idx = 0;
        for (long i2 = startPos; i2 < endPos; i2 += step) {
            out[idx++] = this.dataRe.getDouble(i2);
            out[idx++] = this.dataIm.getDouble(i2);
        }
        return out;
    }

    @Override
    public final void setToNative(long i2, Object value) {
        if (!(value instanceof double[])) {
            throw new IllegalArgumentException(value + " is not an array of doubles.");
        }
        this.dataRe.setToNative(i2, ((double[])value)[0]);
        this.dataIm.setToNative(i2, ((double[])value)[1]);
    }

    @Override
    public final void setBoolean(long i2, boolean value) {
        this.dataRe.setBoolean(i2, value);
        this.dataIm.setBoolean(i2, false);
    }

    @Override
    public final void setByte(long i2, byte value) {
        this.dataRe.setByte(i2, value);
        this.dataIm.setByte(i2, (byte)0);
    }

    @Override
    public final void setUnsignedByte(long i2, short value) {
        this.dataRe.setUnsignedByte(i2, value);
        this.dataIm.setUnsignedByte(i2, (short)0);
    }

    @Override
    public final void setShort(long i2, short value) {
        this.dataRe.setShort(i2, value);
        this.dataIm.setShort(i2, (short)0);
    }

    @Override
    public final void setInt(long i2, int value) {
        this.dataRe.setInt(i2, value);
        this.dataIm.setInt(i2, 0);
    }

    @Override
    public final void setLong(long i2, long value) {
        this.dataRe.setLong(i2, value);
        this.dataIm.setLong(i2, 0L);
    }

    @Override
    public final void setFloat(long i2, float value) {
        this.dataRe.setFloat(i2, value);
        this.dataIm.setFloat(i2, 0.0f);
    }

    @Override
    public final void setDouble(long i2, double value) {
        this.dataRe.setDouble(i2, value);
        this.dataIm.setDouble(i2, 0.0);
    }

    @Override
    public final void set(long i2, Object value) {
        if (!(value instanceof double[])) {
            throw new IllegalArgumentException(value + " is not an array of doubles.");
        }
        this.setComplexDouble(i2, (double[])value);
    }

    public final void setComplexFloat(long i2, float[] value) {
        this.dataRe.setFloat(i2, value[0]);
        this.dataIm.setFloat(i2, value[1]);
    }

    public final void setComplexDouble(long i2, double[] value) {
        this.dataRe.setDouble(i2, value[0]);
        this.dataIm.setDouble(i2, value[1]);
    }
}

