/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.NativeSizeTByReference;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;

@ThreadSafe
public final class BsdSysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed syctl call: {}, Error code: {}";

    private BsdSysctlUtil() {
    }

    public static int sysctl(String name, int def) {
        NativeSizeTByReference size = new NativeSizeTByReference(new LibCAPI.size_t((long)FreeBsdLibc.INT_SIZE));
        Memory p2 = new Memory(size.getValue().longValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error("Failed sysctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p2).getInt(0L);
    }

    public static long sysctl(String name, long def) {
        NativeSizeTByReference size = new NativeSizeTByReference(new LibCAPI.size_t((long)FreeBsdLibc.UINT64_SIZE));
        Memory p2 = new Memory(size.getValue().longValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return ((Pointer)p2).getLong(0L);
    }

    public static String sysctl(String name, String def) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p2 = new Memory(size.getValue().longValue() + 1L);
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, p2, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p2.getString(0L);
    }

    public static boolean sysctl(String name, Structure struct2) {
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, struct2.getPointer(), new NativeSizeTByReference(new LibCAPI.size_t((long)struct2.size())), null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return false;
        }
        struct2.read();
        return true;
    }

    public static Memory sysctl(String name) {
        NativeSizeTByReference size = new NativeSizeTByReference();
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m4 = new Memory(size.getValue().longValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, m4, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        return m4;
    }
}

