/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.python.netty.util.internal.ObjectUtil;
import org.python.netty.util.internal.PlatformDependent;

public final class StringUtil {
    public static final String NEWLINE;
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final String EMPTY_STRING = "";
    private static final String[] BYTE2HEX_PAD;
    private static final String[] BYTE2HEX_NOPAD;
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    public static String[] split(String value, char delim) {
        int i2;
        int end = value.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = 0;
        for (i2 = 0; i2 < end; ++i2) {
            if (value.charAt(i2) != delim) continue;
            if (start == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value.substring(start, i2));
            }
            start = i2 + 1;
        }
        if (start == 0) {
            res.add(value);
        } else if (start != end) {
            res.add(value.substring(start, end));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((String)res.get(i2)).isEmpty(); --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] split(String value, char delim, int maxParts) {
        int i2;
        int end = value.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = 0;
        int cpt = 1;
        for (i2 = 0; i2 < end && cpt < maxParts; ++i2) {
            if (value.charAt(i2) != delim) continue;
            if (start == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value.substring(start, i2));
            }
            start = i2 + 1;
            ++cpt;
        }
        if (start == 0) {
            res.add(value);
        } else if (start != end) {
            res.add(value.substring(start, end));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((String)res.get(i2)).isEmpty(); --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String substringAfter(String value, char delim) {
        int pos = value.indexOf(delim);
        if (pos >= 0) {
            return value.substring(pos + 1);
        }
        return null;
    }

    public static String byteToHexStringPadded(int value) {
        return BYTE2HEX_PAD[value & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T buf, int value) {
        try {
            buf.append(StringUtil.byteToHexStringPadded(value));
        }
        catch (IOException e2) {
            PlatformDependent.throwException(e2);
        }
        return buf;
    }

    public static String toHexStringPadded(byte[] src) {
        return StringUtil.toHexStringPadded(src, 0, src.length);
    }

    public static String toHexStringPadded(byte[] src, int offset, int length) {
        return StringUtil.toHexStringPadded(new StringBuilder(length << 1), src, offset, length).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src) {
        return StringUtil.toHexStringPadded(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src, int offset, int length) {
        int end = offset + length;
        for (int i2 = offset; i2 < end; ++i2) {
            StringUtil.byteToHexStringPadded(dst, src[i2]);
        }
        return dst;
    }

    public static String byteToHexString(int value) {
        return BYTE2HEX_NOPAD[value & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T buf, int value) {
        try {
            buf.append(StringUtil.byteToHexString(value));
        }
        catch (IOException e2) {
            PlatformDependent.throwException(e2);
        }
        return buf;
    }

    public static String toHexString(byte[] src) {
        return StringUtil.toHexString(src, 0, src.length);
    }

    public static String toHexString(byte[] src, int offset, int length) {
        return StringUtil.toHexString(new StringBuilder(length << 1), src, offset, length).toString();
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src) {
        return StringUtil.toHexString(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src, int offset, int length) {
        int i2;
        assert (length >= 0);
        if (length == 0) {
            return dst;
        }
        int end = offset + length;
        int endMinusOne = end - 1;
        for (i2 = offset; i2 < endMinusOne && src[i2] == 0; ++i2) {
        }
        StringUtil.byteToHexString(dst, src[i2++]);
        int remaining = end - i2;
        StringUtil.toHexStringPadded(dst, src, i2, remaining);
        return dst;
    }

    public static String simpleClassName(Object o2) {
        if (o2 == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(o2.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String className = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence escapeCsv(CharSequence value) {
        CharSequence charSequence;
        int length = ObjectUtil.checkNotNull(value, "value").length();
        if (length == 0) {
            return value;
        }
        int last = length - 1;
        boolean quoted = StringUtil.isDoubleQuote(value.charAt(0)) && StringUtil.isDoubleQuote(value.charAt(last)) && length != 1;
        boolean foundSpecialCharacter = false;
        boolean escapedDoubleQuote = false;
        StringBuilder escaped = new StringBuilder(length + 7).append('\"');
        block4: for (int i2 = 0; i2 < length; ++i2) {
            char current = value.charAt(i2);
            switch (current) {
                case '\"': {
                    if (i2 == 0 || i2 == last) {
                        if (quoted) continue block4;
                        escaped.append('\"');
                    } else {
                        boolean isNextCharDoubleQuote = StringUtil.isDoubleQuote(value.charAt(i2 + 1));
                        if (StringUtil.isDoubleQuote(value.charAt(i2 - 1)) || isNextCharDoubleQuote && i2 + 1 != last) break;
                        escaped.append('\"');
                        escapedDoubleQuote = true;
                        break;
                    }
                }
                case '\n': 
                case '\r': 
                case ',': {
                    foundSpecialCharacter = true;
                }
            }
            escaped.append(current);
        }
        if (escapedDoubleQuote || foundSpecialCharacter && !quoted) {
            charSequence = escaped.append('\"');
            return charSequence;
        }
        charSequence = value;
        return charSequence;
    }

    public static int length(String s2) {
        return s2 == null ? 0 : s2.length();
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    private static boolean isDoubleQuote(char c2) {
        return c2 == '\"';
    }

    private StringUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        StringBuilder buf;
        int i2;
        String newLine;
        BYTE2HEX_PAD = new String[256];
        BYTE2HEX_NOPAD = new String[256];
        Formatter formatter = new Formatter();
        try {
            newLine = formatter.format("%n", new Object[0]).toString();
        }
        catch (Exception e2) {
            newLine = "\n";
        }
        finally {
            formatter.close();
        }
        NEWLINE = newLine;
        for (i2 = 0; i2 < 10; ++i2) {
            buf = new StringBuilder(2);
            buf.append('0');
            buf.append(i2);
            StringUtil.BYTE2HEX_PAD[i2] = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i2] = String.valueOf(i2);
        }
        while (i2 < 16) {
            buf = new StringBuilder(2);
            char c2 = (char)(97 + i2 - 10);
            buf.append('0');
            buf.append(c2);
            StringUtil.BYTE2HEX_PAD[i2] = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i2] = String.valueOf(c2);
            ++i2;
        }
        while (i2 < BYTE2HEX_PAD.length) {
            String str;
            buf = new StringBuilder(2);
            buf.append(Integer.toHexString(i2));
            StringUtil.BYTE2HEX_PAD[i2] = str = buf.toString();
            StringUtil.BYTE2HEX_NOPAD[i2] = str;
            ++i2;
        }
    }
}

