/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import ai.h2o.org.eclipse.jetty.alpn.ALPN;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.python.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import org.python.netty.handler.ssl.JdkSslEngine;
import org.python.netty.util.internal.ObjectUtil;

final class JdkAlpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JdkAlpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.ALPNExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JdkAlpnSslEngine(SSLEngine engine, final JdkApplicationProtocolNegotiator applicationNegotiator, boolean server) {
        super(engine);
        ObjectUtil.checkNotNull(applicationNegotiator, "applicationNegotiator");
        if (server) {
            final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = ObjectUtil.checkNotNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
            ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPN.ServerProvider(){

                public String select(List<String> protocols) throws SSLException {
                    try {
                        return protocolSelector.select(protocols);
                    }
                    catch (SSLHandshakeException e2) {
                        throw e2;
                    }
                    catch (Throwable t2) {
                        SSLHandshakeException e3 = new SSLHandshakeException(t2.getMessage());
                        e3.initCause(t2);
                        throw e3;
                    }
                }

                public void unsupported() {
                    protocolSelector.unsupported();
                }
            });
        } else {
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = ObjectUtil.checkNotNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
            ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPN.ClientProvider(){

                public List<String> protocols() {
                    return applicationNegotiator.protocols();
                }

                public void selected(String protocol) throws SSLException {
                    try {
                        protocolListener.selected(protocol);
                    }
                    catch (SSLHandshakeException e2) {
                        throw e2;
                    }
                    catch (Throwable t2) {
                        SSLHandshakeException e3 = new SSLHandshakeException(t2.getMessage());
                        e3.initCause(t2);
                        throw e3;
                    }
                }

                public void unsupported() {
                    protocolListener.unsupported();
                }
            });
        }
    }

    @Override
    public void closeInbound() throws SSLException {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

