/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.AbstractNumericMethodGenerator;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeType;

final class FastLongMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastLongMethodGenerator.getMaximumFastLongParameters();
    private static final String[] signatures = FastLongMethodGenerator.buildSignatures(Long.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeVrL", "invokeLrL", "invokeLLrL", "invokeLLLrL", "invokeLLLLrL", "invokeLLLLLrL", "invokeLLLLLLrL"};

    FastLongMethodGenerator() {
    }

    @Override
    String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerIntType() {
        return Long.TYPE;
    }

    @Override
    public boolean isSupported(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            if (FastLongMethodGenerator.isFastLongParameter(platform, signature.getParameterType(i2))) continue;
            return false;
        }
        return FastLongMethodGenerator.isFastLongResult(platform, signature.getResultType());
    }

    static final int getMaximumFastLongParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeLLLLLLrL", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t2) {
            return -1;
        }
    }

    private static boolean isFastLongType(Platform platform, NativeType type) {
        switch (type) {
            case BOOL: 
            case BYTE: 
            case UBYTE: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG: 
            case ULONG: 
            case LONGLONG: 
            case ULONGLONG: 
            case POINTER: {
                return true;
            }
        }
        return false;
    }

    static boolean isFastLongResult(Platform platform, NativeType type) {
        switch (type) {
            case VOID: {
                return true;
            }
            case POINTER: 
            case STRING: {
                return platform.addressSize() == 64;
            }
        }
        return FastLongMethodGenerator.isFastLongType(platform, type);
    }

    static boolean isFastLongParameter(Platform platform, NativeType type) {
        switch (type) {
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return platform.addressSize() == 64;
            }
        }
        return FastLongMethodGenerator.isFastLongType(platform, type);
    }
}

