/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.BaseSet;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBytecode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.modules.PyIOFile;
import org.python.modules.PyIOFileFactory;

public class _marshal
implements ClassDictInit {
    private static final char TYPE_NULL = '0';
    private static final char TYPE_NONE = 'N';
    private static final char TYPE_FALSE = 'F';
    private static final char TYPE_TRUE = 'T';
    private static final char TYPE_STOPITER = 'S';
    private static final char TYPE_ELLIPSIS = '.';
    private static final char TYPE_INT = 'i';
    private static final char TYPE_INT64 = 'I';
    private static final char TYPE_FLOAT = 'f';
    private static final char TYPE_BINARY_FLOAT = 'g';
    private static final char TYPE_COMPLEX = 'x';
    private static final char TYPE_BINARY_COMPLEX = 'y';
    private static final char TYPE_LONG = 'l';
    private static final char TYPE_STRING = 's';
    private static final char TYPE_INTERNED = 't';
    private static final char TYPE_STRINGREF = 'R';
    private static final char TYPE_TUPLE = '(';
    private static final char TYPE_LIST = '[';
    private static final char TYPE_DICT = '{';
    private static final char TYPE_CODE = 'c';
    private static final char TYPE_UNICODE = 'u';
    private static final char TYPE_UNKNOWN = '?';
    private static final char TYPE_SET = '<';
    private static final char TYPE_FROZENSET = '>';
    private static final int MAX_MARSHAL_STACK_DEPTH = 2000;
    private static final int CURRENT_VERSION = 2;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__name__", (PyObject)Py.newString("_marshal"));
    }

    public static class Unmarshaller
    extends PyObject
    implements Traverseproc {
        private final PyIOFile file;
        private final PyList strings = new PyList();
        private final int version;
        int depth = 0;
        private boolean debug = false;

        public Unmarshaller(PyObject file) {
            this(file, 2);
        }

        public Unmarshaller(PyObject file, int version) {
            this.file = PyIOFileFactory.createIOFile(file);
            this.version = version;
        }

        public void _debug() {
            this.debug = true;
        }

        public PyObject load() {
            try {
                PyObject obj = this.read_object(0);
                if (obj == null) {
                    throw Py.TypeError("NULL object in marshal data");
                }
                return obj;
            }
            catch (StringIndexOutOfBoundsException e2) {
                throw Py.EOFError("EOF read where object expected");
            }
        }

        private int read_byte() {
            char b2 = this.file.read(1).charAt(0);
            if (this.debug) {
                System.err.print("[" + b2 + "]");
            }
            return b2;
        }

        private String read_string(int n2) {
            return this.file.read(n2);
        }

        private int read_short() {
            int x2 = this.read_byte();
            return x2 |= this.read_byte() << 8;
        }

        private int read_int() {
            int x2 = this.read_byte();
            x2 |= this.read_byte() << 8;
            x2 |= this.read_byte() << 16;
            return x2 |= this.read_byte() << 24;
        }

        private long read_long64() {
            long lo4 = this.read_int();
            long hi4 = this.read_int();
            long x2 = hi4 << 32 | lo4 & 0xFFFFFFFFL;
            return x2;
        }

        private BigInteger read_long() {
            int size = this.read_int();
            int sign = 1;
            if (size < 0) {
                sign = -1;
                size = -size;
            }
            BigInteger result = BigInteger.ZERO;
            for (int i2 = 0; i2 < size; ++i2) {
                String digits = String.valueOf(this.read_short());
                result = result.or(new BigInteger(digits).shiftLeft(i2 * 15));
            }
            if (sign < 0) {
                result = result.negate();
            }
            return result;
        }

        private double read_float() {
            int size = this.read_byte();
            return Py.newString(this.read_string(size)).atof();
        }

        private double read_binary_float() {
            return Double.longBitsToDouble(this.read_long64());
        }

        private PyObject read_object_notnull(int depth) {
            PyObject v2 = this.read_object(depth);
            if (v2 == null) {
                throw Py.ValueError("bad marshal data");
            }
            return v2;
        }

        private String[] read_strings(int depth) {
            PyTuple t2 = (PyTuple)this.read_object_notnull(depth);
            String[] some_strings = new String[t2.__len__()];
            int i2 = 0;
            for (PyObject item : t2.asIterable()) {
                some_strings[i2++] = item.toString().intern();
            }
            return some_strings;
        }

        private PyObject read_object(int depth) {
            if (depth >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            int type = this.read_byte();
            switch (type) {
                case 48: {
                    return null;
                }
                case 78: {
                    return Py.None;
                }
                case 83: {
                    return Py.StopIteration;
                }
                case 46: {
                    return Py.Ellipsis;
                }
                case 70: {
                    return Py.False;
                }
                case 84: {
                    return Py.True;
                }
                case 105: {
                    return Py.newInteger(this.read_int());
                }
                case 73: {
                    return Py.newInteger(this.read_long64());
                }
                case 108: {
                    return Py.newLong(this.read_long());
                }
                case 102: {
                    return Py.newFloat(this.read_float());
                }
                case 103: {
                    return Py.newFloat(this.read_binary_float());
                }
                case 120: {
                    double real = this.read_float();
                    double imag = this.read_float();
                    return new PyComplex(real, imag);
                }
                case 121: {
                    double real = this.read_binary_float();
                    double imag = this.read_binary_float();
                    return new PyComplex(real, imag);
                }
                case 115: 
                case 116: {
                    int size = this.read_int();
                    String s2 = this.read_string(size);
                    if (type == 116) {
                        PyString pys = PyString.fromInterned(s2.intern());
                        this.strings.append(pys);
                        return pys;
                    }
                    return Py.newString(s2);
                }
                case 82: {
                    int i2 = this.read_int();
                    return this.strings.__getitem__(i2);
                }
                case 117: {
                    int n2 = this.read_int();
                    PyString buffer = Py.newString(this.read_string(n2));
                    return buffer.decode("utf-8");
                }
                case 40: {
                    int n3 = this.read_int();
                    if (n3 < 0) {
                        throw Py.ValueError("bad marshal data");
                    }
                    PyObject[] items = new PyObject[n3];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        items[i3] = this.read_object_notnull(depth + 1);
                    }
                    return new PyTuple(items);
                }
                case 91: {
                    int n4 = this.read_int();
                    if (n4 < 0) {
                        throw Py.ValueError("bad marshal data");
                    }
                    PyObject[] items = new PyObject[n4];
                    for (int i4 = 0; i4 < n4; ++i4) {
                        items[i4] = this.read_object_notnull(depth + 1);
                    }
                    return new PyList(items);
                }
                case 123: {
                    PyObject key;
                    PyDictionary d2 = new PyDictionary();
                    while ((key = this.read_object(depth + 1)) != null) {
                        PyObject value = this.read_object(depth + 1);
                        if (value == null) continue;
                        d2.__setitem__(key, value);
                    }
                    return d2;
                }
                case 60: 
                case 62: {
                    int n5 = this.read_int();
                    PyObject[] items = new PyObject[n5];
                    for (int i5 = 0; i5 < n5; ++i5) {
                        items[i5] = this.read_object(depth + 1);
                    }
                    PyTuple v2 = new PyTuple(items);
                    if (type == 60) {
                        return new PySet(v2);
                    }
                    return new PyFrozenSet(v2);
                }
                case 99: {
                    int argcount = this.read_int();
                    int nlocals = this.read_int();
                    int stacksize = this.read_int();
                    int flags = this.read_int();
                    String code = this.read_object_notnull(depth + 1).toString();
                    PyObject[] consts = ((PyTuple)this.read_object_notnull(depth + 1)).getArray();
                    String[] names = this.read_strings(depth + 1);
                    String[] varnames = this.read_strings(depth + 1);
                    String[] freevars = this.read_strings(depth + 1);
                    String[] cellvars = this.read_strings(depth + 1);
                    String filename = this.read_object_notnull(depth + 1).toString();
                    String name = this.read_object_notnull(depth + 1).toString();
                    int firstlineno = this.read_int();
                    String lnotab = this.read_object_notnull(depth + 1).toString();
                    return new PyBytecode(argcount, nlocals, stacksize, flags, code, consts, names, varnames, filename, name, firstlineno, lnotab, cellvars, freevars);
                }
            }
            throw Py.ValueError("bad marshal data");
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal;
            if (this.file instanceof Traverseproc && (retVal = ((Traverseproc)((Object)this.file)).traverse(visit, arg)) != 0) {
                return retVal;
            }
            return visit.visit(this.strings, arg);
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            if (ob == null) {
                return false;
            }
            if (this.file != null && this.file instanceof Traverseproc && ((Traverseproc)((Object)this.file)).refersDirectlyTo(ob)) {
                return true;
            }
            return ob == this.strings;
        }
    }

    public static class Marshaller
    extends PyObject
    implements Traverseproc {
        private final PyIOFile file;
        private final int version;
        private boolean debug = false;

        public Marshaller(PyObject file) {
            this(file, 2);
        }

        public Marshaller(PyObject file, int version) {
            this.file = PyIOFileFactory.createIOFile(file);
            this.version = version;
        }

        public void _debug() {
            this.debug = true;
        }

        public void dump(PyObject obj) {
            this.write_object(obj, 0);
        }

        private void write_byte(char c2) {
            if (this.debug) {
                System.err.print("[" + c2 + "]");
            }
            this.file.write(c2);
        }

        private void write_string(String s2) {
            this.file.write(s2);
        }

        private void write_strings(String[] some_strings, int depth) {
            PyObject[] items = new PyObject[some_strings.length];
            for (int i2 = 0; i2 < some_strings.length; ++i2) {
                items[i2] = Py.newString(some_strings[i2]);
            }
            this.write_object(new PyTuple(items), depth + 1);
        }

        private void write_short(short x2) {
            this.write_byte((char)(x2 & 0xFF));
            this.write_byte((char)(x2 >> 8 & 0xFF));
        }

        private void write_int(int x2) {
            this.write_byte((char)(x2 & 0xFF));
            this.write_byte((char)(x2 >> 8 & 0xFF));
            this.write_byte((char)(x2 >> 16 & 0xFF));
            this.write_byte((char)(x2 >> 24 & 0xFF));
        }

        private void write_long64(long x2) {
            this.write_int((int)(x2 & 0xFFFFFFFFFFFFFFFFL));
            this.write_int((int)(x2 >> 32 & 0xFFFFFFFFFFFFFFFFL));
        }

        private void write_long(BigInteger x2) {
            int sign = x2.signum();
            if (sign < 0) {
                x2 = x2.negate();
            }
            int num_bits = x2.bitLength();
            int num_digits = num_bits / 15 + (num_bits % 15 == 0 ? 0 : 1);
            this.write_int(sign < 0 ? -num_digits : num_digits);
            BigInteger mask = BigInteger.valueOf(32767L);
            for (int i2 = 0; i2 < num_digits; ++i2) {
                this.write_short(x2.and(mask).shortValue());
                x2 = x2.shiftRight(15);
            }
        }

        private void write_float(PyFloat f2) {
            this.write_string(f2.__repr__().toString());
        }

        private void write_binary_float(PyFloat f2) {
            this.write_long64(Double.doubleToLongBits(f2.getValue()));
        }

        private void write_object(PyObject v2, int depth) {
            if (depth >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            if (v2 == null) {
                this.write_byte('0');
            } else if (v2 == Py.None) {
                this.write_byte('N');
            } else if (v2 == Py.StopIteration) {
                this.write_byte('S');
            } else if (v2 == Py.Ellipsis) {
                this.write_byte('.');
            } else if (v2 == Py.False) {
                this.write_byte('F');
            } else if (v2 == Py.True) {
                this.write_byte('T');
            } else if (v2 instanceof PyInteger) {
                this.write_byte('i');
                this.write_int(((PyInteger)v2).asInt());
            } else if (v2 instanceof PyLong) {
                this.write_byte('l');
                this.write_long(((PyLong)v2).getValue());
            } else if (v2 instanceof PyFloat) {
                if (this.version == 2) {
                    this.write_byte('g');
                    this.write_binary_float((PyFloat)v2);
                } else {
                    this.write_byte('f');
                    this.write_float((PyFloat)v2);
                }
            } else if (v2 instanceof PyComplex) {
                PyComplex x2 = (PyComplex)v2;
                if (this.version == 2) {
                    this.write_byte('y');
                    this.write_binary_float(x2.getReal());
                    this.write_binary_float(x2.getImag());
                } else {
                    this.write_byte('x');
                    this.write_float(x2.getReal());
                    this.write_float(x2.getImag());
                }
            } else if (v2 instanceof PyUnicode) {
                this.write_byte('u');
                String buffer = ((PyUnicode)v2).encode("utf-8").toString();
                this.write_int(buffer.length());
                this.write_string(buffer);
            } else if (v2 instanceof PyString) {
                this.write_byte('s');
                this.write_int(v2.__len__());
                this.write_string(v2.toString());
            } else if (v2 instanceof PyTuple) {
                this.write_byte('(');
                PyTuple t2 = (PyTuple)v2;
                int n2 = t2.__len__();
                this.write_int(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.write_object(t2.__getitem__(i2), depth + 1);
                }
            } else if (v2 instanceof PyList) {
                this.write_byte('[');
                PyList list = (PyList)v2;
                int n3 = list.__len__();
                this.write_int(n3);
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.write_object(list.__getitem__(i3), depth + 1);
                }
            } else if (v2 instanceof PyDictionary) {
                this.write_byte('{');
                PyDictionary dict = (PyDictionary)v2;
                for (PyObject item : dict.iteritems().asIterable()) {
                    PyTuple pair = (PyTuple)item;
                    this.write_object(pair.__getitem__(0), depth + 1);
                    this.write_object(pair.__getitem__(1), depth + 1);
                }
                this.write_object(null, depth + 1);
            } else if (v2 instanceof BaseSet) {
                if (v2 instanceof PySet) {
                    this.write_byte('<');
                } else {
                    this.write_byte('>');
                }
                int n4 = v2.__len__();
                this.write_int(n4);
                BaseSet set = (BaseSet)v2;
                for (PyObject item : set.asIterable()) {
                    this.write_object(item, depth + 1);
                }
            } else if (v2 instanceof PyBytecode) {
                PyBytecode code = (PyBytecode)v2;
                this.write_byte('c');
                this.write_int(code.co_argcount);
                this.write_int(code.co_nlocals);
                this.write_int(code.co_stacksize);
                this.write_int(code.co_flags.toBits());
                this.write_object(Py.newString(new String(code.co_code)), depth + 1);
                this.write_object(new PyTuple(code.co_consts), depth + 1);
                this.write_strings(code.co_names, depth + 1);
                this.write_strings(code.co_varnames, depth + 1);
                this.write_strings(code.co_freevars, depth + 1);
                this.write_strings(code.co_cellvars, depth + 1);
                this.write_object(Py.newString(code.co_name), depth + 1);
                this.write_int(code.co_firstlineno);
                this.write_object(Py.newString(new String(code.co_lnotab)), depth + 1);
            } else {
                this.write_byte('?');
            }
            --depth;
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            return this.file != null && this.file instanceof Traverseproc ? ((Traverseproc)((Object)this.file)).traverse(visit, arg) : 0;
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return this.file != null && this.file instanceof Traverseproc ? ((Traverseproc)((Object)this.file)).refersDirectlyTo(ob) : false;
        }
    }
}

