/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.io.FileIO;
import org.python.core.io.RawIOBase;
import org.python.core.io.StreamIO;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._io.OpenMode;
import org.python.modules._io.PyFileIO$PyExposer;
import org.python.modules._io.PyFileIODerived;
import org.python.modules._io.PyRawIOBase;

@Untraversable
@ExposedType(name="_io.FileIO", base=PyRawIOBase.class)
public class PyFileIO
extends PyRawIOBase {
    public static final PyType TYPE;
    private RawIOBase ioDelegate;
    private boolean readable;
    private boolean writable;
    private boolean seekableKnown;
    private boolean seekable;
    public final boolean closefd;
    public final PyString mode;
    private static final PyString defaultMode;
    private static final String[] openArgs;

    public final void mode_readonly(PyString value) {
        this.readonlyAttributeError("mode");
    }

    public PyFileIO(PyObject file, OpenMode mode, boolean closefd) {
        this(TYPE, file, mode, closefd);
    }

    public PyFileIO(PyType subtype, PyObject file, OpenMode mode, boolean closefd) {
        super(subtype);
        this.readable = mode.reading | mode.updating;
        this.writable = mode.writing | mode.updating | mode.appending;
        this.closefd = closefd;
        this.setDelegate(file, mode);
        this.mode = this.readable ? new PyString(this.writable ? "rb+" : "rb") : new PyString("wb");
    }

    private void setDelegate(PyObject file, OpenMode mode) {
        if (file instanceof PyString) {
            if (!this.closefd) {
                throw Py.ValueError("Cannot use closefd=False with file name");
            }
            this.ioDelegate = new FileIO((PyString)file, mode.forFileIO());
        } else {
            Object fd = file.__tojava__(Object.class);
            if (fd instanceof FileIO || fd instanceof StreamIO) {
                this.ioDelegate = (RawIOBase)fd;
            }
        }
        if (this.ioDelegate == null) {
            throw Py.TypeError(String.format("invalid file: %s", file.__repr__().asString()));
        }
        if (this.ioDelegate.closed()) {
            throw Py.OSError(Errno.EBADF);
        }
        if (this.readable && !this.ioDelegate.readable() || this.writable && !this.ioDelegate.writable()) {
            throw this.tailoredValueError(this.readable ? "read" : "writ");
        }
        this.fastGetDict().__setitem__("name", file);
    }

    @ExposedNew
    static PyObject FileIO___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("FileIO", args, keywords, openArgs, 1);
        PyObject file = ap.getPyObject(0);
        PyObject m4 = ap.getPyObject(1, defaultMode);
        boolean closefd = Py.py2boolean(ap.getPyObject(2, Py.True));
        OpenMode mode = new OpenMode(m4.asString()){
            {
                this.invalid |= this.universal | this.text;
            }
        };
        mode.checkValid();
        if (subtype == TYPE) {
            return new PyFileIO(subtype, file, mode, closefd);
        }
        return new PyFileIODerived(subtype, file, mode, closefd);
    }

    @Override
    public PyObject readinto(PyObject buf) {
        return this.FileIO_readinto(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PyLong FileIO_readinto(PyObject buf) {
        int count2;
        if (!this.readable) {
            throw this.tailoredValueError("read");
        }
        if (buf instanceof PyArray) {
            PyArray a2 = (PyArray)buf;
            try {
                InputStream is = this.ioDelegate.asInputStream();
                count2 = a2.fillFromStream(is);
                count2 *= a2.getItemsize();
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        PyBuffer pybuf = PyFileIO.writablePyBuffer(buf);
        try {
            ByteBuffer byteBuffer = pybuf.getNIOByteBuffer();
            RawIOBase rawIOBase = this.ioDelegate;
            synchronized (rawIOBase) {
                count2 = this.ioDelegate.readinto(byteBuffer);
            }
        }
        finally {
            pybuf.release();
        }
        return new PyLong(count2);
    }

    @Override
    public PyObject write(PyObject buf) {
        return this.FileIO_write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PyLong FileIO_write(PyObject buf) {
        int count2;
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        if (buf instanceof PyArray) {
            try {
                OutputStream os2 = this.ioDelegate.asOutputStream();
                count2 = ((PyArray)buf).toStream(os2);
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        PyBuffer pybuf = PyFileIO.readablePyBuffer(buf);
        try {
            ByteBuffer byteBuffer = pybuf.getNIOByteBuffer();
            RawIOBase rawIOBase = this.ioDelegate;
            synchronized (rawIOBase) {
                count2 = this.ioDelegate.write(byteBuffer);
            }
        }
        finally {
            pybuf.release();
        }
        return new PyLong(count2);
    }

    @Override
    public long seek(long pos, int whence) {
        return this.FileIO_seek(pos, whence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long FileIO_seek(long pos, int whence) {
        if (this.__closed) {
            throw this.closedValueError();
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.seek(pos, whence);
        }
    }

    @Override
    public long truncate() {
        return this._truncate();
    }

    @Override
    public long truncate(long size) {
        return this._truncate(size);
    }

    final long FileIO_truncate(PyObject size) {
        return size != null ? this._truncate(size.asLong()) : this._truncate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long _truncate() {
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.truncate(this.ioDelegate.tell());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long _truncate(long size) {
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.truncate(size);
        }
    }

    @Override
    public void close() {
        this.FileIO_close();
    }

    final synchronized void FileIO_close() {
        super.close();
        if (this.closefd) {
            this.ioDelegate.close();
        }
        this.readable = false;
        this.writable = false;
    }

    @Override
    public boolean seekable() {
        return this.FileIO_seekable();
    }

    final boolean FileIO_seekable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        if (!this.seekableKnown) {
            try {
                this.ioDelegate.seek(0L, 1);
                this.seekable = true;
            }
            catch (PyException exc) {
                if (!exc.match(Py.IOError)) {
                    throw exc;
                }
                this.seekable = false;
            }
            this.seekableKnown = true;
        }
        return this.seekable;
    }

    @Override
    public boolean readable() throws PyException {
        return this.FileIO_readable();
    }

    final boolean FileIO_readable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.readable;
    }

    @Override
    public boolean writable() throws PyException {
        return this.FileIO_writable();
    }

    final boolean FileIO_writable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.writable;
    }

    @Override
    public PyObject fileno() {
        return this.FileIO_fileno();
    }

    final PyObject FileIO_fileno() {
        return PyJavaType.wrapJavaObject(this.ioDelegate.fileno());
    }

    @Override
    public boolean isatty() {
        return this.FileIO_isatty();
    }

    final boolean FileIO_isatty() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.ioDelegate.isatty();
    }

    @Override
    public void flush() {
        this.FileIO_flush();
    }

    final void FileIO_flush() {
        if (this.writable()) {
            this.ioDelegate.checkClosed();
            this.ioDelegate.flush();
        }
    }

    final String FileIO_toString() {
        if (this.closed()) {
            return "<_io.FileIO [closed]>";
        }
        PyObject name = this.fastGetDict().__finditem__("name");
        if (name != null && name instanceof PyString) {
            String xname = name.asString();
            if (name instanceof PyUnicode) {
                xname = PyString.encode_UnicodeEscape(xname, false);
            }
            return String.format("<_io.FileIO name='%s' mode='%s'>", xname, this.mode);
        }
        return String.format("<_io.FileIO fd=%s mode='%s'>", this.fileno(), this.mode);
    }

    @Override
    public String toString() {
        return this.FileIO_toString().toString();
    }

    private PyException closedValueError() {
        return Py.ValueError("I/O operation on closed file");
    }

    private PyException tailoredValueError(String action) {
        if (action == null || this.__closed) {
            return this.closedValueError();
        }
        return Py.ValueError("File not open for " + action + "ing");
    }

    static {
        PyType.addBuilder(PyFileIO.class, new PyFileIO$PyExposer());
        TYPE = PyType.fromClass(PyFileIO.class);
        defaultMode = new PyString("r");
        openArgs = new String[]{"file", "mode", "closefd"};
    }
}

