/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NType;

public class NSlice
extends NNode {
    static final long serialVersionUID = 8685364390631331543L;
    public NNode lower;
    public NNode step;
    public NNode upper;

    public NSlice(NNode lower, NNode step, NNode upper) {
        this(lower, step, upper, 0, 1);
    }

    public NSlice(NNode lower, NNode step, NNode upper, int start, int end) {
        super(start, end);
        this.lower = lower;
        this.step = step;
        this.upper = upper;
        this.addChildren(lower, step, upper);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NSlice.resolveExpr(this.lower, s2);
        NSlice.resolveExpr(this.step, s2);
        NSlice.resolveExpr(this.upper, s2);
        return this.setType(new NListType());
    }

    public String toString() {
        return "<Slice:" + this.lower + ":" + this.step + ":" + this.upper + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.lower, v2);
            this.visitNode(this.step, v2);
            this.visitNode(this.upper, v2);
        }
    }
}

