/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import java.util.Map;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NImportFrom
extends NNode {
    static final long serialVersionUID = 5070549408963950138L;
    public String module;
    public NQname qname;
    public List<NAlias> aliases;

    public NImportFrom(String module, NQname qname, List<NAlias> aliases) {
        this(module, qname, aliases, 0, 1);
    }

    public NImportFrom(String module, NQname qname, List<NAlias> aliases, int start, int end) {
        super(start, end);
        this.module = module;
        this.qname = qname;
        this.aliases = aliases;
        this.addChildren(qname);
        this.addChildren(aliases);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s2) throws Exception {
        if (this.isImportStar()) {
            return;
        }
        NImport.bindAliases(s2, this.aliases);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        Scope scope = s2.getScopeSymtab();
        NImportFrom.resolveExpr(this.qname, s2);
        NType bottomType = this.qname.getBottom().getType();
        if (!bottomType.isModuleType()) {
            return this.setType(new NUnknownType());
        }
        NModuleType mt = (NModuleType)bottomType;
        this.setType(mt);
        NImport.addReferences(s2, this.qname, false);
        if (this.isImportStar()) {
            this.importStar(s2, mt);
            return this.getType();
        }
        for (NAlias a2 : this.aliases) {
            this.resolveAlias(scope, mt, a2);
        }
        return this.getType();
    }

    public boolean isImportStar() {
        return this.aliases.size() == 1 && "*".equals(this.aliases.get((int)0).name);
    }

    private void resolveAlias(Scope scope, NModuleType mt, NAlias a2) throws Exception {
        String mqname;
        NModuleType mt2;
        NBinding entry = mt.getTable().lookup(a2.name);
        if (entry == null && (mt2 = Indexer.idx.loadModule(mqname = this.qname.toQname() + "." + a2.qname.toQname())) != null) {
            entry = Indexer.idx.lookupQname(mt2.getTable().getPath());
        }
        if (entry == null) {
            this.addError(a2, "name " + a2.qname.getName().id + " not found in module " + this.module);
            return;
        }
        String qname = a2.qname.getName().id;
        String aname = a2.aname != null ? a2.aname.id : null;
        Indexer.idx.putLocation(a2.qname.getName(), entry);
        if (aname != null) {
            Indexer.idx.putLocation(a2.aname, entry);
            scope.put(aname, entry);
        } else {
            scope.put(qname, entry);
        }
    }

    private void importStar(Scope s2, NModuleType mt) throws Exception {
        if (mt == null || mt.getFile() == null) {
            return;
        }
        NModule mod2 = Indexer.idx.getAstForFile(mt.getFile());
        if (mod2 == null) {
            return;
        }
        List<String> names = mod2.getExportedNames();
        if (!names.isEmpty()) {
            for (String name : names) {
                NBinding nb = mt.getTable().lookupLocal(name);
                if (nb == null) continue;
                s2.put(name, nb);
            }
        } else {
            for (Map.Entry<String, NBinding> e2 : mt.getTable().entrySet()) {
                if (e2.getKey().startsWith("_")) continue;
                s2.put(e2.getKey(), e2.getValue());
            }
        }
    }

    public String toString() {
        return "<FromImport:" + this.module + ":" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.qname, v2);
            this.visitNodeList(this.aliases, v2);
        }
    }
}

