/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public class NIfExp
extends NNode {
    static final long serialVersionUID = 8516153579808365723L;
    public NNode test;
    public NNode body;
    public NNode orelse;

    public NIfExp(NNode test, NNode body, NNode orelse) {
        this(test, body, orelse, 0, 1);
    }

    public NIfExp(NNode test, NNode body, NNode orelse, int start, int end) {
        super(start, end);
        this.test = test;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(test, body, orelse);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NIfExp.resolveExpr(this.test, s2);
        if (this.body != null) {
            this.setType(NIfExp.resolveExpr(this.body, s2));
        }
        if (this.orelse != null) {
            this.addType(NIfExp.resolveExpr(this.orelse, s2));
        }
        return this.getType();
    }

    public String toString() {
        return "<IfExp:" + this.start() + ":" + this.test + ":" + this.body + ":" + this.orelse + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.test, v2);
            this.visitNode(this.body, v2);
            this.visitNode(this.orelse, v2);
        }
    }
}

