/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.python.icu.impl.Assert;
import org.python.icu.impl.ICUBinary;
import org.python.icu.impl.ICULocaleService;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.ICUService;
import org.python.icu.text.BreakIterator;
import org.python.icu.text.RuleBasedBreakIterator;
import org.python.icu.util.ULocale;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    static final ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};

    BreakIteratorFactory() {
    }

    public Object registerInstance(BreakIterator iter2, ULocale locale, int kind) {
        iter2.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter2, locale, kind);
    }

    public boolean unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return service.getAvailableULocales();
    }

    public BreakIterator createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter2 = (BreakIterator)service.get(locale, kind, actualLoc);
        iter2.setLocale(actualLoc[0], actualLoc[0]);
        return iter2;
    }

    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        String lbKeyValue;
        RuleBasedBreakIterator iter2 = null;
        ICUResourceBundle rb = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b/brkitr", locale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        ByteBuffer bytes = null;
        String typeKeyExt = null;
        if (kind == 2 && (lbKeyValue = locale.getKeywordValue("lb")) != null && (lbKeyValue.equals("strict") || lbKeyValue.equals("normal") || lbKeyValue.equals("loose"))) {
            typeKeyExt = "_" + lbKeyValue;
        }
        try {
            String typeKey = typeKeyExt == null ? KIND_NAMES[kind] : KIND_NAMES[kind] + typeKeyExt;
            String brkfname = rb.getStringWithFallback("boundaries/" + typeKey);
            String rulesFileName = "brkitr/" + brkfname;
            bytes = ICUBinary.getData(rulesFileName);
        }
        catch (Exception e2) {
            throw new MissingResourceException(e2.toString(), "", "");
        }
        try {
            iter2 = RuleBasedBreakIterator.getInstanceFromCompiledRules(bytes);
        }
        catch (IOException e3) {
            Assert.fail(e3);
        }
        ULocale uloc = ULocale.forLocale(rb.getLocale());
        iter2.setLocale(uloc, uloc);
        iter2.setBreakType(kind);
        return iter2;
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBBreakIteratorFactory() {
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService srvc) {
                    return BreakIteratorFactory.createBreakInstance(loc, kind);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory());
            this.markDefault();
        }

        public String validateFallbackLocale() {
            return "";
        }
    }
}

