/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.lang.reflect.Array;

public class ByteSwapper {
    public static void swap(Object array) {
        Class<?> arrayType = array.getClass().getComponentType();
        if (arrayType.isPrimitive()) {
            if (arrayType == Boolean.TYPE) {
                return;
            }
            if (arrayType == Byte.TYPE) {
                return;
            }
            if (arrayType == Character.TYPE) {
                return;
            }
            if (arrayType == Short.TYPE) {
                ByteSwapper.swapShortArray(array);
            } else if (arrayType == Integer.TYPE) {
                ByteSwapper.swapIntegerArray(array);
            } else if (arrayType == Long.TYPE) {
                ByteSwapper.swapLongArray(array);
            } else if (arrayType == Float.TYPE) {
                ByteSwapper.swapFloatArray(array);
            } else if (arrayType == Double.TYPE) {
                ByteSwapper.swapDoubleArray(array);
            }
        }
    }

    private static void swapDoubleArray(Object array) {
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            double dtmp = Array.getDouble(array, i2);
            long tmp = Double.doubleToLongBits(dtmp);
            long b1 = tmp >> 0 & 0xFFL;
            long b2 = tmp >> 8 & 0xFFL;
            long b3 = tmp >> 16 & 0xFFL;
            long b4 = tmp >> 24 & 0xFFL;
            long b5 = tmp >> 32 & 0xFFL;
            long b6 = tmp >> 40 & 0xFFL;
            long b7 = tmp >> 48 & 0xFFL;
            long b8 = tmp >> 56 & 0xFFL;
            tmp = b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
            dtmp = Double.longBitsToDouble(tmp);
            Array.setDouble(array, i2, dtmp);
        }
    }

    private static void swapFloatArray(Object array) {
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            float ftmp = Array.getFloat(array, i2);
            int tmp = Float.floatToIntBits(ftmp);
            int b1 = tmp >> 0 & 0xFF;
            int b2 = tmp >> 8 & 0xFF;
            int b3 = tmp >> 16 & 0xFF;
            int b4 = tmp >> 24 & 0xFF;
            tmp = b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
            ftmp = Float.intBitsToFloat(tmp);
            Array.setFloat(array, i2, ftmp);
        }
    }

    private static void swapIntegerArray(Object array) {
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            int tmp = Array.getInt(array, i2);
            int b1 = tmp >> 0 & 0xFF;
            int b2 = tmp >> 8 & 0xFF;
            int b3 = tmp >> 16 & 0xFF;
            int b4 = tmp >> 24 & 0xFF;
            tmp = b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
            Array.setInt(array, i2, tmp);
        }
    }

    private static void swapLongArray(Object array) {
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            long tmp = Array.getLong(array, i2);
            long b1 = tmp >> 0 & 0xFFL;
            long b2 = tmp >> 8 & 0xFFL;
            long b3 = tmp >> 16 & 0xFFL;
            long b4 = tmp >> 24 & 0xFFL;
            long b5 = tmp >> 32 & 0xFFL;
            long b6 = tmp >> 40 & 0xFFL;
            long b7 = tmp >> 48 & 0xFFL;
            long b8 = tmp >> 56 & 0xFFL;
            tmp = b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
            Array.setLong(array, i2, tmp);
        }
    }

    private static void swapShortArray(Object array) {
        int len = Array.getLength(array);
        for (int i2 = 0; i2 < len; ++i2) {
            short tmp = Array.getShort(array, i2);
            int b1 = tmp >> 0 & 0xFF;
            int b2 = tmp >> 8 & 0xFF;
            tmp = (short)(b1 << 8 | b2 << 0);
            Array.setShort(array, i2, tmp);
        }
    }
}

