/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Iterator;

class StringSubsequenceIterator
implements Iterator {
    private final String s;
    private int current;
    private int k;
    private int start;
    private int stop;
    private int step;

    StringSubsequenceIterator(String s2, int start, int stop, int step) {
        this.s = s2;
        this.k = 0;
        this.current = start;
        this.start = start;
        this.stop = stop;
        this.step = step;
        int count2 = StringSubsequenceIterator.getCodePointCount(s2);
        if (start >= count2) {
            this.stop = -1;
        } else if (stop >= count2) {
            this.stop = count2;
        }
        for (int i2 = 0; i2 < start; ++i2) {
            this.nextCodePoint();
        }
    }

    StringSubsequenceIterator(String s2) {
        this(s2, 0, StringSubsequenceIterator.getCodePointCount(s2), 1);
    }

    private static int getCodePointCount(String s2) {
        return s2.codePointCount(0, s2.length());
    }

    @Override
    public boolean hasNext() {
        return this.current < this.stop;
    }

    public Object next() {
        int codePoint = this.nextCodePoint();
        ++this.current;
        for (int j2 = 1; j2 < this.step && this.hasNext(); ++j2) {
            this.nextCodePoint();
            ++this.current;
        }
        return codePoint;
    }

    private int nextCodePoint() {
        int U;
        int W1 = this.s.charAt(this.k);
        if (W1 >= 55296 && W1 < 56320) {
            char W2 = this.s.charAt(this.k + 1);
            U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
            this.k += 2;
        } else {
            U = W1;
            ++this.k;
        }
        return U;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported on String objects (immutable)");
    }
}

