/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.python.core.Options;
import org.python.core.Py;

public class BytecodeNotification {
    private static List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();

    public static void register(Callback n2) {
        callbacks.add(n2);
    }

    public static boolean unregister(Callback n2) {
        return callbacks.remove(n2);
    }

    public static void clear() {
        callbacks.clear();
    }

    public static void notify(String name, byte[] data, Class klass) {
        for (Callback c2 : callbacks) {
            try {
                c2.notify(name, data, klass);
            }
            catch (Exception e2) {
                Py.writeWarning("BytecodeNotification", "Exception from callback:" + e2);
            }
        }
    }

    static {
        BytecodeNotification.register(new Callback(){

            @Override
            public void notify(String name, byte[] bytes, Class c2) {
                if (Options.proxyDebugDirectory == null || !name.startsWith("org.python.pycode.") && !name.startsWith("org.python.proxies.")) {
                    return;
                }
                ByteArrayOutputStream ostream = new ByteArrayOutputStream(bytes.length);
                ostream.write(bytes, 0, bytes.length);
                Py.saveClassFile(name, ostream);
            }
        });
    }

    public static interface Callback {
        public void notify(String var1, byte[] var2, Class var3);
    }
}

