/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyXRange;
import org.python.core.buffer.SimpleBuffer;
import org.python.util.PythonInterpreter;

public class BaseBytesTest
extends TestCase {
    public static final int SMALL = 7;
    public static final int MEDIUM = 25;
    public static final int LARGE = 2000;
    public static final int HUGE = 100000;
    PythonInterpreter interp;
    Random random;

    public BaseBytesTest(String name) {
        super(name);
    }

    public static char toChar(int b2) {
        return Character.toChars(0xFF & b2)[0];
    }

    public static int[] toInts(String s2) {
        int n2 = s2.length();
        int[] r2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int c2 = s2.codePointAt(i2);
            r2[i2] = 0xFF & c2;
        }
        return r2;
    }

    public static int[] randomInts(Random random, int n2) {
        int[] r2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            r2[i2] = random.nextInt(256);
        }
        return r2;
    }

    public static int[] randomInts(Random random, int n2, int lo, int hi) {
        int[] r2 = new int[n2];
        int m4 = hi + 1 - lo;
        for (int i2 = 0; i2 < n2; ++i2) {
            r2[i2] = lo + random.nextInt(m4);
        }
        return r2;
    }

    static void checkInts(int[] expected, int first, BaseBytes result, int start, int len) {
        if (len > 0) {
            int end = first + len;
            if (end > expected.length) {
                end = expected.length;
            }
            int i2 = first;
            int j2 = start;
            while (i2 < end) {
                BaseBytesTest.assertEquals((String)"element value", (int)expected[i2], (int)result.intAt(j2));
                ++i2;
                ++j2;
            }
        }
    }

    static void checkInts(int[] expected, BaseBytes result) {
        BaseBytesTest.assertEquals((String)"size", (int)expected.length, (int)result.size());
        for (int i2 = 0; i2 < expected.length; ++i2) {
            BaseBytesTest.assertEquals((String)"element value", (int)expected[i2], (int)result.intAt(i2));
        }
    }

    static void checkInts(List<PyInteger> expected, BaseBytes result) {
        BaseBytesTest.assertEquals((String)"size", (int)expected.size(), (int)result.size());
        for (int i2 = 0; i2 < result.size; ++i2) {
            PyInteger res = result.pyget(i2);
            PyInteger exp = expected.get(i2);
            BaseBytesTest.assertEquals((String)"element value", (Object)exp, (Object)res);
        }
    }

    static void checkInts(List<PyInteger> expected, PyObject result) {
        BaseBytesTest.checkInts(expected, (BaseBytes)result);
    }

    public static Iterable<PyObject> iterableBytes(int[] source) {
        ArrayList<PyObject> list = new ArrayList<PyObject>(source.length);
        int choose = 0;
        block4: for (int b2 : source) {
            switch (choose++) {
                case 0: {
                    PyInteger i2 = new PyInteger(b2);
                    list.add(i2);
                    continue block4;
                }
                case 1: {
                    PyLong l2 = new PyLong(b2);
                    list.add(l2);
                    continue block4;
                }
                default: {
                    PyString s2 = new PyString(BaseBytesTest.toChar(b2));
                    list.add(s2);
                    choose = 0;
                }
            }
        }
        return list;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random(20120310L);
    }

    public void testSize() {
        int[] aRef = BaseBytesTest.toInts("Chaque coquillage incrust\u00e9");
        BaseBytes a2 = this.getInstance(aRef);
        System.out.println(this.toString(a2));
        BaseBytesTest.assertEquals((int)aRef.length, (int)a2.size());
        for (int n2 : new int[]{0, 1, 2, 7, 8, 9, 25, 2000, 100000}) {
            a2 = this.getInstance(n2);
            BaseBytesTest.assertEquals((String)"size()", (int)n2, (int)a2.size());
            BaseBytesTest.assertEquals((String)"__len__()", (int)n2, (int)a2.__len__());
        }
    }

    public void testInit_intArray() {
        int[] aRef = BaseBytesTest.toInts("Dans la grotte o\u00f9 nous nous aim\u00e2mes");
        BaseBytes a2 = this.getInstance(aRef);
        BaseBytes b2 = this.getInstance(a2);
        System.out.println(this.toString(b2));
        BaseBytesTest.assertEquals((int)a2.size(), (int)b2.size());
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            BaseBytesTest.assertEquals((int)a2.intAt(i2), (int)b2.intAt(i2));
        }
    }

    public void testInit_Iterable() {
        int[] aRef = BaseBytesTest.toInts("A sa particularit\u00e9.");
        Iterable<PyObject> ia = BaseBytesTest.iterableBytes(aRef);
        BaseBytes a2 = this.getInstance(ia);
        System.out.println(this.toString(a2));
        BaseBytesTest.assertEquals((int)aRef.length, (int)a2.size());
        BaseBytesTest.checkInts(aRef, a2);
        BaseBytes b2 = this.getInstance(BaseBytesTest.iterableBytes(new int[0]));
        BaseBytesTest.assertEquals((int)0, (int)b2.size());
        int[] cRef = BaseBytesTest.toInts(":-)");
        BaseBytes c2 = this.getInstance(BaseBytesTest.iterableBytes(cRef));
        BaseBytesTest.assertEquals((int)cRef.length, (int)c2.size());
        BaseBytesTest.checkInts(cRef, c2);
    }

    public void testInit_PyObject() {
        PyObject[] brantub = new PyObject[]{null, new PyInteger(5), new PyString("\u00a0\u00a1\u00a2\u00a3\u00a4"), this.getInstance(new int[]{180, 190, 200}), new PyXRange(1, 301, 50)};
        int[][] prize = new int[][]{new int[0], {0, 0, 0, 0, 0}, {160, 161, 162, 163, 164}, {180, 190, 200}, {1, 51, 101, 151, 201, 251}};
        for (int dip = 0; dip < brantub.length; ++dip) {
            int[] aRef = prize[dip];
            BaseBytes a2 = this.getInstance(brantub[dip]);
            BaseBytesTest.assertEquals((int)aRef.length, (int)a2.size());
            BaseBytesTest.checkInts(aRef, a2);
        }
    }

    public void testInit_Exceptions() {
        this.interp = new PythonInterpreter();
        PyObject[] brantub = new PyObject[]{Py.None, new PyInteger(-1), new PyLong(0x80000000L), new PyXRange(3, -2, -1), new PyXRange(250, 257)};
        PyObject[] boobyPrize = new PyObject[]{Py.TypeError, Py.ValueError, Py.OverflowError, Py.ValueError, Py.ValueError};
        for (int dip = 0; dip < brantub.length; ++dip) {
            PyObject aRef = boobyPrize[dip];
            try {
                BaseBytes a2 = this.getInstance(brantub[dip]);
                System.out.println(this.toString(a2));
                BaseBytesTest.fail((String)("Exception not thrown for " + brantub[dip]));
                continue;
            }
            catch (PyException pye) {
                PyObject a3 = pye.type;
                BaseBytesTest.assertEquals((Object)aRef, (Object)a3);
            }
        }
    }

    public void testPyget() {
        this.interp = new PythonInterpreter();
        int[] aRef = BaseBytesTest.randomInts(this.random, 25);
        BaseBytes a2 = this.getInstance(aRef);
        for (int i2 = 0; i2 < 25; ++i2) {
            PyInteger r2 = a2.pyget(i2);
            BaseBytesTest.assertEquals((int)aRef[i2], (int)r2.asInt());
        }
        for (int i3 : new int[]{-1, -100, 25, 26}) {
            try {
                PyInteger r3 = a2.pyget(i3);
                BaseBytesTest.fail((String)("Exception not thrown for pyget(" + i3 + ") =" + r3));
            }
            catch (PyException pye) {
                BaseBytesTest.assertEquals((Object)Py.IndexError, (Object)pye.type);
            }
        }
    }

    public void testGetslice() {
        BaseBytes b2;
        int stop;
        int step;
        String ver = "L'un a la pourpre de nos \u00e2mes";
        int L2 = ver.length();
        int[] aRef = BaseBytesTest.toInts(ver);
        BaseBytes a2 = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L2);
        int[] posStart = new int[]{0, 1, 18, L2 - 8, L2 - 1};
        int[] negStart = new int[]{0, 3, 16, L2 - 10, L2 - 1};
        for (step = 1; step < 4; ++step) {
            int[] arr$ = posStart;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int start;
                for (stop = start = arr$[i$]; stop <= L2; ++stop) {
                    bList.clear();
                    for (int i2 = start; i2 < stop; i2 += step) {
                        bList.add(new PyInteger(aRef[i2]));
                    }
                    b2 = a2.getslice(start, stop, step);
                    BaseBytesTest.checkInts(bList, b2);
                }
            }
        }
        for (step = -1; step > -4; --step) {
            for (int start : negStart) {
                for (stop = -1; stop <= start; ++stop) {
                    bList.clear();
                    for (int i3 = start; i3 > stop; i3 += step) {
                        bList.add(new PyInteger(aRef[i3]));
                    }
                    b2 = a2.getslice(start, stop, step);
                    BaseBytesTest.checkInts(bList, b2);
                }
            }
        }
    }

    public void testRepeatInt() {
        String spam = "Spam, ";
        int maxCount = 10;
        int L2 = spam.length();
        int[] aRef = BaseBytesTest.toInts(spam);
        BaseBytes a2 = this.getInstance(aRef);
        for (int count2 = 0; count2 <= 10; ++count2) {
            int[] bRef = new int[count2 * L2];
            for (int i2 = 0; i2 < count2; ++i2) {
                for (int j2 = 0; j2 < L2; ++j2) {
                    bRef[i2 * L2 + j2] = aRef[j2];
                }
            }
            BaseBytes b2 = a2.repeat(count2);
            BaseBytesTest.checkInts(bRef, b2);
        }
    }

    public void testPyset() {
        PyObject bRef = Py.TypeError;
        int[] aRef = BaseBytesTest.toInts("This immutable type seems to allow modifications.");
        BaseBytes a2 = this.getInstance(aRef);
        int start = a2.size() / 2;
        PyInteger x2 = new PyInteger(120);
        try {
            a2.pyset(start, x2);
            System.out.println(this.toString(a2));
            BaseBytesTest.fail((String)String.format("Exception not thrown for pyset(%d,%s)", start, x2));
        }
        catch (PyException pye) {
            PyObject b2 = pye.type;
            BaseBytesTest.assertEquals((Object)bRef, (Object)b2);
        }
    }

    public void testSetslice3() {
        PyObject bRef = Py.TypeError;
        int[] aRef = BaseBytesTest.toInts("This immutable type seems to allow modifications.");
        BaseBytes a2 = this.getInstance(aRef);
        int start = a2.size() / 4;
        int stop = (3 * a2.size() + 3) / 4;
        int step = 3;
        MyBytes x2 = new MyBytes(BaseBytesTest.randomInts(this.random, 7));
        try {
            a2.setslice(start, stop, step, x2);
            System.out.println(this.toString(a2));
            BaseBytesTest.fail((String)String.format("Exception not thrown for setslice(%d,%d,%d,%s)", start, stop, step, x2));
        }
        catch (PyException pye) {
            PyObject b2 = pye.type;
            BaseBytesTest.assertEquals((Object)bRef, (Object)b2);
        }
    }

    public BaseBytes getInstance(PyType type) {
        return new MyBytes(type);
    }

    public BaseBytes getInstance() {
        return new MyBytes();
    }

    public BaseBytes getInstance(int size) {
        return new MyBytes(size);
    }

    public BaseBytes getInstance(int[] value) {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(BaseBytes value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(BufferProtocol value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(Iterable<? extends PyObject> value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(PyString arg, PyObject encoding, PyObject errors) throws PyException {
        return new MyBytes(arg, encoding, errors);
    }

    public BaseBytes getInstance(PyString arg, String encoding, String errors) throws PyException {
        return new MyBytes(arg, encoding, errors);
    }

    public BaseBytes getInstance(PyObject arg) throws PyException {
        return new MyBytes(arg);
    }

    protected String toString(BaseBytes b2) {
        Image i2 = new Image();
        i2.showSummary(b2);
        if (b2.storage.length >= 0 && b2.storage.length <= 70) {
            i2.padTo(15);
            i2.showContent(b2);
        }
        return i2.toString();
    }

    private static Object getItem(int n2, Object buf, int[] strides, int[] suboffsets, int[] indices) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] p2 = (Object[])buf;
            buf = p2[indices[i2] * strides[i2] + suboffsets[i2]];
        }
        return buf;
    }

    private static byte getByte(int ndim, Object buf, int[] strides, int[] suboffsets, int[] indices) {
        int n2 = ndim - 1;
        byte[] b2 = (byte[])BaseBytesTest.getItem(n2, buf, strides, suboffsets, indices);
        return b2[indices[n2] + suboffsets[n2]];
    }

    protected static class Image {
        private StringBuilder image = new StringBuilder(100);

        protected Image() {
        }

        private void repeat(char c2, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.image.append(i2 == 0 ? (char)'|' : ' ').append(c2);
            }
        }

        private void append(byte[] s2, int pos, int n2) {
            if (pos < 0 || pos + n2 > s2.length) {
                return;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int c2 = 0xFF & s2[pos + i2];
                if (c2 == 0) {
                    c2 = 46;
                } else if (Character.isISOControl(c2)) {
                    c2 = 35;
                }
                this.image.append(i2 == 0 ? (char)'|' : ' ').append(BaseBytesTest.toChar(c2));
            }
        }

        public void padTo(int n2) {
            while (n2 > this.image.length()) {
                this.image.append(' ');
            }
        }

        public String showSummary(BaseBytes b2) {
            this.image.append(b2.offset);
            this.image.append(" [ ").append(b2.size).append(" ] ");
            this.image.append(b2.storage.length - (b2.offset + b2.size));
            return this.image.toString();
        }

        public String showExtent(BaseBytes b2) {
            this.repeat('-', b2.offset);
            this.repeat('x', b2.size);
            int tail = b2.storage.length - (b2.offset + b2.size);
            this.repeat('-', tail);
            this.image.append('|');
            return this.image.toString();
        }

        public String showContent(BaseBytes b2) {
            this.append(b2.storage, 0, b2.offset);
            this.append(b2.storage, b2.offset, b2.size);
            int tail = b2.storage.length - (b2.offset + b2.size);
            this.append(b2.storage, b2.offset + b2.size, tail);
            this.image.append('|');
            return this.image.toString();
        }

        public String toString() {
            return this.image.toString();
        }
    }

    public static class BufferedObject
    extends PyObject
    implements BufferProtocol {
        public static final PyType TYPE = PyType.fromClass(BufferedObject.class);
        private byte[] store;

        BufferedObject(int[] value) {
            super(TYPE);
            int n2 = value.length;
            this.store = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.store[i2] = (byte)value[i2];
            }
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            return new SimpleBuffer(flags, this.store);
        }
    }

    public static class MyBytes
    extends BaseBytes {
        public static final PyType TYPE = PyType.fromClass(MyBytes.class);

        public MyBytes(PyType type) {
            super(type);
        }

        public MyBytes() {
            super(TYPE);
        }

        public MyBytes(int size) {
            super(TYPE, size);
        }

        MyBytes(int[] value) {
            super(TYPE, value);
        }

        public MyBytes(BaseBytes value) {
            super(TYPE);
            this.init(value);
        }

        public MyBytes(BufferProtocol value) {
            super(TYPE);
            this.init(value.getBuffer(0));
        }

        public MyBytes(Iterable<? extends PyObject> value) {
            super(TYPE);
            this.init(value);
        }

        public MyBytes(PyString arg, PyObject encoding, PyObject errors) {
            super(TYPE);
            this.init(arg, encoding, errors);
        }

        public MyBytes(PyString arg, String encoding, String errors) {
            super(TYPE);
            this.init(arg, encoding, errors);
        }

        public MyBytes(PyObject arg) throws PyException {
            super(TYPE);
            this.init(arg);
        }

        protected MyBytes(int start, int stop, BaseBytes source) {
            super(TYPE);
            this.setStorage(source.storage, stop - start, start);
        }

        @Override
        protected MyBytes repeat(int count2) {
            MyBytes ret = new MyBytes();
            ret.setStorage(this.repeatImpl(count2));
            return ret;
        }

        @Override
        protected MyBytes getslice(int start, int stop, int step) {
            MyBytes r2;
            if (step == 1) {
                r2 = new MyBytes();
                if (stop > start) {
                    r2.setStorage(this.storage, stop - start, start + this.offset);
                }
            } else {
                r2 = new MyBytes(MyBytes.sliceLength(start, stop, step));
                int iomax = r2.size + r2.offset;
                int jo = start;
                for (int io = r2.offset; io < iomax; ++io) {
                    r2.storage[io] = this.storage[jo];
                    jo += step;
                }
            }
            return r2;
        }

        @Override
        public int __len__() {
            return this.size;
        }

        protected MyBytes(BaseBytes.Builder builder) {
            super(TYPE);
            this.setStorage(builder.getStorage(), builder.getSize());
        }

        @Override
        protected BaseBytes.Builder getBuilder(int capacity) {
            return new BaseBytes.Builder(capacity){

                @Override
                MyBytes getResult() {
                    return new MyBytes(this);
                }
            };
        }
    }
}

