/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.antlr.adapter.AstAdapter;
import org.python.core.AstList$PyExposer;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedType;

@ExposedType(name="_ast.astlist", base=PyList.class)
public class AstList
extends PySequence
implements Cloneable,
List,
Traverseproc {
    public static final PyType TYPE;
    private static final PyString[] fields;
    private List data;
    private AstAdapter adapter;

    public PyString[] get_fields() {
        return fields;
    }

    public AstList() {
        this(TYPE, new ArrayList(), null);
    }

    public AstList(List data) {
        this(TYPE, data, null);
    }

    public AstList(List data, AstAdapter adapter) {
        this(TYPE, data, adapter);
    }

    public AstList(PyType type, List data, AstAdapter adapter) {
        super(TYPE);
        if (data == null) {
            data = new ArrayList();
        }
        this.data = data;
        this.adapter = adapter;
    }

    final PyObject astlist___ne__(PyObject o2) {
        return this.seq___ne__(o2);
    }

    final PyObject astlist___eq__(PyObject o2) {
        return this.seq___eq__(o2);
    }

    final PyObject astlist___lt__(PyObject o2) {
        return this.seq___lt__(o2);
    }

    final PyObject astlist___le__(PyObject o2) {
        return this.seq___le__(o2);
    }

    final PyObject astlist___gt__(PyObject o2) {
        return this.seq___gt__(o2);
    }

    final PyObject astlist___ge__(PyObject o2) {
        return this.seq___ge__(o2);
    }

    final boolean astlist___contains__(PyObject o2) {
        return this.object___contains__(o2);
    }

    final void astlist___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void astlist___setitem__(PyObject o2, PyObject def) {
        this.seq___setitem__(o2, def);
    }

    final PyObject astlist___getitem__(PyObject o2) {
        PyObject ret = this.seq___finditem__(o2);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o2);
        }
        return ret;
    }

    final boolean astlist___nonzero__() {
        return this.seq___nonzero__();
    }

    public PyObject astlist___iter__() {
        return this.seq___iter__();
    }

    final PyObject astlist___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void astlist___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        if (value == null) {
            value = step;
            step = null;
        }
        this.seq___setslice__(start, stop, step, value);
    }

    final void astlist___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    public PyObject __imul__(PyObject o2) {
        return this.astlist___imul__(o2);
    }

    final PyObject astlist___imul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        int count2 = o2.asIndex(Py.OverflowError);
        int size = this.size();
        if (size == 0 || count2 == 1) {
            return this;
        }
        if (count2 < 1) {
            this.clear();
            return this;
        }
        if (size > Integer.MAX_VALUE / count2) {
            throw Py.MemoryError("");
        }
        int oldsize = this.data.size();
        for (int i2 = 1; i2 < count2; ++i2) {
            this.data.addAll(this.data.subList(0, oldsize));
        }
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.astlist___mul__(o2);
    }

    final PyObject astlist___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.astlist___rmul__(o2);
    }

    final PyObject astlist___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iadd__(PyObject other) {
        return this.astlist___iadd__(other);
    }

    final PyObject astlist___iadd__(PyObject o2) {
        PyObject it;
        PyType oType = o2.getType();
        if (oType == TYPE || oType == PyTuple.TYPE || this == o2) {
            this.extend(AstList.fastSequence(o2, "argument must be iterable"));
            return this;
        }
        try {
            it = o2.__iter__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.TypeError)) {
                throw pye;
            }
            return null;
        }
        this.extend(it);
        return this;
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.astlist___add__(other);
    }

    final PyObject astlist___add__(PyObject o2) {
        AstList sum = null;
        Object oList = o2.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new AstList();
            sum.extend(this);
            Iterator i2 = otherList.iterator();
            while (i2.hasNext()) {
                sum.add(i2.next());
            }
        }
        return sum;
    }

    @Override
    public PyObject __radd__(PyObject o2) {
        return this.astlist___radd__(o2);
    }

    final PyObject astlist___radd__(PyObject o2) {
        PyList sum = null;
        Object oList = o2.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    @Override
    public int __len__() {
        return this.data.size();
    }

    @Override
    public String toString() {
        return this.astlist_toString();
    }

    final String astlist_toString() {
        return this.data.toString();
    }

    public void append(PyObject o2) {
        this.astlist_append(o2);
    }

    final void astlist_append(PyObject o2) {
        this.data.add(o2);
    }

    public Object clone() {
        return new AstList(this);
    }

    final int astlist_count(PyObject value) {
        int count2 = 0;
        for (Object o2 : this.data) {
            if (!o2.equals(value)) continue;
            ++count2;
        }
        return count2;
    }

    public int count(PyObject value) {
        return this.astlist_count(value);
    }

    public int index(PyObject o2) {
        return this.astlist_index(o2, 0, this.size());
    }

    public int index(PyObject o2, int start) {
        return this.astlist_index(o2, start, this.size());
    }

    public int index(PyObject o2, int start, int stop) {
        return this.astlist_index(o2, start, stop);
    }

    final int astlist_index(PyObject o2, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.astlist_index(o2, startInt, stopInt);
    }

    final int astlist_index(PyObject o2, int start, int stop) {
        return this._index(o2, "astlist.index(x): x not in list", start, stop);
    }

    final int astlist_index(PyObject o2, int start) {
        return this._index(o2, "astlist.index(x): x not in list", start, this.size());
    }

    final int astlist_index(PyObject o2) {
        return this._index(o2, "astlist.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o2, String message, int start, int stop) {
        int validStart;
        int validStop = this.boundToSequence(stop);
        for (int i2 = validStart = this.boundToSequence(start); i2 < validStop && i2 < this.size(); ++i2) {
            if (!this.data.get(i2).equals(o2)) continue;
            return i2;
        }
        throw Py.ValueError(message);
    }

    @Override
    protected void del(int i2) {
        this.data.remove(i2);
    }

    protected void delRange(int start, int stop, int step) {
        block3: {
            block2: {
                if (step < 1) break block2;
                for (int i2 = start; i2 < stop; --stop, i2 += step) {
                    this.remove(i2);
                    --i2;
                }
                break block3;
            }
            if (step >= 0) break block3;
            for (int i3 = start; i3 >= 0 && i3 >= stop; i3 += step) {
                this.remove(i3);
            }
        }
    }

    final void astlist_extend(PyObject iterable) {
        int length = this.size();
        this.setslice(length, length, 1, iterable);
    }

    public void extend(PyObject iterable) {
        this.astlist_extend(iterable);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n2 = AstList.sliceLength(start, stop, step);
        List newList = this.data.subList(start, stop);
        if (step == 1) {
            newList = this.data.subList(start, stop);
            return new AstList(newList, this.adapter);
        }
        int j2 = 0;
        int i2 = start;
        while (j2 < n2) {
            newList.set(j2, this.data.get(i2));
            ++j2;
            i2 += step;
        }
        return new AstList(newList, this.adapter);
    }

    public void insert(int index, PyObject o2) {
        this.astlist_insert(index, o2);
    }

    final void astlist_insert(int index, PyObject o2) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.data.add(index, o2);
    }

    final void astlist_remove(PyObject value) {
        this.del(this._index(value, "astlist.remove(x): x not in list", 0, this.size()));
    }

    public void remove(PyObject value) {
        this.astlist_remove(value);
    }

    public void reverse() {
        this.astlist_reverse();
    }

    final void astlist_reverse() {
        Collections.reverse(this.data);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n2) {
        return this.astlist_pop(n2);
    }

    final PyObject astlist_pop(int n2) {
        if (this.adapter == null) {
            return (PyObject)this.data.remove(n2);
        }
        Object element = this.data.remove(n2);
        return this.adapter.ast2py(element);
    }

    @Override
    protected PyObject repeat(int count2) {
        if (count2 < 0) {
            count2 = 0;
        }
        int size = this.size();
        int newSize = size * count2;
        if (count2 != 0 && newSize / count2 != size) {
            throw Py.MemoryError("");
        }
        ArrayList newList = new ArrayList();
        for (int i2 = 0; i2 < count2; ++i2) {
            newList.addAll(this.data);
        }
        return new AstList(newList);
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (value instanceof PySequence) {
            PySequence sequence = (PySequence)value;
            this.setslicePySequence(start, stop, step, sequence);
        } else if (value instanceof List) {
            List list = (List)value.__tojava__(List.class);
            if (list != null && list != Py.NoConversion) {
                this.setsliceList(start, stop, step, list);
            }
        } else {
            this.setsliceIterable(start, stop, step, value);
        }
    }

    protected void setslicePySequence(int start, int stop, int step, PySequence value) {
        if (step != 0) {
            if (value == this) {
                PyList newseq = new PyList();
                PyObject iter2 = value.__iter__();
                PyObject item = null;
                while ((item = iter2.__iternext__()) != null) {
                    newseq.append(item);
                }
                value = newseq;
            }
            int n2 = value.__len__();
            int i2 = 0;
            int j2 = start;
            while (i2 < n2) {
                this.pyset(j2, value.pyget(i2));
                ++i2;
                j2 += step;
            }
        }
    }

    protected void setsliceList(int start, int stop, int step, List value) {
        if (step != 1) {
            throw Py.TypeError("setslice with java.util.List and step != 1 not supported yet");
        }
        int n2 = value.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.data.add(i2 + start, value.get(i2));
        }
    }

    protected void setsliceIterable(int start, int stop, int step, PyObject value) {
        PyObject[] seq;
        try {
            seq = Py.make_array(value);
        }
        catch (PyException pye) {
            if (pye.match(Py.TypeError)) {
                throw Py.TypeError("can only assign an iterable");
            }
            throw pye;
        }
        this.setslicePySequence(start, stop, step, new PyList(seq));
    }

    public void add(int index, Object element) {
        this.data.add(index, element);
    }

    @Override
    public boolean add(Object o2) {
        return this.data.add(o2);
    }

    public boolean addAll(int index, Collection c2) {
        return this.data.addAll(index, c2);
    }

    @Override
    public boolean addAll(Collection c2) {
        return this.data.addAll(c2);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o2) {
        return this.data.contains(o2);
    }

    @Override
    public boolean containsAll(Collection c2) {
        return this.data.containsAll(c2);
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    @Override
    public int indexOf(Object o2) {
        return this.data.indexOf(o2);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.data.lastIndexOf(o2);
    }

    public ListIterator listIterator() {
        return this.data.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.data.listIterator(index);
    }

    public boolean pyadd(PyObject o2) {
        this.data.add(o2);
        return true;
    }

    public void pyadd(int index, PyObject element) {
        this.data.add(index, element);
    }

    @Override
    public PyObject pyget(int index) {
        if (this.adapter == null) {
            return (PyObject)this.data.get(index);
        }
        return this.adapter.ast2py(this.data.get(index));
    }

    @Override
    public void pyset(int index, PyObject element) {
        if (this.adapter == null) {
            this.data.set(index, element);
        } else {
            Object o2 = this.adapter.py2ast(element);
            this.data.set(index, o2);
        }
    }

    public Object remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public boolean remove(Object o2) {
        return this.data.remove(o2);
    }

    @Override
    public boolean removeAll(Collection c2) {
        return this.data.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection c2) {
        return this.data.retainAll(c2);
    }

    public Object set(int index, Object element) {
        return this.data.set(index, element);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public Object[] toArray(Object[] a2) {
        return this.data.toArray(a2);
    }

    public Object __tojava__(Class c2) {
        if (c2.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        for (Object ob : this.data) {
            int retVal;
            if (!(ob instanceof PyObject) || (retVal = visit.visit((PyObject)ob, arg)) == 0) continue;
            return retVal;
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return this.data.contains(ob);
    }

    static {
        PyType.addBuilder(AstList.class, new AstList$PyExposer());
        TYPE = PyType.fromClass(AstList.class);
        fields = new PyString[0];
    }
}

