/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.base.expr;
import org.python.antlr.base.stmt;

public class ArgListCompiler
extends Visitor {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public List<expr> defaults = null;
    public List<String> names = new ArrayList<String>();
    public List<String> fpnames = new ArrayList<String>();
    public List<stmt> init_code = new ArrayList<stmt>();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.clear();
        this.init_code.clear();
    }

    public void appendInitCode(Suite node) {
        node.getInternalBody().addAll(0, this.init_code);
    }

    public List<expr> getDefaults() {
        return this.defaults;
    }

    public void visitArgs(arguments args) throws Exception {
        int i2;
        for (i2 = 0; i2 < args.getInternalArgs().size(); ++i2) {
            String name = (String)this.visit(args.getInternalArgs().get(i2));
            this.names.add(name);
            if (!(args.getInternalArgs().get(i2) instanceof Tuple)) continue;
            ArrayList<expr> targets = new ArrayList<expr>();
            targets.add(args.getInternalArgs().get(i2));
            Assign ass = new Assign(args.getInternalArgs().get(i2), targets, (expr)new Name(args.getInternalArgs().get(i2), name, expr_contextType.Load));
            this.init_code.add(ass);
        }
        if (args.getInternalVararg() != null) {
            this.arglist = true;
            this.names.add(args.getInternalVararg());
        }
        if (args.getInternalKwarg() != null) {
            this.keywordlist = true;
            this.names.add(args.getInternalKwarg());
        }
        this.defaults = args.getInternalDefaults();
        for (i2 = 0; i2 < this.defaults.size(); ++i2) {
            if (this.defaults.get(i2) != null) continue;
            throw new ParseException("non-default argument follows default argument", args.getInternalArgs().get(args.getInternalArgs().size() - this.defaults.size() + i2));
        }
    }

    @Override
    public Object visitName(Name node) throws Exception {
        if (node.getInternalCtx() != expr_contextType.Store && node.getInternalCtx() != expr_contextType.Param) {
            return null;
        }
        if (this.fpnames.contains(node.getInternalId())) {
            throw new ParseException("duplicate argument name found: " + node.getInternalId(), node);
        }
        this.fpnames.add(node.getInternalId());
        return node.getInternalId();
    }

    @Override
    public Object visitTuple(Tuple node) throws Exception {
        StringBuffer name = new StringBuffer("(");
        int n2 = node.getInternalElts().size();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            name.append(this.visit(node.getInternalElts().get(i2)));
            name.append(", ");
        }
        name.append(this.visit(node.getInternalElts().get(n2 - 1)));
        name.append(")");
        return name.toString();
    }
}

