/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.jcajce.provider.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;
import org.python.bouncycastle.pqc.jcajce.provider.util.CipherSpiExt;

public abstract class AsymmetricHybridCipher
extends CipherSpiExt {
    protected AlgorithmParameterSpec paramSpec;

    protected final void setMode(String string) {
    }

    protected final void setPadding(String string) {
    }

    public final byte[] getIV() {
        return null;
    }

    public final int getBlockSize() {
        return 0;
    }

    public final AlgorithmParameterSpec getParameters() {
        return this.paramSpec;
    }

    public final int getOutputSize(int n2) {
        return this.opMode == 1 ? this.encryptOutputSize(n2) : this.decryptOutputSize(n2);
    }

    public final void initEncrypt(Key key) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, new SecureRandom());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.initEncrypt(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initEncrypt(key, algorithmParameterSpec, new SecureRandom());
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 1;
        this.initCipherEncrypt(key, algorithmParameterSpec, secureRandom);
    }

    public final void initDecrypt(Key key) throws InvalidKeyException {
        try {
            this.initDecrypt(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initDecrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opMode = 2;
        this.initCipherDecrypt(key, algorithmParameterSpec);
    }

    public abstract byte[] update(byte[] var1, int var2, int var3);

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (byArray2.length < this.getOutputSize(n3)) {
            throw new ShortBufferException("output");
        }
        byte[] byArray3 = this.update(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws BadPaddingException;

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, BadPaddingException {
        if (byArray2.length < this.getOutputSize(n3)) {
            throw new ShortBufferException("Output buffer too short.");
        }
        byte[] byArray3 = this.doFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    protected abstract int encryptOutputSize(int var1);

    protected abstract int decryptOutputSize(int var1);

    protected abstract void initCipherEncrypt(Key var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void initCipherDecrypt(Key var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;
}

