/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.crypto.Digest;
import org.python.bouncycastle.crypto.ExtendedDigest;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.operator.DigestCalculatorProvider;
import org.python.bouncycastle.operator.OperatorCreationException;
import org.python.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.python.bouncycastle.operator.bc.BcDigestProvider;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    public DigestCalculator get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier);
        final DigestOutputStream digestOutputStream = new DigestOutputStream(extendedDigest);
        return new DigestCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            public OutputStream getOutputStream() {
                return digestOutputStream;
            }

            public byte[] getDigest() {
                return digestOutputStream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.dig.update(byArray, n2, n3);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        public void write(int n2) throws IOException {
            this.dig.update((byte)n2);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

