/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonLexer;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.CommonTokenStream;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.TokenSource;
import org.python.core.Py;

public class PythonTokenSource
implements TokenSource {
    public static final int MAX_INDENTS = 100;
    public static final int FIRST_CHAR_POSITION = 0;
    int[] indentStack = new int[100];
    int sp = -1;
    Vector<Token> tokens = new Vector();
    CommonTokenStream stream;
    int lastTokenAddedIndex = -1;
    String filename;
    boolean inSingle;

    public PythonTokenSource(PythonLexer lexer) {
    }

    public PythonTokenSource(CommonTokenStream stream, String filename) {
        this(stream, filename, false);
    }

    public PythonTokenSource(CommonTokenStream stream, String filename, boolean single) {
        this.stream = stream;
        this.filename = filename;
        this.inSingle = single;
        this.push(0);
    }

    @Override
    public Token nextToken() {
        if (this.tokens.size() > 0) {
            Token t2 = this.tokens.firstElement();
            this.tokens.removeElementAt(0);
            return t2;
        }
        this.insertImaginaryIndentDedentTokens();
        return this.nextToken();
    }

    private void generateNewline(Token t2) {
        CommonToken newline = new CommonToken(7, "\n");
        newline.setLine(t2.getLine());
        newline.setCharPositionInLine(t2.getCharPositionInLine());
        this.tokens.addElement(newline);
    }

    private void handleEOF(CommonToken eof, CommonToken prev) {
        if (prev != null) {
            eof.setStartIndex(prev.getStopIndex());
            eof.setStopIndex(prev.getStopIndex());
            eof.setLine(prev.getLine());
            eof.setCharPositionInLine(prev.getCharPositionInLine());
        }
    }

    protected void insertImaginaryIndentDedentTokens() {
        Token t2 = this.stream.LT(1);
        this.stream.consume();
        if (t2.getType() == -1) {
            Token prev = this.stream.LT(-1);
            this.handleEOF((CommonToken)t2, (CommonToken)prev);
            if (!this.inSingle) {
                if (prev == null) {
                    this.generateNewline(t2);
                } else if (prev.getType() == 8) {
                    this.handleDedents(-1, (CommonToken)t2);
                    this.generateNewline(t2);
                } else if (prev.getType() != 7) {
                    this.generateNewline(t2);
                    this.handleDedents(-1, (CommonToken)t2);
                }
            } else {
                this.handleDedents(-1, (CommonToken)t2);
            }
            this.enqueue(t2);
        } else if (t2.getType() == 7) {
            this.enqueueHiddens(t2);
            this.tokens.addElement(t2);
            Token newline = t2;
            t2 = this.stream.LT(1);
            this.stream.consume();
            List<Token> commentedNewlines = this.enqueueHiddens(t2);
            int cpos = t2.getCharPositionInLine();
            if (t2.getType() == -1) {
                this.handleEOF((CommonToken)t2, (CommonToken)newline);
                cpos = -1;
            } else if (t2.getType() == 8) {
                Token next = this.stream.LT(1);
                if (next != null && next.getType() == -1) {
                    this.stream.consume();
                    return;
                }
                cpos = t2.getText().length();
            }
            int lastIndent = this.peek();
            if (cpos > lastIndent) {
                this.handleIndents(cpos, (CommonToken)t2);
            } else if (cpos < lastIndent) {
                this.handleDedents(cpos, (CommonToken)t2);
            }
            if (t2.getType() == -1 && this.inSingle) {
                String newlines = newline.getText();
                for (int i2 = 1; i2 < newlines.length(); ++i2) {
                    this.generateNewline(newline);
                }
                for (Token c2 : commentedNewlines) {
                    this.generateNewline(c2);
                }
            }
            if (t2.getType() != 8) {
                this.tokens.addElement(t2);
            }
        } else {
            this.enqueue(t2);
        }
    }

    private void enqueue(Token t2) {
        this.enqueueHiddens(t2);
        this.tokens.addElement(t2);
    }

    private List<Token> enqueueHiddens(Token t2) {
        List hiddenTokens;
        ArrayList<Token> newlines = new ArrayList<Token>();
        if (this.inSingle && t2.getType() == -1) {
            int k2 = 1;
            while (this.stream.size() > this.lastTokenAddedIndex + k2) {
                Token hidden = this.stream.get(this.lastTokenAddedIndex + k2);
                if (hidden.getType() == 96) {
                    String text = hidden.getText();
                    int i2 = text.indexOf("\n");
                    i2 = text.indexOf("\n", i2 + 1);
                    while (i2 != -1) {
                        newlines.add(hidden);
                        ++this.lastTokenAddedIndex;
                        i2 = text.indexOf("\n", i2 + 1);
                    }
                    ++k2;
                    continue;
                }
                if (hidden.getType() == 7) {
                    this.generateNewline(hidden);
                    ++this.lastTokenAddedIndex;
                    break;
                }
                if (hidden.getType() != 8) break;
                ++k2;
            }
        }
        if ((hiddenTokens = this.stream.getTokens(this.lastTokenAddedIndex + 1, t2.getTokenIndex() - 1)) != null) {
            this.tokens.addAll(hiddenTokens);
        }
        this.lastTokenAddedIndex = t2.getTokenIndex();
        return newlines;
    }

    private void handleIndents(int cpos, CommonToken t2) {
        this.push(cpos);
        CommonToken indent = new CommonToken(4, "");
        indent.setCharPositionInLine(t2.getCharPositionInLine());
        indent.setLine(t2.getLine());
        indent.setStartIndex(t2.getStartIndex() - 1);
        indent.setStopIndex(t2.getStartIndex() - 1);
        this.tokens.addElement(indent);
    }

    private void handleDedents(int cpos, CommonToken t2) {
        int prevIndex = this.findPreviousIndent(cpos, t2);
        for (int d2 = this.sp - 1; d2 >= prevIndex; --d2) {
            CommonToken dedent = new CommonToken(5, "");
            dedent.setCharPositionInLine(t2.getCharPositionInLine());
            dedent.setLine(t2.getLine());
            dedent.setStartIndex(t2.getStartIndex() - 1);
            dedent.setStopIndex(t2.getStartIndex() - 1);
            this.tokens.addElement(dedent);
        }
        this.sp = prevIndex;
    }

    protected void push(int i2) {
        if (this.sp >= 100) {
            throw new IllegalStateException("stack overflow");
        }
        ++this.sp;
        this.indentStack[this.sp] = i2;
    }

    protected int pop() {
        if (this.sp < 0) {
            throw new IllegalStateException("stack underflow");
        }
        int top = this.indentStack[this.sp];
        --this.sp;
        return top;
    }

    protected int peek() {
        return this.indentStack[this.sp];
    }

    protected int findPreviousIndent(int i2, Token t2) {
        for (int j2 = this.sp - 1; j2 >= 0; --j2) {
            if (this.indentStack[j2] != i2) continue;
            return j2;
        }
        if (i2 == -1 || i2 == -2) {
            return 0;
        }
        ParseException p2 = new ParseException("unindent does not match any outer indentation level", t2.getLine(), t2.getCharPositionInLine());
        p2.setType(Py.IndentationError);
        throw p2;
    }

    public String stackString() {
        StringBuffer buf = new StringBuffer();
        for (int j2 = this.sp; j2 >= 0; --j2) {
            buf.append(" ");
            buf.append(this.indentStack[j2]);
        }
        return buf.toString();
    }

    @Override
    public String getSourceName() {
        return this.filename;
    }
}

