/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.util.FileUtils;

public class Version {
    private static final int UPDATE_INTERVAL = 180;

    public static String getVersion() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Version.printVersion(pw);
        pw.close();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPlainVersion() {
        Properties p2 = new Properties();
        InputStream s2 = Version.class.getResourceAsStream("/jmh.properties");
        if (s2 == null) {
            return "-";
        }
        try {
            p2.load(s2);
        }
        catch (IOException e2) {
            String string = "-";
            return string;
        }
        finally {
            FileUtils.safelyClose(s2);
        }
        String version = (String)p2.get("jmh.version");
        if (version == null) {
            return "-";
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printVersion(PrintWriter pw) {
        Properties p2 = new Properties();
        InputStream s2 = Version.class.getResourceAsStream("/jmh.properties");
        if (s2 == null) {
            pw.print("Cannot figure out JMH version, no jmh.properties");
            return;
        }
        try {
            p2.load(s2);
        }
        catch (IOException e2) {
            pw.print("Cannot figure out JMH version");
            return;
        }
        finally {
            FileUtils.safelyClose(s2);
        }
        String version = (String)p2.get("jmh.version");
        if (version == null) {
            pw.print("Cannot read jmh.version");
            return;
        }
        pw.print("JMH " + version + " ");
        String time = (String)p2.get("jmh.buildDate");
        if (time == null) {
            pw.print("(cannot read jmh.buildDate)");
            return;
        }
        pw.print("(released ");
        try {
            Date parse = new SimpleDateFormat("yyyy/MM/dd", Locale.ROOT).parse(time);
            long diff = (System.currentTimeMillis() - parse.getTime()) / TimeUnit.DAYS.toMillis(1L);
            if (diff > 0L) {
                pw.print(String.format("%d days ago", diff));
                if (diff > 180L) {
                    pw.print(", please consider updating!");
                }
            } else {
                pw.print("today");
            }
        }
        catch (ParseException e3) {
            pw.print(time);
        }
        pw.print(")");
    }
}

