/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import org.openjdk.jmh.util.AbstractStatistics;

public class SingletonStatistics
extends AbstractStatistics {
    private static final long serialVersionUID = -90642978235578197L;
    private final double value;

    public SingletonStatistics(double value) {
        this.value = value;
    }

    @Override
    public double getMax() {
        return this.value;
    }

    @Override
    public double getMin() {
        return this.value;
    }

    @Override
    public long getN() {
        return 1L;
    }

    @Override
    public double getSum() {
        return this.value;
    }

    @Override
    public double getPercentile(double rank) {
        return this.value;
    }

    @Override
    public double getVariance() {
        return Double.NaN;
    }

    @Override
    public int[] getHistogram(double[] levels) {
        int[] result = new int[levels.length - 1];
        for (int c2 = 0; c2 < levels.length - 1; ++c2) {
            if (!(levels[c2] <= this.value) || !(this.value < levels[c2 + 1])) continue;
            result[c2] = 1;
            break;
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Double, Long>> getRawData() {
        return new SingletonStatisticsIterator();
    }

    private class SingletonStatisticsIterator
    implements Iterator<Map.Entry<Double, Long>> {
        private boolean entryReturned = false;

        private SingletonStatisticsIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.entryReturned;
        }

        @Override
        public Map.Entry<Double, Long> next() {
            this.entryReturned = true;
            return new AbstractMap.SimpleImmutableEntry<Double, Long>(SingletonStatistics.this.value, 1L);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Element cannot be removed.");
        }
    }
}

