/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.options;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class TimeValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TimeValue NONE = new TimeValue(0L, TimeUnit.SECONDS);
    private final long time;
    private final TimeUnit timeUnit;

    public static TimeValue days(long v2) {
        return new TimeValue(v2, TimeUnit.DAYS);
    }

    public static TimeValue hours(long v2) {
        return new TimeValue(v2, TimeUnit.HOURS);
    }

    public static TimeValue microseconds(long v2) {
        return new TimeValue(v2, TimeUnit.MICROSECONDS);
    }

    public static TimeValue milliseconds(long v2) {
        return new TimeValue(v2, TimeUnit.MILLISECONDS);
    }

    public static TimeValue minutes(long v2) {
        return new TimeValue(v2, TimeUnit.MINUTES);
    }

    public static TimeValue nanoseconds(long v2) {
        return new TimeValue(v2, TimeUnit.NANOSECONDS);
    }

    public static TimeValue seconds(long v2) {
        return new TimeValue(v2, TimeUnit.SECONDS);
    }

    public TimeValue(long time, TimeUnit timeUnit) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time should be greater or equal to zero: " + time);
        }
        this.time = time;
        this.timeUnit = timeUnit;
    }

    public long getTime() {
        return this.time;
    }

    public long convertTo(TimeUnit tu) {
        return tu.convert(this.time, this.timeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (int)(this.time ^ this.time >>> 32);
        hash = 41 * hash + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeValue other = (TimeValue)obj;
        if (this.time != other.time) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    public String toString() {
        if (this.time == 0L) {
            return "single-shot";
        }
        return this.time + " " + TimeValue.tuToString(this.timeUnit);
    }

    public static String tuToString(TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                return "day";
            }
            case HOURS: {
                return "hr";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MINUTES: {
                return "min";
            }
            case NANOSECONDS: {
                return "ns";
            }
            case SECONDS: {
                return "s";
            }
        }
        return "?";
    }

    public static TimeValue valueOf(String timeString) {
        return TimeValue.fromString(timeString);
    }

    public static TimeValue fromString(String timeString) {
        if (timeString == null) {
            throw new IllegalArgumentException("String is null");
        }
        if ((timeString = timeString.replaceAll(" ", "").toLowerCase()).contains("ns")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("ns"))), TimeUnit.NANOSECONDS);
        }
        if (timeString.contains("ms")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("ms"))), TimeUnit.MILLISECONDS);
        }
        if (timeString.contains("us")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("us"))), TimeUnit.MICROSECONDS);
        }
        if (timeString.contains("s")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("s"))), TimeUnit.SECONDS);
        }
        if (timeString.contains("m")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("m"))), TimeUnit.MINUTES);
        }
        if (timeString.contains("hr")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("hr"))), TimeUnit.HOURS);
        }
        if (timeString.contains("day")) {
            return new TimeValue(Integer.parseInt(timeString.substring(0, timeString.indexOf("day"))), TimeUnit.DAYS);
        }
        return new TimeValue(Integer.parseInt(timeString), TimeUnit.SECONDS);
    }

    public void sleep() throws InterruptedException {
        this.timeUnit.sleep(this.time);
    }
}

