/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class WorkloadParams
implements Comparable<WorkloadParams>,
Serializable {
    private static final long serialVersionUID = 780563934988950196L;
    private final SortedMap<String, Value> params = new TreeMap<String, Value>();

    public WorkloadParams() {
    }

    private WorkloadParams(SortedMap<String, Value> params) {
        this();
        this.params.putAll(params);
    }

    @Override
    public int compareTo(WorkloadParams o2) {
        if (!this.params.keySet().equals(o2.params.keySet())) {
            throw new IllegalStateException("Comparing actual params with different key sets.");
        }
        for (Map.Entry<String, Value> e2 : this.params.entrySet()) {
            int cr = e2.getValue().compareTo((Value)o2.params.get(e2.getKey()));
            if (cr == 0) continue;
            return cr;
        }
        return 0;
    }

    public void put(String k2, String v2, int vOrder) {
        this.params.put(k2, new Value(v2, vOrder));
    }

    public boolean containsKey(String name) {
        return this.params.containsKey(name);
    }

    public String get(String name) {
        Value value = (Value)this.params.get(name);
        if (value == null) {
            return null;
        }
        return value.value;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        WorkloadParams that = (WorkloadParams)o2;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return this.params != null ? this.params.hashCode() : 0;
    }

    public String toString() {
        return this.params.toString();
    }

    public WorkloadParams copy() {
        return new WorkloadParams(this.params);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Collection<String> keys() {
        return this.params.keySet();
    }

    private static class Value
    implements Comparable<Value>,
    Serializable {
        private static final long serialVersionUID = 8846779314306880977L;
        private final String value;
        private final int order;

        public Value(String value, int order) {
            this.value = value;
            this.order = order;
        }

        @Override
        public int compareTo(Value o2) {
            return Integer.compare(this.order, o2.order);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Value value1 = (Value)o2;
            return Objects.equals(this.value, value1.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

