/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.IOException;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BaseRunner;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.IterationResultAcceptor;
import org.openjdk.jmh.runner.link.BinaryLinkClient;
import org.openjdk.jmh.runner.options.Options;

class ForkedRunner
extends BaseRunner {
    private final BinaryLinkClient link;

    public ForkedRunner(Options options, BinaryLinkClient link) {
        super(options, link.getOutputFormat());
        this.link = link;
    }

    public void run() throws IOException, ClassNotFoundException {
        ActionPlan actionPlan = this.link.requestPlan();
        try {
            IterationResultAcceptor acceptor = new IterationResultAcceptor(){

                @Override
                public void accept(IterationResult iterationData) {
                    try {
                        ForkedRunner.this.link.pushResults(iterationData);
                    }
                    catch (IOException e2) {
                        throw new SavedIOException(e2);
                    }
                }

                @Override
                public void acceptMeta(BenchmarkResultMetaData md) {
                    try {
                        ForkedRunner.this.link.pushResultMetadata(md);
                    }
                    catch (IOException e2) {
                        throw new SavedIOException(e2);
                    }
                }
            };
            this.runBenchmarksForked(actionPlan, acceptor);
        }
        catch (BenchmarkException be) {
            this.link.pushException(be);
        }
        catch (SavedIOException ioe) {
            throw ioe.getCause();
        }
        this.out.flush();
        this.out.close();
    }

    static class SavedIOException
    extends RuntimeException {
        private final IOException e;

        public SavedIOException(IOException e2) {
            super(e2);
            this.e = e2;
        }

        @Override
        public IOException getCause() {
            return this.e;
        }
    }
}

