/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.infra;

import java.io.Serializable;
import java.util.Objects;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.IterationParamsL1;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.options.TimeValue;

abstract class IterationParamsL2
extends IterationParamsL1
implements Serializable {
    private static final long serialVersionUID = -6138850517953881052L;
    protected final IterationType type;
    protected final int count;
    protected final TimeValue timeValue;
    protected final int batchSize;

    public IterationParamsL2(IterationType type, int count2, TimeValue time, int batchSize) {
        this.type = type;
        this.count = count2;
        this.timeValue = time;
        this.batchSize = batchSize;
    }

    public IterationType getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public TimeValue getTime() {
        return this.timeValue;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        IterationParams that = (IterationParams)o2;
        if (this.count != that.count) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        return Objects.equals(this.timeValue, that.timeValue);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + this.batchSize;
        result = 31 * result + (this.timeValue != null ? this.timeValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IterationParams(" + this.getCount() + ", " + this.getTime() + ", " + this.getBatchSize() + ")";
    }
}

