/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GenerationException;

class Identifiers {
    private final Map<String, String> collapsedTypes = new HashMap<String, String>();
    private int collapsedIndex = 0;
    private final Set<String> claimedJmhTypes = new HashSet<String>();
    private final Map<String, String> jmhTypes = new HashMap<String, String>();
    private int index = 0;

    Identifiers() {
    }

    public String getJMHtype(ClassInfo type) {
        String id = BenchmarkGeneratorUtils.getGeneratedName(type);
        String jmhType = this.jmhTypes.get(id);
        if (jmhType == null) {
            int v2 = 0;
            do {
                jmhType = id + (v2 == 0 ? "" : "_" + v2) + "_jmhType";
                ++v2;
            } while (!this.claimedJmhTypes.add(jmhType));
            this.jmhTypes.put(id, jmhType);
        }
        return jmhType;
    }

    public String collapseTypeName(String e2) {
        if (this.collapsedTypes.containsKey(e2)) {
            return this.collapsedTypes.get(e2);
        }
        String[] strings = e2.split("\\.");
        String name = strings[strings.length - 1].toLowerCase();
        String collapsedName = name + this.collapsedIndex++ + "_";
        this.collapsedTypes.put(e2, collapsedName);
        return collapsedName;
    }

    public String identifier(Scope scope) {
        switch (scope) {
            case Benchmark: 
            case Group: {
                return "G";
            }
            case Thread: {
                return String.valueOf(this.index++);
            }
        }
        throw new GenerationException("Unknown scope: " + (Object)((Object)scope), null);
    }
}

