/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.openjdk.jmh.generators.annotations.APClassInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GeneratorSource;

public class APGeneratorSource
implements GeneratorSource {
    private final RoundEnvironment roundEnv;
    private final ProcessingEnvironment processingEnv;
    private Collection<ClassInfo> classInfos;

    public APGeneratorSource(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        this.roundEnv = roundEnv;
        this.processingEnv = processingEnv;
    }

    @Override
    public Collection<ClassInfo> getClasses() {
        if (this.classInfos != null) {
            return this.classInfos;
        }
        TreeSet<TypeElement> discoveredClasses = new TreeSet<TypeElement>(new Comparator<TypeElement>(){

            @Override
            public int compare(TypeElement o1, TypeElement o2) {
                return o1.getQualifiedName().toString().compareTo(o2.getQualifiedName().toString());
            }
        });
        for (Element element : this.roundEnv.getRootElements()) {
            if (element.getKind() != ElementKind.CLASS) continue;
            discoveredClasses.add((TypeElement)element);
        }
        int lastSize = 0;
        while (discoveredClasses.size() > lastSize) {
            lastSize = discoveredClasses.size();
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
            for (Element element : discoveredClasses) {
                try {
                    TypeElement walk = (TypeElement)element;
                    do {
                        arrayList.addAll(ElementFilter.typesIn(walk.getEnclosedElements()));
                    } while ((walk = (TypeElement)this.processingEnv.getTypeUtils().asElement(walk.getSuperclass())) != null);
                }
                catch (Exception t2) {
                    if (t2.getClass().getName().endsWith("CompletionFailure")) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "While traversing " + element + ", caught " + t2);
                        continue;
                    }
                    throw new RuntimeException(t2);
                }
            }
            discoveredClasses.addAll(arrayList);
        }
        this.classInfos = this.convert(discoveredClasses);
        return this.classInfos;
    }

    protected Collection<ClassInfo> convert(Collection<TypeElement> els) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        for (TypeElement el : els) {
            list.add(new APClassInfo(this.processingEnv, el));
        }
        return list;
    }

    @Override
    public ClassInfo resolveClass(String className) {
        return new APClassInfo(this.processingEnv, this.processingEnv.getElementUtils().getTypeElement(className));
    }
}

