/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LongLargeArray;

public class CommonUtils {
    private static long THREADS_BEGIN_N_1D_FFT_2THREADS = 8192L;
    private static long THREADS_BEGIN_N_1D_FFT_4THREADS = 65536L;
    private static long THREADS_BEGIN_N_2D = 65536L;
    private static long THREADS_BEGIN_N_3D = 65536L;
    private static boolean useLargeArrays = false;

    public static void sleep(long millis) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public static long getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static long getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static long getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static long getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(long n2) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = n2 < 1024L ? 1024L : n2;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(long n2) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = n2 < 1024L ? 1024L : n2;
    }

    public static void setThreadsBeginN_2D(long n2) {
        THREADS_BEGIN_N_2D = n2 < 4096L ? 4096L : n2;
    }

    public static void setThreadsBeginN_3D(long n2) {
        THREADS_BEGIN_N_3D = n2;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192L;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536L;
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_2D = 65536L;
        THREADS_BEGIN_N_3D = 65536L;
    }

    public static boolean isUseLargeArrays() {
        return useLargeArrays;
    }

    public static void setUseLargeArrays(boolean useLargeArrays) {
        CommonUtils.useLargeArrays = useLargeArrays;
    }

    public static int nextPow2(int x2) {
        if (x2 < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((x2 & x2 - 1) == 0) {
            return x2;
        }
        x2 |= x2 >>> 1;
        x2 |= x2 >>> 2;
        x2 |= x2 >>> 4;
        x2 |= x2 >>> 8;
        x2 |= x2 >>> 16;
        return x2 + 1;
    }

    public static long nextPow2(long x2) {
        if (x2 < 1L) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((x2 & x2 - 1L) == 0L) {
            return x2;
        }
        x2 |= x2 >>> 1;
        x2 |= x2 >>> 2;
        x2 |= x2 >>> 4;
        x2 |= x2 >>> 8;
        x2 |= x2 >>> 16;
        x2 |= x2 >>> 32;
        return x2 + 1L;
    }

    public static int prevPow2(int x2) {
        if (x2 < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)FastMath.pow((double)2.0, (double)FastMath.floor((double)(FastMath.log((double)x2) / FastMath.log((double)2.0))));
    }

    public static long prevPow2(long x2) {
        if (x2 < 1L) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (long)FastMath.pow((double)2.0, (double)FastMath.floor((double)(FastMath.log((double)x2) / FastMath.log((double)2.0))));
    }

    public static boolean isPowerOf2(int x2) {
        if (x2 <= 0) {
            return false;
        }
        return (x2 & x2 - 1) == 0;
    }

    public static boolean isPowerOf2(long x2) {
        if (x2 <= 0L) {
            return false;
        }
        return (x2 & x2 - 1L) == 0L;
    }

    public static long getReminder(long n2, int[] factors) {
        long reminder = n2;
        if (n2 <= 0L) {
            throw new IllegalArgumentException("n must be positive integer");
        }
        for (int i2 = 0; i2 < factors.length && reminder != 1L; ++i2) {
            long factor = factors[i2];
            while (reminder % factor == 0L) {
                reminder /= factor;
            }
        }
        return reminder;
    }

    public static void makeipt(int nw, int[] ip) {
        ip[2] = 0;
        ip[3] = 16;
        int m4 = 2;
        for (int l2 = nw; l2 > 32; l2 >>= 2) {
            int m22 = m4 << 1;
            int q2 = m22 << 3;
            for (int j2 = m4; j2 < m22; ++j2) {
                int p2;
                ip[m4 + j2] = p2 = ip[j2] << 2;
                ip[m22 + j2] = p2 + q2;
            }
            m4 = m22;
        }
    }

    public static void makeipt(long nw, LongLargeArray ipl) {
        ipl.setLong(2L, 0L);
        ipl.setLong(3L, 16L);
        long m4 = 2L;
        for (long l2 = nw; l2 > 32L; l2 >>= 2) {
            long m22 = m4 << 1;
            long q2 = m22 << 3;
            for (long j2 = m4; j2 < m22; ++j2) {
                long p2 = ipl.getLong(j2) << 2;
                ipl.setLong(m4 + j2, p2);
                ipl.setLong(m22 + j2, p2 + q2);
            }
            m4 = m22;
        }
    }

    public static void makewt(int nw, int[] ip, double[] w2) {
        ip[0] = nw;
        ip[1] = 1;
        if (nw > 2) {
            int j2;
            int nwh = nw >> 1;
            double delta = 0.7853981633974483 / (double)nwh;
            double delta2 = delta * 2.0;
            double wn4r = FastMath.cos((double)(delta * (double)nwh));
            w2[0] = 1.0;
            w2[1] = wn4r;
            if (nwh == 4) {
                w2[2] = FastMath.cos((double)delta2);
                w2[3] = FastMath.sin((double)delta2);
            } else if (nwh > 4) {
                CommonUtils.makeipt(nw, ip);
                w2[2] = 0.5 / FastMath.cos((double)delta2);
                w2[3] = 0.5 / FastMath.cos((double)(delta * 6.0));
                for (j2 = 4; j2 < nwh; j2 += 4) {
                    double deltaj = delta * (double)j2;
                    double deltaj3 = 3.0 * deltaj;
                    w2[j2] = FastMath.cos((double)deltaj);
                    w2[j2 + 1] = FastMath.sin((double)deltaj);
                    w2[j2 + 2] = FastMath.cos((double)deltaj3);
                    w2[j2 + 3] = -FastMath.sin((double)deltaj3);
                }
            }
            int nw0 = 0;
            while (nwh > 2) {
                double wk1i;
                double wk1r;
                int nw1 = nw0 + nwh;
                w2[nw1] = 1.0;
                w2[nw1 + 1] = wn4r;
                if ((nwh >>= 1) == 4) {
                    wk1r = w2[nw0 + 4];
                    wk1i = w2[nw0 + 5];
                    w2[nw1 + 2] = wk1r;
                    w2[nw1 + 3] = wk1i;
                } else if (nwh > 4) {
                    wk1r = w2[nw0 + 4];
                    double wk3r = w2[nw0 + 6];
                    w2[nw1 + 2] = 0.5 / wk1r;
                    w2[nw1 + 3] = 0.5 / wk3r;
                    for (j2 = 4; j2 < nwh; j2 += 4) {
                        int idx1 = nw0 + 2 * j2;
                        int idx2 = nw1 + j2;
                        wk1r = w2[idx1];
                        wk1i = w2[idx1 + 1];
                        wk3r = w2[idx1 + 2];
                        double wk3i = w2[idx1 + 3];
                        w2[idx2] = wk1r;
                        w2[idx2 + 1] = wk1i;
                        w2[idx2 + 2] = wk3r;
                        w2[idx2 + 3] = wk3i;
                    }
                }
                nw0 = nw1;
            }
        }
    }

    public static void makewt(long nw, LongLargeArray ipl, DoubleLargeArray wl) {
        ipl.setLong(0L, nw);
        ipl.setLong(1L, 1L);
        if (nw > 2L) {
            long j2;
            long nwh = nw >> 1;
            double delta = 0.7853981633974483 / (double)nwh;
            double delta2 = delta * 2.0;
            double wn4r = FastMath.cos((double)(delta * (double)nwh));
            wl.setDouble(0L, 1.0);
            wl.setDouble(1L, wn4r);
            if (nwh == 4L) {
                wl.setDouble(2L, FastMath.cos((double)delta2));
                wl.setDouble(3L, FastMath.sin((double)delta2));
            } else if (nwh > 4L) {
                CommonUtils.makeipt(nw, ipl);
                wl.setDouble(2L, 0.5 / FastMath.cos((double)delta2));
                wl.setDouble(3L, 0.5 / FastMath.cos((double)(delta * 6.0)));
                for (j2 = 4L; j2 < nwh; j2 += 4L) {
                    double deltaj = delta * (double)j2;
                    double deltaj3 = 3.0 * deltaj;
                    wl.setDouble(j2, FastMath.cos((double)deltaj));
                    wl.setDouble(j2 + 1L, FastMath.sin((double)deltaj));
                    wl.setDouble(j2 + 2L, FastMath.cos((double)deltaj3));
                    wl.setDouble(j2 + 3L, -FastMath.sin((double)deltaj3));
                }
            }
            long nw0 = 0L;
            while (nwh > 2L) {
                double wk1i;
                double wk1r;
                long nw1 = nw0 + nwh;
                wl.setDouble(nw1, 1.0);
                wl.setDouble(nw1 + 1L, wn4r);
                if ((nwh >>= 1) == 4L) {
                    wk1r = wl.getDouble(nw0 + 4L);
                    wk1i = wl.getDouble(nw0 + 5L);
                    wl.setDouble(nw1 + 2L, wk1r);
                    wl.setDouble(nw1 + 3L, wk1i);
                } else if (nwh > 4L) {
                    wk1r = wl.getDouble(nw0 + 4L);
                    double wk3r = wl.getDouble(nw0 + 6L);
                    wl.setDouble(nw1 + 2L, 0.5 / wk1r);
                    wl.setDouble(nw1 + 3L, 0.5 / wk3r);
                    for (j2 = 4L; j2 < nwh; j2 += 4L) {
                        long idx1 = nw0 + 2L * j2;
                        long idx2 = nw1 + j2;
                        wk1r = wl.getDouble(idx1);
                        wk1i = wl.getDouble(idx1 + 1L);
                        wk3r = wl.getDouble(idx1 + 2L);
                        double wk3i = wl.getDouble(idx1 + 3L);
                        wl.setDouble(idx2, wk1r);
                        wl.setDouble(idx2 + 1L, wk1i);
                        wl.setDouble(idx2 + 2L, wk3r);
                        wl.setDouble(idx2 + 3L, wk3i);
                    }
                }
                nw0 = nw1;
            }
        }
    }

    public static void makect(int nc, double[] c2, int startc, int[] ip) {
        ip[1] = nc;
        if (nc > 1) {
            int nch = nc >> 1;
            double delta = 0.7853981633974483 / (double)nch;
            c2[startc] = FastMath.cos((double)(delta * (double)nch));
            c2[startc + nch] = 0.5 * c2[startc];
            for (int j2 = 1; j2 < nch; ++j2) {
                double deltaj = delta * (double)j2;
                c2[startc + j2] = 0.5 * FastMath.cos((double)deltaj);
                c2[startc + nc - j2] = 0.5 * FastMath.sin((double)deltaj);
            }
        }
    }

    public static void makect(long nc, DoubleLargeArray c2, long startc, LongLargeArray ipl) {
        ipl.setLong(1L, nc);
        if (nc > 1L) {
            long nch = nc >> 1;
            double delta = 0.7853981633974483 / (double)nch;
            c2.setDouble(startc, FastMath.cos((double)(delta * (double)nch)));
            c2.setDouble(startc + nch, 0.5 * c2.getDouble(startc));
            for (long j2 = 1L; j2 < nch; ++j2) {
                double deltaj = delta * (double)j2;
                c2.setDouble(startc + j2, 0.5 * FastMath.cos((double)deltaj));
                c2.setDouble(startc + nc - j2, 0.5 * FastMath.sin((double)deltaj));
            }
        }
    }

    public static void makect(int nc, float[] c2, int startc, int[] ip) {
        ip[1] = nc;
        if (nc > 1) {
            int nch = nc >> 1;
            float delta = 0.7853982f / (float)nch;
            c2[startc] = (float)FastMath.cos((double)(delta * (float)nch));
            c2[startc + nch] = 0.5f * c2[startc];
            for (int j2 = 1; j2 < nch; ++j2) {
                float deltaj = delta * (float)j2;
                c2[startc + j2] = 0.5f * (float)FastMath.cos((double)deltaj);
                c2[startc + nc - j2] = 0.5f * (float)FastMath.sin((double)deltaj);
            }
        }
    }

    public static void makect(long nc, FloatLargeArray c2, long startc, LongLargeArray ipl) {
        ipl.setLong(1L, nc);
        if (nc > 1L) {
            long nch = nc >> 1;
            float delta = 0.7853982f / (float)nch;
            c2.setFloat(startc, (float)FastMath.cos((double)(delta * (float)nch)));
            c2.setFloat(startc + nch, 0.5f * c2.getFloat(startc));
            for (long j2 = 1L; j2 < nch; ++j2) {
                float deltaj = delta * (float)j2;
                c2.setFloat(startc + j2, 0.5f * (float)FastMath.cos((double)deltaj));
                c2.setFloat(startc + nc - j2, 0.5f * (float)FastMath.sin((double)deltaj));
            }
        }
    }

    public static void makewt(int nw, int[] ip, float[] w2) {
        ip[0] = nw;
        ip[1] = 1;
        if (nw > 2) {
            int j2;
            int nwh = nw >> 1;
            float delta = 0.7853982f / (float)nwh;
            float delta2 = delta * 2.0f;
            float wn4r = (float)FastMath.cos((double)(delta * (float)nwh));
            w2[0] = 1.0f;
            w2[1] = wn4r;
            if (nwh == 4) {
                w2[2] = (float)FastMath.cos((double)delta2);
                w2[3] = (float)FastMath.sin((double)delta2);
            } else if (nwh > 4) {
                CommonUtils.makeipt(nw, ip);
                w2[2] = 0.5f / (float)FastMath.cos((double)delta2);
                w2[3] = 0.5f / (float)FastMath.cos((double)(delta * 6.0f));
                for (j2 = 4; j2 < nwh; j2 += 4) {
                    float deltaj = delta * (float)j2;
                    float deltaj3 = 3.0f * deltaj;
                    w2[j2] = (float)FastMath.cos((double)deltaj);
                    w2[j2 + 1] = (float)FastMath.sin((double)deltaj);
                    w2[j2 + 2] = (float)FastMath.cos((double)deltaj3);
                    w2[j2 + 3] = -((float)FastMath.sin((double)deltaj3));
                }
            }
            int nw0 = 0;
            while (nwh > 2) {
                float wk1i;
                float wk1r;
                int nw1 = nw0 + nwh;
                w2[nw1] = 1.0f;
                w2[nw1 + 1] = wn4r;
                if ((nwh >>= 1) == 4) {
                    wk1r = w2[nw0 + 4];
                    wk1i = w2[nw0 + 5];
                    w2[nw1 + 2] = wk1r;
                    w2[nw1 + 3] = wk1i;
                } else if (nwh > 4) {
                    wk1r = w2[nw0 + 4];
                    float wk3r = w2[nw0 + 6];
                    w2[nw1 + 2] = 0.5f / wk1r;
                    w2[nw1 + 3] = 0.5f / wk3r;
                    for (j2 = 4; j2 < nwh; j2 += 4) {
                        int idx1 = nw0 + 2 * j2;
                        int idx2 = nw1 + j2;
                        wk1r = w2[idx1];
                        wk1i = w2[idx1 + 1];
                        wk3r = w2[idx1 + 2];
                        float wk3i = w2[idx1 + 3];
                        w2[idx2] = wk1r;
                        w2[idx2 + 1] = wk1i;
                        w2[idx2 + 2] = wk3r;
                        w2[idx2 + 3] = wk3i;
                    }
                }
                nw0 = nw1;
            }
        }
    }

    public static void makewt(long nw, LongLargeArray ipl, FloatLargeArray wl) {
        ipl.setLong(0L, nw);
        ipl.setLong(1L, 1L);
        if (nw > 2L) {
            long j2;
            long nwh = nw >> 1;
            float delta = 0.7853982f / (float)nwh;
            float delta2 = delta * 2.0f;
            float wn4r = (float)FastMath.cos((double)(delta * (float)nwh));
            wl.setFloat(0L, 1.0f);
            wl.setFloat(1L, wn4r);
            if (nwh == 4L) {
                wl.setFloat(2L, (float)FastMath.cos((double)delta2));
                wl.setFloat(3L, (float)FastMath.sin((double)delta2));
            } else if (nwh > 4L) {
                CommonUtils.makeipt(nw, ipl);
                wl.setFloat(2L, 0.5f / (float)FastMath.cos((double)delta2));
                wl.setFloat(3L, 0.5f / (float)FastMath.cos((double)(delta * 6.0f)));
                for (j2 = 4L; j2 < nwh; j2 += 4L) {
                    float deltaj = delta * (float)j2;
                    float deltaj3 = 3.0f * deltaj;
                    wl.setFloat(j2, (float)FastMath.cos((double)deltaj));
                    wl.setFloat(j2 + 1L, (float)FastMath.sin((double)deltaj));
                    wl.setFloat(j2 + 2L, (float)FastMath.cos((double)deltaj3));
                    wl.setFloat(j2 + 3L, -((float)FastMath.sin((double)deltaj3)));
                }
            }
            long nw0 = 0L;
            while (nwh > 2L) {
                float wk1i;
                float wk1r;
                long nw1 = nw0 + nwh;
                wl.setFloat(nw1, 1.0f);
                wl.setFloat(nw1 + 1L, wn4r);
                if ((nwh >>= 1) == 4L) {
                    wk1r = wl.getFloat(nw0 + 4L);
                    wk1i = wl.getFloat(nw0 + 5L);
                    wl.setFloat(nw1 + 2L, wk1r);
                    wl.setFloat(nw1 + 3L, wk1i);
                } else if (nwh > 4L) {
                    wk1r = wl.getFloat(nw0 + 4L);
                    float wk3r = wl.getFloat(nw0 + 6L);
                    wl.setFloat(nw1 + 2L, 0.5f / wk1r);
                    wl.setFloat(nw1 + 3L, 0.5f / wk3r);
                    for (j2 = 4L; j2 < nwh; j2 += 4L) {
                        long idx1 = nw0 + 2L * j2;
                        long idx2 = nw1 + j2;
                        wk1r = wl.getFloat(idx1);
                        wk1i = wl.getFloat(idx1 + 1L);
                        wk3r = wl.getFloat(idx1 + 2L);
                        float wk3i = wl.getFloat(idx1 + 3L);
                        wl.setFloat(idx2, wk1r);
                        wl.setFloat(idx2 + 1L, wk1i);
                        wl.setFloat(idx2 + 2L, wk3r);
                        wl.setFloat(idx2 + 3L, wk3i);
                    }
                }
                nw0 = nw1;
            }
        }
    }

    public static void cftfsub(int n2, double[] a2, int offa, int[] ip, int nw, double[] w2) {
        if (n2 > 8) {
            if (n2 > 32) {
                CommonUtils.cftf1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && (long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128) {
                    CommonUtils.cftleaf(n2, 1, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2(n2, ip, a2, offa);
            } else if (n2 == 32) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8);
                CommonUtils.bitrv216(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0);
                CommonUtils.bitrv208(a2, offa);
            }
        } else if (n2 == 8) {
            CommonUtils.cftf040(a2, offa);
        } else if (n2 == 4) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftfsub(long n2, DoubleLargeArray a2, long offa, LongLargeArray ip, long nw, DoubleLargeArray w2) {
        if (n2 > 8L) {
            if (n2 > 32L) {
                CommonUtils.cftf1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512L) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128L) {
                    CommonUtils.cftleaf(n2, 1L, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2l(n2, ip, a2, offa);
            } else if (n2 == 32L) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8L);
                CommonUtils.bitrv216(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0L);
                CommonUtils.bitrv208(a2, offa);
            }
        } else if (n2 == 8L) {
            CommonUtils.cftf040(a2, offa);
        } else if (n2 == 4L) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftbsub(int n2, double[] a2, int offa, int[] ip, int nw, double[] w2) {
        if (n2 > 8) {
            if (n2 > 32) {
                CommonUtils.cftb1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && (long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128) {
                    CommonUtils.cftleaf(n2, 1, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2conj(n2, ip, a2, offa);
            } else if (n2 == 32) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8);
                CommonUtils.bitrv216neg(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0);
                CommonUtils.bitrv208neg(a2, offa);
            }
        } else if (n2 == 8) {
            CommonUtils.cftb040(a2, offa);
        } else if (n2 == 4) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftbsub(long n2, DoubleLargeArray a2, long offa, LongLargeArray ip, long nw, DoubleLargeArray w2) {
        if (n2 > 8L) {
            if (n2 > 32L) {
                CommonUtils.cftb1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512L) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128L) {
                    CommonUtils.cftleaf(n2, 1L, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2conj(n2, ip, a2, offa);
            } else if (n2 == 32L) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8L);
                CommonUtils.bitrv216neg(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0L);
                CommonUtils.bitrv208neg(a2, offa);
            }
        } else if (n2 == 8L) {
            CommonUtils.cftb040(a2, offa);
        } else if (n2 == 4L) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void bitrv2(int n2, int[] ip, double[] a2, int offa) {
        int l2;
        int m4 = 1;
        for (l2 = n2 >> 2; l2 > 8; l2 >>= 2) {
            m4 <<= 1;
        }
        int nh = n2 >> 1;
        int nm = 4 * m4;
        if (l2 == 8) {
            for (int k2 = 0; k2 < m4; ++k2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k2;
                for (int j2 = 0; j2 < k2; ++j2) {
                    j1 = 4 * j2 + 2 * ip[m4 + k2];
                    k1 = idx0 + 2 * ip[m4 + j2];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + 2 * ip[m4 + k2];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
            }
        } else {
            for (int k3 = 0; k3 < m4; ++k3) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = 4 * j3 + ip[m4 + k3];
                    k1 = idx0 + ip[m4 + j3];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + ip[m4 + k3];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
            }
        }
    }

    public static void bitrv2l(long n2, LongLargeArray ip, DoubleLargeArray a2, long offa) {
        long l2;
        long m4 = 1L;
        for (l2 = n2 >> 2; l2 > 8L; l2 >>= 2) {
            m4 <<= 1;
        }
        long nh = n2 >> 1;
        long nm = 4L * m4;
        if (l2 == 8L) {
            for (long k2 = 0L; k2 < m4; ++k2) {
                double yi;
                double yr;
                double xi;
                double xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k2;
                for (long j2 = 0L; j2 < k2; ++j2) {
                    j1 = 4L * j2 + 2L * ip.getLong(m4 + k2);
                    k1 = idx0 + 2L * ip.getLong(m4 + j2);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                }
                k1 = idx0 + 2L * ip.getLong(m4 + k2);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2L * nm);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 -= 2L);
                idx2 = offa + (k1 -= nh);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nh + 2L);
                idx2 = offa + (k1 += nh + 2L);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2L * nm - 2L);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
            }
        } else {
            for (long k3 = 0L; k3 < m4; ++k3) {
                double yi;
                double yr;
                double xi;
                double xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k3;
                for (long j3 = 0L; j3 < k3; ++j3) {
                    j1 = 4L * j3 + ip.getLong(m4 + k3);
                    k1 = idx0 + ip.getLong(m4 + j3);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                }
                k1 = idx0 + ip.getLong(m4 + k3);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a2.getDouble(idx1);
                xi = a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
            }
        }
    }

    public static void bitrv2conj(int n2, int[] ip, double[] a2, int offa) {
        int l2;
        int m4 = 1;
        for (l2 = n2 >> 2; l2 > 8; l2 >>= 2) {
            m4 <<= 1;
        }
        int nh = n2 >> 1;
        int nm = 4 * m4;
        if (l2 == 8) {
            for (int k2 = 0; k2 < m4; ++k2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k2;
                for (int j2 = 0; j2 < k2; ++j2) {
                    j1 = 4 * j2 + 2 * ip[m4 + k2];
                    k1 = idx0 + 2 * ip[m4 + j2];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + 2 * ip[m4 + k2];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
            }
        } else {
            for (int k3 = 0; k3 < m4; ++k3) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = 4 * j3 + ip[m4 + k3];
                    k1 = idx0 + ip[m4 + j3];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + ip[m4 + k3];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
            }
        }
    }

    public static void bitrv2conj(long n2, LongLargeArray ip, DoubleLargeArray a2, long offa) {
        long l2;
        long m4 = 1L;
        for (l2 = n2 >> 2; l2 > 8L; l2 >>= 2) {
            m4 <<= 1;
        }
        long nh = n2 >> 1;
        long nm = 4L * m4;
        if (l2 == 8L) {
            for (long k2 = 0L; k2 < m4; ++k2) {
                double yi;
                double yr;
                double xi;
                double xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k2;
                for (long j2 = 0L; j2 < k2; ++j2) {
                    j1 = 4L * j2 + 2L * ip.getLong(m4 + k2);
                    k1 = idx0 + 2L * ip.getLong(m4 + j2);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                }
                k1 = idx0 + 2L * ip.getLong(m4 + k2);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2.setDouble(idx1 - 1L, -a2.getDouble(idx1 - 1L));
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                a2.setDouble(idx2 + 3L, -a2.getDouble(idx2 + 3L));
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2L * nm);
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 -= 2L);
                idx2 = offa + (k1 -= nh);
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 += nh + 2L);
                idx2 = offa + (k1 += nh + 2L);
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2L * nm - 2L);
                a2.setDouble(idx1 - 1L, -a2.getDouble(idx1 - 1L));
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                a2.setDouble(idx2 + 3L, -a2.getDouble(idx2 + 3L));
            }
        } else {
            int k3 = 0;
            while ((long)k3 < m4) {
                double yi;
                double yr;
                double xi;
                double xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = (long)(4 * j3) + ip.getLong(m4 + (long)k3);
                    k1 = idx0 + ip.getLong(m4 + (long)j3);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getDouble(idx1);
                    xi = -a2.getDouble(idx1 + 1L);
                    yr = a2.getDouble(idx2);
                    yi = -a2.getDouble(idx2 + 1L);
                    a2.setDouble(idx1, yr);
                    a2.setDouble(idx1 + 1L, yi);
                    a2.setDouble(idx2, xr);
                    a2.setDouble(idx2 + 1L, xi);
                }
                k1 = idx0 + ip.getLong(m4 + (long)k3);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2.setDouble(idx1 - 1L, -a2.getDouble(idx1 - 1L));
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                a2.setDouble(idx2 + 3L, -a2.getDouble(idx2 + 3L));
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a2.setDouble(idx1 - 1L, -a2.getDouble(idx1 - 1L));
                xr = a2.getDouble(idx1);
                xi = -a2.getDouble(idx1 + 1L);
                yr = a2.getDouble(idx2);
                yi = -a2.getDouble(idx2 + 1L);
                a2.setDouble(idx1, yr);
                a2.setDouble(idx1 + 1L, yi);
                a2.setDouble(idx2, xr);
                a2.setDouble(idx2 + 1L, xi);
                a2.setDouble(idx2 + 3L, -a2.getDouble(idx2 + 3L));
                ++k3;
            }
        }
    }

    public static void bitrv216(double[] a2, int offa) {
        double x1r = a2[offa + 2];
        double x1i = a2[offa + 3];
        double x2r = a2[offa + 4];
        double x2i = a2[offa + 5];
        double x3r = a2[offa + 6];
        double x3i = a2[offa + 7];
        double x4r = a2[offa + 8];
        double x4i = a2[offa + 9];
        double x5r = a2[offa + 10];
        double x5i = a2[offa + 11];
        double x7r = a2[offa + 14];
        double x7i = a2[offa + 15];
        double x8r = a2[offa + 16];
        double x8i = a2[offa + 17];
        double x10r = a2[offa + 20];
        double x10i = a2[offa + 21];
        double x11r = a2[offa + 22];
        double x11i = a2[offa + 23];
        double x12r = a2[offa + 24];
        double x12i = a2[offa + 25];
        double x13r = a2[offa + 26];
        double x13i = a2[offa + 27];
        double x14r = a2[offa + 28];
        double x14i = a2[offa + 29];
        a2[offa + 2] = x8r;
        a2[offa + 3] = x8i;
        a2[offa + 4] = x4r;
        a2[offa + 5] = x4i;
        a2[offa + 6] = x12r;
        a2[offa + 7] = x12i;
        a2[offa + 8] = x2r;
        a2[offa + 9] = x2i;
        a2[offa + 10] = x10r;
        a2[offa + 11] = x10i;
        a2[offa + 14] = x14r;
        a2[offa + 15] = x14i;
        a2[offa + 16] = x1r;
        a2[offa + 17] = x1i;
        a2[offa + 20] = x5r;
        a2[offa + 21] = x5i;
        a2[offa + 22] = x13r;
        a2[offa + 23] = x13i;
        a2[offa + 24] = x3r;
        a2[offa + 25] = x3i;
        a2[offa + 26] = x11r;
        a2[offa + 27] = x11i;
        a2[offa + 28] = x7r;
        a2[offa + 29] = x7i;
    }

    public static void bitrv216(DoubleLargeArray a2, long offa) {
        double x1r = a2.getDouble(offa + 2L);
        double x1i = a2.getDouble(offa + 3L);
        double x2r = a2.getDouble(offa + 4L);
        double x2i = a2.getDouble(offa + 5L);
        double x3r = a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 7L);
        double x4r = a2.getDouble(offa + 8L);
        double x4i = a2.getDouble(offa + 9L);
        double x5r = a2.getDouble(offa + 10L);
        double x5i = a2.getDouble(offa + 11L);
        double x7r = a2.getDouble(offa + 14L);
        double x7i = a2.getDouble(offa + 15L);
        double x8r = a2.getDouble(offa + 16L);
        double x8i = a2.getDouble(offa + 17L);
        double x10r = a2.getDouble(offa + 20L);
        double x10i = a2.getDouble(offa + 21L);
        double x11r = a2.getDouble(offa + 22L);
        double x11i = a2.getDouble(offa + 23L);
        double x12r = a2.getDouble(offa + 24L);
        double x12i = a2.getDouble(offa + 25L);
        double x13r = a2.getDouble(offa + 26L);
        double x13i = a2.getDouble(offa + 27L);
        double x14r = a2.getDouble(offa + 28L);
        double x14i = a2.getDouble(offa + 29L);
        a2.setDouble(offa + 2L, x8r);
        a2.setDouble(offa + 3L, x8i);
        a2.setDouble(offa + 4L, x4r);
        a2.setDouble(offa + 5L, x4i);
        a2.setDouble(offa + 6L, x12r);
        a2.setDouble(offa + 7L, x12i);
        a2.setDouble(offa + 8L, x2r);
        a2.setDouble(offa + 9L, x2i);
        a2.setDouble(offa + 10L, x10r);
        a2.setDouble(offa + 11L, x10i);
        a2.setDouble(offa + 14L, x14r);
        a2.setDouble(offa + 15L, x14i);
        a2.setDouble(offa + 16L, x1r);
        a2.setDouble(offa + 17L, x1i);
        a2.setDouble(offa + 20L, x5r);
        a2.setDouble(offa + 21L, x5i);
        a2.setDouble(offa + 22L, x13r);
        a2.setDouble(offa + 23L, x13i);
        a2.setDouble(offa + 24L, x3r);
        a2.setDouble(offa + 25L, x3i);
        a2.setDouble(offa + 26L, x11r);
        a2.setDouble(offa + 27L, x11i);
        a2.setDouble(offa + 28L, x7r);
        a2.setDouble(offa + 29L, x7i);
    }

    public static void bitrv216neg(double[] a2, int offa) {
        double x1r = a2[offa + 2];
        double x1i = a2[offa + 3];
        double x2r = a2[offa + 4];
        double x2i = a2[offa + 5];
        double x3r = a2[offa + 6];
        double x3i = a2[offa + 7];
        double x4r = a2[offa + 8];
        double x4i = a2[offa + 9];
        double x5r = a2[offa + 10];
        double x5i = a2[offa + 11];
        double x6r = a2[offa + 12];
        double x6i = a2[offa + 13];
        double x7r = a2[offa + 14];
        double x7i = a2[offa + 15];
        double x8r = a2[offa + 16];
        double x8i = a2[offa + 17];
        double x9r = a2[offa + 18];
        double x9i = a2[offa + 19];
        double x10r = a2[offa + 20];
        double x10i = a2[offa + 21];
        double x11r = a2[offa + 22];
        double x11i = a2[offa + 23];
        double x12r = a2[offa + 24];
        double x12i = a2[offa + 25];
        double x13r = a2[offa + 26];
        double x13i = a2[offa + 27];
        double x14r = a2[offa + 28];
        double x14i = a2[offa + 29];
        double x15r = a2[offa + 30];
        double x15i = a2[offa + 31];
        a2[offa + 2] = x15r;
        a2[offa + 3] = x15i;
        a2[offa + 4] = x7r;
        a2[offa + 5] = x7i;
        a2[offa + 6] = x11r;
        a2[offa + 7] = x11i;
        a2[offa + 8] = x3r;
        a2[offa + 9] = x3i;
        a2[offa + 10] = x13r;
        a2[offa + 11] = x13i;
        a2[offa + 12] = x5r;
        a2[offa + 13] = x5i;
        a2[offa + 14] = x9r;
        a2[offa + 15] = x9i;
        a2[offa + 16] = x1r;
        a2[offa + 17] = x1i;
        a2[offa + 18] = x14r;
        a2[offa + 19] = x14i;
        a2[offa + 20] = x6r;
        a2[offa + 21] = x6i;
        a2[offa + 22] = x10r;
        a2[offa + 23] = x10i;
        a2[offa + 24] = x2r;
        a2[offa + 25] = x2i;
        a2[offa + 26] = x12r;
        a2[offa + 27] = x12i;
        a2[offa + 28] = x4r;
        a2[offa + 29] = x4i;
        a2[offa + 30] = x8r;
        a2[offa + 31] = x8i;
    }

    public static void bitrv216neg(DoubleLargeArray a2, long offa) {
        double x1r = a2.getDouble(offa + 2L);
        double x1i = a2.getDouble(offa + 3L);
        double x2r = a2.getDouble(offa + 4L);
        double x2i = a2.getDouble(offa + 5L);
        double x3r = a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 7L);
        double x4r = a2.getDouble(offa + 8L);
        double x4i = a2.getDouble(offa + 9L);
        double x5r = a2.getDouble(offa + 10L);
        double x5i = a2.getDouble(offa + 11L);
        double x6r = a2.getDouble(offa + 12L);
        double x6i = a2.getDouble(offa + 13L);
        double x7r = a2.getDouble(offa + 14L);
        double x7i = a2.getDouble(offa + 15L);
        double x8r = a2.getDouble(offa + 16L);
        double x8i = a2.getDouble(offa + 17L);
        double x9r = a2.getDouble(offa + 18L);
        double x9i = a2.getDouble(offa + 19L);
        double x10r = a2.getDouble(offa + 20L);
        double x10i = a2.getDouble(offa + 21L);
        double x11r = a2.getDouble(offa + 22L);
        double x11i = a2.getDouble(offa + 23L);
        double x12r = a2.getDouble(offa + 24L);
        double x12i = a2.getDouble(offa + 25L);
        double x13r = a2.getDouble(offa + 26L);
        double x13i = a2.getDouble(offa + 27L);
        double x14r = a2.getDouble(offa + 28L);
        double x14i = a2.getDouble(offa + 29L);
        double x15r = a2.getDouble(offa + 30L);
        double x15i = a2.getDouble(offa + 31L);
        a2.setDouble(offa + 2L, x15r);
        a2.setDouble(offa + 3L, x15i);
        a2.setDouble(offa + 4L, x7r);
        a2.setDouble(offa + 5L, x7i);
        a2.setDouble(offa + 6L, x11r);
        a2.setDouble(offa + 7L, x11i);
        a2.setDouble(offa + 8L, x3r);
        a2.setDouble(offa + 9L, x3i);
        a2.setDouble(offa + 10L, x13r);
        a2.setDouble(offa + 11L, x13i);
        a2.setDouble(offa + 12L, x5r);
        a2.setDouble(offa + 13L, x5i);
        a2.setDouble(offa + 14L, x9r);
        a2.setDouble(offa + 15L, x9i);
        a2.setDouble(offa + 16L, x1r);
        a2.setDouble(offa + 17L, x1i);
        a2.setDouble(offa + 18L, x14r);
        a2.setDouble(offa + 19L, x14i);
        a2.setDouble(offa + 20L, x6r);
        a2.setDouble(offa + 21L, x6i);
        a2.setDouble(offa + 22L, x10r);
        a2.setDouble(offa + 23L, x10i);
        a2.setDouble(offa + 24L, x2r);
        a2.setDouble(offa + 25L, x2i);
        a2.setDouble(offa + 26L, x12r);
        a2.setDouble(offa + 27L, x12i);
        a2.setDouble(offa + 28L, x4r);
        a2.setDouble(offa + 29L, x4i);
        a2.setDouble(offa + 30L, x8r);
        a2.setDouble(offa + 31L, x8i);
    }

    public static void bitrv208(double[] a2, int offa) {
        double x1r = a2[offa + 2];
        double x1i = a2[offa + 3];
        double x3r = a2[offa + 6];
        double x3i = a2[offa + 7];
        double x4r = a2[offa + 8];
        double x4i = a2[offa + 9];
        double x6r = a2[offa + 12];
        double x6i = a2[offa + 13];
        a2[offa + 2] = x4r;
        a2[offa + 3] = x4i;
        a2[offa + 6] = x6r;
        a2[offa + 7] = x6i;
        a2[offa + 8] = x1r;
        a2[offa + 9] = x1i;
        a2[offa + 12] = x3r;
        a2[offa + 13] = x3i;
    }

    public static void bitrv208(DoubleLargeArray a2, long offa) {
        double x1r = a2.getDouble(offa + 2L);
        double x1i = a2.getDouble(offa + 3L);
        double x3r = a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 7L);
        double x4r = a2.getDouble(offa + 8L);
        double x4i = a2.getDouble(offa + 9L);
        double x6r = a2.getDouble(offa + 12L);
        double x6i = a2.getDouble(offa + 13L);
        a2.setDouble(offa + 2L, x4r);
        a2.setDouble(offa + 3L, x4i);
        a2.setDouble(offa + 6L, x6r);
        a2.setDouble(offa + 7L, x6i);
        a2.setDouble(offa + 8L, x1r);
        a2.setDouble(offa + 9L, x1i);
        a2.setDouble(offa + 12L, x3r);
        a2.setDouble(offa + 13L, x3i);
    }

    public static void bitrv208neg(double[] a2, int offa) {
        double x1r = a2[offa + 2];
        double x1i = a2[offa + 3];
        double x2r = a2[offa + 4];
        double x2i = a2[offa + 5];
        double x3r = a2[offa + 6];
        double x3i = a2[offa + 7];
        double x4r = a2[offa + 8];
        double x4i = a2[offa + 9];
        double x5r = a2[offa + 10];
        double x5i = a2[offa + 11];
        double x6r = a2[offa + 12];
        double x6i = a2[offa + 13];
        double x7r = a2[offa + 14];
        double x7i = a2[offa + 15];
        a2[offa + 2] = x7r;
        a2[offa + 3] = x7i;
        a2[offa + 4] = x3r;
        a2[offa + 5] = x3i;
        a2[offa + 6] = x5r;
        a2[offa + 7] = x5i;
        a2[offa + 8] = x1r;
        a2[offa + 9] = x1i;
        a2[offa + 10] = x6r;
        a2[offa + 11] = x6i;
        a2[offa + 12] = x2r;
        a2[offa + 13] = x2i;
        a2[offa + 14] = x4r;
        a2[offa + 15] = x4i;
    }

    public static void bitrv208neg(DoubleLargeArray a2, long offa) {
        double x1r = a2.getDouble(offa + 2L);
        double x1i = a2.getDouble(offa + 3L);
        double x2r = a2.getDouble(offa + 4L);
        double x2i = a2.getDouble(offa + 5L);
        double x3r = a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 7L);
        double x4r = a2.getDouble(offa + 8L);
        double x4i = a2.getDouble(offa + 9L);
        double x5r = a2.getDouble(offa + 10L);
        double x5i = a2.getDouble(offa + 11L);
        double x6r = a2.getDouble(offa + 12L);
        double x6i = a2.getDouble(offa + 13L);
        double x7r = a2.getDouble(offa + 14L);
        double x7i = a2.getDouble(offa + 15L);
        a2.setDouble(offa + 2L, x7r);
        a2.setDouble(offa + 3L, x7i);
        a2.setDouble(offa + 4L, x3r);
        a2.setDouble(offa + 5L, x3i);
        a2.setDouble(offa + 6L, x5r);
        a2.setDouble(offa + 7L, x5i);
        a2.setDouble(offa + 8L, x1r);
        a2.setDouble(offa + 9L, x1i);
        a2.setDouble(offa + 10L, x6r);
        a2.setDouble(offa + 11L, x6i);
        a2.setDouble(offa + 12L, x2r);
        a2.setDouble(offa + 13L, x2i);
        a2.setDouble(offa + 14L, x4r);
        a2.setDouble(offa + 15L, x4i);
    }

    public static void cftf1st(int n2, double[] a2, int offa, double[] w2, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a2[offa] + a2[idx2];
        double x0i = a2[offa + 1] + a2[idx2 + 1];
        double x1r = a2[offa] - a2[idx2];
        double x1i = a2[offa + 1] - a2[idx2 + 1];
        double x2r = a2[idx1] + a2[idx3];
        double x2i = a2[idx1 + 1] + a2[idx3 + 1];
        double x3r = a2[idx1] - a2[idx3];
        double x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        a2[idx2] = x1r - x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r + x3i;
        a2[idx3 + 1] = x1i - x3r;
        double wn4r = w2[startw + 1];
        double csc1 = w2[startw + 2];
        double csc3 = w2[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k2 = 0;
        for (int j4 = 2; j4 < mh - 2; j4 += 4) {
            int idx4 = startw + (k2 += 4);
            wk1r = csc1 * (wd1r + w2[idx4]);
            wk1i = csc1 * (wd1i + w2[idx4 + 1]);
            wk3r = csc3 * (wd3r + w2[idx4 + 2]);
            wk3i = csc3 * (wd3i + w2[idx4 + 3]);
            wd1r = w2[idx4];
            wd1i = w2[idx4 + 1];
            wd3r = w2[idx4 + 2];
            wd3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = a2[idx5 + 1] + a2[idx2 + 1];
            x1r = a2[idx5] - a2[idx2];
            x1i = a2[idx5 + 1] - a2[idx2 + 1];
            double y0r = a2[idx5 + 2] + a2[idx2 + 2];
            double y0i = a2[idx5 + 3] + a2[idx2 + 3];
            double y1r = a2[idx5 + 2] - a2[idx2 + 2];
            double y1i = a2[idx5 + 3] - a2[idx2 + 3];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            double y2r = a2[idx1 + 2] + a2[idx3 + 2];
            double y2i = a2[idx1 + 3] + a2[idx3 + 3];
            double y3r = a2[idx1 + 2] - a2[idx3 + 2];
            double y3i = a2[idx1 + 3] - a2[idx3 + 3];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i + x2i;
            a2[idx5 + 2] = y0r + y2r;
            a2[idx5 + 3] = y0i + y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            a2[idx1 + 2] = y0r - y2r;
            a2[idx1 + 3] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a2[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a2[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = a2[idx0 + 1] + a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = a2[idx0 + 1] - a2[idx2 + 1];
            y0r = a2[idx0 - 2] + a2[idx2 - 2];
            y0i = a2[idx0 - 1] + a2[idx2 - 1];
            y1r = a2[idx0 - 2] - a2[idx2 - 2];
            y1i = a2[idx0 - 1] - a2[idx2 - 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            y2r = a2[idx1 - 2] + a2[idx3 - 2];
            y2i = a2[idx1 - 1] + a2[idx3 - 1];
            y3r = a2[idx1 - 2] - a2[idx3 - 2];
            y3i = a2[idx1 - 1] - a2[idx3 - 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i + x2i;
            a2[idx0 - 2] = y0r + y2r;
            a2[idx0 - 1] = y0i + y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            a2[idx1 - 2] = y0r - y2r;
            a2[idx1 - 1] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a2[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2[offa + j3 - 2] = wd3i * x0r + wd3r * x0i;
            a2[offa + j3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0 - 2] + a2[idx2 - 2];
        x0i = a2[idx0 - 1] + a2[idx2 - 1];
        x1r = a2[idx0 - 2] - a2[idx2 - 2];
        x1i = a2[idx0 - 1] - a2[idx2 - 1];
        x2r = a2[idx1 - 2] + a2[idx3 - 2];
        x2i = a2[idx1 - 1] + a2[idx3 - 1];
        x3r = a2[idx1 - 2] - a2[idx3 - 2];
        x3i = a2[idx1 - 1] - a2[idx3 - 1];
        a2[idx0 - 2] = x0r + x2r;
        a2[idx0 - 1] = x0i + x2i;
        a2[idx1 - 2] = x0r - x2r;
        a2[idx1 - 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a2[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a2[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a2[idx0] + a2[idx2];
        x0i = a2[idx0 + 1] + a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = a2[idx0 + 1] - a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a2[idx0 + 2] + a2[idx2 + 2];
        x0i = a2[idx0 + 3] + a2[idx2 + 3];
        x1r = a2[idx0 + 2] - a2[idx2 + 2];
        x1i = a2[idx0 + 3] - a2[idx2 + 3];
        x2r = a2[idx1 + 2] + a2[idx3 + 2];
        x2i = a2[idx1 + 3] + a2[idx3 + 3];
        x3r = a2[idx1 + 2] - a2[idx3 + 2];
        x3i = a2[idx1 + 3] - a2[idx3 + 3];
        a2[idx0 + 2] = x0r + x2r;
        a2[idx0 + 3] = x0i + x2i;
        a2[idx1 + 2] = x0r - x2r;
        a2[idx1 + 3] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a2[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a2[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    public static void cftf1st(long n2, DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        long idx0;
        long j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        double x0r = a2.getDouble(offa) + a2.getDouble(idx2);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(idx2 + 1L);
        double x1r = a2.getDouble(offa) - a2.getDouble(idx2);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(idx2 + 1L);
        double x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        double x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        double x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        double x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i + x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i - x2i);
        a2.setDouble(idx2, x1r - x3i);
        a2.setDouble(idx2 + 1L, x1i + x3r);
        a2.setDouble(idx3, x1r + x3i);
        a2.setDouble(idx3 + 1L, x1i - x3r);
        double wn4r = w2.getDouble(startw + 1L);
        double csc1 = w2.getDouble(startw + 2L);
        double csc3 = w2.getDouble(startw + 3L);
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        long k2 = 0L;
        int j4 = 2;
        while ((long)j4 < mh - 2L) {
            long idx4 = startw + (k2 += 4L);
            wk1r = csc1 * (wd1r + w2.getDouble(idx4));
            wk1i = csc1 * (wd1i + w2.getDouble(idx4 + 1L));
            wk3r = csc3 * (wd3r + w2.getDouble(idx4 + 2L));
            wk3i = csc3 * (wd3i + w2.getDouble(idx4 + 3L));
            wd1r = w2.getDouble(idx4);
            wd1i = w2.getDouble(idx4 + 1L);
            wd3r = w2.getDouble(idx4 + 2L);
            wd3i = w2.getDouble(idx4 + 3L);
            j1 = (long)j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + (long)j4;
            x0r = a2.getDouble(idx5) + a2.getDouble(idx2);
            x0i = a2.getDouble(idx5 + 1L) + a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx5) - a2.getDouble(idx2);
            x1i = a2.getDouble(idx5 + 1L) - a2.getDouble(idx2 + 1L);
            double y0r = a2.getDouble(idx5 + 2L) + a2.getDouble(idx2 + 2L);
            double y0i = a2.getDouble(idx5 + 3L) + a2.getDouble(idx2 + 3L);
            double y1r = a2.getDouble(idx5 + 2L) - a2.getDouble(idx2 + 2L);
            double y1i = a2.getDouble(idx5 + 3L) - a2.getDouble(idx2 + 3L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            double y2r = a2.getDouble(idx1 + 2L) + a2.getDouble(idx3 + 2L);
            double y2i = a2.getDouble(idx1 + 3L) + a2.getDouble(idx3 + 3L);
            double y3r = a2.getDouble(idx1 + 2L) - a2.getDouble(idx3 + 2L);
            double y3i = a2.getDouble(idx1 + 3L) - a2.getDouble(idx3 + 3L);
            a2.setDouble(idx5, x0r + x2r);
            a2.setDouble(idx5 + 1L, x0i + x2i);
            a2.setDouble(idx5 + 2L, y0r + y2r);
            a2.setDouble(idx5 + 3L, y0i + y2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i - x2i);
            a2.setDouble(idx1 + 2L, y0r - y2r);
            a2.setDouble(idx1 + 3L, y0i - y2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1r * x0r - wk1i * x0i);
            a2.setDouble(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2.setDouble(idx2 + 2L, wd1r * x0r - wd1i * x0i);
            a2.setDouble(idx2 + 3L, wd1r * x0i + wd1i * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3r * x0r + wk3i * x0i);
            a2.setDouble(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2.setDouble(idx3 + 2L, wd3r * x0r + wd3i * x0i);
            a2.setDouble(idx3 + 3L, wd3r * x0i - wd3i * x0r);
            j0 = m4 - (long)j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
            x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
            x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
            y0r = a2.getDouble(idx0 - 2L) + a2.getDouble(idx2 - 2L);
            y0i = a2.getDouble(idx0 - 1L) + a2.getDouble(idx2 - 1L);
            y1r = a2.getDouble(idx0 - 2L) - a2.getDouble(idx2 - 2L);
            y1i = a2.getDouble(idx0 - 1L) - a2.getDouble(idx2 - 1L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            y2r = a2.getDouble(idx1 - 2L) + a2.getDouble(idx3 - 2L);
            y2i = a2.getDouble(idx1 - 1L) + a2.getDouble(idx3 - 1L);
            y3r = a2.getDouble(idx1 - 2L) - a2.getDouble(idx3 - 2L);
            y3i = a2.getDouble(idx1 - 1L) - a2.getDouble(idx3 - 1L);
            a2.setDouble(idx0, x0r + x2r);
            a2.setDouble(idx0 + 1L, x0i + x2i);
            a2.setDouble(idx0 - 2L, y0r + y2r);
            a2.setDouble(idx0 - 1L, y0i + y2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i - x2i);
            a2.setDouble(idx1 - 2L, y0r - y2r);
            a2.setDouble(idx1 - 1L, y0i - y2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1i * x0r - wk1r * x0i);
            a2.setDouble(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2.setDouble(idx2 - 2L, wd1i * x0r - wd1r * x0i);
            a2.setDouble(idx2 - 1L, wd1i * x0i + wd1r * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3i * x0r + wk3r * x0i);
            a2.setDouble(idx3 + 1L, wk3i * x0i - wk3r * x0r);
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2.setDouble(offa + j3 - 2L, wd3i * x0r + wd3r * x0i);
            a2.setDouble(offa + j3 - 1L, wd3i * x0i - wd3r * x0r);
            j4 += 4;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getDouble(idx0 - 2L) + a2.getDouble(idx2 - 2L);
        x0i = a2.getDouble(idx0 - 1L) + a2.getDouble(idx2 - 1L);
        x1r = a2.getDouble(idx0 - 2L) - a2.getDouble(idx2 - 2L);
        x1i = a2.getDouble(idx0 - 1L) - a2.getDouble(idx2 - 1L);
        x2r = a2.getDouble(idx1 - 2L) + a2.getDouble(idx3 - 2L);
        x2i = a2.getDouble(idx1 - 1L) + a2.getDouble(idx3 - 1L);
        x3r = a2.getDouble(idx1 - 2L) - a2.getDouble(idx3 - 2L);
        x3i = a2.getDouble(idx1 - 1L) - a2.getDouble(idx3 - 1L);
        a2.setDouble(idx0 - 2L, x0r + x2r);
        a2.setDouble(idx0 - 1L, x0i + x2i);
        a2.setDouble(idx1 - 2L, x0r - x2r);
        a2.setDouble(idx1 - 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2 - 2L, wk1r * x0r - wk1i * x0i);
        a2.setDouble(idx2 - 1L, wk1r * x0i + wk1i * x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3 - 2L, wk3r * x0r + wk3i * x0i);
        a2.setDouble(idx3 - 1L, wk3r * x0i - wk3i * x0r);
        x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
        x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
        x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
        x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
        x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(idx0, x0r + x2r);
        a2.setDouble(idx0 + 1L, x0i + x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2, wn4r * (x0r - x0i));
        a2.setDouble(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3, -wn4r * (x0r + x0i));
        a2.setDouble(idx3 + 1L, -wn4r * (x0i - x0r));
        x0r = a2.getDouble(idx0 + 2L) + a2.getDouble(idx2 + 2L);
        x0i = a2.getDouble(idx0 + 3L) + a2.getDouble(idx2 + 3L);
        x1r = a2.getDouble(idx0 + 2L) - a2.getDouble(idx2 + 2L);
        x1i = a2.getDouble(idx0 + 3L) - a2.getDouble(idx2 + 3L);
        x2r = a2.getDouble(idx1 + 2L) + a2.getDouble(idx3 + 2L);
        x2i = a2.getDouble(idx1 + 3L) + a2.getDouble(idx3 + 3L);
        x3r = a2.getDouble(idx1 + 2L) - a2.getDouble(idx3 + 2L);
        x3i = a2.getDouble(idx1 + 3L) - a2.getDouble(idx3 + 3L);
        a2.setDouble(idx0 + 2L, x0r + x2r);
        a2.setDouble(idx0 + 3L, x0i + x2i);
        a2.setDouble(idx1 + 2L, x0r - x2r);
        a2.setDouble(idx1 + 3L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2 + 2L, wk1i * x0r - wk1r * x0i);
        a2.setDouble(idx2 + 3L, wk1i * x0i + wk1r * x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3 + 2L, wk3i * x0r + wk3r * x0i);
        a2.setDouble(idx3 + 3L, wk3i * x0i - wk3r * x0r);
    }

    public static void cftb1st(int n2, double[] a2, int offa, double[] w2, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a2[offa] + a2[idx2];
        double x0i = -a2[offa + 1] - a2[idx2 + 1];
        double x1r = a2[offa] - a2[idx2];
        double x1i = -a2[offa + 1] + a2[idx2 + 1];
        double x2r = a2[idx1] + a2[idx3];
        double x2i = a2[idx1 + 1] + a2[idx3 + 1];
        double x3r = a2[idx1] - a2[idx3];
        double x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i - x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i + x2i;
        a2[idx2] = x1r + x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r - x3i;
        a2[idx3 + 1] = x1i - x3r;
        double wn4r = w2[startw + 1];
        double csc1 = w2[startw + 2];
        double csc3 = w2[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k2 = 0;
        for (int j4 = 2; j4 < mh - 2; j4 += 4) {
            int idx4 = startw + (k2 += 4);
            wk1r = csc1 * (wd1r + w2[idx4]);
            wk1i = csc1 * (wd1i + w2[idx4 + 1]);
            wk3r = csc3 * (wd3r + w2[idx4 + 2]);
            wk3i = csc3 * (wd3i + w2[idx4 + 3]);
            wd1r = w2[idx4];
            wd1i = w2[idx4 + 1];
            wd3r = w2[idx4 + 2];
            wd3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = -a2[idx5 + 1] - a2[idx2 + 1];
            x1r = a2[idx5] - a2[offa + j2];
            x1i = -a2[idx5 + 1] + a2[idx2 + 1];
            double y0r = a2[idx5 + 2] + a2[idx2 + 2];
            double y0i = -a2[idx5 + 3] - a2[idx2 + 3];
            double y1r = a2[idx5 + 2] - a2[idx2 + 2];
            double y1i = -a2[idx5 + 3] + a2[idx2 + 3];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            double y2r = a2[idx1 + 2] + a2[idx3 + 2];
            double y2i = a2[idx1 + 3] + a2[idx3 + 3];
            double y3r = a2[idx1 + 2] - a2[idx3 + 2];
            double y3i = a2[idx1 + 3] - a2[idx3 + 3];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i - x2i;
            a2[idx5 + 2] = y0r + y2r;
            a2[idx5 + 3] = y0i - y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i + x2i;
            a2[idx1 + 2] = y0r - y2r;
            a2[idx1 + 3] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a2[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a2[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = -a2[idx0 + 1] - a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = -a2[idx0 + 1] + a2[idx2 + 1];
            y0r = a2[idx0 - 2] + a2[idx2 - 2];
            y0i = -a2[idx0 - 1] - a2[idx2 - 1];
            y1r = a2[idx0 - 2] - a2[idx2 - 2];
            y1i = -a2[idx0 - 1] + a2[idx2 - 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            y2r = a2[idx1 - 2] + a2[idx3 - 2];
            y2i = a2[idx1 - 1] + a2[idx3 - 1];
            y3r = a2[idx1 - 2] - a2[idx3 - 2];
            y3i = a2[idx1 - 1] - a2[idx3 - 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i - x2i;
            a2[idx0 - 2] = y0r + y2r;
            a2[idx0 - 1] = y0i - y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i + x2i;
            a2[idx1 - 2] = y0r - y2r;
            a2[idx1 - 1] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a2[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2[idx3 - 2] = wd3i * x0r + wd3r * x0i;
            a2[idx3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0 - 2] + a2[idx2 - 2];
        x0i = -a2[idx0 - 1] - a2[idx2 - 1];
        x1r = a2[idx0 - 2] - a2[idx2 - 2];
        x1i = -a2[idx0 - 1] + a2[idx2 - 1];
        x2r = a2[idx1 - 2] + a2[idx3 - 2];
        x2i = a2[idx1 - 1] + a2[idx3 - 1];
        x3r = a2[idx1 - 2] - a2[idx3 - 2];
        x3i = a2[idx1 - 1] - a2[idx3 - 1];
        a2[idx0 - 2] = x0r + x2r;
        a2[idx0 - 1] = x0i - x2i;
        a2[idx1 - 2] = x0r - x2r;
        a2[idx1 - 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a2[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a2[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a2[idx0] + a2[idx2];
        x0i = -a2[idx0 + 1] - a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = -a2[idx0 + 1] + a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i - x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a2[idx0 + 2] + a2[idx2 + 2];
        x0i = -a2[idx0 + 3] - a2[idx2 + 3];
        x1r = a2[idx0 + 2] - a2[idx2 + 2];
        x1i = -a2[idx0 + 3] + a2[idx2 + 3];
        x2r = a2[idx1 + 2] + a2[idx3 + 2];
        x2i = a2[idx1 + 3] + a2[idx3 + 3];
        x3r = a2[idx1 + 2] - a2[idx3 + 2];
        x3i = a2[idx1 + 3] - a2[idx3 + 3];
        a2[idx0 + 2] = x0r + x2r;
        a2[idx0 + 3] = x0i - x2i;
        a2[idx1 + 2] = x0r - x2r;
        a2[idx1 + 3] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a2[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a2[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    public static void cftb1st(long n2, DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        long idx0;
        long j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        double x0r = a2.getDouble(offa) + a2.getDouble(idx2);
        double x0i = -a2.getDouble(offa + 1L) - a2.getDouble(idx2 + 1L);
        double x1r = a2.getDouble(offa) - a2.getDouble(idx2);
        double x1i = -a2.getDouble(offa + 1L) + a2.getDouble(idx2 + 1L);
        double x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        double x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        double x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        double x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i - x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i + x2i);
        a2.setDouble(idx2, x1r + x3i);
        a2.setDouble(idx2 + 1L, x1i + x3r);
        a2.setDouble(idx3, x1r - x3i);
        a2.setDouble(idx3 + 1L, x1i - x3r);
        double wn4r = w2.getDouble(startw + 1L);
        double csc1 = w2.getDouble(startw + 2L);
        double csc3 = w2.getDouble(startw + 3L);
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        long k2 = 0L;
        for (long j4 = 2L; j4 < mh - 2L; j4 += 4L) {
            long idx4 = startw + (k2 += 4L);
            wk1r = csc1 * (wd1r + w2.getDouble(idx4));
            wk1i = csc1 * (wd1i + w2.getDouble(idx4 + 1L));
            wk3r = csc3 * (wd3r + w2.getDouble(idx4 + 2L));
            wk3i = csc3 * (wd3i + w2.getDouble(idx4 + 3L));
            wd1r = w2.getDouble(idx4);
            wd1i = w2.getDouble(idx4 + 1L);
            wd3r = w2.getDouble(idx4 + 2L);
            wd3i = w2.getDouble(idx4 + 3L);
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + j4;
            x0r = a2.getDouble(idx5) + a2.getDouble(idx2);
            x0i = -a2.getDouble(idx5 + 1L) - a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx5) - a2.getDouble(offa + j2);
            x1i = -a2.getDouble(idx5 + 1L) + a2.getDouble(idx2 + 1L);
            double y0r = a2.getDouble(idx5 + 2L) + a2.getDouble(idx2 + 2L);
            double y0i = -a2.getDouble(idx5 + 3L) - a2.getDouble(idx2 + 3L);
            double y1r = a2.getDouble(idx5 + 2L) - a2.getDouble(idx2 + 2L);
            double y1i = -a2.getDouble(idx5 + 3L) + a2.getDouble(idx2 + 3L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            double y2r = a2.getDouble(idx1 + 2L) + a2.getDouble(idx3 + 2L);
            double y2i = a2.getDouble(idx1 + 3L) + a2.getDouble(idx3 + 3L);
            double y3r = a2.getDouble(idx1 + 2L) - a2.getDouble(idx3 + 2L);
            double y3i = a2.getDouble(idx1 + 3L) - a2.getDouble(idx3 + 3L);
            a2.setDouble(idx5, x0r + x2r);
            a2.setDouble(idx5 + 1L, x0i - x2i);
            a2.setDouble(idx5 + 2L, y0r + y2r);
            a2.setDouble(idx5 + 3L, y0i - y2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i + x2i);
            a2.setDouble(idx1 + 2L, y0r - y2r);
            a2.setDouble(idx1 + 3L, y0i + y2i);
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1r * x0r - wk1i * x0i);
            a2.setDouble(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2.setDouble(idx2 + 2L, wd1r * x0r - wd1i * x0i);
            a2.setDouble(idx2 + 3L, wd1r * x0i + wd1i * x0r);
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3r * x0r + wk3i * x0i);
            a2.setDouble(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2.setDouble(idx3 + 2L, wd3r * x0r + wd3i * x0i);
            a2.setDouble(idx3 + 3L, wd3r * x0i - wd3i * x0r);
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
            x0i = -a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
            x1i = -a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
            y0r = a2.getDouble(idx0 - 2L) + a2.getDouble(idx2 - 2L);
            y0i = -a2.getDouble(idx0 - 1L) - a2.getDouble(idx2 - 1L);
            y1r = a2.getDouble(idx0 - 2L) - a2.getDouble(idx2 - 2L);
            y1i = -a2.getDouble(idx0 - 1L) + a2.getDouble(idx2 - 1L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            y2r = a2.getDouble(idx1 - 2L) + a2.getDouble(idx3 - 2L);
            y2i = a2.getDouble(idx1 - 1L) + a2.getDouble(idx3 - 1L);
            y3r = a2.getDouble(idx1 - 2L) - a2.getDouble(idx3 - 2L);
            y3i = a2.getDouble(idx1 - 1L) - a2.getDouble(idx3 - 1L);
            a2.setDouble(idx0, x0r + x2r);
            a2.setDouble(idx0 + 1L, x0i - x2i);
            a2.setDouble(idx0 - 2L, y0r + y2r);
            a2.setDouble(idx0 - 1L, y0i - y2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i + x2i);
            a2.setDouble(idx1 - 2L, y0r - y2r);
            a2.setDouble(idx1 - 1L, y0i + y2i);
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1i * x0r - wk1r * x0i);
            a2.setDouble(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2.setDouble(idx2 - 2L, wd1i * x0r - wd1r * x0i);
            a2.setDouble(idx2 - 1L, wd1i * x0i + wd1r * x0r);
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3i * x0r + wk3r * x0i);
            a2.setDouble(idx3 + 1L, wk3i * x0i - wk3r * x0r);
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2.setDouble(idx3 - 2L, wd3i * x0r + wd3r * x0i);
            a2.setDouble(idx3 - 1L, wd3i * x0i - wd3r * x0r);
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getDouble(idx0 - 2L) + a2.getDouble(idx2 - 2L);
        x0i = -a2.getDouble(idx0 - 1L) - a2.getDouble(idx2 - 1L);
        x1r = a2.getDouble(idx0 - 2L) - a2.getDouble(idx2 - 2L);
        x1i = -a2.getDouble(idx0 - 1L) + a2.getDouble(idx2 - 1L);
        x2r = a2.getDouble(idx1 - 2L) + a2.getDouble(idx3 - 2L);
        x2i = a2.getDouble(idx1 - 1L) + a2.getDouble(idx3 - 1L);
        x3r = a2.getDouble(idx1 - 2L) - a2.getDouble(idx3 - 2L);
        x3i = a2.getDouble(idx1 - 1L) - a2.getDouble(idx3 - 1L);
        a2.setDouble(idx0 - 2L, x0r + x2r);
        a2.setDouble(idx0 - 1L, x0i - x2i);
        a2.setDouble(idx1 - 2L, x0r - x2r);
        a2.setDouble(idx1 - 1L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2 - 2L, wk1r * x0r - wk1i * x0i);
        a2.setDouble(idx2 - 1L, wk1r * x0i + wk1i * x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3 - 2L, wk3r * x0r + wk3i * x0i);
        a2.setDouble(idx3 - 1L, wk3r * x0i - wk3i * x0r);
        x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
        x0i = -a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
        x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
        x1i = -a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
        x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(idx0, x0r + x2r);
        a2.setDouble(idx0 + 1L, x0i - x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2, wn4r * (x0r - x0i));
        a2.setDouble(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3, -wn4r * (x0r + x0i));
        a2.setDouble(idx3 + 1L, -wn4r * (x0i - x0r));
        x0r = a2.getDouble(idx0 + 2L) + a2.getDouble(idx2 + 2L);
        x0i = -a2.getDouble(idx0 + 3L) - a2.getDouble(idx2 + 3L);
        x1r = a2.getDouble(idx0 + 2L) - a2.getDouble(idx2 + 2L);
        x1i = -a2.getDouble(idx0 + 3L) + a2.getDouble(idx2 + 3L);
        x2r = a2.getDouble(idx1 + 2L) + a2.getDouble(idx3 + 2L);
        x2i = a2.getDouble(idx1 + 3L) + a2.getDouble(idx3 + 3L);
        x3r = a2.getDouble(idx1 + 2L) - a2.getDouble(idx3 + 2L);
        x3i = a2.getDouble(idx1 + 3L) - a2.getDouble(idx3 + 3L);
        a2.setDouble(idx0 + 2L, x0r + x2r);
        a2.setDouble(idx0 + 3L, x0i - x2i);
        a2.setDouble(idx1 + 2L, x0r - x2r);
        a2.setDouble(idx1 + 3L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2 + 2L, wk1i * x0r - wk1r * x0i);
        a2.setDouble(idx2 + 3L, wk1i * x0i + wk1r * x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3 + 2L, wk3i * x0r + wk3r * x0i);
        a2.setDouble(idx3 + 3L, wk3i * x0i - wk3r * x0r);
    }

    public static void cftrec4_th(final int n2, final double[] a2, int offa, final int nw, final double[] w2) {
        int idx = 0;
        int nthreads = 2;
        int idiv4 = 0;
        int m4 = n2 >> 1;
        if ((long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthreads = 4;
            idiv4 = 1;
            m4 >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final int mf = m4;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int firstIdx = offa + i2 * m4;
            futures[idx++] = i2 != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int m4 = n2;
                    while (m4 > 512) {
                        CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
                    }
                    CommonUtils.cftleaf(m4, 1, a2, idx1 - m4, nw, w2);
                    int k2 = 0;
                    int idx2 = firstIdx - m4;
                    for (int j2 = mf - m4; j2 > 0; j2 -= m4) {
                        int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int k2 = 1;
                    int m4 = n2;
                    while (m4 > 512) {
                        k2 <<= 2;
                        CommonUtils.cftmdl2(m4 >>= 2, a2, idx1 - m4, w2, nw - m4);
                    }
                    CommonUtils.cftleaf(m4, 0, a2, idx1 - m4, nw, w2);
                    k2 >>= 1;
                    int idx2 = firstIdx - m4;
                    for (int j2 = mf - m4; j2 > 0; j2 -= m4) {
                        int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cftrec4_th(final long n2, final DoubleLargeArray a2, long offa, final long nw, final DoubleLargeArray w2) {
        int idx = 0;
        int nthreads = 2;
        int idiv4 = 0;
        long m4 = n2 >> 1;
        if (n2 >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthreads = 4;
            idiv4 = 1;
            m4 >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final long mf = m4;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long firstIdx = offa + (long)i2 * m4;
            futures[idx++] = i2 != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    long idx1 = firstIdx + mf;
                    long m4 = n2;
                    while (m4 > 512L) {
                        CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
                    }
                    CommonUtils.cftleaf(m4, 1L, a2, idx1 - m4, nw, w2);
                    long k2 = 0L;
                    long idx2 = firstIdx - m4;
                    for (long j2 = mf - m4; j2 > 0L; j2 -= m4) {
                        long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    long idx1 = firstIdx + mf;
                    long k2 = 1L;
                    long m4 = n2;
                    while (m4 > 512L) {
                        k2 <<= 2;
                        CommonUtils.cftmdl2(m4 >>= 2, a2, idx1 - m4, w2, nw - m4);
                    }
                    CommonUtils.cftleaf(m4, 0L, a2, idx1 - m4, nw, w2);
                    k2 >>= 1;
                    long idx2 = firstIdx - m4;
                    for (long j2 = mf - m4; j2 > 0L; j2 -= m4) {
                        long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cftrec4(int n2, double[] a2, int offa, int nw, double[] w2) {
        int m4 = n2;
        int idx1 = offa + n2;
        while (m4 > 512) {
            CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
        }
        CommonUtils.cftleaf(m4, 1, a2, idx1 - m4, nw, w2);
        int k2 = 0;
        int idx2 = offa - m4;
        for (int j2 = n2 - m4; j2 > 0; j2 -= m4) {
            int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, offa, nw, w2);
            CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
        }
    }

    public static void cftrec4(long n2, DoubleLargeArray a2, long offa, long nw, DoubleLargeArray w2) {
        long m4 = n2;
        long idx1 = offa + n2;
        while (m4 > 512L) {
            CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
        }
        CommonUtils.cftleaf(m4, 1L, a2, idx1 - m4, nw, w2);
        long k2 = 0L;
        long idx2 = offa - m4;
        for (long j2 = n2 - m4; j2 > 0L; j2 -= m4) {
            long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, offa, nw, w2);
            CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
        }
    }

    public static int cfttree(int n2, int j2, int k2, double[] a2, int offa, int nw, double[] w2) {
        int isplt;
        int idx1 = offa - n2;
        if ((k2 & 3) != 0) {
            isplt = k2 & 1;
            if (isplt != 0) {
                CommonUtils.cftmdl1(n2, a2, idx1 + j2, w2, nw - (n2 >> 1));
            } else {
                CommonUtils.cftmdl2(n2, a2, idx1 + j2, w2, nw - n2);
            }
        } else {
            int m4 = n2;
            int i2 = k2;
            while ((i2 & 3) == 0) {
                m4 <<= 2;
                i2 >>= 2;
            }
            isplt = i2 & 1;
            int idx2 = offa + j2;
            if (isplt != 0) {
                while (m4 > 128) {
                    CommonUtils.cftmdl1(m4, a2, idx2 - m4, w2, nw - (m4 >> 1));
                    m4 >>= 2;
                }
            } else {
                while (m4 > 128) {
                    CommonUtils.cftmdl2(m4, a2, idx2 - m4, w2, nw - m4);
                    m4 >>= 2;
                }
            }
        }
        return isplt;
    }

    public static long cfttree(long n2, long j2, long k2, DoubleLargeArray a2, long offa, long nw, DoubleLargeArray w2) {
        long isplt;
        long idx1 = offa - n2;
        if ((k2 & 3L) != 0L) {
            isplt = k2 & 1L;
            if (isplt != 0L) {
                CommonUtils.cftmdl1(n2, a2, idx1 + j2, w2, nw - (n2 >> 1));
            } else {
                CommonUtils.cftmdl2(n2, a2, idx1 + j2, w2, nw - n2);
            }
        } else {
            long m4 = n2;
            long i2 = k2;
            while ((i2 & 3L) == 0L) {
                m4 <<= 2;
                i2 >>= 2;
            }
            isplt = i2 & 1L;
            long idx2 = offa + j2;
            if (isplt != 0L) {
                while (m4 > 128L) {
                    CommonUtils.cftmdl1(m4, a2, idx2 - m4, w2, nw - (m4 >> 1));
                    m4 >>= 2;
                }
            } else {
                while (m4 > 128L) {
                    CommonUtils.cftmdl2(m4, a2, idx2 - m4, w2, nw - m4);
                    m4 >>= 2;
                }
            }
        }
        return isplt;
    }

    public static void cftleaf(int n2, int isplt, double[] a2, int offa, int nw, double[] w2) {
        if (n2 == 512) {
            CommonUtils.cftmdl1(128, a2, offa, w2, nw - 64);
            CommonUtils.cftf161(a2, offa, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 32, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 96, w2, nw - 8);
            CommonUtils.cftmdl2(128, a2, offa + 128, w2, nw - 128);
            CommonUtils.cftf161(a2, offa + 128, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 160, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 192, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 224, w2, nw - 32);
            CommonUtils.cftmdl1(128, a2, offa + 256, w2, nw - 64);
            CommonUtils.cftf161(a2, offa + 256, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 288, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 320, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 352, w2, nw - 8);
            if (isplt != 0) {
                CommonUtils.cftmdl1(128, a2, offa + 384, w2, nw - 64);
                CommonUtils.cftf161(a2, offa + 480, w2, nw - 8);
            } else {
                CommonUtils.cftmdl2(128, a2, offa + 384, w2, nw - 128);
                CommonUtils.cftf162(a2, offa + 480, w2, nw - 32);
            }
            CommonUtils.cftf161(a2, offa + 384, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 416, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 448, w2, nw - 8);
        } else {
            CommonUtils.cftmdl1(64, a2, offa, w2, nw - 32);
            CommonUtils.cftf081(a2, offa, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 16, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 32, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 48, w2, nw - 8);
            CommonUtils.cftmdl2(64, a2, offa + 64, w2, nw - 64);
            CommonUtils.cftf081(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 80, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 96, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 112, w2, nw - 8);
            CommonUtils.cftmdl1(64, a2, offa + 128, w2, nw - 32);
            CommonUtils.cftf081(a2, offa + 128, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 144, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 160, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 176, w2, nw - 8);
            if (isplt != 0) {
                CommonUtils.cftmdl1(64, a2, offa + 192, w2, nw - 32);
                CommonUtils.cftf081(a2, offa + 240, w2, nw - 8);
            } else {
                CommonUtils.cftmdl2(64, a2, offa + 192, w2, nw - 64);
                CommonUtils.cftf082(a2, offa + 240, w2, nw - 8);
            }
            CommonUtils.cftf081(a2, offa + 192, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 208, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 224, w2, nw - 8);
        }
    }

    public static void cftleaf(long n2, long isplt, DoubleLargeArray a2, long offa, long nw, DoubleLargeArray w2) {
        if (n2 == 512L) {
            CommonUtils.cftmdl1(128L, a2, offa, w2, nw - 64L);
            CommonUtils.cftf161(a2, offa, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 32L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 96L, w2, nw - 8L);
            CommonUtils.cftmdl2(128L, a2, offa + 128L, w2, nw - 128L);
            CommonUtils.cftf161(a2, offa + 128L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 160L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 192L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 224L, w2, nw - 32L);
            CommonUtils.cftmdl1(128L, a2, offa + 256L, w2, nw - 64L);
            CommonUtils.cftf161(a2, offa + 256L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 288L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 320L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 352L, w2, nw - 8L);
            if (isplt != 0L) {
                CommonUtils.cftmdl1(128L, a2, offa + 384L, w2, nw - 64L);
                CommonUtils.cftf161(a2, offa + 480L, w2, nw - 8L);
            } else {
                CommonUtils.cftmdl2(128L, a2, offa + 384L, w2, nw - 128L);
                CommonUtils.cftf162(a2, offa + 480L, w2, nw - 32L);
            }
            CommonUtils.cftf161(a2, offa + 384L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 416L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 448L, w2, nw - 8L);
        } else {
            CommonUtils.cftmdl1(64L, a2, offa, w2, nw - 32L);
            CommonUtils.cftf081(a2, offa, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 16L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 32L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 48L, w2, nw - 8L);
            CommonUtils.cftmdl2(64L, a2, offa + 64L, w2, nw - 64L);
            CommonUtils.cftf081(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 80L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 96L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 112L, w2, nw - 8L);
            CommonUtils.cftmdl1(64L, a2, offa + 128L, w2, nw - 32L);
            CommonUtils.cftf081(a2, offa + 128L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 144L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 160L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 176L, w2, nw - 8L);
            if (isplt != 0L) {
                CommonUtils.cftmdl1(64L, a2, offa + 192L, w2, nw - 32L);
                CommonUtils.cftf081(a2, offa + 240L, w2, nw - 8L);
            } else {
                CommonUtils.cftmdl2(64L, a2, offa + 192L, w2, nw - 64L);
                CommonUtils.cftf082(a2, offa + 240L, w2, nw - 8L);
            }
            CommonUtils.cftf081(a2, offa + 192L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 208L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 224L, w2, nw - 8L);
        }
    }

    public static void cftmdl1(int n2, double[] a2, int offa, double[] w2, int startw) {
        int idx0;
        int j0;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a2[offa] + a2[idx2];
        double x0i = a2[offa + 1] + a2[idx2 + 1];
        double x1r = a2[offa] - a2[idx2];
        double x1i = a2[offa + 1] - a2[idx2 + 1];
        double x2r = a2[idx1] + a2[idx3];
        double x2i = a2[idx1 + 1] + a2[idx3 + 1];
        double x3r = a2[idx1] - a2[idx3];
        double x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        a2[idx2] = x1r - x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r + x3i;
        a2[idx3 + 1] = x1i - x3r;
        double wn4r = w2[startw + 1];
        int k2 = 0;
        for (int j4 = 2; j4 < mh; j4 += 2) {
            int idx4 = startw + (k2 += 4);
            double wk1r = w2[idx4];
            double wk1i = w2[idx4 + 1];
            double wk3r = w2[idx4 + 2];
            double wk3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = a2[idx5 + 1] + a2[idx2 + 1];
            x1r = a2[idx5] - a2[idx2];
            x1i = a2[idx5 + 1] - a2[idx2 + 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i + x2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = a2[idx0 + 1] + a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = a2[idx0 + 1] - a2[idx2 + 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i + x2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
        }
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0] + a2[idx2];
        x0i = a2[idx0 + 1] + a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = a2[idx0 + 1] - a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
    }

    public static void cftmdl1(long n2, DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        long idx0;
        long j0;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        double x0r = a2.getDouble(offa) + a2.getDouble(idx2);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(idx2 + 1L);
        double x1r = a2.getDouble(offa) - a2.getDouble(idx2);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(idx2 + 1L);
        double x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        double x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        double x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        double x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i + x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i - x2i);
        a2.setDouble(idx2, x1r - x3i);
        a2.setDouble(idx2 + 1L, x1i + x3r);
        a2.setDouble(idx3, x1r + x3i);
        a2.setDouble(idx3 + 1L, x1i - x3r);
        double wn4r = w2.getDouble(startw + 1L);
        long k2 = 0L;
        for (long j4 = 2L; j4 < mh; j4 += 2L) {
            long idx4 = startw + (k2 += 4L);
            double wk1r = w2.getDouble(idx4);
            double wk1i = w2.getDouble(idx4 + 1L);
            double wk3r = w2.getDouble(idx4 + 2L);
            double wk3i = w2.getDouble(idx4 + 3L);
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + j4;
            x0r = a2.getDouble(idx5) + a2.getDouble(idx2);
            x0i = a2.getDouble(idx5 + 1L) + a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx5) - a2.getDouble(idx2);
            x1i = a2.getDouble(idx5 + 1L) - a2.getDouble(idx2 + 1L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            a2.setDouble(idx5, x0r + x2r);
            a2.setDouble(idx5 + 1L, x0i + x2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i - x2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1r * x0r - wk1i * x0i);
            a2.setDouble(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3r * x0r + wk3i * x0i);
            a2.setDouble(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
            x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
            x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
            x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
            x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
            x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
            a2.setDouble(idx0, x0r + x2r);
            a2.setDouble(idx0 + 1L, x0i + x2i);
            a2.setDouble(idx1, x0r - x2r);
            a2.setDouble(idx1 + 1L, x0i - x2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setDouble(idx2, wk1i * x0r - wk1r * x0i);
            a2.setDouble(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setDouble(idx3, wk3i * x0r + wk3r * x0i);
            a2.setDouble(idx3 + 1L, wk3i * x0i - wk3r * x0r);
        }
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getDouble(idx0) + a2.getDouble(idx2);
        x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2 + 1L);
        x1r = a2.getDouble(idx0) - a2.getDouble(idx2);
        x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2 + 1L);
        x2r = a2.getDouble(idx1) + a2.getDouble(idx3);
        x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3 + 1L);
        x3r = a2.getDouble(idx1) - a2.getDouble(idx3);
        x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3 + 1L);
        a2.setDouble(idx0, x0r + x2r);
        a2.setDouble(idx0 + 1L, x0i + x2i);
        a2.setDouble(idx1, x0r - x2r);
        a2.setDouble(idx1 + 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setDouble(idx2, wn4r * (x0r - x0i));
        a2.setDouble(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setDouble(idx3, -wn4r * (x0r + x0i));
        a2.setDouble(idx3 + 1L, -wn4r * (x0i - x0r));
    }

    public static void cftmdl2(int n2, double[] a2, int offa, double[] w2, int startw) {
        int idx0;
        int j0;
        double y2i;
        double y2r;
        double wk1i;
        double wk1r;
        int mh = n2 >> 3;
        int m4 = 2 * mh;
        double wn4r = w2[startw + 1];
        int j1 = m4;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a2[offa] - a2[idx2 + 1];
        double x0i = a2[offa + 1] + a2[idx2];
        double x1r = a2[offa] + a2[idx2 + 1];
        double x1i = a2[offa + 1] - a2[idx2];
        double x2r = a2[idx1] - a2[idx3 + 1];
        double x2i = a2[idx1 + 1] + a2[idx3];
        double x3r = a2[idx1] + a2[idx3 + 1];
        double x3i = a2[idx1 + 1] - a2[idx3];
        double y0r = wn4r * (x2r - x2i);
        double y0i = wn4r * (x2i + x2r);
        a2[offa] = x0r + y0r;
        a2[offa + 1] = x0i + y0i;
        a2[idx1] = x0r - y0r;
        a2[idx1 + 1] = x0i - y0i;
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a2[idx2] = x1r - y0i;
        a2[idx2 + 1] = x1i + y0r;
        a2[idx3] = x1r + y0i;
        a2[idx3 + 1] = x1i - y0r;
        int k2 = 0;
        int kr = 2 * m4;
        for (int j4 = 2; j4 < mh; j4 += 2) {
            int idx4 = startw + (k2 += 4);
            wk1r = w2[idx4];
            wk1i = w2[idx4 + 1];
            double wk3r = w2[idx4 + 2];
            double wk3i = w2[idx4 + 3];
            int idx5 = startw + (kr -= 4);
            double wd1i = w2[idx5];
            double wd1r = w2[idx5 + 1];
            double wd3i = w2[idx5 + 2];
            double wd3r = w2[idx5 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx6 = offa + j4;
            x0r = a2[idx6] - a2[idx2 + 1];
            x0i = a2[idx6 + 1] + a2[idx2];
            x1r = a2[idx6] + a2[idx2 + 1];
            x1i = a2[idx6 + 1] - a2[idx2];
            x2r = a2[idx1] - a2[idx3 + 1];
            x2i = a2[idx1 + 1] + a2[idx3];
            x3r = a2[idx1] + a2[idx3 + 1];
            x3i = a2[idx1 + 1] - a2[idx3];
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a2[idx6] = y0r + y2r;
            a2[idx6 + 1] = y0i + y2i;
            a2[idx1] = y0r - y2r;
            a2[idx1 + 1] = y0i - y2i;
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a2[idx2] = y0r + y2r;
            a2[idx2 + 1] = y0i + y2i;
            a2[idx3] = y0r - y2r;
            a2[idx3 + 1] = y0i - y2i;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] - a2[idx2 + 1];
            x0i = a2[idx0 + 1] + a2[idx2];
            x1r = a2[idx0] + a2[idx2 + 1];
            x1i = a2[idx0 + 1] - a2[idx2];
            x2r = a2[idx1] - a2[idx3 + 1];
            x2i = a2[idx1 + 1] + a2[idx3];
            x3r = a2[idx1] + a2[idx3 + 1];
            x3i = a2[idx1 + 1] - a2[idx3];
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a2[idx0] = y0r + y2r;
            a2[idx0 + 1] = y0i + y2i;
            a2[idx1] = y0r - y2r;
            a2[idx1 + 1] = y0i - y2i;
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a2[idx2] = y0r + y2r;
            a2[idx2 + 1] = y0i + y2i;
            a2[idx3] = y0r - y2r;
            a2[idx3 + 1] = y0i - y2i;
        }
        wk1r = w2[startw + m4];
        wk1i = w2[startw + m4 + 1];
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0] - a2[idx2 + 1];
        x0i = a2[idx0 + 1] + a2[idx2];
        x1r = a2[idx0] + a2[idx2 + 1];
        x1i = a2[idx0 + 1] - a2[idx2];
        x2r = a2[idx1] - a2[idx3 + 1];
        x2i = a2[idx1 + 1] + a2[idx3];
        x3r = a2[idx1] + a2[idx3 + 1];
        x3i = a2[idx1 + 1] - a2[idx3];
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a2[idx0] = y0r + y2r;
        a2[idx0 + 1] = y0i + y2i;
        a2[idx1] = y0r - y2r;
        a2[idx1 + 1] = y0i - y2i;
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a2[idx2] = y0r - y2r;
        a2[idx2 + 1] = y0i - y2i;
        a2[idx3] = y0r + y2r;
        a2[idx3 + 1] = y0i + y2i;
    }

    public static void cftmdl2(long n2, DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        long idx0;
        long j0;
        double y2i;
        double y2r;
        double wk1i;
        double wk1r;
        long mh = n2 >> 3;
        long m4 = 2L * mh;
        double wn4r = w2.getDouble(startw + 1L);
        long j1 = m4;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        double x0r = a2.getDouble(offa) - a2.getDouble(idx2 + 1L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(idx2);
        double x1r = a2.getDouble(offa) + a2.getDouble(idx2 + 1L);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(idx2);
        double x2r = a2.getDouble(idx1) - a2.getDouble(idx3 + 1L);
        double x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3);
        double x3r = a2.getDouble(idx1) + a2.getDouble(idx3 + 1L);
        double x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3);
        double y0r = wn4r * (x2r - x2i);
        double y0i = wn4r * (x2i + x2r);
        a2.setDouble(offa, x0r + y0r);
        a2.setDouble(offa + 1L, x0i + y0i);
        a2.setDouble(idx1, x0r - y0r);
        a2.setDouble(idx1 + 1L, x0i - y0i);
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a2.setDouble(idx2, x1r - y0i);
        a2.setDouble(idx2 + 1L, x1i + y0r);
        a2.setDouble(idx3, x1r + y0i);
        a2.setDouble(idx3 + 1L, x1i - y0r);
        long k2 = 0L;
        long kr = 2L * m4;
        int j4 = 2;
        while ((long)j4 < mh) {
            long idx4 = startw + (k2 += 4L);
            wk1r = w2.getDouble(idx4);
            wk1i = w2.getDouble(idx4 + 1L);
            double wk3r = w2.getDouble(idx4 + 2L);
            double wk3i = w2.getDouble(idx4 + 3L);
            long idx5 = startw + (kr -= 4L);
            double wd1i = w2.getDouble(idx5);
            double wd1r = w2.getDouble(idx5 + 1L);
            double wd3i = w2.getDouble(idx5 + 2L);
            double wd3r = w2.getDouble(idx5 + 3L);
            j1 = (long)j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx6 = offa + (long)j4;
            x0r = a2.getDouble(idx6) - a2.getDouble(idx2 + 1L);
            x0i = a2.getDouble(idx6 + 1L) + a2.getDouble(idx2);
            x1r = a2.getDouble(idx6) + a2.getDouble(idx2 + 1L);
            x1i = a2.getDouble(idx6 + 1L) - a2.getDouble(idx2);
            x2r = a2.getDouble(idx1) - a2.getDouble(idx3 + 1L);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3);
            x3r = a2.getDouble(idx1) + a2.getDouble(idx3 + 1L);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3);
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a2.setDouble(idx6, y0r + y2r);
            a2.setDouble(idx6 + 1L, y0i + y2i);
            a2.setDouble(idx1, y0r - y2r);
            a2.setDouble(idx1 + 1L, y0i - y2i);
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a2.setDouble(idx2, y0r + y2r);
            a2.setDouble(idx2 + 1L, y0i + y2i);
            a2.setDouble(idx3, y0r - y2r);
            a2.setDouble(idx3 + 1L, y0i - y2i);
            j0 = m4 - (long)j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getDouble(idx0) - a2.getDouble(idx2 + 1L);
            x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2);
            x1r = a2.getDouble(idx0) + a2.getDouble(idx2 + 1L);
            x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2);
            x2r = a2.getDouble(idx1) - a2.getDouble(idx3 + 1L);
            x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3);
            x3r = a2.getDouble(idx1) + a2.getDouble(idx3 + 1L);
            x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3);
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a2.setDouble(idx0, y0r + y2r);
            a2.setDouble(idx0 + 1L, y0i + y2i);
            a2.setDouble(idx1, y0r - y2r);
            a2.setDouble(idx1 + 1L, y0i - y2i);
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a2.setDouble(idx2, y0r + y2r);
            a2.setDouble(idx2 + 1L, y0i + y2i);
            a2.setDouble(idx3, y0r - y2r);
            a2.setDouble(idx3 + 1L, y0i - y2i);
            j4 += 2;
        }
        wk1r = w2.getDouble(startw + m4);
        wk1i = w2.getDouble(startw + m4 + 1L);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getDouble(idx0) - a2.getDouble(idx2 + 1L);
        x0i = a2.getDouble(idx0 + 1L) + a2.getDouble(idx2);
        x1r = a2.getDouble(idx0) + a2.getDouble(idx2 + 1L);
        x1i = a2.getDouble(idx0 + 1L) - a2.getDouble(idx2);
        x2r = a2.getDouble(idx1) - a2.getDouble(idx3 + 1L);
        x2i = a2.getDouble(idx1 + 1L) + a2.getDouble(idx3);
        x3r = a2.getDouble(idx1) + a2.getDouble(idx3 + 1L);
        x3i = a2.getDouble(idx1 + 1L) - a2.getDouble(idx3);
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a2.setDouble(idx0, y0r + y2r);
        a2.setDouble(idx0 + 1L, y0i + y2i);
        a2.setDouble(idx1, y0r - y2r);
        a2.setDouble(idx1 + 1L, y0i - y2i);
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a2.setDouble(idx2, y0r - y2r);
        a2.setDouble(idx2 + 1L, y0i - y2i);
        a2.setDouble(idx3, y0r + y2r);
        a2.setDouble(idx3 + 1L, y0i + y2i);
    }

    public static void cftfx41(int n2, double[] a2, int offa, int nw, double[] w2) {
        if (n2 == 128) {
            CommonUtils.cftf161(a2, offa, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 32, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 96, w2, nw - 8);
        } else {
            CommonUtils.cftf081(a2, offa, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 16, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 32, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 48, w2, nw - 8);
        }
    }

    public static void cftfx41(long n2, DoubleLargeArray a2, long offa, long nw, DoubleLargeArray w2) {
        if (n2 == 128L) {
            CommonUtils.cftf161(a2, offa, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 32L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 96L, w2, nw - 8L);
        } else {
            CommonUtils.cftf081(a2, offa, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 16L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 32L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 48L, w2, nw - 8L);
        }
    }

    public static void cftf161(double[] a2, int offa, double[] w2, int startw) {
        double wn4r = w2[startw + 1];
        double wk1r = w2[startw + 2];
        double wk1i = w2[startw + 3];
        double x0r = a2[offa] + a2[offa + 16];
        double x0i = a2[offa + 1] + a2[offa + 17];
        double x1r = a2[offa] - a2[offa + 16];
        double x1i = a2[offa + 1] - a2[offa + 17];
        double x2r = a2[offa + 8] + a2[offa + 24];
        double x2i = a2[offa + 9] + a2[offa + 25];
        double x3r = a2[offa + 8] - a2[offa + 24];
        double x3i = a2[offa + 9] - a2[offa + 25];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y4r = x0r - x2r;
        double y4i = x0i - x2i;
        double y8r = x1r - x3i;
        double y8i = x1i + x3r;
        double y12r = x1r + x3i;
        double y12i = x1i - x3r;
        x0r = a2[offa + 2] + a2[offa + 18];
        x0i = a2[offa + 3] + a2[offa + 19];
        x1r = a2[offa + 2] - a2[offa + 18];
        x1i = a2[offa + 3] - a2[offa + 19];
        x2r = a2[offa + 10] + a2[offa + 26];
        x2i = a2[offa + 11] + a2[offa + 27];
        x3r = a2[offa + 10] - a2[offa + 26];
        x3i = a2[offa + 11] - a2[offa + 27];
        double y1r = x0r + x2r;
        double y1i = x0i + x2i;
        double y5r = x0r - x2r;
        double y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y9r = wk1r * x0r - wk1i * x0i;
        double y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y13r = wk1i * x0r - wk1r * x0i;
        double y13i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 4] + a2[offa + 20];
        x0i = a2[offa + 5] + a2[offa + 21];
        x1r = a2[offa + 4] - a2[offa + 20];
        x1i = a2[offa + 5] - a2[offa + 21];
        x2r = a2[offa + 12] + a2[offa + 28];
        x2i = a2[offa + 13] + a2[offa + 29];
        x3r = a2[offa + 12] - a2[offa + 28];
        x3i = a2[offa + 13] - a2[offa + 29];
        double y2r = x0r + x2r;
        double y2i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y10r = wn4r * (x0r - x0i);
        double y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y14r = wn4r * (x0r + x0i);
        double y14i = wn4r * (x0i - x0r);
        x0r = a2[offa + 6] + a2[offa + 22];
        x0i = a2[offa + 7] + a2[offa + 23];
        x1r = a2[offa + 6] - a2[offa + 22];
        x1i = a2[offa + 7] - a2[offa + 23];
        x2r = a2[offa + 14] + a2[offa + 30];
        x2i = a2[offa + 15] + a2[offa + 31];
        x3r = a2[offa + 14] - a2[offa + 30];
        x3i = a2[offa + 15] - a2[offa + 31];
        double y3r = x0r + x2r;
        double y3i = x0i + x2i;
        double y7r = x0r - x2r;
        double y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y11r = wk1i * x0r - wk1r * x0i;
        double y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y15r = wk1r * x0r - wk1i * x0i;
        double y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a2[offa + 24] = x0r + x2r;
        a2[offa + 25] = x0i + x2i;
        a2[offa + 26] = x0r - x2r;
        a2[offa + 27] = x0i - x2i;
        a2[offa + 28] = x1r - x3i;
        a2[offa + 29] = x1i + x3r;
        a2[offa + 30] = x1r + x3i;
        a2[offa + 31] = x1i - x3r;
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a2[offa + 16] = x0r + x2r;
        a2[offa + 17] = x0i + x2i;
        a2[offa + 18] = x0r - x2r;
        a2[offa + 19] = x0i - x2i;
        a2[offa + 20] = x1r - x3i;
        a2[offa + 21] = x1i + x3r;
        a2[offa + 22] = x1r + x3i;
        a2[offa + 23] = x1i - x3r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a2[offa + 8] = x0r + x2r;
        a2[offa + 9] = x0i + x2i;
        a2[offa + 10] = x0r - x2r;
        a2[offa + 11] = x0i - x2i;
        a2[offa + 12] = x1r - x3i;
        a2[offa + 13] = x1i + x3r;
        a2[offa + 14] = x1r + x3i;
        a2[offa + 15] = x1i - x3r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x0r - x2r;
        a2[offa + 3] = x0i - x2i;
        a2[offa + 4] = x1r - x3i;
        a2[offa + 5] = x1i + x3r;
        a2[offa + 6] = x1r + x3i;
        a2[offa + 7] = x1i - x3r;
    }

    public static void cftf161(DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        double wn4r = w2.getDouble(startw + 1L);
        double wk1r = w2.getDouble(startw + 2L);
        double wk1i = w2.getDouble(startw + 3L);
        double x0r = a2.getDouble(offa) + a2.getDouble(offa + 16L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 17L);
        double x1r = a2.getDouble(offa) - a2.getDouble(offa + 16L);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 17L);
        double x2r = a2.getDouble(offa + 8L) + a2.getDouble(offa + 24L);
        double x2i = a2.getDouble(offa + 9L) + a2.getDouble(offa + 25L);
        double x3r = a2.getDouble(offa + 8L) - a2.getDouble(offa + 24L);
        double x3i = a2.getDouble(offa + 9L) - a2.getDouble(offa + 25L);
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y4r = x0r - x2r;
        double y4i = x0i - x2i;
        double y8r = x1r - x3i;
        double y8i = x1i + x3r;
        double y12r = x1r + x3i;
        double y12i = x1i - x3r;
        x0r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 18L);
        x0i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 19L);
        x1r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 18L);
        x1i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 19L);
        x2r = a2.getDouble(offa + 10L) + a2.getDouble(offa + 26L);
        x2i = a2.getDouble(offa + 11L) + a2.getDouble(offa + 27L);
        x3r = a2.getDouble(offa + 10L) - a2.getDouble(offa + 26L);
        x3i = a2.getDouble(offa + 11L) - a2.getDouble(offa + 27L);
        double y1r = x0r + x2r;
        double y1i = x0i + x2i;
        double y5r = x0r - x2r;
        double y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y9r = wk1r * x0r - wk1i * x0i;
        double y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y13r = wk1i * x0r - wk1r * x0i;
        double y13i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getDouble(offa + 4L) + a2.getDouble(offa + 20L);
        x0i = a2.getDouble(offa + 5L) + a2.getDouble(offa + 21L);
        x1r = a2.getDouble(offa + 4L) - a2.getDouble(offa + 20L);
        x1i = a2.getDouble(offa + 5L) - a2.getDouble(offa + 21L);
        x2r = a2.getDouble(offa + 12L) + a2.getDouble(offa + 28L);
        x2i = a2.getDouble(offa + 13L) + a2.getDouble(offa + 29L);
        x3r = a2.getDouble(offa + 12L) - a2.getDouble(offa + 28L);
        x3i = a2.getDouble(offa + 13L) - a2.getDouble(offa + 29L);
        double y2r = x0r + x2r;
        double y2i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y10r = wn4r * (x0r - x0i);
        double y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y14r = wn4r * (x0r + x0i);
        double y14i = wn4r * (x0i - x0r);
        x0r = a2.getDouble(offa + 6L) + a2.getDouble(offa + 22L);
        x0i = a2.getDouble(offa + 7L) + a2.getDouble(offa + 23L);
        x1r = a2.getDouble(offa + 6L) - a2.getDouble(offa + 22L);
        x1i = a2.getDouble(offa + 7L) - a2.getDouble(offa + 23L);
        x2r = a2.getDouble(offa + 14L) + a2.getDouble(offa + 30L);
        x2i = a2.getDouble(offa + 15L) + a2.getDouble(offa + 31L);
        x3r = a2.getDouble(offa + 14L) - a2.getDouble(offa + 30L);
        x3i = a2.getDouble(offa + 15L) - a2.getDouble(offa + 31L);
        double y3r = x0r + x2r;
        double y3i = x0i + x2i;
        double y7r = x0r - x2r;
        double y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y11r = wk1i * x0r - wk1r * x0i;
        double y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y15r = wk1r * x0r - wk1i * x0i;
        double y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a2.setDouble(offa + 24L, x0r + x2r);
        a2.setDouble(offa + 25L, x0i + x2i);
        a2.setDouble(offa + 26L, x0r - x2r);
        a2.setDouble(offa + 27L, x0i - x2i);
        a2.setDouble(offa + 28L, x1r - x3i);
        a2.setDouble(offa + 29L, x1i + x3r);
        a2.setDouble(offa + 30L, x1r + x3i);
        a2.setDouble(offa + 31L, x1i - x3r);
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a2.setDouble(offa + 16L, x0r + x2r);
        a2.setDouble(offa + 17L, x0i + x2i);
        a2.setDouble(offa + 18L, x0r - x2r);
        a2.setDouble(offa + 19L, x0i - x2i);
        a2.setDouble(offa + 20L, x1r - x3i);
        a2.setDouble(offa + 21L, x1i + x3r);
        a2.setDouble(offa + 22L, x1r + x3i);
        a2.setDouble(offa + 23L, x1i - x3r);
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a2.setDouble(offa + 8L, x0r + x2r);
        a2.setDouble(offa + 9L, x0i + x2i);
        a2.setDouble(offa + 10L, x0r - x2r);
        a2.setDouble(offa + 11L, x0i - x2i);
        a2.setDouble(offa + 12L, x1r - x3i);
        a2.setDouble(offa + 13L, x1i + x3r);
        a2.setDouble(offa + 14L, x1r + x3i);
        a2.setDouble(offa + 15L, x1i - x3r);
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i + x2i);
        a2.setDouble(offa + 2L, x0r - x2r);
        a2.setDouble(offa + 3L, x0i - x2i);
        a2.setDouble(offa + 4L, x1r - x3i);
        a2.setDouble(offa + 5L, x1i + x3r);
        a2.setDouble(offa + 6L, x1r + x3i);
        a2.setDouble(offa + 7L, x1i - x3r);
    }

    public static void cftf162(double[] a2, int offa, double[] w2, int startw) {
        double wn4r = w2[startw + 1];
        double wk1r = w2[startw + 4];
        double wk1i = w2[startw + 5];
        double wk3r = w2[startw + 6];
        double wk3i = -w2[startw + 7];
        double wk2r = w2[startw + 8];
        double wk2i = w2[startw + 9];
        double x1r = a2[offa] - a2[offa + 17];
        double x1i = a2[offa + 1] + a2[offa + 16];
        double x0r = a2[offa + 8] - a2[offa + 25];
        double x0i = a2[offa + 9] + a2[offa + 24];
        double x2r = wn4r * (x0r - x0i);
        double x2i = wn4r * (x0i + x0r);
        double y0r = x1r + x2r;
        double y0i = x1i + x2i;
        double y4r = x1r - x2r;
        double y4i = x1i - x2i;
        x1r = a2[offa] + a2[offa + 17];
        x1i = a2[offa + 1] - a2[offa + 16];
        x0r = a2[offa + 8] + a2[offa + 25];
        x0i = a2[offa + 9] - a2[offa + 24];
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        double y8r = x1r - x2i;
        double y8i = x1i + x2r;
        double y12r = x1r + x2i;
        double y12i = x1i - x2r;
        x0r = a2[offa + 2] - a2[offa + 19];
        x0i = a2[offa + 3] + a2[offa + 18];
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a2[offa + 10] - a2[offa + 27];
        x0i = a2[offa + 11] + a2[offa + 26];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y1r = x1r + x2r;
        double y1i = x1i + x2i;
        double y5r = x1r - x2r;
        double y5i = x1i - x2i;
        x0r = a2[offa + 2] + a2[offa + 19];
        x0i = a2[offa + 3] - a2[offa + 18];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2[offa + 10] + a2[offa + 27];
        x0i = a2[offa + 11] - a2[offa + 26];
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        double y9r = x1r - x2r;
        double y9i = x1i - x2i;
        double y13r = x1r + x2r;
        double y13i = x1i + x2i;
        x0r = a2[offa + 4] - a2[offa + 21];
        x0i = a2[offa + 5] + a2[offa + 20];
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a2[offa + 12] - a2[offa + 29];
        x0i = a2[offa + 13] + a2[offa + 28];
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        double y2r = x1r + x2r;
        double y2i = x1i + x2i;
        double y6r = x1r - x2r;
        double y6i = x1i - x2i;
        x0r = a2[offa + 4] + a2[offa + 21];
        x0i = a2[offa + 5] - a2[offa + 20];
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a2[offa + 12] + a2[offa + 29];
        x0i = a2[offa + 13] - a2[offa + 28];
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        double y10r = x1r - x2r;
        double y10i = x1i - x2i;
        double y14r = x1r + x2r;
        double y14i = x1i + x2i;
        x0r = a2[offa + 6] - a2[offa + 23];
        x0i = a2[offa + 7] + a2[offa + 22];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2[offa + 14] - a2[offa + 31];
        x0i = a2[offa + 15] + a2[offa + 30];
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        double y3r = x1r + x2r;
        double y3i = x1i + x2i;
        double y7r = x1r - x2r;
        double y7i = x1i - x2i;
        x0r = a2[offa + 6] + a2[offa + 23];
        x0i = a2[offa + 7] - a2[offa + 22];
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a2[offa + 14] + a2[offa + 31];
        x0i = a2[offa + 15] - a2[offa + 30];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y11r = x1r + x2r;
        double y11i = x1i + x2i;
        double y15r = x1r - x2r;
        double y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a2[offa] = x1r + x2r;
        a2[offa + 1] = x1i + x2i;
        a2[offa + 2] = x1r - x2r;
        a2[offa + 3] = x1i - x2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a2[offa + 4] = x1r - x2i;
        a2[offa + 5] = x1i + x2r;
        a2[offa + 6] = x1r + x2i;
        a2[offa + 7] = x1i - x2r;
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 8] = x1r + x2r;
        a2[offa + 9] = x1i + x2i;
        a2[offa + 10] = x1r - x2r;
        a2[offa + 11] = x1i - x2i;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 12] = x1r - x2i;
        a2[offa + 13] = x1i + x2r;
        a2[offa + 14] = x1r + x2i;
        a2[offa + 15] = x1i - x2r;
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a2[offa + 16] = x1r + x2r;
        a2[offa + 17] = x1i + x2i;
        a2[offa + 18] = x1r - x2r;
        a2[offa + 19] = x1i - x2i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a2[offa + 20] = x1r - x2i;
        a2[offa + 21] = x1i + x2r;
        a2[offa + 22] = x1r + x2i;
        a2[offa + 23] = x1i - x2r;
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 24] = x1r + x2r;
        a2[offa + 25] = x1i + x2i;
        a2[offa + 26] = x1r - x2r;
        a2[offa + 27] = x1i - x2i;
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 28] = x1r - x2i;
        a2[offa + 29] = x1i + x2r;
        a2[offa + 30] = x1r + x2i;
        a2[offa + 31] = x1i - x2r;
    }

    public static void cftf162(DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        double wn4r = w2.getDouble(startw + 1L);
        double wk1r = w2.getDouble(startw + 4L);
        double wk1i = w2.getDouble(startw + 5L);
        double wk3r = w2.getDouble(startw + 6L);
        double wk3i = -w2.getDouble(startw + 7L);
        double wk2r = w2.getDouble(startw + 8L);
        double wk2i = w2.getDouble(startw + 9L);
        double x1r = a2.getDouble(offa) - a2.getDouble(offa + 17L);
        double x1i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 16L);
        double x0r = a2.getDouble(offa + 8L) - a2.getDouble(offa + 25L);
        double x0i = a2.getDouble(offa + 9L) + a2.getDouble(offa + 24L);
        double x2r = wn4r * (x0r - x0i);
        double x2i = wn4r * (x0i + x0r);
        double y0r = x1r + x2r;
        double y0i = x1i + x2i;
        double y4r = x1r - x2r;
        double y4i = x1i - x2i;
        x1r = a2.getDouble(offa) + a2.getDouble(offa + 17L);
        x1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 16L);
        x0r = a2.getDouble(offa + 8L) + a2.getDouble(offa + 25L);
        x0i = a2.getDouble(offa + 9L) - a2.getDouble(offa + 24L);
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        double y8r = x1r - x2i;
        double y8i = x1i + x2r;
        double y12r = x1r + x2i;
        double y12i = x1i - x2r;
        x0r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 19L);
        x0i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 18L);
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a2.getDouble(offa + 10L) - a2.getDouble(offa + 27L);
        x0i = a2.getDouble(offa + 11L) + a2.getDouble(offa + 26L);
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y1r = x1r + x2r;
        double y1i = x1i + x2i;
        double y5r = x1r - x2r;
        double y5i = x1i - x2i;
        x0r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 19L);
        x0i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 18L);
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2.getDouble(offa + 10L) + a2.getDouble(offa + 27L);
        x0i = a2.getDouble(offa + 11L) - a2.getDouble(offa + 26L);
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        double y9r = x1r - x2r;
        double y9i = x1i - x2i;
        double y13r = x1r + x2r;
        double y13i = x1i + x2i;
        x0r = a2.getDouble(offa + 4L) - a2.getDouble(offa + 21L);
        x0i = a2.getDouble(offa + 5L) + a2.getDouble(offa + 20L);
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a2.getDouble(offa + 12L) - a2.getDouble(offa + 29L);
        x0i = a2.getDouble(offa + 13L) + a2.getDouble(offa + 28L);
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        double y2r = x1r + x2r;
        double y2i = x1i + x2i;
        double y6r = x1r - x2r;
        double y6i = x1i - x2i;
        x0r = a2.getDouble(offa + 4L) + a2.getDouble(offa + 21L);
        x0i = a2.getDouble(offa + 5L) - a2.getDouble(offa + 20L);
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a2.getDouble(offa + 12L) + a2.getDouble(offa + 29L);
        x0i = a2.getDouble(offa + 13L) - a2.getDouble(offa + 28L);
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        double y10r = x1r - x2r;
        double y10i = x1i - x2i;
        double y14r = x1r + x2r;
        double y14i = x1i + x2i;
        x0r = a2.getDouble(offa + 6L) - a2.getDouble(offa + 23L);
        x0i = a2.getDouble(offa + 7L) + a2.getDouble(offa + 22L);
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2.getDouble(offa + 14L) - a2.getDouble(offa + 31L);
        x0i = a2.getDouble(offa + 15L) + a2.getDouble(offa + 30L);
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        double y3r = x1r + x2r;
        double y3i = x1i + x2i;
        double y7r = x1r - x2r;
        double y7i = x1i - x2i;
        x0r = a2.getDouble(offa + 6L) + a2.getDouble(offa + 23L);
        x0i = a2.getDouble(offa + 7L) - a2.getDouble(offa + 22L);
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a2.getDouble(offa + 14L) + a2.getDouble(offa + 31L);
        x0i = a2.getDouble(offa + 15L) - a2.getDouble(offa + 30L);
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y11r = x1r + x2r;
        double y11i = x1i + x2i;
        double y15r = x1r - x2r;
        double y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a2.setDouble(offa, x1r + x2r);
        a2.setDouble(offa + 1L, x1i + x2i);
        a2.setDouble(offa + 2L, x1r - x2r);
        a2.setDouble(offa + 3L, x1i - x2i);
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a2.setDouble(offa + 4L, x1r - x2i);
        a2.setDouble(offa + 5L, x1i + x2r);
        a2.setDouble(offa + 6L, x1r + x2i);
        a2.setDouble(offa + 7L, x1i - x2r);
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setDouble(offa + 8L, x1r + x2r);
        a2.setDouble(offa + 9L, x1i + x2i);
        a2.setDouble(offa + 10L, x1r - x2r);
        a2.setDouble(offa + 11L, x1i - x2i);
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setDouble(offa + 12L, x1r - x2i);
        a2.setDouble(offa + 13L, x1i + x2r);
        a2.setDouble(offa + 14L, x1r + x2i);
        a2.setDouble(offa + 15L, x1i - x2r);
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a2.setDouble(offa + 16L, x1r + x2r);
        a2.setDouble(offa + 17L, x1i + x2i);
        a2.setDouble(offa + 18L, x1r - x2r);
        a2.setDouble(offa + 19L, x1i - x2i);
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a2.setDouble(offa + 20L, x1r - x2i);
        a2.setDouble(offa + 21L, x1i + x2r);
        a2.setDouble(offa + 22L, x1r + x2i);
        a2.setDouble(offa + 23L, x1i - x2r);
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setDouble(offa + 24L, x1r + x2r);
        a2.setDouble(offa + 25L, x1i + x2i);
        a2.setDouble(offa + 26L, x1r - x2r);
        a2.setDouble(offa + 27L, x1i - x2i);
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setDouble(offa + 28L, x1r - x2i);
        a2.setDouble(offa + 29L, x1i + x2r);
        a2.setDouble(offa + 30L, x1r + x2i);
        a2.setDouble(offa + 31L, x1i - x2r);
    }

    public static void cftf081(double[] a2, int offa, double[] w2, int startw) {
        double wn4r = w2[startw + 1];
        double x0r = a2[offa] + a2[offa + 8];
        double x0i = a2[offa + 1] + a2[offa + 9];
        double x1r = a2[offa] - a2[offa + 8];
        double x1i = a2[offa + 1] - a2[offa + 9];
        double x2r = a2[offa + 4] + a2[offa + 12];
        double x2i = a2[offa + 5] + a2[offa + 13];
        double x3r = a2[offa + 4] - a2[offa + 12];
        double x3i = a2[offa + 5] - a2[offa + 13];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y2r = x0r - x2r;
        double y2i = x0i - x2i;
        double y1r = x1r - x3i;
        double y1i = x1i + x3r;
        double y3r = x1r + x3i;
        double y3i = x1i - x3r;
        x0r = a2[offa + 2] + a2[offa + 10];
        x0i = a2[offa + 3] + a2[offa + 11];
        x1r = a2[offa + 2] - a2[offa + 10];
        x1i = a2[offa + 3] - a2[offa + 11];
        x2r = a2[offa + 6] + a2[offa + 14];
        x2i = a2[offa + 7] + a2[offa + 15];
        x3r = a2[offa + 6] - a2[offa + 14];
        x3i = a2[offa + 7] - a2[offa + 15];
        double y4r = x0r + x2r;
        double y4i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        double y5r = wn4r * (x0r - x0i);
        double y5i = wn4r * (x0r + x0i);
        double y7r = wn4r * (x2r - x2i);
        double y7i = wn4r * (x2r + x2i);
        a2[offa + 8] = y1r + y5r;
        a2[offa + 9] = y1i + y5i;
        a2[offa + 10] = y1r - y5r;
        a2[offa + 11] = y1i - y5i;
        a2[offa + 12] = y3r - y7i;
        a2[offa + 13] = y3i + y7r;
        a2[offa + 14] = y3r + y7i;
        a2[offa + 15] = y3i - y7r;
        a2[offa] = y0r + y4r;
        a2[offa + 1] = y0i + y4i;
        a2[offa + 2] = y0r - y4r;
        a2[offa + 3] = y0i - y4i;
        a2[offa + 4] = y2r - y6i;
        a2[offa + 5] = y2i + y6r;
        a2[offa + 6] = y2r + y6i;
        a2[offa + 7] = y2i - y6r;
    }

    public static void cftf081(DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        double wn4r = w2.getDouble(startw + 1L);
        double x0r = a2.getDouble(offa) + a2.getDouble(offa + 8L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 9L);
        double x1r = a2.getDouble(offa) - a2.getDouble(offa + 8L);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 9L);
        double x2r = a2.getDouble(offa + 4L) + a2.getDouble(offa + 12L);
        double x2i = a2.getDouble(offa + 5L) + a2.getDouble(offa + 13L);
        double x3r = a2.getDouble(offa + 4L) - a2.getDouble(offa + 12L);
        double x3i = a2.getDouble(offa + 5L) - a2.getDouble(offa + 13L);
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y2r = x0r - x2r;
        double y2i = x0i - x2i;
        double y1r = x1r - x3i;
        double y1i = x1i + x3r;
        double y3r = x1r + x3i;
        double y3i = x1i - x3r;
        x0r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 10L);
        x0i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 11L);
        x1r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 10L);
        x1i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 11L);
        x2r = a2.getDouble(offa + 6L) + a2.getDouble(offa + 14L);
        x2i = a2.getDouble(offa + 7L) + a2.getDouble(offa + 15L);
        x3r = a2.getDouble(offa + 6L) - a2.getDouble(offa + 14L);
        x3i = a2.getDouble(offa + 7L) - a2.getDouble(offa + 15L);
        double y4r = x0r + x2r;
        double y4i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        double y5r = wn4r * (x0r - x0i);
        double y5i = wn4r * (x0r + x0i);
        double y7r = wn4r * (x2r - x2i);
        double y7i = wn4r * (x2r + x2i);
        a2.setDouble(offa + 8L, y1r + y5r);
        a2.setDouble(offa + 9L, y1i + y5i);
        a2.setDouble(offa + 10L, y1r - y5r);
        a2.setDouble(offa + 11L, y1i - y5i);
        a2.setDouble(offa + 12L, y3r - y7i);
        a2.setDouble(offa + 13L, y3i + y7r);
        a2.setDouble(offa + 14L, y3r + y7i);
        a2.setDouble(offa + 15L, y3i - y7r);
        a2.setDouble(offa, y0r + y4r);
        a2.setDouble(offa + 1L, y0i + y4i);
        a2.setDouble(offa + 2L, y0r - y4r);
        a2.setDouble(offa + 3L, y0i - y4i);
        a2.setDouble(offa + 4L, y2r - y6i);
        a2.setDouble(offa + 5L, y2i + y6r);
        a2.setDouble(offa + 6L, y2r + y6i);
        a2.setDouble(offa + 7L, y2i - y6r);
    }

    public static void cftf082(double[] a2, int offa, double[] w2, int startw) {
        double wn4r = w2[startw + 1];
        double wk1r = w2[startw + 2];
        double wk1i = w2[startw + 3];
        double y0r = a2[offa] - a2[offa + 9];
        double y0i = a2[offa + 1] + a2[offa + 8];
        double y1r = a2[offa] + a2[offa + 9];
        double y1i = a2[offa + 1] - a2[offa + 8];
        double x0r = a2[offa + 4] - a2[offa + 13];
        double x0i = a2[offa + 5] + a2[offa + 12];
        double y2r = wn4r * (x0r - x0i);
        double y2i = wn4r * (x0i + x0r);
        x0r = a2[offa + 4] + a2[offa + 13];
        x0i = a2[offa + 5] - a2[offa + 12];
        double y3r = wn4r * (x0r - x0i);
        double y3i = wn4r * (x0i + x0r);
        x0r = a2[offa + 2] - a2[offa + 11];
        x0i = a2[offa + 3] + a2[offa + 10];
        double y4r = wk1r * x0r - wk1i * x0i;
        double y4i = wk1r * x0i + wk1i * x0r;
        x0r = a2[offa + 2] + a2[offa + 11];
        x0i = a2[offa + 3] - a2[offa + 10];
        double y5r = wk1i * x0r - wk1r * x0i;
        double y5i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 6] - a2[offa + 15];
        x0i = a2[offa + 7] + a2[offa + 14];
        double y6r = wk1i * x0r - wk1r * x0i;
        double y6i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 6] + a2[offa + 15];
        x0i = a2[offa + 7] - a2[offa + 14];
        double y7r = wk1r * x0r - wk1i * x0i;
        double y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        double x1r = y4r + y6r;
        double x1i = y4i + y6i;
        a2[offa] = x0r + x1r;
        a2[offa + 1] = x0i + x1i;
        a2[offa + 2] = x0r - x1r;
        a2[offa + 3] = x0i - x1i;
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a2[offa + 4] = x0r - x1i;
        a2[offa + 5] = x0i + x1r;
        a2[offa + 6] = x0r + x1i;
        a2[offa + 7] = x0i - x1r;
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a2[offa + 8] = x0r + x1r;
        a2[offa + 9] = x0i + x1i;
        a2[offa + 10] = x0r - x1r;
        a2[offa + 11] = x0i - x1i;
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a2[offa + 12] = x0r - x1i;
        a2[offa + 13] = x0i + x1r;
        a2[offa + 14] = x0r + x1i;
        a2[offa + 15] = x0i - x1r;
    }

    public static void cftf082(DoubleLargeArray a2, long offa, DoubleLargeArray w2, long startw) {
        double wn4r = w2.getDouble(startw + 1L);
        double wk1r = w2.getDouble(startw + 2L);
        double wk1i = w2.getDouble(startw + 3L);
        double y0r = a2.getDouble(offa) - a2.getDouble(offa + 9L);
        double y0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 8L);
        double y1r = a2.getDouble(offa) + a2.getDouble(offa + 9L);
        double y1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 8L);
        double x0r = a2.getDouble(offa + 4L) - a2.getDouble(offa + 13L);
        double x0i = a2.getDouble(offa + 5L) + a2.getDouble(offa + 12L);
        double y2r = wn4r * (x0r - x0i);
        double y2i = wn4r * (x0i + x0r);
        x0r = a2.getDouble(offa + 4L) + a2.getDouble(offa + 13L);
        x0i = a2.getDouble(offa + 5L) - a2.getDouble(offa + 12L);
        double y3r = wn4r * (x0r - x0i);
        double y3i = wn4r * (x0i + x0r);
        x0r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 11L);
        x0i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 10L);
        double y4r = wk1r * x0r - wk1i * x0i;
        double y4i = wk1r * x0i + wk1i * x0r;
        x0r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 11L);
        x0i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 10L);
        double y5r = wk1i * x0r - wk1r * x0i;
        double y5i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getDouble(offa + 6L) - a2.getDouble(offa + 15L);
        x0i = a2.getDouble(offa + 7L) + a2.getDouble(offa + 14L);
        double y6r = wk1i * x0r - wk1r * x0i;
        double y6i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getDouble(offa + 6L) + a2.getDouble(offa + 15L);
        x0i = a2.getDouble(offa + 7L) - a2.getDouble(offa + 14L);
        double y7r = wk1r * x0r - wk1i * x0i;
        double y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        double x1r = y4r + y6r;
        double x1i = y4i + y6i;
        a2.setDouble(offa, x0r + x1r);
        a2.setDouble(offa + 1L, x0i + x1i);
        a2.setDouble(offa + 2L, x0r - x1r);
        a2.setDouble(offa + 3L, x0i - x1i);
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a2.setDouble(offa + 4L, x0r - x1i);
        a2.setDouble(offa + 5L, x0i + x1r);
        a2.setDouble(offa + 6L, x0r + x1i);
        a2.setDouble(offa + 7L, x0i - x1r);
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a2.setDouble(offa + 8L, x0r + x1r);
        a2.setDouble(offa + 9L, x0i + x1i);
        a2.setDouble(offa + 10L, x0r - x1r);
        a2.setDouble(offa + 11L, x0i - x1i);
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a2.setDouble(offa + 12L, x0r - x1i);
        a2.setDouble(offa + 13L, x0i + x1r);
        a2.setDouble(offa + 14L, x0r + x1i);
        a2.setDouble(offa + 15L, x0i - x1r);
    }

    public static void cftf040(double[] a2, int offa) {
        double x0r = a2[offa] + a2[offa + 4];
        double x0i = a2[offa + 1] + a2[offa + 5];
        double x1r = a2[offa] - a2[offa + 4];
        double x1i = a2[offa + 1] - a2[offa + 5];
        double x2r = a2[offa + 2] + a2[offa + 6];
        double x2i = a2[offa + 3] + a2[offa + 7];
        double x3r = a2[offa + 2] - a2[offa + 6];
        double x3i = a2[offa + 3] - a2[offa + 7];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x1r - x3i;
        a2[offa + 3] = x1i + x3r;
        a2[offa + 4] = x0r - x2r;
        a2[offa + 5] = x0i - x2i;
        a2[offa + 6] = x1r + x3i;
        a2[offa + 7] = x1i - x3r;
    }

    public static void cftf040(DoubleLargeArray a2, long offa) {
        double x0r = a2.getDouble(offa) + a2.getDouble(offa + 4L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 5L);
        double x1r = a2.getDouble(offa) - a2.getDouble(offa + 4L);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 5L);
        double x2r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 6L);
        double x2i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 7L);
        double x3r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 7L);
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i + x2i);
        a2.setDouble(offa + 2L, x1r - x3i);
        a2.setDouble(offa + 3L, x1i + x3r);
        a2.setDouble(offa + 4L, x0r - x2r);
        a2.setDouble(offa + 5L, x0i - x2i);
        a2.setDouble(offa + 6L, x1r + x3i);
        a2.setDouble(offa + 7L, x1i - x3r);
    }

    public static void cftb040(double[] a2, int offa) {
        double x0r = a2[offa] + a2[offa + 4];
        double x0i = a2[offa + 1] + a2[offa + 5];
        double x1r = a2[offa] - a2[offa + 4];
        double x1i = a2[offa + 1] - a2[offa + 5];
        double x2r = a2[offa + 2] + a2[offa + 6];
        double x2i = a2[offa + 3] + a2[offa + 7];
        double x3r = a2[offa + 2] - a2[offa + 6];
        double x3i = a2[offa + 3] - a2[offa + 7];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x1r + x3i;
        a2[offa + 3] = x1i - x3r;
        a2[offa + 4] = x0r - x2r;
        a2[offa + 5] = x0i - x2i;
        a2[offa + 6] = x1r - x3i;
        a2[offa + 7] = x1i + x3r;
    }

    public static void cftb040(DoubleLargeArray a2, long offa) {
        double x0r = a2.getDouble(offa) + a2.getDouble(offa + 4L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 5L);
        double x1r = a2.getDouble(offa) - a2.getDouble(offa + 4L);
        double x1i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 5L);
        double x2r = a2.getDouble(offa + 2L) + a2.getDouble(offa + 6L);
        double x2i = a2.getDouble(offa + 3L) + a2.getDouble(offa + 7L);
        double x3r = a2.getDouble(offa + 2L) - a2.getDouble(offa + 6L);
        double x3i = a2.getDouble(offa + 3L) - a2.getDouble(offa + 7L);
        a2.setDouble(offa, x0r + x2r);
        a2.setDouble(offa + 1L, x0i + x2i);
        a2.setDouble(offa + 2L, x1r + x3i);
        a2.setDouble(offa + 3L, x1i - x3r);
        a2.setDouble(offa + 4L, x0r - x2r);
        a2.setDouble(offa + 5L, x0i - x2i);
        a2.setDouble(offa + 6L, x1r - x3i);
        a2.setDouble(offa + 7L, x1i + x3r);
    }

    public static void cftx020(double[] a2, int offa) {
        double x0r = a2[offa] - a2[offa + 2];
        double x0i = -a2[offa + 1] + a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] + a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftx020(DoubleLargeArray a2, long offa) {
        double x0r = a2.getDouble(offa) - a2.getDouble(offa + 2L);
        double x0i = -a2.getDouble(offa + 1L) + a2.getDouble(offa + 3L);
        a2.setDouble(offa, a2.getDouble(offa) + a2.getDouble(offa + 2L));
        a2.setDouble(offa + 1L, a2.getDouble(offa + 1L) + a2.getDouble(offa + 3L));
        a2.setDouble(offa + 2L, x0r);
        a2.setDouble(offa + 3L, x0i);
    }

    public static void cftxb020(double[] a2, int offa) {
        double x0r = a2[offa] - a2[offa + 2];
        double x0i = a2[offa + 1] - a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] + a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftxb020(DoubleLargeArray a2, long offa) {
        double x0r = a2.getDouble(offa) - a2.getDouble(offa + 2L);
        double x0i = a2.getDouble(offa + 1L) - a2.getDouble(offa + 3L);
        a2.setDouble(offa, a2.getDouble(offa) + a2.getDouble(offa + 2L));
        a2.setDouble(offa + 1L, a2.getDouble(offa + 1L) + a2.getDouble(offa + 3L));
        a2.setDouble(offa + 2L, x0r);
        a2.setDouble(offa + 3L, x0i);
    }

    public static void cftxc020(double[] a2, int offa) {
        double x0r = a2[offa] - a2[offa + 2];
        double x0i = a2[offa + 1] + a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] - a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftxc020(DoubleLargeArray a2, long offa) {
        double x0r = a2.getDouble(offa) - a2.getDouble(offa + 2L);
        double x0i = a2.getDouble(offa + 1L) + a2.getDouble(offa + 3L);
        a2.setDouble(offa, a2.getDouble(offa) + a2.getDouble(offa + 2L));
        a2.setDouble(offa + 1L, a2.getDouble(offa + 1L) - a2.getDouble(offa + 3L));
        a2.setDouble(offa + 2L, x0r);
        a2.setDouble(offa + 3L, x0i);
    }

    public static void rftfsub(int n2, double[] a2, int offa, int nc, double[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            double wkr = 0.5 - c2[startc + nc - (kk += ks)];
            double wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            double xr = a2[idx1] - a2[idx2];
            double xi = a2[idx1 + 1] + a2[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            a2[idx1 + 1] = yi - a2[idx1 + 1];
            int n4 = idx2;
            a2[n4] = a2[n4] + yr;
            a2[idx2 + 1] = yi - a2[idx2 + 1];
        }
        a2[offa + m4 + 1] = -a2[offa + m4 + 1];
    }

    public static void rftfsub(long n2, DoubleLargeArray a2, long offa, long nc, DoubleLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            double wkr = 0.5 - c2.getDouble(startc + nc - (kk += ks));
            double wki = c2.getDouble(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            double xr = a2.getDouble(idx1) - a2.getDouble(idx2);
            double xi = a2.getDouble(idx1 + 1L) + a2.getDouble(idx2 + 1L);
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            a2.setDouble(idx1, a2.getDouble(idx1) - yr);
            a2.setDouble(idx1 + 1L, yi - a2.getDouble(idx1 + 1L));
            a2.setDouble(idx2, a2.getDouble(idx2) + yr);
            a2.setDouble(idx2 + 1L, yi - a2.getDouble(idx2 + 1L));
        }
        a2.setDouble(offa + m4 + 1L, -a2.getDouble(offa + m4 + 1L));
    }

    public static void rftbsub(int n2, double[] a2, int offa, int nc, double[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            double wkr = 0.5 - c2[startc + nc - (kk += ks)];
            double wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            double xr = a2[idx1] - a2[idx2];
            double xi = a2[idx1 + 1] + a2[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            int n4 = idx1 + 1;
            a2[n4] = a2[n4] - yi;
            int n5 = idx2;
            a2[n5] = a2[n5] + yr;
            int n6 = idx2 + 1;
            a2[n6] = a2[n6] - yi;
        }
    }

    public static void rftbsub(long n2, DoubleLargeArray a2, long offa, long nc, DoubleLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            double wkr = 0.5 - c2.getDouble(startc + nc - (kk += ks));
            double wki = c2.getDouble(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            double xr = a2.getDouble(idx1) - a2.getDouble(idx2);
            double xi = a2.getDouble(idx1 + 1L) + a2.getDouble(idx2 + 1L);
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            a2.setDouble(idx1, a2.getDouble(idx1) - yr);
            a2.setDouble(idx1 + 1L, a2.getDouble(idx1 + 1L) - yi);
            a2.setDouble(idx2, a2.getDouble(idx2) + yr);
            a2.setDouble(idx2 + 1L, a2.getDouble(idx2 + 1L) - yi);
        }
    }

    public static void dctsub(int n2, double[] a2, int offa, int nc, double[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = nc / n2;
        int kk = 0;
        for (int j2 = 1; j2 < m4; ++j2) {
            int k2 = n2 - j2;
            int idx0 = startc + (kk += ks);
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            double wkr = c2[idx0] - c2[startc + nc - kk];
            double wki = c2[idx0] + c2[startc + nc - kk];
            double xr = wki * a2[idx1] - wkr * a2[idx2];
            a2[idx1] = wkr * a2[idx1] + wki * a2[idx2];
            a2[idx2] = xr;
        }
        int n3 = offa + m4;
        a2[n3] = a2[n3] * c2[startc];
    }

    public static void dctsub(long n2, DoubleLargeArray a2, long offa, long nc, DoubleLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = nc / n2;
        long kk = 0L;
        for (long j2 = 1L; j2 < m4; ++j2) {
            long k2 = n2 - j2;
            long idx0 = startc + (kk += ks);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            double wkr = c2.getDouble(idx0) - c2.getDouble(startc + nc - kk);
            double wki = c2.getDouble(idx0) + c2.getDouble(startc + nc - kk);
            double xr = wki * a2.getDouble(idx1) - wkr * a2.getDouble(idx2);
            a2.setDouble(idx1, wkr * a2.getDouble(idx1) + wki * a2.getDouble(idx2));
            a2.setDouble(idx2, xr);
        }
        a2.setDouble(offa + m4, a2.getDouble(offa + m4) * c2.getDouble(startc));
    }

    public static void cftfsub(int n2, float[] a2, int offa, int[] ip, int nw, float[] w2) {
        if (n2 > 8) {
            if (n2 > 32) {
                CommonUtils.cftf1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && (long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128) {
                    CommonUtils.cftleaf(n2, 1, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2(n2, ip, a2, offa);
            } else if (n2 == 32) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8);
                CommonUtils.bitrv216(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0);
                CommonUtils.bitrv208(a2, offa);
            }
        } else if (n2 == 8) {
            CommonUtils.cftf040(a2, offa);
        } else if (n2 == 4) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftfsub(long n2, FloatLargeArray a2, long offa, LongLargeArray ip, long nw, FloatLargeArray w2) {
        if (n2 > 8L) {
            if (n2 > 32L) {
                CommonUtils.cftf1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512L) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128L) {
                    CommonUtils.cftleaf(n2, 1L, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2l(n2, ip, a2, offa);
            } else if (n2 == 32L) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8L);
                CommonUtils.bitrv216(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0L);
                CommonUtils.bitrv208(a2, offa);
            }
        } else if (n2 == 8L) {
            CommonUtils.cftf040(a2, offa);
        } else if (n2 == 4L) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftbsub(int n2, float[] a2, int offa, int[] ip, int nw, float[] w2) {
        if (n2 > 8) {
            if (n2 > 32) {
                CommonUtils.cftb1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && (long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128) {
                    CommonUtils.cftleaf(n2, 1, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2conj(n2, ip, a2, offa);
            } else if (n2 == 32) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8);
                CommonUtils.bitrv216neg(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0);
                CommonUtils.bitrv208neg(a2, offa);
            }
        } else if (n2 == 8) {
            CommonUtils.cftb040(a2, offa);
        } else if (n2 == 4) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void cftbsub(long n2, FloatLargeArray a2, long offa, LongLargeArray ip, long nw, FloatLargeArray w2) {
        if (n2 > 8L) {
            if (n2 > 32L) {
                CommonUtils.cftb1st(n2, a2, offa, w2, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n2, a2, offa, nw, w2);
                } else if (n2 > 512L) {
                    CommonUtils.cftrec4(n2, a2, offa, nw, w2);
                } else if (n2 > 128L) {
                    CommonUtils.cftleaf(n2, 1L, a2, offa, nw, w2);
                } else {
                    CommonUtils.cftfx41(n2, a2, offa, nw, w2);
                }
                CommonUtils.bitrv2conj(n2, ip, a2, offa);
            } else if (n2 == 32L) {
                CommonUtils.cftf161(a2, offa, w2, nw - 8L);
                CommonUtils.bitrv216neg(a2, offa);
            } else {
                CommonUtils.cftf081(a2, offa, w2, 0L);
                CommonUtils.bitrv208neg(a2, offa);
            }
        } else if (n2 == 8L) {
            CommonUtils.cftb040(a2, offa);
        } else if (n2 == 4L) {
            CommonUtils.cftxb020(a2, offa);
        }
    }

    public static void bitrv2(int n2, int[] ip, float[] a2, int offa) {
        int l2;
        int m4 = 1;
        for (l2 = n2 >> 2; l2 > 8; l2 >>= 2) {
            m4 <<= 1;
        }
        int nh = n2 >> 1;
        int nm = 4 * m4;
        if (l2 == 8) {
            for (int k2 = 0; k2 < m4; ++k2) {
                float yi;
                float yr;
                float xi;
                float xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k2;
                for (int j2 = 0; j2 < k2; ++j2) {
                    j1 = 4 * j2 + 2 * ip[m4 + k2];
                    k1 = idx0 + 2 * ip[m4 + j2];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + 2 * ip[m4 + k2];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
            }
        } else {
            for (int k3 = 0; k3 < m4; ++k3) {
                float yi;
                float yr;
                float xi;
                float xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = 4 * j3 + ip[m4 + k3];
                    k1 = idx0 + ip[m4 + j3];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + ip[m4 + k3];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a2[idx1];
                xi = a2[idx1 + 1];
                yr = a2[idx2];
                yi = a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
            }
        }
    }

    public static void bitrv2l(long n2, LongLargeArray ip, FloatLargeArray a2, long offa) {
        long l2;
        long m4 = 1L;
        for (l2 = n2 >> 2; l2 > 8L; l2 >>= 2) {
            m4 <<= 1;
        }
        long nh = n2 >> 1;
        long nm = 4L * m4;
        if (l2 == 8L) {
            for (long k2 = 0L; k2 < m4; ++k2) {
                float yi;
                float yr;
                float xi;
                float xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k2;
                for (long j2 = 0L; j2 < k2; ++j2) {
                    j1 = 4L * j2 + 2L * ip.getLong(m4 + k2);
                    k1 = idx0 + 2L * ip.getLong(m4 + j2);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                }
                k1 = idx0 + 2L * ip.getLong(m4 + k2);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2L * nm);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 -= 2L);
                idx2 = offa + (k1 -= nh);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nh + 2L);
                idx2 = offa + (k1 += nh + 2L);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2L * nm - 2L);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
            }
        } else {
            for (long k3 = 0L; k3 < m4; ++k3) {
                float yi;
                float yr;
                float xi;
                float xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k3;
                for (long j3 = 0L; j3 < k3; ++j3) {
                    j1 = 4L * j3 + ip.getLong(m4 + k3);
                    k1 = idx0 + ip.getLong(m4 + j3);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                }
                k1 = idx0 + ip.getLong(m4 + k3);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a2.getFloat(idx1);
                xi = a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
            }
        }
    }

    public static void bitrv2conj(int n2, int[] ip, float[] a2, int offa) {
        int l2;
        int m4 = 1;
        for (l2 = n2 >> 2; l2 > 8; l2 >>= 2) {
            m4 <<= 1;
        }
        int nh = n2 >> 1;
        int nm = 4 * m4;
        if (l2 == 8) {
            for (int k2 = 0; k2 < m4; ++k2) {
                float yi;
                float yr;
                float xi;
                float xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k2;
                for (int j2 = 0; j2 < k2; ++j2) {
                    j1 = 4 * j2 + 2 * ip[m4 + k2];
                    k1 = idx0 + 2 * ip[m4 + j2];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + 2 * ip[m4 + k2];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
            }
        } else {
            for (int k3 = 0; k3 < m4; ++k3) {
                float yi;
                float yr;
                float xi;
                float xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = 4 * j3 + ip[m4 + k3];
                    k1 = idx0 + ip[m4 + j3];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2[idx1];
                    xi = -a2[idx1 + 1];
                    yr = a2[idx2];
                    yi = -a2[idx2 + 1];
                    a2[idx1] = yr;
                    a2[idx1 + 1] = yi;
                    a2[idx2] = xr;
                    a2[idx2 + 1] = xi;
                }
                k1 = idx0 + ip[m4 + k3];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a2[idx1 - 1] = -a2[idx1 - 1];
                xr = a2[idx1];
                xi = -a2[idx1 + 1];
                yr = a2[idx2];
                yi = -a2[idx2 + 1];
                a2[idx1] = yr;
                a2[idx1 + 1] = yi;
                a2[idx2] = xr;
                a2[idx2 + 1] = xi;
                a2[idx2 + 3] = -a2[idx2 + 3];
            }
        }
    }

    public static void bitrv2conj(long n2, LongLargeArray ip, FloatLargeArray a2, long offa) {
        long l2;
        long m4 = 1L;
        for (l2 = n2 >> 2; l2 > 8L; l2 >>= 2) {
            m4 <<= 1;
        }
        long nh = n2 >> 1;
        long nm = 4L * m4;
        if (l2 == 8L) {
            for (long k2 = 0L; k2 < m4; ++k2) {
                float yi;
                float yr;
                float xi;
                float xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4L * k2;
                for (long j2 = 0L; j2 < k2; ++j2) {
                    j1 = 4L * j2 + 2L * ip.getLong(m4 + k2);
                    k1 = idx0 + 2L * ip.getLong(m4 + j2);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2L * nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                }
                k1 = idx0 + 2L * ip.getLong(m4 + k2);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2.setFloat(idx1 - 1L, -a2.getFloat(idx1 - 1L));
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                a2.setFloat(idx2 + 3L, -a2.getFloat(idx2 + 3L));
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2L * nm);
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 -= 2L);
                idx2 = offa + (k1 -= nh);
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 += nh + 2L);
                idx2 = offa + (k1 += nh + 2L);
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2L * nm - 2L);
                a2.setFloat(idx1 - 1L, -a2.getFloat(idx1 - 1L));
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                a2.setFloat(idx2 + 3L, -a2.getFloat(idx2 + 3L));
            }
        } else {
            int k3 = 0;
            while ((long)k3 < m4) {
                float yi;
                float yr;
                float xi;
                float xr;
                long idx2;
                long idx1;
                long k1;
                long j1;
                long idx0 = 4 * k3;
                for (int j3 = 0; j3 < k3; ++j3) {
                    j1 = (long)(4 * j3) + ip.getLong(m4 + (long)k3);
                    k1 = idx0 + ip.getLong(m4 + (long)j3);
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2L);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += 2L);
                    idx2 = offa + (k1 += nh);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2L);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a2.getFloat(idx1);
                    xi = -a2.getFloat(idx1 + 1L);
                    yr = a2.getFloat(idx2);
                    yi = -a2.getFloat(idx2 + 1L);
                    a2.setFloat(idx1, yr);
                    a2.setFloat(idx1 + 1L, yi);
                    a2.setFloat(idx2, xr);
                    a2.setFloat(idx2 + 1L, xi);
                }
                k1 = idx0 + ip.getLong(m4 + (long)k3);
                j1 = k1 + 2L;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a2.setFloat(idx1 - 1L, -a2.getFloat(idx1 - 1L));
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                a2.setFloat(idx2 + 3L, -a2.getFloat(idx2 + 3L));
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a2.setFloat(idx1 - 1L, -a2.getFloat(idx1 - 1L));
                xr = a2.getFloat(idx1);
                xi = -a2.getFloat(idx1 + 1L);
                yr = a2.getFloat(idx2);
                yi = -a2.getFloat(idx2 + 1L);
                a2.setFloat(idx1, yr);
                a2.setFloat(idx1 + 1L, yi);
                a2.setFloat(idx2, xr);
                a2.setFloat(idx2 + 1L, xi);
                a2.setFloat(idx2 + 3L, -a2.getFloat(idx2 + 3L));
                ++k3;
            }
        }
    }

    public static void bitrv216(float[] a2, int offa) {
        float x1r = a2[offa + 2];
        float x1i = a2[offa + 3];
        float x2r = a2[offa + 4];
        float x2i = a2[offa + 5];
        float x3r = a2[offa + 6];
        float x3i = a2[offa + 7];
        float x4r = a2[offa + 8];
        float x4i = a2[offa + 9];
        float x5r = a2[offa + 10];
        float x5i = a2[offa + 11];
        float x7r = a2[offa + 14];
        float x7i = a2[offa + 15];
        float x8r = a2[offa + 16];
        float x8i = a2[offa + 17];
        float x10r = a2[offa + 20];
        float x10i = a2[offa + 21];
        float x11r = a2[offa + 22];
        float x11i = a2[offa + 23];
        float x12r = a2[offa + 24];
        float x12i = a2[offa + 25];
        float x13r = a2[offa + 26];
        float x13i = a2[offa + 27];
        float x14r = a2[offa + 28];
        float x14i = a2[offa + 29];
        a2[offa + 2] = x8r;
        a2[offa + 3] = x8i;
        a2[offa + 4] = x4r;
        a2[offa + 5] = x4i;
        a2[offa + 6] = x12r;
        a2[offa + 7] = x12i;
        a2[offa + 8] = x2r;
        a2[offa + 9] = x2i;
        a2[offa + 10] = x10r;
        a2[offa + 11] = x10i;
        a2[offa + 14] = x14r;
        a2[offa + 15] = x14i;
        a2[offa + 16] = x1r;
        a2[offa + 17] = x1i;
        a2[offa + 20] = x5r;
        a2[offa + 21] = x5i;
        a2[offa + 22] = x13r;
        a2[offa + 23] = x13i;
        a2[offa + 24] = x3r;
        a2[offa + 25] = x3i;
        a2[offa + 26] = x11r;
        a2[offa + 27] = x11i;
        a2[offa + 28] = x7r;
        a2[offa + 29] = x7i;
    }

    public static void bitrv216(FloatLargeArray a2, long offa) {
        float x1r = a2.getFloat(offa + 2L);
        float x1i = a2.getFloat(offa + 3L);
        float x2r = a2.getFloat(offa + 4L);
        float x2i = a2.getFloat(offa + 5L);
        float x3r = a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 7L);
        float x4r = a2.getFloat(offa + 8L);
        float x4i = a2.getFloat(offa + 9L);
        float x5r = a2.getFloat(offa + 10L);
        float x5i = a2.getFloat(offa + 11L);
        float x7r = a2.getFloat(offa + 14L);
        float x7i = a2.getFloat(offa + 15L);
        float x8r = a2.getFloat(offa + 16L);
        float x8i = a2.getFloat(offa + 17L);
        float x10r = a2.getFloat(offa + 20L);
        float x10i = a2.getFloat(offa + 21L);
        float x11r = a2.getFloat(offa + 22L);
        float x11i = a2.getFloat(offa + 23L);
        float x12r = a2.getFloat(offa + 24L);
        float x12i = a2.getFloat(offa + 25L);
        float x13r = a2.getFloat(offa + 26L);
        float x13i = a2.getFloat(offa + 27L);
        float x14r = a2.getFloat(offa + 28L);
        float x14i = a2.getFloat(offa + 29L);
        a2.setFloat(offa + 2L, x8r);
        a2.setFloat(offa + 3L, x8i);
        a2.setFloat(offa + 4L, x4r);
        a2.setFloat(offa + 5L, x4i);
        a2.setFloat(offa + 6L, x12r);
        a2.setFloat(offa + 7L, x12i);
        a2.setFloat(offa + 8L, x2r);
        a2.setFloat(offa + 9L, x2i);
        a2.setFloat(offa + 10L, x10r);
        a2.setFloat(offa + 11L, x10i);
        a2.setFloat(offa + 14L, x14r);
        a2.setFloat(offa + 15L, x14i);
        a2.setFloat(offa + 16L, x1r);
        a2.setFloat(offa + 17L, x1i);
        a2.setFloat(offa + 20L, x5r);
        a2.setFloat(offa + 21L, x5i);
        a2.setFloat(offa + 22L, x13r);
        a2.setFloat(offa + 23L, x13i);
        a2.setFloat(offa + 24L, x3r);
        a2.setFloat(offa + 25L, x3i);
        a2.setFloat(offa + 26L, x11r);
        a2.setFloat(offa + 27L, x11i);
        a2.setFloat(offa + 28L, x7r);
        a2.setFloat(offa + 29L, x7i);
    }

    public static void bitrv216neg(float[] a2, int offa) {
        float x1r = a2[offa + 2];
        float x1i = a2[offa + 3];
        float x2r = a2[offa + 4];
        float x2i = a2[offa + 5];
        float x3r = a2[offa + 6];
        float x3i = a2[offa + 7];
        float x4r = a2[offa + 8];
        float x4i = a2[offa + 9];
        float x5r = a2[offa + 10];
        float x5i = a2[offa + 11];
        float x6r = a2[offa + 12];
        float x6i = a2[offa + 13];
        float x7r = a2[offa + 14];
        float x7i = a2[offa + 15];
        float x8r = a2[offa + 16];
        float x8i = a2[offa + 17];
        float x9r = a2[offa + 18];
        float x9i = a2[offa + 19];
        float x10r = a2[offa + 20];
        float x10i = a2[offa + 21];
        float x11r = a2[offa + 22];
        float x11i = a2[offa + 23];
        float x12r = a2[offa + 24];
        float x12i = a2[offa + 25];
        float x13r = a2[offa + 26];
        float x13i = a2[offa + 27];
        float x14r = a2[offa + 28];
        float x14i = a2[offa + 29];
        float x15r = a2[offa + 30];
        float x15i = a2[offa + 31];
        a2[offa + 2] = x15r;
        a2[offa + 3] = x15i;
        a2[offa + 4] = x7r;
        a2[offa + 5] = x7i;
        a2[offa + 6] = x11r;
        a2[offa + 7] = x11i;
        a2[offa + 8] = x3r;
        a2[offa + 9] = x3i;
        a2[offa + 10] = x13r;
        a2[offa + 11] = x13i;
        a2[offa + 12] = x5r;
        a2[offa + 13] = x5i;
        a2[offa + 14] = x9r;
        a2[offa + 15] = x9i;
        a2[offa + 16] = x1r;
        a2[offa + 17] = x1i;
        a2[offa + 18] = x14r;
        a2[offa + 19] = x14i;
        a2[offa + 20] = x6r;
        a2[offa + 21] = x6i;
        a2[offa + 22] = x10r;
        a2[offa + 23] = x10i;
        a2[offa + 24] = x2r;
        a2[offa + 25] = x2i;
        a2[offa + 26] = x12r;
        a2[offa + 27] = x12i;
        a2[offa + 28] = x4r;
        a2[offa + 29] = x4i;
        a2[offa + 30] = x8r;
        a2[offa + 31] = x8i;
    }

    public static void bitrv216neg(FloatLargeArray a2, long offa) {
        float x1r = a2.getFloat(offa + 2L);
        float x1i = a2.getFloat(offa + 3L);
        float x2r = a2.getFloat(offa + 4L);
        float x2i = a2.getFloat(offa + 5L);
        float x3r = a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 7L);
        float x4r = a2.getFloat(offa + 8L);
        float x4i = a2.getFloat(offa + 9L);
        float x5r = a2.getFloat(offa + 10L);
        float x5i = a2.getFloat(offa + 11L);
        float x6r = a2.getFloat(offa + 12L);
        float x6i = a2.getFloat(offa + 13L);
        float x7r = a2.getFloat(offa + 14L);
        float x7i = a2.getFloat(offa + 15L);
        float x8r = a2.getFloat(offa + 16L);
        float x8i = a2.getFloat(offa + 17L);
        float x9r = a2.getFloat(offa + 18L);
        float x9i = a2.getFloat(offa + 19L);
        float x10r = a2.getFloat(offa + 20L);
        float x10i = a2.getFloat(offa + 21L);
        float x11r = a2.getFloat(offa + 22L);
        float x11i = a2.getFloat(offa + 23L);
        float x12r = a2.getFloat(offa + 24L);
        float x12i = a2.getFloat(offa + 25L);
        float x13r = a2.getFloat(offa + 26L);
        float x13i = a2.getFloat(offa + 27L);
        float x14r = a2.getFloat(offa + 28L);
        float x14i = a2.getFloat(offa + 29L);
        float x15r = a2.getFloat(offa + 30L);
        float x15i = a2.getFloat(offa + 31L);
        a2.setFloat(offa + 2L, x15r);
        a2.setFloat(offa + 3L, x15i);
        a2.setFloat(offa + 4L, x7r);
        a2.setFloat(offa + 5L, x7i);
        a2.setFloat(offa + 6L, x11r);
        a2.setFloat(offa + 7L, x11i);
        a2.setFloat(offa + 8L, x3r);
        a2.setFloat(offa + 9L, x3i);
        a2.setFloat(offa + 10L, x13r);
        a2.setFloat(offa + 11L, x13i);
        a2.setFloat(offa + 12L, x5r);
        a2.setFloat(offa + 13L, x5i);
        a2.setFloat(offa + 14L, x9r);
        a2.setFloat(offa + 15L, x9i);
        a2.setFloat(offa + 16L, x1r);
        a2.setFloat(offa + 17L, x1i);
        a2.setFloat(offa + 18L, x14r);
        a2.setFloat(offa + 19L, x14i);
        a2.setFloat(offa + 20L, x6r);
        a2.setFloat(offa + 21L, x6i);
        a2.setFloat(offa + 22L, x10r);
        a2.setFloat(offa + 23L, x10i);
        a2.setFloat(offa + 24L, x2r);
        a2.setFloat(offa + 25L, x2i);
        a2.setFloat(offa + 26L, x12r);
        a2.setFloat(offa + 27L, x12i);
        a2.setFloat(offa + 28L, x4r);
        a2.setFloat(offa + 29L, x4i);
        a2.setFloat(offa + 30L, x8r);
        a2.setFloat(offa + 31L, x8i);
    }

    public static void bitrv208(float[] a2, int offa) {
        float x1r = a2[offa + 2];
        float x1i = a2[offa + 3];
        float x3r = a2[offa + 6];
        float x3i = a2[offa + 7];
        float x4r = a2[offa + 8];
        float x4i = a2[offa + 9];
        float x6r = a2[offa + 12];
        float x6i = a2[offa + 13];
        a2[offa + 2] = x4r;
        a2[offa + 3] = x4i;
        a2[offa + 6] = x6r;
        a2[offa + 7] = x6i;
        a2[offa + 8] = x1r;
        a2[offa + 9] = x1i;
        a2[offa + 12] = x3r;
        a2[offa + 13] = x3i;
    }

    public static void bitrv208(FloatLargeArray a2, long offa) {
        float x1r = a2.getFloat(offa + 2L);
        float x1i = a2.getFloat(offa + 3L);
        float x3r = a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 7L);
        float x4r = a2.getFloat(offa + 8L);
        float x4i = a2.getFloat(offa + 9L);
        float x6r = a2.getFloat(offa + 12L);
        float x6i = a2.getFloat(offa + 13L);
        a2.setFloat(offa + 2L, x4r);
        a2.setFloat(offa + 3L, x4i);
        a2.setFloat(offa + 6L, x6r);
        a2.setFloat(offa + 7L, x6i);
        a2.setFloat(offa + 8L, x1r);
        a2.setFloat(offa + 9L, x1i);
        a2.setFloat(offa + 12L, x3r);
        a2.setFloat(offa + 13L, x3i);
    }

    public static void bitrv208neg(float[] a2, int offa) {
        float x1r = a2[offa + 2];
        float x1i = a2[offa + 3];
        float x2r = a2[offa + 4];
        float x2i = a2[offa + 5];
        float x3r = a2[offa + 6];
        float x3i = a2[offa + 7];
        float x4r = a2[offa + 8];
        float x4i = a2[offa + 9];
        float x5r = a2[offa + 10];
        float x5i = a2[offa + 11];
        float x6r = a2[offa + 12];
        float x6i = a2[offa + 13];
        float x7r = a2[offa + 14];
        float x7i = a2[offa + 15];
        a2[offa + 2] = x7r;
        a2[offa + 3] = x7i;
        a2[offa + 4] = x3r;
        a2[offa + 5] = x3i;
        a2[offa + 6] = x5r;
        a2[offa + 7] = x5i;
        a2[offa + 8] = x1r;
        a2[offa + 9] = x1i;
        a2[offa + 10] = x6r;
        a2[offa + 11] = x6i;
        a2[offa + 12] = x2r;
        a2[offa + 13] = x2i;
        a2[offa + 14] = x4r;
        a2[offa + 15] = x4i;
    }

    public static void bitrv208neg(FloatLargeArray a2, long offa) {
        float x1r = a2.getFloat(offa + 2L);
        float x1i = a2.getFloat(offa + 3L);
        float x2r = a2.getFloat(offa + 4L);
        float x2i = a2.getFloat(offa + 5L);
        float x3r = a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 7L);
        float x4r = a2.getFloat(offa + 8L);
        float x4i = a2.getFloat(offa + 9L);
        float x5r = a2.getFloat(offa + 10L);
        float x5i = a2.getFloat(offa + 11L);
        float x6r = a2.getFloat(offa + 12L);
        float x6i = a2.getFloat(offa + 13L);
        float x7r = a2.getFloat(offa + 14L);
        float x7i = a2.getFloat(offa + 15L);
        a2.setFloat(offa + 2L, x7r);
        a2.setFloat(offa + 3L, x7i);
        a2.setFloat(offa + 4L, x3r);
        a2.setFloat(offa + 5L, x3i);
        a2.setFloat(offa + 6L, x5r);
        a2.setFloat(offa + 7L, x5i);
        a2.setFloat(offa + 8L, x1r);
        a2.setFloat(offa + 9L, x1i);
        a2.setFloat(offa + 10L, x6r);
        a2.setFloat(offa + 11L, x6i);
        a2.setFloat(offa + 12L, x2r);
        a2.setFloat(offa + 13L, x2i);
        a2.setFloat(offa + 14L, x4r);
        a2.setFloat(offa + 15L, x4i);
    }

    public static void cftf1st(int n2, float[] a2, int offa, float[] w2, int startw) {
        int idx0;
        int j0;
        float wk3i;
        float wk3r;
        float wk1i;
        float wk1r;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        float x0r = a2[offa] + a2[idx2];
        float x0i = a2[offa + 1] + a2[idx2 + 1];
        float x1r = a2[offa] - a2[idx2];
        float x1i = a2[offa + 1] - a2[idx2 + 1];
        float x2r = a2[idx1] + a2[idx3];
        float x2i = a2[idx1 + 1] + a2[idx3 + 1];
        float x3r = a2[idx1] - a2[idx3];
        float x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        a2[idx2] = x1r - x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r + x3i;
        a2[idx3 + 1] = x1i - x3r;
        float wn4r = w2[startw + 1];
        float csc1 = w2[startw + 2];
        float csc3 = w2[startw + 3];
        float wd1r = 1.0f;
        float wd1i = 0.0f;
        float wd3r = 1.0f;
        float wd3i = 0.0f;
        int k2 = 0;
        for (int j4 = 2; j4 < mh - 2; j4 += 4) {
            int idx4 = startw + (k2 += 4);
            wk1r = csc1 * (wd1r + w2[idx4]);
            wk1i = csc1 * (wd1i + w2[idx4 + 1]);
            wk3r = csc3 * (wd3r + w2[idx4 + 2]);
            wk3i = csc3 * (wd3i + w2[idx4 + 3]);
            wd1r = w2[idx4];
            wd1i = w2[idx4 + 1];
            wd3r = w2[idx4 + 2];
            wd3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = a2[idx5 + 1] + a2[idx2 + 1];
            x1r = a2[idx5] - a2[idx2];
            x1i = a2[idx5 + 1] - a2[idx2 + 1];
            float y0r = a2[idx5 + 2] + a2[idx2 + 2];
            float y0i = a2[idx5 + 3] + a2[idx2 + 3];
            float y1r = a2[idx5 + 2] - a2[idx2 + 2];
            float y1i = a2[idx5 + 3] - a2[idx2 + 3];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            float y2r = a2[idx1 + 2] + a2[idx3 + 2];
            float y2i = a2[idx1 + 3] + a2[idx3 + 3];
            float y3r = a2[idx1 + 2] - a2[idx3 + 2];
            float y3i = a2[idx1 + 3] - a2[idx3 + 3];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i + x2i;
            a2[idx5 + 2] = y0r + y2r;
            a2[idx5 + 3] = y0i + y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            a2[idx1 + 2] = y0r - y2r;
            a2[idx1 + 3] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a2[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a2[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = a2[idx0 + 1] + a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = a2[idx0 + 1] - a2[idx2 + 1];
            y0r = a2[idx0 - 2] + a2[idx2 - 2];
            y0i = a2[idx0 - 1] + a2[idx2 - 1];
            y1r = a2[idx0 - 2] - a2[idx2 - 2];
            y1i = a2[idx0 - 1] - a2[idx2 - 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            y2r = a2[idx1 - 2] + a2[idx3 - 2];
            y2i = a2[idx1 - 1] + a2[idx3 - 1];
            y3r = a2[idx1 - 2] - a2[idx3 - 2];
            y3i = a2[idx1 - 1] - a2[idx3 - 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i + x2i;
            a2[idx0 - 2] = y0r + y2r;
            a2[idx0 - 1] = y0i + y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            a2[idx1 - 2] = y0r - y2r;
            a2[idx1 - 1] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a2[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2[offa + j3 - 2] = wd3i * x0r + wd3r * x0i;
            a2[offa + j3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0 - 2] + a2[idx2 - 2];
        x0i = a2[idx0 - 1] + a2[idx2 - 1];
        x1r = a2[idx0 - 2] - a2[idx2 - 2];
        x1i = a2[idx0 - 1] - a2[idx2 - 1];
        x2r = a2[idx1 - 2] + a2[idx3 - 2];
        x2i = a2[idx1 - 1] + a2[idx3 - 1];
        x3r = a2[idx1 - 2] - a2[idx3 - 2];
        x3i = a2[idx1 - 1] - a2[idx3 - 1];
        a2[idx0 - 2] = x0r + x2r;
        a2[idx0 - 1] = x0i + x2i;
        a2[idx1 - 2] = x0r - x2r;
        a2[idx1 - 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a2[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a2[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a2[idx0] + a2[idx2];
        x0i = a2[idx0 + 1] + a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = a2[idx0 + 1] - a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a2[idx0 + 2] + a2[idx2 + 2];
        x0i = a2[idx0 + 3] + a2[idx2 + 3];
        x1r = a2[idx0 + 2] - a2[idx2 + 2];
        x1i = a2[idx0 + 3] - a2[idx2 + 3];
        x2r = a2[idx1 + 2] + a2[idx3 + 2];
        x2i = a2[idx1 + 3] + a2[idx3 + 3];
        x3r = a2[idx1 + 2] - a2[idx3 + 2];
        x3i = a2[idx1 + 3] - a2[idx3 + 3];
        a2[idx0 + 2] = x0r + x2r;
        a2[idx0 + 3] = x0i + x2i;
        a2[idx1 + 2] = x0r - x2r;
        a2[idx1 + 3] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a2[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a2[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    public static void cftf1st(long n2, FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        long idx0;
        long j0;
        float wk3i;
        float wk3r;
        float wk1i;
        float wk1r;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        float x0r = a2.getFloat(offa) + a2.getFloat(idx2);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(idx2 + 1L);
        float x1r = a2.getFloat(offa) - a2.getFloat(idx2);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(idx2 + 1L);
        float x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        float x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        float x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        float x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i + x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i - x2i);
        a2.setFloat(idx2, x1r - x3i);
        a2.setFloat(idx2 + 1L, x1i + x3r);
        a2.setFloat(idx3, x1r + x3i);
        a2.setFloat(idx3 + 1L, x1i - x3r);
        float wn4r = w2.getFloat(startw + 1L);
        float csc1 = w2.getFloat(startw + 2L);
        float csc3 = w2.getFloat(startw + 3L);
        float wd1r = 1.0f;
        float wd1i = 0.0f;
        float wd3r = 1.0f;
        float wd3i = 0.0f;
        long k2 = 0L;
        int j4 = 2;
        while ((long)j4 < mh - 2L) {
            long idx4 = startw + (k2 += 4L);
            wk1r = csc1 * (wd1r + w2.getFloat(idx4));
            wk1i = csc1 * (wd1i + w2.getFloat(idx4 + 1L));
            wk3r = csc3 * (wd3r + w2.getFloat(idx4 + 2L));
            wk3i = csc3 * (wd3i + w2.getFloat(idx4 + 3L));
            wd1r = w2.getFloat(idx4);
            wd1i = w2.getFloat(idx4 + 1L);
            wd3r = w2.getFloat(idx4 + 2L);
            wd3i = w2.getFloat(idx4 + 3L);
            j1 = (long)j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + (long)j4;
            x0r = a2.getFloat(idx5) + a2.getFloat(idx2);
            x0i = a2.getFloat(idx5 + 1L) + a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx5) - a2.getFloat(idx2);
            x1i = a2.getFloat(idx5 + 1L) - a2.getFloat(idx2 + 1L);
            float y0r = a2.getFloat(idx5 + 2L) + a2.getFloat(idx2 + 2L);
            float y0i = a2.getFloat(idx5 + 3L) + a2.getFloat(idx2 + 3L);
            float y1r = a2.getFloat(idx5 + 2L) - a2.getFloat(idx2 + 2L);
            float y1i = a2.getFloat(idx5 + 3L) - a2.getFloat(idx2 + 3L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            float y2r = a2.getFloat(idx1 + 2L) + a2.getFloat(idx3 + 2L);
            float y2i = a2.getFloat(idx1 + 3L) + a2.getFloat(idx3 + 3L);
            float y3r = a2.getFloat(idx1 + 2L) - a2.getFloat(idx3 + 2L);
            float y3i = a2.getFloat(idx1 + 3L) - a2.getFloat(idx3 + 3L);
            a2.setFloat(idx5, x0r + x2r);
            a2.setFloat(idx5 + 1L, x0i + x2i);
            a2.setFloat(idx5 + 2L, y0r + y2r);
            a2.setFloat(idx5 + 3L, y0i + y2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i - x2i);
            a2.setFloat(idx1 + 2L, y0r - y2r);
            a2.setFloat(idx1 + 3L, y0i - y2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1r * x0r - wk1i * x0i);
            a2.setFloat(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2.setFloat(idx2 + 2L, wd1r * x0r - wd1i * x0i);
            a2.setFloat(idx2 + 3L, wd1r * x0i + wd1i * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3r * x0r + wk3i * x0i);
            a2.setFloat(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2.setFloat(idx3 + 2L, wd3r * x0r + wd3i * x0i);
            a2.setFloat(idx3 + 3L, wd3r * x0i - wd3i * x0r);
            j0 = m4 - (long)j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
            x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
            x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
            y0r = a2.getFloat(idx0 - 2L) + a2.getFloat(idx2 - 2L);
            y0i = a2.getFloat(idx0 - 1L) + a2.getFloat(idx2 - 1L);
            y1r = a2.getFloat(idx0 - 2L) - a2.getFloat(idx2 - 2L);
            y1i = a2.getFloat(idx0 - 1L) - a2.getFloat(idx2 - 1L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            y2r = a2.getFloat(idx1 - 2L) + a2.getFloat(idx3 - 2L);
            y2i = a2.getFloat(idx1 - 1L) + a2.getFloat(idx3 - 1L);
            y3r = a2.getFloat(idx1 - 2L) - a2.getFloat(idx3 - 2L);
            y3i = a2.getFloat(idx1 - 1L) - a2.getFloat(idx3 - 1L);
            a2.setFloat(idx0, x0r + x2r);
            a2.setFloat(idx0 + 1L, x0i + x2i);
            a2.setFloat(idx0 - 2L, y0r + y2r);
            a2.setFloat(idx0 - 1L, y0i + y2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i - x2i);
            a2.setFloat(idx1 - 2L, y0r - y2r);
            a2.setFloat(idx1 - 1L, y0i - y2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1i * x0r - wk1r * x0i);
            a2.setFloat(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a2.setFloat(idx2 - 2L, wd1i * x0r - wd1r * x0i);
            a2.setFloat(idx2 - 1L, wd1i * x0i + wd1r * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3i * x0r + wk3r * x0i);
            a2.setFloat(idx3 + 1L, wk3i * x0i - wk3r * x0r);
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a2.setFloat(offa + j3 - 2L, wd3i * x0r + wd3r * x0i);
            a2.setFloat(offa + j3 - 1L, wd3i * x0i - wd3r * x0r);
            j4 += 4;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getFloat(idx0 - 2L) + a2.getFloat(idx2 - 2L);
        x0i = a2.getFloat(idx0 - 1L) + a2.getFloat(idx2 - 1L);
        x1r = a2.getFloat(idx0 - 2L) - a2.getFloat(idx2 - 2L);
        x1i = a2.getFloat(idx0 - 1L) - a2.getFloat(idx2 - 1L);
        x2r = a2.getFloat(idx1 - 2L) + a2.getFloat(idx3 - 2L);
        x2i = a2.getFloat(idx1 - 1L) + a2.getFloat(idx3 - 1L);
        x3r = a2.getFloat(idx1 - 2L) - a2.getFloat(idx3 - 2L);
        x3i = a2.getFloat(idx1 - 1L) - a2.getFloat(idx3 - 1L);
        a2.setFloat(idx0 - 2L, x0r + x2r);
        a2.setFloat(idx0 - 1L, x0i + x2i);
        a2.setFloat(idx1 - 2L, x0r - x2r);
        a2.setFloat(idx1 - 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2 - 2L, wk1r * x0r - wk1i * x0i);
        a2.setFloat(idx2 - 1L, wk1r * x0i + wk1i * x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3 - 2L, wk3r * x0r + wk3i * x0i);
        a2.setFloat(idx3 - 1L, wk3r * x0i - wk3i * x0r);
        x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
        x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
        x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
        x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
        x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(idx0, x0r + x2r);
        a2.setFloat(idx0 + 1L, x0i + x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2, wn4r * (x0r - x0i));
        a2.setFloat(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3, -wn4r * (x0r + x0i));
        a2.setFloat(idx3 + 1L, -wn4r * (x0i - x0r));
        x0r = a2.getFloat(idx0 + 2L) + a2.getFloat(idx2 + 2L);
        x0i = a2.getFloat(idx0 + 3L) + a2.getFloat(idx2 + 3L);
        x1r = a2.getFloat(idx0 + 2L) - a2.getFloat(idx2 + 2L);
        x1i = a2.getFloat(idx0 + 3L) - a2.getFloat(idx2 + 3L);
        x2r = a2.getFloat(idx1 + 2L) + a2.getFloat(idx3 + 2L);
        x2i = a2.getFloat(idx1 + 3L) + a2.getFloat(idx3 + 3L);
        x3r = a2.getFloat(idx1 + 2L) - a2.getFloat(idx3 + 2L);
        x3i = a2.getFloat(idx1 + 3L) - a2.getFloat(idx3 + 3L);
        a2.setFloat(idx0 + 2L, x0r + x2r);
        a2.setFloat(idx0 + 3L, x0i + x2i);
        a2.setFloat(idx1 + 2L, x0r - x2r);
        a2.setFloat(idx1 + 3L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2 + 2L, wk1i * x0r - wk1r * x0i);
        a2.setFloat(idx2 + 3L, wk1i * x0i + wk1r * x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3 + 2L, wk3i * x0r + wk3r * x0i);
        a2.setFloat(idx3 + 3L, wk3i * x0i - wk3r * x0r);
    }

    public static void cftb1st(int n2, float[] a2, int offa, float[] w2, int startw) {
        int idx0;
        int j0;
        float wk3i;
        float wk3r;
        float wk1i;
        float wk1r;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        float x0r = a2[offa] + a2[idx2];
        float x0i = -a2[offa + 1] - a2[idx2 + 1];
        float x1r = a2[offa] - a2[idx2];
        float x1i = -a2[offa + 1] + a2[idx2 + 1];
        float x2r = a2[idx1] + a2[idx3];
        float x2i = a2[idx1 + 1] + a2[idx3 + 1];
        float x3r = a2[idx1] - a2[idx3];
        float x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i - x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i + x2i;
        a2[idx2] = x1r + x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r - x3i;
        a2[idx3 + 1] = x1i - x3r;
        float wn4r = w2[startw + 1];
        float csc1 = w2[startw + 2];
        float csc3 = w2[startw + 3];
        float wd1r = 1.0f;
        float wd1i = 0.0f;
        float wd3r = 1.0f;
        float wd3i = 0.0f;
        int k2 = 0;
        for (int j4 = 2; j4 < mh - 2; j4 += 4) {
            int idx4 = startw + (k2 += 4);
            wk1r = csc1 * (wd1r + w2[idx4]);
            wk1i = csc1 * (wd1i + w2[idx4 + 1]);
            wk3r = csc3 * (wd3r + w2[idx4 + 2]);
            wk3i = csc3 * (wd3i + w2[idx4 + 3]);
            wd1r = w2[idx4];
            wd1i = w2[idx4 + 1];
            wd3r = w2[idx4 + 2];
            wd3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = -a2[idx5 + 1] - a2[idx2 + 1];
            x1r = a2[idx5] - a2[offa + j2];
            x1i = -a2[idx5 + 1] + a2[idx2 + 1];
            float y0r = a2[idx5 + 2] + a2[idx2 + 2];
            float y0i = -a2[idx5 + 3] - a2[idx2 + 3];
            float y1r = a2[idx5 + 2] - a2[idx2 + 2];
            float y1i = -a2[idx5 + 3] + a2[idx2 + 3];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            float y2r = a2[idx1 + 2] + a2[idx3 + 2];
            float y2i = a2[idx1 + 3] + a2[idx3 + 3];
            float y3r = a2[idx1 + 2] - a2[idx3 + 2];
            float y3i = a2[idx1 + 3] - a2[idx3 + 3];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i - x2i;
            a2[idx5 + 2] = y0r + y2r;
            a2[idx5 + 3] = y0i - y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i + x2i;
            a2[idx1 + 2] = y0r - y2r;
            a2[idx1 + 3] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a2[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a2[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = -a2[idx0 + 1] - a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = -a2[idx0 + 1] + a2[idx2 + 1];
            y0r = a2[idx0 - 2] + a2[idx2 - 2];
            y0i = -a2[idx0 - 1] - a2[idx2 - 1];
            y1r = a2[idx0 - 2] - a2[idx2 - 2];
            y1i = -a2[idx0 - 1] + a2[idx2 - 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            y2r = a2[idx1 - 2] + a2[idx3 - 2];
            y2i = a2[idx1 - 1] + a2[idx3 - 1];
            y3r = a2[idx1 - 2] - a2[idx3 - 2];
            y3i = a2[idx1 - 1] - a2[idx3 - 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i - x2i;
            a2[idx0 - 2] = y0r + y2r;
            a2[idx0 - 1] = y0i - y2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i + x2i;
            a2[idx1 - 2] = y0r - y2r;
            a2[idx1 - 1] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a2[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2[idx3 - 2] = wd3i * x0r + wd3r * x0i;
            a2[idx3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0 - 2] + a2[idx2 - 2];
        x0i = -a2[idx0 - 1] - a2[idx2 - 1];
        x1r = a2[idx0 - 2] - a2[idx2 - 2];
        x1i = -a2[idx0 - 1] + a2[idx2 - 1];
        x2r = a2[idx1 - 2] + a2[idx3 - 2];
        x2i = a2[idx1 - 1] + a2[idx3 - 1];
        x3r = a2[idx1 - 2] - a2[idx3 - 2];
        x3i = a2[idx1 - 1] - a2[idx3 - 1];
        a2[idx0 - 2] = x0r + x2r;
        a2[idx0 - 1] = x0i - x2i;
        a2[idx1 - 2] = x0r - x2r;
        a2[idx1 - 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a2[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a2[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a2[idx0] + a2[idx2];
        x0i = -a2[idx0 + 1] - a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = -a2[idx0 + 1] + a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i - x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a2[idx0 + 2] + a2[idx2 + 2];
        x0i = -a2[idx0 + 3] - a2[idx2 + 3];
        x1r = a2[idx0 + 2] - a2[idx2 + 2];
        x1i = -a2[idx0 + 3] + a2[idx2 + 3];
        x2r = a2[idx1 + 2] + a2[idx3 + 2];
        x2i = a2[idx1 + 3] + a2[idx3 + 3];
        x3r = a2[idx1 + 2] - a2[idx3 + 2];
        x3i = a2[idx1 + 3] - a2[idx3 + 3];
        a2[idx0 + 2] = x0r + x2r;
        a2[idx0 + 3] = x0i - x2i;
        a2[idx1 + 2] = x0r - x2r;
        a2[idx1 + 3] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a2[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a2[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    public static void cftb1st(long n2, FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        long idx0;
        long j0;
        float wk3i;
        float wk3r;
        float wk1i;
        float wk1r;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        float x0r = a2.getFloat(offa) + a2.getFloat(idx2);
        float x0i = -a2.getFloat(offa + 1L) - a2.getFloat(idx2 + 1L);
        float x1r = a2.getFloat(offa) - a2.getFloat(idx2);
        float x1i = -a2.getFloat(offa + 1L) + a2.getFloat(idx2 + 1L);
        float x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        float x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        float x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        float x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i - x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i + x2i);
        a2.setFloat(idx2, x1r + x3i);
        a2.setFloat(idx2 + 1L, x1i + x3r);
        a2.setFloat(idx3, x1r - x3i);
        a2.setFloat(idx3 + 1L, x1i - x3r);
        float wn4r = w2.getFloat(startw + 1L);
        float csc1 = w2.getFloat(startw + 2L);
        float csc3 = w2.getFloat(startw + 3L);
        float wd1r = 1.0f;
        float wd1i = 0.0f;
        float wd3r = 1.0f;
        float wd3i = 0.0f;
        long k2 = 0L;
        for (long j4 = 2L; j4 < mh - 2L; j4 += 4L) {
            long idx4 = startw + (k2 += 4L);
            wk1r = csc1 * (wd1r + w2.getFloat(idx4));
            wk1i = csc1 * (wd1i + w2.getFloat(idx4 + 1L));
            wk3r = csc3 * (wd3r + w2.getFloat(idx4 + 2L));
            wk3i = csc3 * (wd3i + w2.getFloat(idx4 + 3L));
            wd1r = w2.getFloat(idx4);
            wd1i = w2.getFloat(idx4 + 1L);
            wd3r = w2.getFloat(idx4 + 2L);
            wd3i = w2.getFloat(idx4 + 3L);
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + j4;
            x0r = a2.getFloat(idx5) + a2.getFloat(idx2);
            x0i = -a2.getFloat(idx5 + 1L) - a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx5) - a2.getFloat(offa + j2);
            x1i = -a2.getFloat(idx5 + 1L) + a2.getFloat(idx2 + 1L);
            float y0r = a2.getFloat(idx5 + 2L) + a2.getFloat(idx2 + 2L);
            float y0i = -a2.getFloat(idx5 + 3L) - a2.getFloat(idx2 + 3L);
            float y1r = a2.getFloat(idx5 + 2L) - a2.getFloat(idx2 + 2L);
            float y1i = -a2.getFloat(idx5 + 3L) + a2.getFloat(idx2 + 3L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            float y2r = a2.getFloat(idx1 + 2L) + a2.getFloat(idx3 + 2L);
            float y2i = a2.getFloat(idx1 + 3L) + a2.getFloat(idx3 + 3L);
            float y3r = a2.getFloat(idx1 + 2L) - a2.getFloat(idx3 + 2L);
            float y3i = a2.getFloat(idx1 + 3L) - a2.getFloat(idx3 + 3L);
            a2.setFloat(idx5, x0r + x2r);
            a2.setFloat(idx5 + 1L, x0i - x2i);
            a2.setFloat(idx5 + 2L, y0r + y2r);
            a2.setFloat(idx5 + 3L, y0i - y2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i + x2i);
            a2.setFloat(idx1 + 2L, y0r - y2r);
            a2.setFloat(idx1 + 3L, y0i + y2i);
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1r * x0r - wk1i * x0i);
            a2.setFloat(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2.setFloat(idx2 + 2L, wd1r * x0r - wd1i * x0i);
            a2.setFloat(idx2 + 3L, wd1r * x0i + wd1i * x0r);
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3r * x0r + wk3i * x0i);
            a2.setFloat(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2.setFloat(idx3 + 2L, wd3r * x0r + wd3i * x0i);
            a2.setFloat(idx3 + 3L, wd3r * x0i - wd3i * x0r);
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
            x0i = -a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
            x1i = -a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
            y0r = a2.getFloat(idx0 - 2L) + a2.getFloat(idx2 - 2L);
            y0i = -a2.getFloat(idx0 - 1L) - a2.getFloat(idx2 - 1L);
            y1r = a2.getFloat(idx0 - 2L) - a2.getFloat(idx2 - 2L);
            y1i = -a2.getFloat(idx0 - 1L) + a2.getFloat(idx2 - 1L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            y2r = a2.getFloat(idx1 - 2L) + a2.getFloat(idx3 - 2L);
            y2i = a2.getFloat(idx1 - 1L) + a2.getFloat(idx3 - 1L);
            y3r = a2.getFloat(idx1 - 2L) - a2.getFloat(idx3 - 2L);
            y3i = a2.getFloat(idx1 - 1L) - a2.getFloat(idx3 - 1L);
            a2.setFloat(idx0, x0r + x2r);
            a2.setFloat(idx0 + 1L, x0i - x2i);
            a2.setFloat(idx0 - 2L, y0r + y2r);
            a2.setFloat(idx0 - 1L, y0i - y2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i + x2i);
            a2.setFloat(idx1 - 2L, y0r - y2r);
            a2.setFloat(idx1 - 1L, y0i + y2i);
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1i * x0r - wk1r * x0i);
            a2.setFloat(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a2.setFloat(idx2 - 2L, wd1i * x0r - wd1r * x0i);
            a2.setFloat(idx2 - 1L, wd1i * x0i + wd1r * x0r);
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3i * x0r + wk3r * x0i);
            a2.setFloat(idx3 + 1L, wk3i * x0i - wk3r * x0r);
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a2.setFloat(idx3 - 2L, wd3i * x0r + wd3r * x0i);
            a2.setFloat(idx3 - 1L, wd3i * x0i - wd3r * x0r);
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getFloat(idx0 - 2L) + a2.getFloat(idx2 - 2L);
        x0i = -a2.getFloat(idx0 - 1L) - a2.getFloat(idx2 - 1L);
        x1r = a2.getFloat(idx0 - 2L) - a2.getFloat(idx2 - 2L);
        x1i = -a2.getFloat(idx0 - 1L) + a2.getFloat(idx2 - 1L);
        x2r = a2.getFloat(idx1 - 2L) + a2.getFloat(idx3 - 2L);
        x2i = a2.getFloat(idx1 - 1L) + a2.getFloat(idx3 - 1L);
        x3r = a2.getFloat(idx1 - 2L) - a2.getFloat(idx3 - 2L);
        x3i = a2.getFloat(idx1 - 1L) - a2.getFloat(idx3 - 1L);
        a2.setFloat(idx0 - 2L, x0r + x2r);
        a2.setFloat(idx0 - 1L, x0i - x2i);
        a2.setFloat(idx1 - 2L, x0r - x2r);
        a2.setFloat(idx1 - 1L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2 - 2L, wk1r * x0r - wk1i * x0i);
        a2.setFloat(idx2 - 1L, wk1r * x0i + wk1i * x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3 - 2L, wk3r * x0r + wk3i * x0i);
        a2.setFloat(idx3 - 1L, wk3r * x0i - wk3i * x0r);
        x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
        x0i = -a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
        x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
        x1i = -a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
        x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(idx0, x0r + x2r);
        a2.setFloat(idx0 + 1L, x0i - x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2, wn4r * (x0r - x0i));
        a2.setFloat(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3, -wn4r * (x0r + x0i));
        a2.setFloat(idx3 + 1L, -wn4r * (x0i - x0r));
        x0r = a2.getFloat(idx0 + 2L) + a2.getFloat(idx2 + 2L);
        x0i = -a2.getFloat(idx0 + 3L) - a2.getFloat(idx2 + 3L);
        x1r = a2.getFloat(idx0 + 2L) - a2.getFloat(idx2 + 2L);
        x1i = -a2.getFloat(idx0 + 3L) + a2.getFloat(idx2 + 3L);
        x2r = a2.getFloat(idx1 + 2L) + a2.getFloat(idx3 + 2L);
        x2i = a2.getFloat(idx1 + 3L) + a2.getFloat(idx3 + 3L);
        x3r = a2.getFloat(idx1 + 2L) - a2.getFloat(idx3 + 2L);
        x3i = a2.getFloat(idx1 + 3L) - a2.getFloat(idx3 + 3L);
        a2.setFloat(idx0 + 2L, x0r + x2r);
        a2.setFloat(idx0 + 3L, x0i - x2i);
        a2.setFloat(idx1 + 2L, x0r - x2r);
        a2.setFloat(idx1 + 3L, x0i + x2i);
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2 + 2L, wk1i * x0r - wk1r * x0i);
        a2.setFloat(idx2 + 3L, wk1i * x0i + wk1r * x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3 + 2L, wk3i * x0r + wk3r * x0i);
        a2.setFloat(idx3 + 3L, wk3i * x0i - wk3r * x0r);
    }

    public static void cftrec4_th(final int n2, final float[] a2, int offa, final int nw, final float[] w2) {
        int idx = 0;
        int nthreads = 2;
        int idiv4 = 0;
        int m4 = n2 >> 1;
        if ((long)n2 >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthreads = 4;
            idiv4 = 1;
            m4 >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final int mf = m4;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int firstIdx = offa + i2 * m4;
            futures[idx++] = i2 != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int m4 = n2;
                    while (m4 > 512) {
                        CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
                    }
                    CommonUtils.cftleaf(m4, 1, a2, idx1 - m4, nw, w2);
                    int k2 = 0;
                    int idx2 = firstIdx - m4;
                    for (int j2 = mf - m4; j2 > 0; j2 -= m4) {
                        int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int k2 = 1;
                    int m4 = n2;
                    while (m4 > 512) {
                        k2 <<= 2;
                        CommonUtils.cftmdl2(m4 >>= 2, a2, idx1 - m4, w2, nw - m4);
                    }
                    CommonUtils.cftleaf(m4, 0, a2, idx1 - m4, nw, w2);
                    k2 >>= 1;
                    int idx2 = firstIdx - m4;
                    for (int j2 = mf - m4; j2 > 0; j2 -= m4) {
                        int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cftrec4_th(final long n2, final FloatLargeArray a2, long offa, final long nw, final FloatLargeArray w2) {
        int idx = 0;
        int nthreads = 2;
        int idiv4 = 0;
        long m4 = n2 >> 1;
        if (n2 >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthreads = 4;
            idiv4 = 1;
            m4 >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final long mf = m4;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long firstIdx = offa + (long)i2 * m4;
            futures[idx++] = i2 != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    long idx1 = firstIdx + mf;
                    long m4 = n2;
                    while (m4 > 512L) {
                        CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
                    }
                    CommonUtils.cftleaf(m4, 1L, a2, idx1 - m4, nw, w2);
                    long k2 = 0L;
                    long idx2 = firstIdx - m4;
                    for (long j2 = mf - m4; j2 > 0L; j2 -= m4) {
                        long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    long idx1 = firstIdx + mf;
                    long k2 = 1L;
                    long m4 = n2;
                    while (m4 > 512L) {
                        k2 <<= 2;
                        CommonUtils.cftmdl2(m4 >>= 2, a2, idx1 - m4, w2, nw - m4);
                    }
                    CommonUtils.cftleaf(m4, 0L, a2, idx1 - m4, nw, w2);
                    k2 >>= 1;
                    long idx2 = firstIdx - m4;
                    for (long j2 = mf - m4; j2 > 0L; j2 -= m4) {
                        long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, firstIdx, nw, w2);
                        CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void cftrec4(int n2, float[] a2, int offa, int nw, float[] w2) {
        int m4 = n2;
        int idx1 = offa + n2;
        while (m4 > 512) {
            CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
        }
        CommonUtils.cftleaf(m4, 1, a2, idx1 - m4, nw, w2);
        int k2 = 0;
        int idx2 = offa - m4;
        for (int j2 = n2 - m4; j2 > 0; j2 -= m4) {
            int isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, offa, nw, w2);
            CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
        }
    }

    public static void cftrec4(long n2, FloatLargeArray a2, long offa, long nw, FloatLargeArray w2) {
        long m4 = n2;
        long idx1 = offa + n2;
        while (m4 > 512L) {
            CommonUtils.cftmdl1(m4 >>= 2, a2, idx1 - m4, w2, nw - (m4 >> 1));
        }
        CommonUtils.cftleaf(m4, 1L, a2, idx1 - m4, nw, w2);
        long k2 = 0L;
        long idx2 = offa - m4;
        for (long j2 = n2 - m4; j2 > 0L; j2 -= m4) {
            long isplt = CommonUtils.cfttree(m4, j2, ++k2, a2, offa, nw, w2);
            CommonUtils.cftleaf(m4, isplt, a2, idx2 + j2, nw, w2);
        }
    }

    public static int cfttree(int n2, int j2, int k2, float[] a2, int offa, int nw, float[] w2) {
        int isplt;
        int idx1 = offa - n2;
        if ((k2 & 3) != 0) {
            isplt = k2 & 1;
            if (isplt != 0) {
                CommonUtils.cftmdl1(n2, a2, idx1 + j2, w2, nw - (n2 >> 1));
            } else {
                CommonUtils.cftmdl2(n2, a2, idx1 + j2, w2, nw - n2);
            }
        } else {
            int m4 = n2;
            int i2 = k2;
            while ((i2 & 3) == 0) {
                m4 <<= 2;
                i2 >>= 2;
            }
            isplt = i2 & 1;
            int idx2 = offa + j2;
            if (isplt != 0) {
                while (m4 > 128) {
                    CommonUtils.cftmdl1(m4, a2, idx2 - m4, w2, nw - (m4 >> 1));
                    m4 >>= 2;
                }
            } else {
                while (m4 > 128) {
                    CommonUtils.cftmdl2(m4, a2, idx2 - m4, w2, nw - m4);
                    m4 >>= 2;
                }
            }
        }
        return isplt;
    }

    public static long cfttree(long n2, long j2, long k2, FloatLargeArray a2, long offa, long nw, FloatLargeArray w2) {
        long isplt;
        long idx1 = offa - n2;
        if ((k2 & 3L) != 0L) {
            isplt = k2 & 1L;
            if (isplt != 0L) {
                CommonUtils.cftmdl1(n2, a2, idx1 + j2, w2, nw - (n2 >> 1));
            } else {
                CommonUtils.cftmdl2(n2, a2, idx1 + j2, w2, nw - n2);
            }
        } else {
            long m4 = n2;
            long i2 = k2;
            while ((i2 & 3L) == 0L) {
                m4 <<= 2;
                i2 >>= 2;
            }
            isplt = i2 & 1L;
            long idx2 = offa + j2;
            if (isplt != 0L) {
                while (m4 > 128L) {
                    CommonUtils.cftmdl1(m4, a2, idx2 - m4, w2, nw - (m4 >> 1));
                    m4 >>= 2;
                }
            } else {
                while (m4 > 128L) {
                    CommonUtils.cftmdl2(m4, a2, idx2 - m4, w2, nw - m4);
                    m4 >>= 2;
                }
            }
        }
        return isplt;
    }

    public static void cftleaf(int n2, int isplt, float[] a2, int offa, int nw, float[] w2) {
        if (n2 == 512) {
            CommonUtils.cftmdl1(128, a2, offa, w2, nw - 64);
            CommonUtils.cftf161(a2, offa, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 32, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 96, w2, nw - 8);
            CommonUtils.cftmdl2(128, a2, offa + 128, w2, nw - 128);
            CommonUtils.cftf161(a2, offa + 128, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 160, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 192, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 224, w2, nw - 32);
            CommonUtils.cftmdl1(128, a2, offa + 256, w2, nw - 64);
            CommonUtils.cftf161(a2, offa + 256, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 288, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 320, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 352, w2, nw - 8);
            if (isplt != 0) {
                CommonUtils.cftmdl1(128, a2, offa + 384, w2, nw - 64);
                CommonUtils.cftf161(a2, offa + 480, w2, nw - 8);
            } else {
                CommonUtils.cftmdl2(128, a2, offa + 384, w2, nw - 128);
                CommonUtils.cftf162(a2, offa + 480, w2, nw - 32);
            }
            CommonUtils.cftf161(a2, offa + 384, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 416, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 448, w2, nw - 8);
        } else {
            CommonUtils.cftmdl1(64, a2, offa, w2, nw - 32);
            CommonUtils.cftf081(a2, offa, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 16, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 32, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 48, w2, nw - 8);
            CommonUtils.cftmdl2(64, a2, offa + 64, w2, nw - 64);
            CommonUtils.cftf081(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 80, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 96, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 112, w2, nw - 8);
            CommonUtils.cftmdl1(64, a2, offa + 128, w2, nw - 32);
            CommonUtils.cftf081(a2, offa + 128, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 144, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 160, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 176, w2, nw - 8);
            if (isplt != 0) {
                CommonUtils.cftmdl1(64, a2, offa + 192, w2, nw - 32);
                CommonUtils.cftf081(a2, offa + 240, w2, nw - 8);
            } else {
                CommonUtils.cftmdl2(64, a2, offa + 192, w2, nw - 64);
                CommonUtils.cftf082(a2, offa + 240, w2, nw - 8);
            }
            CommonUtils.cftf081(a2, offa + 192, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 208, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 224, w2, nw - 8);
        }
    }

    public static void cftleaf(long n2, long isplt, FloatLargeArray a2, long offa, long nw, FloatLargeArray w2) {
        if (n2 == 512L) {
            CommonUtils.cftmdl1(128L, a2, offa, w2, nw - 64L);
            CommonUtils.cftf161(a2, offa, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 32L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 96L, w2, nw - 8L);
            CommonUtils.cftmdl2(128L, a2, offa + 128L, w2, nw - 128L);
            CommonUtils.cftf161(a2, offa + 128L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 160L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 192L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 224L, w2, nw - 32L);
            CommonUtils.cftmdl1(128L, a2, offa + 256L, w2, nw - 64L);
            CommonUtils.cftf161(a2, offa + 256L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 288L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 320L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 352L, w2, nw - 8L);
            if (isplt != 0L) {
                CommonUtils.cftmdl1(128L, a2, offa + 384L, w2, nw - 64L);
                CommonUtils.cftf161(a2, offa + 480L, w2, nw - 8L);
            } else {
                CommonUtils.cftmdl2(128L, a2, offa + 384L, w2, nw - 128L);
                CommonUtils.cftf162(a2, offa + 480L, w2, nw - 32L);
            }
            CommonUtils.cftf161(a2, offa + 384L, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 416L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 448L, w2, nw - 8L);
        } else {
            CommonUtils.cftmdl1(64L, a2, offa, w2, nw - 32L);
            CommonUtils.cftf081(a2, offa, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 16L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 32L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 48L, w2, nw - 8L);
            CommonUtils.cftmdl2(64L, a2, offa + 64L, w2, nw - 64L);
            CommonUtils.cftf081(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 80L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 96L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 112L, w2, nw - 8L);
            CommonUtils.cftmdl1(64L, a2, offa + 128L, w2, nw - 32L);
            CommonUtils.cftf081(a2, offa + 128L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 144L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 160L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 176L, w2, nw - 8L);
            if (isplt != 0L) {
                CommonUtils.cftmdl1(64L, a2, offa + 192L, w2, nw - 32L);
                CommonUtils.cftf081(a2, offa + 240L, w2, nw - 8L);
            } else {
                CommonUtils.cftmdl2(64L, a2, offa + 192L, w2, nw - 64L);
                CommonUtils.cftf082(a2, offa + 240L, w2, nw - 8L);
            }
            CommonUtils.cftf081(a2, offa + 192L, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 208L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 224L, w2, nw - 8L);
        }
    }

    public static void cftmdl1(int n2, float[] a2, int offa, float[] w2, int startw) {
        int idx0;
        int j0;
        int m4;
        int mh = n2 >> 3;
        int j1 = m4 = 2 * mh;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        float x0r = a2[offa] + a2[idx2];
        float x0i = a2[offa + 1] + a2[idx2 + 1];
        float x1r = a2[offa] - a2[idx2];
        float x1i = a2[offa + 1] - a2[idx2 + 1];
        float x2r = a2[idx1] + a2[idx3];
        float x2i = a2[idx1 + 1] + a2[idx3 + 1];
        float x3r = a2[idx1] - a2[idx3];
        float x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        a2[idx2] = x1r - x3i;
        a2[idx2 + 1] = x1i + x3r;
        a2[idx3] = x1r + x3i;
        a2[idx3 + 1] = x1i - x3r;
        float wn4r = w2[startw + 1];
        int k2 = 0;
        for (int j4 = 2; j4 < mh; j4 += 2) {
            int idx4 = startw + (k2 += 4);
            float wk1r = w2[idx4];
            float wk1i = w2[idx4 + 1];
            float wk3r = w2[idx4 + 2];
            float wk3i = w2[idx4 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j4;
            x0r = a2[idx5] + a2[idx2];
            x0i = a2[idx5 + 1] + a2[idx2 + 1];
            x1r = a2[idx5] - a2[idx2];
            x1i = a2[idx5 + 1] - a2[idx2 + 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            a2[idx5] = x0r + x2r;
            a2[idx5 + 1] = x0i + x2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1r * x0r - wk1i * x0i;
            a2[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3r * x0r + wk3i * x0i;
            a2[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] + a2[idx2];
            x0i = a2[idx0 + 1] + a2[idx2 + 1];
            x1r = a2[idx0] - a2[idx2];
            x1i = a2[idx0 + 1] - a2[idx2 + 1];
            x2r = a2[idx1] + a2[idx3];
            x2i = a2[idx1 + 1] + a2[idx3 + 1];
            x3r = a2[idx1] - a2[idx3];
            x3i = a2[idx1 + 1] - a2[idx3 + 1];
            a2[idx0] = x0r + x2r;
            a2[idx0 + 1] = x0i + x2i;
            a2[idx1] = x0r - x2r;
            a2[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2[idx2] = wk1i * x0r - wk1r * x0i;
            a2[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2[idx3] = wk3i * x0r + wk3r * x0i;
            a2[idx3 + 1] = wk3i * x0i - wk3r * x0r;
        }
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0] + a2[idx2];
        x0i = a2[idx0 + 1] + a2[idx2 + 1];
        x1r = a2[idx0] - a2[idx2];
        x1i = a2[idx0 + 1] - a2[idx2 + 1];
        x2r = a2[idx1] + a2[idx3];
        x2i = a2[idx1 + 1] + a2[idx3 + 1];
        x3r = a2[idx1] - a2[idx3];
        x3i = a2[idx1 + 1] - a2[idx3 + 1];
        a2[idx0] = x0r + x2r;
        a2[idx0 + 1] = x0i + x2i;
        a2[idx1] = x0r - x2r;
        a2[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2[idx2] = wn4r * (x0r - x0i);
        a2[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2[idx3] = -wn4r * (x0r + x0i);
        a2[idx3 + 1] = -wn4r * (x0i - x0r);
    }

    public static void cftmdl1(long n2, FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        long idx0;
        long j0;
        long m4;
        long mh = n2 >> 3;
        long j1 = m4 = 2L * mh;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        float x0r = a2.getFloat(offa) + a2.getFloat(idx2);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(idx2 + 1L);
        float x1r = a2.getFloat(offa) - a2.getFloat(idx2);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(idx2 + 1L);
        float x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        float x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        float x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        float x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i + x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i - x2i);
        a2.setFloat(idx2, x1r - x3i);
        a2.setFloat(idx2 + 1L, x1i + x3r);
        a2.setFloat(idx3, x1r + x3i);
        a2.setFloat(idx3 + 1L, x1i - x3r);
        float wn4r = w2.getFloat(startw + 1L);
        long k2 = 0L;
        for (long j4 = 2L; j4 < mh; j4 += 2L) {
            long idx4 = startw + (k2 += 4L);
            float wk1r = w2.getFloat(idx4);
            float wk1i = w2.getFloat(idx4 + 1L);
            float wk3r = w2.getFloat(idx4 + 2L);
            float wk3i = w2.getFloat(idx4 + 3L);
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx5 = offa + j4;
            x0r = a2.getFloat(idx5) + a2.getFloat(idx2);
            x0i = a2.getFloat(idx5 + 1L) + a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx5) - a2.getFloat(idx2);
            x1i = a2.getFloat(idx5 + 1L) - a2.getFloat(idx2 + 1L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            a2.setFloat(idx5, x0r + x2r);
            a2.setFloat(idx5 + 1L, x0i + x2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i - x2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1r * x0r - wk1i * x0i);
            a2.setFloat(idx2 + 1L, wk1r * x0i + wk1i * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3r * x0r + wk3i * x0i);
            a2.setFloat(idx3 + 1L, wk3r * x0i - wk3i * x0r);
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
            x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
            x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
            x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
            x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
            x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
            a2.setFloat(idx0, x0r + x2r);
            a2.setFloat(idx0 + 1L, x0i + x2i);
            a2.setFloat(idx1, x0r - x2r);
            a2.setFloat(idx1 + 1L, x0i - x2i);
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a2.setFloat(idx2, wk1i * x0r - wk1r * x0i);
            a2.setFloat(idx2 + 1L, wk1i * x0i + wk1r * x0r);
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a2.setFloat(idx3, wk3i * x0r + wk3r * x0i);
            a2.setFloat(idx3 + 1L, wk3i * x0i - wk3r * x0r);
        }
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getFloat(idx0) + a2.getFloat(idx2);
        x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2 + 1L);
        x1r = a2.getFloat(idx0) - a2.getFloat(idx2);
        x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2 + 1L);
        x2r = a2.getFloat(idx1) + a2.getFloat(idx3);
        x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3 + 1L);
        x3r = a2.getFloat(idx1) - a2.getFloat(idx3);
        x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3 + 1L);
        a2.setFloat(idx0, x0r + x2r);
        a2.setFloat(idx0 + 1L, x0i + x2i);
        a2.setFloat(idx1, x0r - x2r);
        a2.setFloat(idx1 + 1L, x0i - x2i);
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a2.setFloat(idx2, wn4r * (x0r - x0i));
        a2.setFloat(idx2 + 1L, wn4r * (x0i + x0r));
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a2.setFloat(idx3, -wn4r * (x0r + x0i));
        a2.setFloat(idx3 + 1L, -wn4r * (x0i - x0r));
    }

    public static void cftmdl2(int n2, float[] a2, int offa, float[] w2, int startw) {
        int idx0;
        int j0;
        float y2i;
        float y2r;
        float wk1i;
        float wk1r;
        int mh = n2 >> 3;
        int m4 = 2 * mh;
        float wn4r = w2[startw + 1];
        int j1 = m4;
        int j2 = j1 + m4;
        int j3 = j2 + m4;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        float x0r = a2[offa] - a2[idx2 + 1];
        float x0i = a2[offa + 1] + a2[idx2];
        float x1r = a2[offa] + a2[idx2 + 1];
        float x1i = a2[offa + 1] - a2[idx2];
        float x2r = a2[idx1] - a2[idx3 + 1];
        float x2i = a2[idx1 + 1] + a2[idx3];
        float x3r = a2[idx1] + a2[idx3 + 1];
        float x3i = a2[idx1 + 1] - a2[idx3];
        float y0r = wn4r * (x2r - x2i);
        float y0i = wn4r * (x2i + x2r);
        a2[offa] = x0r + y0r;
        a2[offa + 1] = x0i + y0i;
        a2[idx1] = x0r - y0r;
        a2[idx1 + 1] = x0i - y0i;
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a2[idx2] = x1r - y0i;
        a2[idx2 + 1] = x1i + y0r;
        a2[idx3] = x1r + y0i;
        a2[idx3 + 1] = x1i - y0r;
        int k2 = 0;
        int kr = 2 * m4;
        for (int j4 = 2; j4 < mh; j4 += 2) {
            int idx4 = startw + (k2 += 4);
            wk1r = w2[idx4];
            wk1i = w2[idx4 + 1];
            float wk3r = w2[idx4 + 2];
            float wk3i = w2[idx4 + 3];
            int idx5 = startw + (kr -= 4);
            float wd1i = w2[idx5];
            float wd1r = w2[idx5 + 1];
            float wd3i = w2[idx5 + 2];
            float wd3r = w2[idx5 + 3];
            j1 = j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx6 = offa + j4;
            x0r = a2[idx6] - a2[idx2 + 1];
            x0i = a2[idx6 + 1] + a2[idx2];
            x1r = a2[idx6] + a2[idx2 + 1];
            x1i = a2[idx6 + 1] - a2[idx2];
            x2r = a2[idx1] - a2[idx3 + 1];
            x2i = a2[idx1 + 1] + a2[idx3];
            x3r = a2[idx1] + a2[idx3 + 1];
            x3i = a2[idx1 + 1] - a2[idx3];
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a2[idx6] = y0r + y2r;
            a2[idx6 + 1] = y0i + y2i;
            a2[idx1] = y0r - y2r;
            a2[idx1 + 1] = y0i - y2i;
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a2[idx2] = y0r + y2r;
            a2[idx2 + 1] = y0i + y2i;
            a2[idx3] = y0r - y2r;
            a2[idx3 + 1] = y0i - y2i;
            j0 = m4 - j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2[idx0] - a2[idx2 + 1];
            x0i = a2[idx0 + 1] + a2[idx2];
            x1r = a2[idx0] + a2[idx2 + 1];
            x1i = a2[idx0 + 1] - a2[idx2];
            x2r = a2[idx1] - a2[idx3 + 1];
            x2i = a2[idx1 + 1] + a2[idx3];
            x3r = a2[idx1] + a2[idx3 + 1];
            x3i = a2[idx1 + 1] - a2[idx3];
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a2[idx0] = y0r + y2r;
            a2[idx0 + 1] = y0i + y2i;
            a2[idx1] = y0r - y2r;
            a2[idx1 + 1] = y0i - y2i;
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a2[idx2] = y0r + y2r;
            a2[idx2 + 1] = y0i + y2i;
            a2[idx3] = y0r - y2r;
            a2[idx3 + 1] = y0i - y2i;
        }
        wk1r = w2[startw + m4];
        wk1i = w2[startw + m4 + 1];
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2[idx0] - a2[idx2 + 1];
        x0i = a2[idx0 + 1] + a2[idx2];
        x1r = a2[idx0] + a2[idx2 + 1];
        x1i = a2[idx0 + 1] - a2[idx2];
        x2r = a2[idx1] - a2[idx3 + 1];
        x2i = a2[idx1 + 1] + a2[idx3];
        x3r = a2[idx1] + a2[idx3 + 1];
        x3i = a2[idx1 + 1] - a2[idx3];
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a2[idx0] = y0r + y2r;
        a2[idx0 + 1] = y0i + y2i;
        a2[idx1] = y0r - y2r;
        a2[idx1 + 1] = y0i - y2i;
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a2[idx2] = y0r - y2r;
        a2[idx2 + 1] = y0i - y2i;
        a2[idx3] = y0r + y2r;
        a2[idx3 + 1] = y0i + y2i;
    }

    public static void cftmdl2(long n2, FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        long idx0;
        long j0;
        float y2i;
        float y2r;
        float wk1i;
        float wk1r;
        long mh = n2 >> 3;
        long m4 = 2L * mh;
        float wn4r = w2.getFloat(startw + 1L);
        long j1 = m4;
        long j2 = j1 + m4;
        long j3 = j2 + m4;
        long idx1 = offa + j1;
        long idx2 = offa + j2;
        long idx3 = offa + j3;
        float x0r = a2.getFloat(offa) - a2.getFloat(idx2 + 1L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(idx2);
        float x1r = a2.getFloat(offa) + a2.getFloat(idx2 + 1L);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(idx2);
        float x2r = a2.getFloat(idx1) - a2.getFloat(idx3 + 1L);
        float x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3);
        float x3r = a2.getFloat(idx1) + a2.getFloat(idx3 + 1L);
        float x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3);
        float y0r = wn4r * (x2r - x2i);
        float y0i = wn4r * (x2i + x2r);
        a2.setFloat(offa, x0r + y0r);
        a2.setFloat(offa + 1L, x0i + y0i);
        a2.setFloat(idx1, x0r - y0r);
        a2.setFloat(idx1 + 1L, x0i - y0i);
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a2.setFloat(idx2, x1r - y0i);
        a2.setFloat(idx2 + 1L, x1i + y0r);
        a2.setFloat(idx3, x1r + y0i);
        a2.setFloat(idx3 + 1L, x1i - y0r);
        long k2 = 0L;
        long kr = 2L * m4;
        int j4 = 2;
        while ((long)j4 < mh) {
            long idx4 = startw + (k2 += 4L);
            wk1r = w2.getFloat(idx4);
            wk1i = w2.getFloat(idx4 + 1L);
            float wk3r = w2.getFloat(idx4 + 2L);
            float wk3i = w2.getFloat(idx4 + 3L);
            long idx5 = startw + (kr -= 4L);
            float wd1i = w2.getFloat(idx5);
            float wd1r = w2.getFloat(idx5 + 1L);
            float wd3i = w2.getFloat(idx5 + 2L);
            float wd3r = w2.getFloat(idx5 + 3L);
            j1 = (long)j4 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            long idx6 = offa + (long)j4;
            x0r = a2.getFloat(idx6) - a2.getFloat(idx2 + 1L);
            x0i = a2.getFloat(idx6 + 1L) + a2.getFloat(idx2);
            x1r = a2.getFloat(idx6) + a2.getFloat(idx2 + 1L);
            x1i = a2.getFloat(idx6 + 1L) - a2.getFloat(idx2);
            x2r = a2.getFloat(idx1) - a2.getFloat(idx3 + 1L);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3);
            x3r = a2.getFloat(idx1) + a2.getFloat(idx3 + 1L);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3);
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a2.setFloat(idx6, y0r + y2r);
            a2.setFloat(idx6 + 1L, y0i + y2i);
            a2.setFloat(idx1, y0r - y2r);
            a2.setFloat(idx1 + 1L, y0i - y2i);
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a2.setFloat(idx2, y0r + y2r);
            a2.setFloat(idx2 + 1L, y0i + y2i);
            a2.setFloat(idx3, y0r - y2r);
            a2.setFloat(idx3 + 1L, y0i - y2i);
            j0 = m4 - (long)j4;
            j1 = j0 + m4;
            j2 = j1 + m4;
            j3 = j2 + m4;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a2.getFloat(idx0) - a2.getFloat(idx2 + 1L);
            x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2);
            x1r = a2.getFloat(idx0) + a2.getFloat(idx2 + 1L);
            x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2);
            x2r = a2.getFloat(idx1) - a2.getFloat(idx3 + 1L);
            x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3);
            x3r = a2.getFloat(idx1) + a2.getFloat(idx3 + 1L);
            x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3);
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a2.setFloat(idx0, y0r + y2r);
            a2.setFloat(idx0 + 1L, y0i + y2i);
            a2.setFloat(idx1, y0r - y2r);
            a2.setFloat(idx1 + 1L, y0i - y2i);
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a2.setFloat(idx2, y0r + y2r);
            a2.setFloat(idx2 + 1L, y0i + y2i);
            a2.setFloat(idx3, y0r - y2r);
            a2.setFloat(idx3 + 1L, y0i - y2i);
            j4 += 2;
        }
        wk1r = w2.getFloat(startw + m4);
        wk1i = w2.getFloat(startw + m4 + 1L);
        j0 = mh;
        j1 = j0 + m4;
        j2 = j1 + m4;
        j3 = j2 + m4;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a2.getFloat(idx0) - a2.getFloat(idx2 + 1L);
        x0i = a2.getFloat(idx0 + 1L) + a2.getFloat(idx2);
        x1r = a2.getFloat(idx0) + a2.getFloat(idx2 + 1L);
        x1i = a2.getFloat(idx0 + 1L) - a2.getFloat(idx2);
        x2r = a2.getFloat(idx1) - a2.getFloat(idx3 + 1L);
        x2i = a2.getFloat(idx1 + 1L) + a2.getFloat(idx3);
        x3r = a2.getFloat(idx1) + a2.getFloat(idx3 + 1L);
        x3i = a2.getFloat(idx1 + 1L) - a2.getFloat(idx3);
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a2.setFloat(idx0, y0r + y2r);
        a2.setFloat(idx0 + 1L, y0i + y2i);
        a2.setFloat(idx1, y0r - y2r);
        a2.setFloat(idx1 + 1L, y0i - y2i);
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a2.setFloat(idx2, y0r - y2r);
        a2.setFloat(idx2 + 1L, y0i - y2i);
        a2.setFloat(idx3, y0r + y2r);
        a2.setFloat(idx3 + 1L, y0i + y2i);
    }

    public static void cftfx41(int n2, float[] a2, int offa, int nw, float[] w2) {
        if (n2 == 128) {
            CommonUtils.cftf161(a2, offa, w2, nw - 8);
            CommonUtils.cftf162(a2, offa + 32, w2, nw - 32);
            CommonUtils.cftf161(a2, offa + 64, w2, nw - 8);
            CommonUtils.cftf161(a2, offa + 96, w2, nw - 8);
        } else {
            CommonUtils.cftf081(a2, offa, w2, nw - 8);
            CommonUtils.cftf082(a2, offa + 16, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 32, w2, nw - 8);
            CommonUtils.cftf081(a2, offa + 48, w2, nw - 8);
        }
    }

    public static void cftfx41(long n2, FloatLargeArray a2, long offa, long nw, FloatLargeArray w2) {
        if (n2 == 128L) {
            CommonUtils.cftf161(a2, offa, w2, nw - 8L);
            CommonUtils.cftf162(a2, offa + 32L, w2, nw - 32L);
            CommonUtils.cftf161(a2, offa + 64L, w2, nw - 8L);
            CommonUtils.cftf161(a2, offa + 96L, w2, nw - 8L);
        } else {
            CommonUtils.cftf081(a2, offa, w2, nw - 8L);
            CommonUtils.cftf082(a2, offa + 16L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 32L, w2, nw - 8L);
            CommonUtils.cftf081(a2, offa + 48L, w2, nw - 8L);
        }
    }

    public static void cftf161(float[] a2, int offa, float[] w2, int startw) {
        float wn4r = w2[startw + 1];
        float wk1r = w2[startw + 2];
        float wk1i = w2[startw + 3];
        float x0r = a2[offa] + a2[offa + 16];
        float x0i = a2[offa + 1] + a2[offa + 17];
        float x1r = a2[offa] - a2[offa + 16];
        float x1i = a2[offa + 1] - a2[offa + 17];
        float x2r = a2[offa + 8] + a2[offa + 24];
        float x2i = a2[offa + 9] + a2[offa + 25];
        float x3r = a2[offa + 8] - a2[offa + 24];
        float x3i = a2[offa + 9] - a2[offa + 25];
        float y0r = x0r + x2r;
        float y0i = x0i + x2i;
        float y4r = x0r - x2r;
        float y4i = x0i - x2i;
        float y8r = x1r - x3i;
        float y8i = x1i + x3r;
        float y12r = x1r + x3i;
        float y12i = x1i - x3r;
        x0r = a2[offa + 2] + a2[offa + 18];
        x0i = a2[offa + 3] + a2[offa + 19];
        x1r = a2[offa + 2] - a2[offa + 18];
        x1i = a2[offa + 3] - a2[offa + 19];
        x2r = a2[offa + 10] + a2[offa + 26];
        x2i = a2[offa + 11] + a2[offa + 27];
        x3r = a2[offa + 10] - a2[offa + 26];
        x3i = a2[offa + 11] - a2[offa + 27];
        float y1r = x0r + x2r;
        float y1i = x0i + x2i;
        float y5r = x0r - x2r;
        float y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y9r = wk1r * x0r - wk1i * x0i;
        float y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y13r = wk1i * x0r - wk1r * x0i;
        float y13i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 4] + a2[offa + 20];
        x0i = a2[offa + 5] + a2[offa + 21];
        x1r = a2[offa + 4] - a2[offa + 20];
        x1i = a2[offa + 5] - a2[offa + 21];
        x2r = a2[offa + 12] + a2[offa + 28];
        x2i = a2[offa + 13] + a2[offa + 29];
        x3r = a2[offa + 12] - a2[offa + 28];
        x3i = a2[offa + 13] - a2[offa + 29];
        float y2r = x0r + x2r;
        float y2i = x0i + x2i;
        float y6r = x0r - x2r;
        float y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y10r = wn4r * (x0r - x0i);
        float y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y14r = wn4r * (x0r + x0i);
        float y14i = wn4r * (x0i - x0r);
        x0r = a2[offa + 6] + a2[offa + 22];
        x0i = a2[offa + 7] + a2[offa + 23];
        x1r = a2[offa + 6] - a2[offa + 22];
        x1i = a2[offa + 7] - a2[offa + 23];
        x2r = a2[offa + 14] + a2[offa + 30];
        x2i = a2[offa + 15] + a2[offa + 31];
        x3r = a2[offa + 14] - a2[offa + 30];
        x3i = a2[offa + 15] - a2[offa + 31];
        float y3r = x0r + x2r;
        float y3i = x0i + x2i;
        float y7r = x0r - x2r;
        float y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y11r = wk1i * x0r - wk1r * x0i;
        float y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y15r = wk1r * x0r - wk1i * x0i;
        float y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a2[offa + 24] = x0r + x2r;
        a2[offa + 25] = x0i + x2i;
        a2[offa + 26] = x0r - x2r;
        a2[offa + 27] = x0i - x2i;
        a2[offa + 28] = x1r - x3i;
        a2[offa + 29] = x1i + x3r;
        a2[offa + 30] = x1r + x3i;
        a2[offa + 31] = x1i - x3r;
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a2[offa + 16] = x0r + x2r;
        a2[offa + 17] = x0i + x2i;
        a2[offa + 18] = x0r - x2r;
        a2[offa + 19] = x0i - x2i;
        a2[offa + 20] = x1r - x3i;
        a2[offa + 21] = x1i + x3r;
        a2[offa + 22] = x1r + x3i;
        a2[offa + 23] = x1i - x3r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a2[offa + 8] = x0r + x2r;
        a2[offa + 9] = x0i + x2i;
        a2[offa + 10] = x0r - x2r;
        a2[offa + 11] = x0i - x2i;
        a2[offa + 12] = x1r - x3i;
        a2[offa + 13] = x1i + x3r;
        a2[offa + 14] = x1r + x3i;
        a2[offa + 15] = x1i - x3r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x0r - x2r;
        a2[offa + 3] = x0i - x2i;
        a2[offa + 4] = x1r - x3i;
        a2[offa + 5] = x1i + x3r;
        a2[offa + 6] = x1r + x3i;
        a2[offa + 7] = x1i - x3r;
    }

    public static void cftf161(FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        float wn4r = w2.getFloat(startw + 1L);
        float wk1r = w2.getFloat(startw + 2L);
        float wk1i = w2.getFloat(startw + 3L);
        float x0r = a2.getFloat(offa) + a2.getFloat(offa + 16L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 17L);
        float x1r = a2.getFloat(offa) - a2.getFloat(offa + 16L);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 17L);
        float x2r = a2.getFloat(offa + 8L) + a2.getFloat(offa + 24L);
        float x2i = a2.getFloat(offa + 9L) + a2.getFloat(offa + 25L);
        float x3r = a2.getFloat(offa + 8L) - a2.getFloat(offa + 24L);
        float x3i = a2.getFloat(offa + 9L) - a2.getFloat(offa + 25L);
        float y0r = x0r + x2r;
        float y0i = x0i + x2i;
        float y4r = x0r - x2r;
        float y4i = x0i - x2i;
        float y8r = x1r - x3i;
        float y8i = x1i + x3r;
        float y12r = x1r + x3i;
        float y12i = x1i - x3r;
        x0r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 18L);
        x0i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 19L);
        x1r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 18L);
        x1i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 19L);
        x2r = a2.getFloat(offa + 10L) + a2.getFloat(offa + 26L);
        x2i = a2.getFloat(offa + 11L) + a2.getFloat(offa + 27L);
        x3r = a2.getFloat(offa + 10L) - a2.getFloat(offa + 26L);
        x3i = a2.getFloat(offa + 11L) - a2.getFloat(offa + 27L);
        float y1r = x0r + x2r;
        float y1i = x0i + x2i;
        float y5r = x0r - x2r;
        float y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y9r = wk1r * x0r - wk1i * x0i;
        float y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y13r = wk1i * x0r - wk1r * x0i;
        float y13i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getFloat(offa + 4L) + a2.getFloat(offa + 20L);
        x0i = a2.getFloat(offa + 5L) + a2.getFloat(offa + 21L);
        x1r = a2.getFloat(offa + 4L) - a2.getFloat(offa + 20L);
        x1i = a2.getFloat(offa + 5L) - a2.getFloat(offa + 21L);
        x2r = a2.getFloat(offa + 12L) + a2.getFloat(offa + 28L);
        x2i = a2.getFloat(offa + 13L) + a2.getFloat(offa + 29L);
        x3r = a2.getFloat(offa + 12L) - a2.getFloat(offa + 28L);
        x3i = a2.getFloat(offa + 13L) - a2.getFloat(offa + 29L);
        float y2r = x0r + x2r;
        float y2i = x0i + x2i;
        float y6r = x0r - x2r;
        float y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y10r = wn4r * (x0r - x0i);
        float y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y14r = wn4r * (x0r + x0i);
        float y14i = wn4r * (x0i - x0r);
        x0r = a2.getFloat(offa + 6L) + a2.getFloat(offa + 22L);
        x0i = a2.getFloat(offa + 7L) + a2.getFloat(offa + 23L);
        x1r = a2.getFloat(offa + 6L) - a2.getFloat(offa + 22L);
        x1i = a2.getFloat(offa + 7L) - a2.getFloat(offa + 23L);
        x2r = a2.getFloat(offa + 14L) + a2.getFloat(offa + 30L);
        x2i = a2.getFloat(offa + 15L) + a2.getFloat(offa + 31L);
        x3r = a2.getFloat(offa + 14L) - a2.getFloat(offa + 30L);
        x3i = a2.getFloat(offa + 15L) - a2.getFloat(offa + 31L);
        float y3r = x0r + x2r;
        float y3i = x0i + x2i;
        float y7r = x0r - x2r;
        float y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        float y11r = wk1i * x0r - wk1r * x0i;
        float y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        float y15r = wk1r * x0r - wk1i * x0i;
        float y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a2.setFloat(offa + 24L, x0r + x2r);
        a2.setFloat(offa + 25L, x0i + x2i);
        a2.setFloat(offa + 26L, x0r - x2r);
        a2.setFloat(offa + 27L, x0i - x2i);
        a2.setFloat(offa + 28L, x1r - x3i);
        a2.setFloat(offa + 29L, x1i + x3r);
        a2.setFloat(offa + 30L, x1r + x3i);
        a2.setFloat(offa + 31L, x1i - x3r);
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a2.setFloat(offa + 16L, x0r + x2r);
        a2.setFloat(offa + 17L, x0i + x2i);
        a2.setFloat(offa + 18L, x0r - x2r);
        a2.setFloat(offa + 19L, x0i - x2i);
        a2.setFloat(offa + 20L, x1r - x3i);
        a2.setFloat(offa + 21L, x1i + x3r);
        a2.setFloat(offa + 22L, x1r + x3i);
        a2.setFloat(offa + 23L, x1i - x3r);
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a2.setFloat(offa + 8L, x0r + x2r);
        a2.setFloat(offa + 9L, x0i + x2i);
        a2.setFloat(offa + 10L, x0r - x2r);
        a2.setFloat(offa + 11L, x0i - x2i);
        a2.setFloat(offa + 12L, x1r - x3i);
        a2.setFloat(offa + 13L, x1i + x3r);
        a2.setFloat(offa + 14L, x1r + x3i);
        a2.setFloat(offa + 15L, x1i - x3r);
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i + x2i);
        a2.setFloat(offa + 2L, x0r - x2r);
        a2.setFloat(offa + 3L, x0i - x2i);
        a2.setFloat(offa + 4L, x1r - x3i);
        a2.setFloat(offa + 5L, x1i + x3r);
        a2.setFloat(offa + 6L, x1r + x3i);
        a2.setFloat(offa + 7L, x1i - x3r);
    }

    public static void cftf162(float[] a2, int offa, float[] w2, int startw) {
        float wn4r = w2[startw + 1];
        float wk1r = w2[startw + 4];
        float wk1i = w2[startw + 5];
        float wk3r = w2[startw + 6];
        float wk3i = -w2[startw + 7];
        float wk2r = w2[startw + 8];
        float wk2i = w2[startw + 9];
        float x1r = a2[offa] - a2[offa + 17];
        float x1i = a2[offa + 1] + a2[offa + 16];
        float x0r = a2[offa + 8] - a2[offa + 25];
        float x0i = a2[offa + 9] + a2[offa + 24];
        float x2r = wn4r * (x0r - x0i);
        float x2i = wn4r * (x0i + x0r);
        float y0r = x1r + x2r;
        float y0i = x1i + x2i;
        float y4r = x1r - x2r;
        float y4i = x1i - x2i;
        x1r = a2[offa] + a2[offa + 17];
        x1i = a2[offa + 1] - a2[offa + 16];
        x0r = a2[offa + 8] + a2[offa + 25];
        x0i = a2[offa + 9] - a2[offa + 24];
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        float y8r = x1r - x2i;
        float y8i = x1i + x2r;
        float y12r = x1r + x2i;
        float y12i = x1i - x2r;
        x0r = a2[offa + 2] - a2[offa + 19];
        x0i = a2[offa + 3] + a2[offa + 18];
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a2[offa + 10] - a2[offa + 27];
        x0i = a2[offa + 11] + a2[offa + 26];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        float y1r = x1r + x2r;
        float y1i = x1i + x2i;
        float y5r = x1r - x2r;
        float y5i = x1i - x2i;
        x0r = a2[offa + 2] + a2[offa + 19];
        x0i = a2[offa + 3] - a2[offa + 18];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2[offa + 10] + a2[offa + 27];
        x0i = a2[offa + 11] - a2[offa + 26];
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        float y9r = x1r - x2r;
        float y9i = x1i - x2i;
        float y13r = x1r + x2r;
        float y13i = x1i + x2i;
        x0r = a2[offa + 4] - a2[offa + 21];
        x0i = a2[offa + 5] + a2[offa + 20];
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a2[offa + 12] - a2[offa + 29];
        x0i = a2[offa + 13] + a2[offa + 28];
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        float y2r = x1r + x2r;
        float y2i = x1i + x2i;
        float y6r = x1r - x2r;
        float y6i = x1i - x2i;
        x0r = a2[offa + 4] + a2[offa + 21];
        x0i = a2[offa + 5] - a2[offa + 20];
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a2[offa + 12] + a2[offa + 29];
        x0i = a2[offa + 13] - a2[offa + 28];
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        float y10r = x1r - x2r;
        float y10i = x1i - x2i;
        float y14r = x1r + x2r;
        float y14i = x1i + x2i;
        x0r = a2[offa + 6] - a2[offa + 23];
        x0i = a2[offa + 7] + a2[offa + 22];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2[offa + 14] - a2[offa + 31];
        x0i = a2[offa + 15] + a2[offa + 30];
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        float y3r = x1r + x2r;
        float y3i = x1i + x2i;
        float y7r = x1r - x2r;
        float y7i = x1i - x2i;
        x0r = a2[offa + 6] + a2[offa + 23];
        x0i = a2[offa + 7] - a2[offa + 22];
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a2[offa + 14] + a2[offa + 31];
        x0i = a2[offa + 15] - a2[offa + 30];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        float y11r = x1r + x2r;
        float y11i = x1i + x2i;
        float y15r = x1r - x2r;
        float y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a2[offa] = x1r + x2r;
        a2[offa + 1] = x1i + x2i;
        a2[offa + 2] = x1r - x2r;
        a2[offa + 3] = x1i - x2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a2[offa + 4] = x1r - x2i;
        a2[offa + 5] = x1i + x2r;
        a2[offa + 6] = x1r + x2i;
        a2[offa + 7] = x1i - x2r;
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 8] = x1r + x2r;
        a2[offa + 9] = x1i + x2i;
        a2[offa + 10] = x1r - x2r;
        a2[offa + 11] = x1i - x2i;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 12] = x1r - x2i;
        a2[offa + 13] = x1i + x2r;
        a2[offa + 14] = x1r + x2i;
        a2[offa + 15] = x1i - x2r;
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a2[offa + 16] = x1r + x2r;
        a2[offa + 17] = x1i + x2i;
        a2[offa + 18] = x1r - x2r;
        a2[offa + 19] = x1i - x2i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a2[offa + 20] = x1r - x2i;
        a2[offa + 21] = x1i + x2r;
        a2[offa + 22] = x1r + x2i;
        a2[offa + 23] = x1i - x2r;
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 24] = x1r + x2r;
        a2[offa + 25] = x1i + x2i;
        a2[offa + 26] = x1r - x2r;
        a2[offa + 27] = x1i - x2i;
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2[offa + 28] = x1r - x2i;
        a2[offa + 29] = x1i + x2r;
        a2[offa + 30] = x1r + x2i;
        a2[offa + 31] = x1i - x2r;
    }

    public static void cftf162(FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        float wn4r = w2.getFloat(startw + 1L);
        float wk1r = w2.getFloat(startw + 4L);
        float wk1i = w2.getFloat(startw + 5L);
        float wk3r = w2.getFloat(startw + 6L);
        float wk3i = -w2.getFloat(startw + 7L);
        float wk2r = w2.getFloat(startw + 8L);
        float wk2i = w2.getFloat(startw + 9L);
        float x1r = a2.getFloat(offa) - a2.getFloat(offa + 17L);
        float x1i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 16L);
        float x0r = a2.getFloat(offa + 8L) - a2.getFloat(offa + 25L);
        float x0i = a2.getFloat(offa + 9L) + a2.getFloat(offa + 24L);
        float x2r = wn4r * (x0r - x0i);
        float x2i = wn4r * (x0i + x0r);
        float y0r = x1r + x2r;
        float y0i = x1i + x2i;
        float y4r = x1r - x2r;
        float y4i = x1i - x2i;
        x1r = a2.getFloat(offa) + a2.getFloat(offa + 17L);
        x1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 16L);
        x0r = a2.getFloat(offa + 8L) + a2.getFloat(offa + 25L);
        x0i = a2.getFloat(offa + 9L) - a2.getFloat(offa + 24L);
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        float y8r = x1r - x2i;
        float y8i = x1i + x2r;
        float y12r = x1r + x2i;
        float y12i = x1i - x2r;
        x0r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 19L);
        x0i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 18L);
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a2.getFloat(offa + 10L) - a2.getFloat(offa + 27L);
        x0i = a2.getFloat(offa + 11L) + a2.getFloat(offa + 26L);
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        float y1r = x1r + x2r;
        float y1i = x1i + x2i;
        float y5r = x1r - x2r;
        float y5i = x1i - x2i;
        x0r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 19L);
        x0i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 18L);
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2.getFloat(offa + 10L) + a2.getFloat(offa + 27L);
        x0i = a2.getFloat(offa + 11L) - a2.getFloat(offa + 26L);
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        float y9r = x1r - x2r;
        float y9i = x1i - x2i;
        float y13r = x1r + x2r;
        float y13i = x1i + x2i;
        x0r = a2.getFloat(offa + 4L) - a2.getFloat(offa + 21L);
        x0i = a2.getFloat(offa + 5L) + a2.getFloat(offa + 20L);
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a2.getFloat(offa + 12L) - a2.getFloat(offa + 29L);
        x0i = a2.getFloat(offa + 13L) + a2.getFloat(offa + 28L);
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        float y2r = x1r + x2r;
        float y2i = x1i + x2i;
        float y6r = x1r - x2r;
        float y6i = x1i - x2i;
        x0r = a2.getFloat(offa + 4L) + a2.getFloat(offa + 21L);
        x0i = a2.getFloat(offa + 5L) - a2.getFloat(offa + 20L);
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a2.getFloat(offa + 12L) + a2.getFloat(offa + 29L);
        x0i = a2.getFloat(offa + 13L) - a2.getFloat(offa + 28L);
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        float y10r = x1r - x2r;
        float y10i = x1i - x2i;
        float y14r = x1r + x2r;
        float y14i = x1i + x2i;
        x0r = a2.getFloat(offa + 6L) - a2.getFloat(offa + 23L);
        x0i = a2.getFloat(offa + 7L) + a2.getFloat(offa + 22L);
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a2.getFloat(offa + 14L) - a2.getFloat(offa + 31L);
        x0i = a2.getFloat(offa + 15L) + a2.getFloat(offa + 30L);
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        float y3r = x1r + x2r;
        float y3i = x1i + x2i;
        float y7r = x1r - x2r;
        float y7i = x1i - x2i;
        x0r = a2.getFloat(offa + 6L) + a2.getFloat(offa + 23L);
        x0i = a2.getFloat(offa + 7L) - a2.getFloat(offa + 22L);
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a2.getFloat(offa + 14L) + a2.getFloat(offa + 31L);
        x0i = a2.getFloat(offa + 15L) - a2.getFloat(offa + 30L);
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        float y11r = x1r + x2r;
        float y11i = x1i + x2i;
        float y15r = x1r - x2r;
        float y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a2.setFloat(offa, x1r + x2r);
        a2.setFloat(offa + 1L, x1i + x2i);
        a2.setFloat(offa + 2L, x1r - x2r);
        a2.setFloat(offa + 3L, x1i - x2i);
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a2.setFloat(offa + 4L, x1r - x2i);
        a2.setFloat(offa + 5L, x1i + x2r);
        a2.setFloat(offa + 6L, x1r + x2i);
        a2.setFloat(offa + 7L, x1i - x2r);
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setFloat(offa + 8L, x1r + x2r);
        a2.setFloat(offa + 9L, x1i + x2i);
        a2.setFloat(offa + 10L, x1r - x2r);
        a2.setFloat(offa + 11L, x1i - x2i);
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setFloat(offa + 12L, x1r - x2i);
        a2.setFloat(offa + 13L, x1i + x2r);
        a2.setFloat(offa + 14L, x1r + x2i);
        a2.setFloat(offa + 15L, x1i - x2r);
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a2.setFloat(offa + 16L, x1r + x2r);
        a2.setFloat(offa + 17L, x1i + x2i);
        a2.setFloat(offa + 18L, x1r - x2r);
        a2.setFloat(offa + 19L, x1i - x2i);
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a2.setFloat(offa + 20L, x1r - x2i);
        a2.setFloat(offa + 21L, x1i + x2r);
        a2.setFloat(offa + 22L, x1r + x2i);
        a2.setFloat(offa + 23L, x1i - x2r);
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setFloat(offa + 24L, x1r + x2r);
        a2.setFloat(offa + 25L, x1i + x2i);
        a2.setFloat(offa + 26L, x1r - x2r);
        a2.setFloat(offa + 27L, x1i - x2i);
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a2.setFloat(offa + 28L, x1r - x2i);
        a2.setFloat(offa + 29L, x1i + x2r);
        a2.setFloat(offa + 30L, x1r + x2i);
        a2.setFloat(offa + 31L, x1i - x2r);
    }

    public static void cftf081(float[] a2, int offa, float[] w2, int startw) {
        float wn4r = w2[startw + 1];
        float x0r = a2[offa] + a2[offa + 8];
        float x0i = a2[offa + 1] + a2[offa + 9];
        float x1r = a2[offa] - a2[offa + 8];
        float x1i = a2[offa + 1] - a2[offa + 9];
        float x2r = a2[offa + 4] + a2[offa + 12];
        float x2i = a2[offa + 5] + a2[offa + 13];
        float x3r = a2[offa + 4] - a2[offa + 12];
        float x3i = a2[offa + 5] - a2[offa + 13];
        float y0r = x0r + x2r;
        float y0i = x0i + x2i;
        float y2r = x0r - x2r;
        float y2i = x0i - x2i;
        float y1r = x1r - x3i;
        float y1i = x1i + x3r;
        float y3r = x1r + x3i;
        float y3i = x1i - x3r;
        x0r = a2[offa + 2] + a2[offa + 10];
        x0i = a2[offa + 3] + a2[offa + 11];
        x1r = a2[offa + 2] - a2[offa + 10];
        x1i = a2[offa + 3] - a2[offa + 11];
        x2r = a2[offa + 6] + a2[offa + 14];
        x2i = a2[offa + 7] + a2[offa + 15];
        x3r = a2[offa + 6] - a2[offa + 14];
        x3i = a2[offa + 7] - a2[offa + 15];
        float y4r = x0r + x2r;
        float y4i = x0i + x2i;
        float y6r = x0r - x2r;
        float y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        float y5r = wn4r * (x0r - x0i);
        float y5i = wn4r * (x0r + x0i);
        float y7r = wn4r * (x2r - x2i);
        float y7i = wn4r * (x2r + x2i);
        a2[offa + 8] = y1r + y5r;
        a2[offa + 9] = y1i + y5i;
        a2[offa + 10] = y1r - y5r;
        a2[offa + 11] = y1i - y5i;
        a2[offa + 12] = y3r - y7i;
        a2[offa + 13] = y3i + y7r;
        a2[offa + 14] = y3r + y7i;
        a2[offa + 15] = y3i - y7r;
        a2[offa] = y0r + y4r;
        a2[offa + 1] = y0i + y4i;
        a2[offa + 2] = y0r - y4r;
        a2[offa + 3] = y0i - y4i;
        a2[offa + 4] = y2r - y6i;
        a2[offa + 5] = y2i + y6r;
        a2[offa + 6] = y2r + y6i;
        a2[offa + 7] = y2i - y6r;
    }

    public static void cftf081(FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        float wn4r = w2.getFloat(startw + 1L);
        float x0r = a2.getFloat(offa) + a2.getFloat(offa + 8L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 9L);
        float x1r = a2.getFloat(offa) - a2.getFloat(offa + 8L);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 9L);
        float x2r = a2.getFloat(offa + 4L) + a2.getFloat(offa + 12L);
        float x2i = a2.getFloat(offa + 5L) + a2.getFloat(offa + 13L);
        float x3r = a2.getFloat(offa + 4L) - a2.getFloat(offa + 12L);
        float x3i = a2.getFloat(offa + 5L) - a2.getFloat(offa + 13L);
        float y0r = x0r + x2r;
        float y0i = x0i + x2i;
        float y2r = x0r - x2r;
        float y2i = x0i - x2i;
        float y1r = x1r - x3i;
        float y1i = x1i + x3r;
        float y3r = x1r + x3i;
        float y3i = x1i - x3r;
        x0r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 10L);
        x0i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 11L);
        x1r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 10L);
        x1i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 11L);
        x2r = a2.getFloat(offa + 6L) + a2.getFloat(offa + 14L);
        x2i = a2.getFloat(offa + 7L) + a2.getFloat(offa + 15L);
        x3r = a2.getFloat(offa + 6L) - a2.getFloat(offa + 14L);
        x3i = a2.getFloat(offa + 7L) - a2.getFloat(offa + 15L);
        float y4r = x0r + x2r;
        float y4i = x0i + x2i;
        float y6r = x0r - x2r;
        float y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        float y5r = wn4r * (x0r - x0i);
        float y5i = wn4r * (x0r + x0i);
        float y7r = wn4r * (x2r - x2i);
        float y7i = wn4r * (x2r + x2i);
        a2.setFloat(offa + 8L, y1r + y5r);
        a2.setFloat(offa + 9L, y1i + y5i);
        a2.setFloat(offa + 10L, y1r - y5r);
        a2.setFloat(offa + 11L, y1i - y5i);
        a2.setFloat(offa + 12L, y3r - y7i);
        a2.setFloat(offa + 13L, y3i + y7r);
        a2.setFloat(offa + 14L, y3r + y7i);
        a2.setFloat(offa + 15L, y3i - y7r);
        a2.setFloat(offa, y0r + y4r);
        a2.setFloat(offa + 1L, y0i + y4i);
        a2.setFloat(offa + 2L, y0r - y4r);
        a2.setFloat(offa + 3L, y0i - y4i);
        a2.setFloat(offa + 4L, y2r - y6i);
        a2.setFloat(offa + 5L, y2i + y6r);
        a2.setFloat(offa + 6L, y2r + y6i);
        a2.setFloat(offa + 7L, y2i - y6r);
    }

    public static void cftf082(float[] a2, int offa, float[] w2, int startw) {
        float wn4r = w2[startw + 1];
        float wk1r = w2[startw + 2];
        float wk1i = w2[startw + 3];
        float y0r = a2[offa] - a2[offa + 9];
        float y0i = a2[offa + 1] + a2[offa + 8];
        float y1r = a2[offa] + a2[offa + 9];
        float y1i = a2[offa + 1] - a2[offa + 8];
        float x0r = a2[offa + 4] - a2[offa + 13];
        float x0i = a2[offa + 5] + a2[offa + 12];
        float y2r = wn4r * (x0r - x0i);
        float y2i = wn4r * (x0i + x0r);
        x0r = a2[offa + 4] + a2[offa + 13];
        x0i = a2[offa + 5] - a2[offa + 12];
        float y3r = wn4r * (x0r - x0i);
        float y3i = wn4r * (x0i + x0r);
        x0r = a2[offa + 2] - a2[offa + 11];
        x0i = a2[offa + 3] + a2[offa + 10];
        float y4r = wk1r * x0r - wk1i * x0i;
        float y4i = wk1r * x0i + wk1i * x0r;
        x0r = a2[offa + 2] + a2[offa + 11];
        x0i = a2[offa + 3] - a2[offa + 10];
        float y5r = wk1i * x0r - wk1r * x0i;
        float y5i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 6] - a2[offa + 15];
        x0i = a2[offa + 7] + a2[offa + 14];
        float y6r = wk1i * x0r - wk1r * x0i;
        float y6i = wk1i * x0i + wk1r * x0r;
        x0r = a2[offa + 6] + a2[offa + 15];
        x0i = a2[offa + 7] - a2[offa + 14];
        float y7r = wk1r * x0r - wk1i * x0i;
        float y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        float x1r = y4r + y6r;
        float x1i = y4i + y6i;
        a2[offa] = x0r + x1r;
        a2[offa + 1] = x0i + x1i;
        a2[offa + 2] = x0r - x1r;
        a2[offa + 3] = x0i - x1i;
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a2[offa + 4] = x0r - x1i;
        a2[offa + 5] = x0i + x1r;
        a2[offa + 6] = x0r + x1i;
        a2[offa + 7] = x0i - x1r;
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a2[offa + 8] = x0r + x1r;
        a2[offa + 9] = x0i + x1i;
        a2[offa + 10] = x0r - x1r;
        a2[offa + 11] = x0i - x1i;
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a2[offa + 12] = x0r - x1i;
        a2[offa + 13] = x0i + x1r;
        a2[offa + 14] = x0r + x1i;
        a2[offa + 15] = x0i - x1r;
    }

    public static void cftf082(FloatLargeArray a2, long offa, FloatLargeArray w2, long startw) {
        float wn4r = w2.getFloat(startw + 1L);
        float wk1r = w2.getFloat(startw + 2L);
        float wk1i = w2.getFloat(startw + 3L);
        float y0r = a2.getFloat(offa) - a2.getFloat(offa + 9L);
        float y0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 8L);
        float y1r = a2.getFloat(offa) + a2.getFloat(offa + 9L);
        float y1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 8L);
        float x0r = a2.getFloat(offa + 4L) - a2.getFloat(offa + 13L);
        float x0i = a2.getFloat(offa + 5L) + a2.getFloat(offa + 12L);
        float y2r = wn4r * (x0r - x0i);
        float y2i = wn4r * (x0i + x0r);
        x0r = a2.getFloat(offa + 4L) + a2.getFloat(offa + 13L);
        x0i = a2.getFloat(offa + 5L) - a2.getFloat(offa + 12L);
        float y3r = wn4r * (x0r - x0i);
        float y3i = wn4r * (x0i + x0r);
        x0r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 11L);
        x0i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 10L);
        float y4r = wk1r * x0r - wk1i * x0i;
        float y4i = wk1r * x0i + wk1i * x0r;
        x0r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 11L);
        x0i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 10L);
        float y5r = wk1i * x0r - wk1r * x0i;
        float y5i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getFloat(offa + 6L) - a2.getFloat(offa + 15L);
        x0i = a2.getFloat(offa + 7L) + a2.getFloat(offa + 14L);
        float y6r = wk1i * x0r - wk1r * x0i;
        float y6i = wk1i * x0i + wk1r * x0r;
        x0r = a2.getFloat(offa + 6L) + a2.getFloat(offa + 15L);
        x0i = a2.getFloat(offa + 7L) - a2.getFloat(offa + 14L);
        float y7r = wk1r * x0r - wk1i * x0i;
        float y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        float x1r = y4r + y6r;
        float x1i = y4i + y6i;
        a2.setFloat(offa, x0r + x1r);
        a2.setFloat(offa + 1L, x0i + x1i);
        a2.setFloat(offa + 2L, x0r - x1r);
        a2.setFloat(offa + 3L, x0i - x1i);
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a2.setFloat(offa + 4L, x0r - x1i);
        a2.setFloat(offa + 5L, x0i + x1r);
        a2.setFloat(offa + 6L, x0r + x1i);
        a2.setFloat(offa + 7L, x0i - x1r);
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a2.setFloat(offa + 8L, x0r + x1r);
        a2.setFloat(offa + 9L, x0i + x1i);
        a2.setFloat(offa + 10L, x0r - x1r);
        a2.setFloat(offa + 11L, x0i - x1i);
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a2.setFloat(offa + 12L, x0r - x1i);
        a2.setFloat(offa + 13L, x0i + x1r);
        a2.setFloat(offa + 14L, x0r + x1i);
        a2.setFloat(offa + 15L, x0i - x1r);
    }

    public static void cftf040(float[] a2, int offa) {
        float x0r = a2[offa] + a2[offa + 4];
        float x0i = a2[offa + 1] + a2[offa + 5];
        float x1r = a2[offa] - a2[offa + 4];
        float x1i = a2[offa + 1] - a2[offa + 5];
        float x2r = a2[offa + 2] + a2[offa + 6];
        float x2i = a2[offa + 3] + a2[offa + 7];
        float x3r = a2[offa + 2] - a2[offa + 6];
        float x3i = a2[offa + 3] - a2[offa + 7];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x1r - x3i;
        a2[offa + 3] = x1i + x3r;
        a2[offa + 4] = x0r - x2r;
        a2[offa + 5] = x0i - x2i;
        a2[offa + 6] = x1r + x3i;
        a2[offa + 7] = x1i - x3r;
    }

    public static void cftf040(FloatLargeArray a2, long offa) {
        float x0r = a2.getFloat(offa) + a2.getFloat(offa + 4L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 5L);
        float x1r = a2.getFloat(offa) - a2.getFloat(offa + 4L);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 5L);
        float x2r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 6L);
        float x2i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 7L);
        float x3r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 7L);
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i + x2i);
        a2.setFloat(offa + 2L, x1r - x3i);
        a2.setFloat(offa + 3L, x1i + x3r);
        a2.setFloat(offa + 4L, x0r - x2r);
        a2.setFloat(offa + 5L, x0i - x2i);
        a2.setFloat(offa + 6L, x1r + x3i);
        a2.setFloat(offa + 7L, x1i - x3r);
    }

    public static void cftb040(float[] a2, int offa) {
        float x0r = a2[offa] + a2[offa + 4];
        float x0i = a2[offa + 1] + a2[offa + 5];
        float x1r = a2[offa] - a2[offa + 4];
        float x1i = a2[offa + 1] - a2[offa + 5];
        float x2r = a2[offa + 2] + a2[offa + 6];
        float x2i = a2[offa + 3] + a2[offa + 7];
        float x3r = a2[offa + 2] - a2[offa + 6];
        float x3i = a2[offa + 3] - a2[offa + 7];
        a2[offa] = x0r + x2r;
        a2[offa + 1] = x0i + x2i;
        a2[offa + 2] = x1r + x3i;
        a2[offa + 3] = x1i - x3r;
        a2[offa + 4] = x0r - x2r;
        a2[offa + 5] = x0i - x2i;
        a2[offa + 6] = x1r - x3i;
        a2[offa + 7] = x1i + x3r;
    }

    public static void cftb040(FloatLargeArray a2, long offa) {
        float x0r = a2.getFloat(offa) + a2.getFloat(offa + 4L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 5L);
        float x1r = a2.getFloat(offa) - a2.getFloat(offa + 4L);
        float x1i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 5L);
        float x2r = a2.getFloat(offa + 2L) + a2.getFloat(offa + 6L);
        float x2i = a2.getFloat(offa + 3L) + a2.getFloat(offa + 7L);
        float x3r = a2.getFloat(offa + 2L) - a2.getFloat(offa + 6L);
        float x3i = a2.getFloat(offa + 3L) - a2.getFloat(offa + 7L);
        a2.setFloat(offa, x0r + x2r);
        a2.setFloat(offa + 1L, x0i + x2i);
        a2.setFloat(offa + 2L, x1r + x3i);
        a2.setFloat(offa + 3L, x1i - x3r);
        a2.setFloat(offa + 4L, x0r - x2r);
        a2.setFloat(offa + 5L, x0i - x2i);
        a2.setFloat(offa + 6L, x1r - x3i);
        a2.setFloat(offa + 7L, x1i + x3r);
    }

    public static void cftx020(float[] a2, int offa) {
        float x0r = a2[offa] - a2[offa + 2];
        float x0i = -a2[offa + 1] + a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] + a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftx020(FloatLargeArray a2, long offa) {
        float x0r = a2.getFloat(offa) - a2.getFloat(offa + 2L);
        float x0i = -a2.getFloat(offa + 1L) + a2.getFloat(offa + 3L);
        a2.setFloat(offa, a2.getFloat(offa) + a2.getFloat(offa + 2L));
        a2.setFloat(offa + 1L, a2.getFloat(offa + 1L) + a2.getFloat(offa + 3L));
        a2.setFloat(offa + 2L, x0r);
        a2.setFloat(offa + 3L, x0i);
    }

    public static void cftxb020(float[] a2, int offa) {
        float x0r = a2[offa] - a2[offa + 2];
        float x0i = a2[offa + 1] - a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] + a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftxb020(FloatLargeArray a2, long offa) {
        float x0r = a2.getFloat(offa) - a2.getFloat(offa + 2L);
        float x0i = a2.getFloat(offa + 1L) - a2.getFloat(offa + 3L);
        a2.setFloat(offa, a2.getFloat(offa) + a2.getFloat(offa + 2L));
        a2.setFloat(offa + 1L, a2.getFloat(offa + 1L) + a2.getFloat(offa + 3L));
        a2.setFloat(offa + 2L, x0r);
        a2.setFloat(offa + 3L, x0i);
    }

    public static void cftxc020(float[] a2, int offa) {
        float x0r = a2[offa] - a2[offa + 2];
        float x0i = a2[offa + 1] + a2[offa + 3];
        int n2 = offa;
        a2[n2] = a2[n2] + a2[offa + 2];
        int n3 = offa + 1;
        a2[n3] = a2[n3] - a2[offa + 3];
        a2[offa + 2] = x0r;
        a2[offa + 3] = x0i;
    }

    public static void cftxc020(FloatLargeArray a2, long offa) {
        float x0r = a2.getFloat(offa) - a2.getFloat(offa + 2L);
        float x0i = a2.getFloat(offa + 1L) + a2.getFloat(offa + 3L);
        a2.setFloat(offa, a2.getFloat(offa) + a2.getFloat(offa + 2L));
        a2.setFloat(offa + 1L, a2.getFloat(offa + 1L) - a2.getFloat(offa + 3L));
        a2.setFloat(offa + 2L, x0r);
        a2.setFloat(offa + 3L, x0i);
    }

    public static void rftfsub(int n2, float[] a2, int offa, int nc, float[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            float wkr = 0.5f - c2[startc + nc - (kk += ks)];
            float wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            float xr = a2[idx1] - a2[idx2];
            float xi = a2[idx1 + 1] + a2[idx2 + 1];
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            a2[idx1 + 1] = yi - a2[idx1 + 1];
            int n4 = idx2;
            a2[n4] = a2[n4] + yr;
            a2[idx2 + 1] = yi - a2[idx2 + 1];
        }
        a2[offa + m4 + 1] = -a2[offa + m4 + 1];
    }

    public static void rftfsub(long n2, FloatLargeArray a2, long offa, long nc, FloatLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            float wkr = 0.5f - c2.getFloat(startc + nc - (kk += ks));
            float wki = c2.getFloat(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            float xr = a2.getFloat(idx1) - a2.getFloat(idx2);
            float xi = a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L);
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            a2.setFloat(idx1, a2.getFloat(idx1) - yr);
            a2.setFloat(idx1 + 1L, yi - a2.getFloat(idx1 + 1L));
            a2.setFloat(idx2, a2.getFloat(idx2) + yr);
            a2.setFloat(idx2 + 1L, yi - a2.getFloat(idx2 + 1L));
        }
        a2.setFloat(offa + m4 + 1L, -a2.getFloat(offa + m4 + 1L));
    }

    public static void rftbsub(int n2, float[] a2, int offa, int nc, float[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j2 = 2; j2 < m4; j2 += 2) {
            int k2 = n2 - j2;
            float wkr = 0.5f - c2[startc + nc - (kk += ks)];
            float wki = c2[startc + kk];
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            float xr = a2[idx1] - a2[idx2];
            float xi = a2[idx1 + 1] + a2[idx2 + 1];
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a2[n3] = a2[n3] - yr;
            int n4 = idx1 + 1;
            a2[n4] = a2[n4] - yi;
            int n5 = idx2;
            a2[n5] = a2[n5] + yr;
            int n6 = idx2 + 1;
            a2[n6] = a2[n6] - yi;
        }
    }

    public static void rftbsub(long n2, FloatLargeArray a2, long offa, long nc, FloatLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j2 = 2L; j2 < m4; j2 += 2L) {
            long k2 = n2 - j2;
            float wkr = 0.5f - c2.getFloat(startc + nc - (kk += ks));
            float wki = c2.getFloat(startc + kk);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            float xr = a2.getFloat(idx1) - a2.getFloat(idx2);
            float xi = a2.getFloat(idx1 + 1L) + a2.getFloat(idx2 + 1L);
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            a2.setFloat(idx1, a2.getFloat(idx1) - yr);
            a2.setFloat(idx1 + 1L, a2.getFloat(idx1 + 1L) - yi);
            a2.setFloat(idx2, a2.getFloat(idx2) + yr);
            a2.setFloat(idx2 + 1L, a2.getFloat(idx2 + 1L) - yi);
        }
    }

    public static void dctsub(int n2, float[] a2, int offa, int nc, float[] c2, int startc) {
        int m4 = n2 >> 1;
        int ks = nc / n2;
        int kk = 0;
        for (int j2 = 1; j2 < m4; ++j2) {
            int k2 = n2 - j2;
            int idx0 = startc + (kk += ks);
            int idx1 = offa + j2;
            int idx2 = offa + k2;
            float wkr = c2[idx0] - c2[startc + nc - kk];
            float wki = c2[idx0] + c2[startc + nc - kk];
            float xr = wki * a2[idx1] - wkr * a2[idx2];
            a2[idx1] = wkr * a2[idx1] + wki * a2[idx2];
            a2[idx2] = xr;
        }
        int n3 = offa + m4;
        a2[n3] = a2[n3] * c2[startc];
    }

    public static void dctsub(long n2, FloatLargeArray a2, long offa, long nc, FloatLargeArray c2, long startc) {
        long m4 = n2 >> 1;
        long ks = nc / n2;
        long kk = 0L;
        for (long j2 = 1L; j2 < m4; ++j2) {
            long k2 = n2 - j2;
            long idx0 = startc + (kk += ks);
            long idx1 = offa + j2;
            long idx2 = offa + k2;
            float wkr = c2.getFloat(idx0) - c2.getFloat(startc + nc - kk);
            float wki = c2.getFloat(idx0) + c2.getFloat(startc + nc - kk);
            float xr = wki * a2.getFloat(idx1) - wkr * a2.getFloat(idx2);
            a2.setFloat(idx1, wkr * a2.getFloat(idx1) + wki * a2.getFloat(idx2));
            a2.setFloat(idx2, xr);
        }
        a2.setFloat(offa + m4, a2.getFloat(offa + m4) * c2.getFloat(startc));
    }

    public static void scale(int n2, final double m4, final double[] a2, int offa, boolean complex) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int n22 = complex ? 2 * n2 : n2;
        if (nthreads > 1 && (long)n22 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k2 = n22 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final int firstIdx = offa + i2 * k2;
                final int lastIdx = i2 == nthreads - 1 ? offa + n22 : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int n2 = i2++;
                            a2[n2] = a2[n2] * m4;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int firstIdx = offa;
            int lastIdx = offa + n22;
            int i3 = firstIdx;
            while (i3 < lastIdx) {
                int n3 = i3++;
                a2[n3] = a2[n3] * m4;
            }
        }
    }

    public static void scale(long nl, final double m4, final DoubleLargeArray a2, long offa, boolean complex) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        long n2 = complex ? 2L * nl : nl;
        if (nthreads > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long k2 = n2 / (long)nthreads;
            Future[] futures = new Future[nthreads];
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final long firstIdx = offa + (long)i2 * k2;
                final long lastIdx = i2 == nthreads - 1 ? offa + n2 : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            a2.setDouble(i2, a2.getDouble(i2) * m4);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (long i3 = offa; i3 < offa + n2; ++i3) {
                a2.setDouble(i3, a2.getDouble(i3) * m4);
            }
        }
    }

    public static void scale(int n2, final float m4, final float[] a2, int offa, boolean complex) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int n22 = complex ? 2 * n2 : n2;
        if (nthreads > 1 && (long)n22 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k2 = n22 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final int firstIdx = offa + i2 * k2;
                final int lastIdx = i2 == nthreads - 1 ? offa + n22 : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int n2 = i2++;
                            a2[n2] = a2[n2] * m4;
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int firstIdx = offa;
            int lastIdx = offa + n22;
            int i3 = firstIdx;
            while (i3 < lastIdx) {
                int n3 = i3++;
                a2[n3] = a2[n3] * m4;
            }
        }
    }

    public static void scale(long nl, final float m4, final FloatLargeArray a2, long offa, boolean complex) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        long n2 = complex ? 2L * nl : nl;
        if (nthreads > 1 && n2 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long k2 = n2 / (long)nthreads;
            Future[] futures = new Future[nthreads];
            for (int i2 = 0; i2 < nthreads; ++i2) {
                final long firstIdx = offa + (long)i2 * k2;
                final long lastIdx = i2 == nthreads - 1 ? offa + n2 : firstIdx + k2;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                            a2.setDouble(i2, a2.getDouble(i2) * (double)m4);
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (long i3 = offa; i3 < offa + n2; ++i3) {
                a2.setDouble(i3, a2.getDouble(i3) * (double)m4);
            }
        }
    }
}

