/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class DoubleDHT_1D {
    private final int n;
    private final long nl;
    private final DoubleFFT_1D fft;
    private final boolean useLargeArrays;

    public DoubleDHT_1D(long n2) {
        this.n = (int)n2;
        this.nl = n2;
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || n2 > (long)LargeArray.getMaxSizeOf32bitArray();
        this.fft = new DoubleFFT_1D(n2);
    }

    public void forward(double[] a2) {
        this.forward(a2, 0);
    }

    public void forward(DoubleLargeArray a2) {
        this.forward(a2, 0L);
    }

    public void forward(final double[] a2, final int offa) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(a2), (long)offa);
        } else {
            this.fft.realForward(a2, offa);
            final double[] b2 = new double[this.n];
            System.arraycopy(a2, offa, b2, 0, this.n);
            int nd2 = this.n / 2;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && (long)nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k1 = nd2 / nthreads;
                Future[] futures = new Future[nthreads];
                for (int i2 = 0; i2 < nthreads; ++i2) {
                    final int firstIdx = 1 + i2 * k1;
                    final int lastIdx = i2 == nthreads - 1 ? nd2 : firstIdx + k1;
                    futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstIdx; i2 < lastIdx; ++i2) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                a2[offa + i2] = b2[idx1] - b2[idx2];
                                a2[offa + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i2] = b2[idx1] + b2[idx2];
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i3 = 1; i3 < nd2; ++i3) {
                    int idx1 = 2 * i3;
                    int idx2 = idx1 + 1;
                    a2[offa + i3] = b2[idx1] - b2[idx2];
                    a2[offa + this.n - i3] = b2[idx1] + b2[idx2];
                }
            }
            if (this.n % 2 == 0) {
                a2[offa + nd2] = b2[1];
            } else {
                a2[offa + nd2] = b2[this.n - 1] - b2[1];
                a2[offa + nd2 + 1] = b2[this.n - 1] + b2[1];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray a2, final long offa) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(a2.getData(), (int)offa);
            return;
        } else {
            this.fft.realForward(a2, offa);
            final DoubleLargeArray b2 = new DoubleLargeArray(this.nl, false);
            LargeArrayUtils.arraycopy(a2, offa, b2, 0L, this.nl);
            long nd2 = this.nl / 2L;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && nd2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k1 = nd2 / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int i2 = 0; i2 < nthreads; ++i2) {
                    final long firstIdx = 1L + (long)i2 * k1;
                    final long lastIdx = i2 == nthreads - 1 ? nd2 : firstIdx + k1;
                    futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i2 = firstIdx; i2 < lastIdx; ++i2) {
                                long idx1 = 2L * i2;
                                long idx2 = idx1 + 1L;
                                a2.setDouble(offa + i2, b2.getDouble(idx1) - b2.getDouble(idx2));
                                a2.setDouble(offa + DoubleDHT_1D.this.nl - i2, b2.getDouble(idx1) + b2.getDouble(idx2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i3 = 1L; i3 < nd2; ++i3) {
                    long idx1 = 2L * i3;
                    long idx2 = idx1 + 1L;
                    a2.setDouble(offa + i3, b2.getDouble(idx1) - b2.getDouble(idx2));
                    a2.setDouble(offa + this.nl - i3, b2.getDouble(idx1) + b2.getDouble(idx2));
                }
            }
            if (this.nl % 2L == 0L) {
                a2.setDouble(offa + nd2, b2.getDouble(1L));
                return;
            } else {
                a2.setDouble(offa + nd2, b2.getDouble(this.nl - 1L) - b2.getDouble(1L));
                a2.setDouble(offa + nd2 + 1L, b2.getDouble(this.nl - 1L) + b2.getDouble(1L));
            }
        }
    }

    public void inverse(double[] a2, boolean scale) {
        this.inverse(a2, 0, scale);
    }

    public void inverse(DoubleLargeArray a2, boolean scale) {
        this.inverse(a2, 0L, scale);
    }

    public void inverse(double[] a2, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(a2), (long)offa, scale);
        } else {
            this.forward(a2, offa);
            if (scale) {
                CommonUtils.scale(this.n, 1.0 / (double)this.n, a2, offa, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(DoubleLargeArray a2, long offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a2.isLarge() || a2.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(a2.getData(), (int)offa, scale);
            return;
        } else {
            this.forward(a2, offa);
            if (!scale) return;
            CommonUtils.scale((long)this.n, 1.0 / (double)this.n, a2, offa, false);
        }
    }
}

