/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.util.Map;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class CopyObjectsEvent
extends ServiceEvent {
    private Map[] results = null;
    private S3Object[] copyCancelledObjects = null;
    private S3Object[] destinationObjects = null;
    private String[] sourceObjectKeys = null;

    private CopyObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static CopyObjectsEvent newErrorEvent(Throwable t2, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t2);
        return event;
    }

    public static CopyObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CopyObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, Map[] completedResults, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setResults(completedResults);
        return event;
    }

    public static CopyObjectsEvent newCompletedEvent(Object uniqueOperationId, String[] sourceObjectKeys, S3Object[] destinationObjects) {
        CopyObjectsEvent event = new CopyObjectsEvent(2, uniqueOperationId);
        event.setDestinationObjects(destinationObjects);
        event.setSourceObjectKeys(sourceObjectKeys);
        return event;
    }

    public static CopyObjectsEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(4, uniqueOperationId);
        event.setCopyCancelledObjects(incompletedObjects);
        return event;
    }

    public static CopyObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setResults(Map[] results) {
        this.results = results;
    }

    private void setSourceObjectKeys(String[] sourceObjectKeys) {
        this.sourceObjectKeys = sourceObjectKeys;
    }

    private void setCopyCancelledObjects(S3Object[] objects) {
        this.copyCancelledObjects = objects;
    }

    private void setDestinationObjects(S3Object[] objects) {
        this.destinationObjects = objects;
    }

    public Map[] getCopyResults() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Copy results are only available from EVENT_IN_PROGRESS events");
        }
        return this.results;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are only available from EVENT_CANCELLED events");
        }
        return this.copyCancelledObjects;
    }

    public S3Object[] getCopiedObjects() throws IllegalStateException {
        if (this.getEventCode() != 2) {
            throw new IllegalStateException("Cancelled Objects are only available from EVENT_COMPLETED events");
        }
        return this.destinationObjects;
    }

    public String[] getSourceObjectKeys() throws IllegalStateException {
        if (this.getEventCode() != 2) {
            throw new IllegalStateException("Source Objects are only available from EVENT_COMPLETED events");
        }
        return this.sourceObjectKeys;
    }
}

