/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.GZipInflatingOutputStream;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.EncryptionUtil;

public class DownloadPackage {
    private static final Log log = LogFactory.getLog(DownloadPackage.class);
    protected StorageObject object = null;
    protected File outputFile = null;
    protected OutputStream outputStream = null;
    protected boolean isUnzipping = false;
    protected EncryptionUtil encryptionUtil = null;
    private boolean appendToFile = false;

    public DownloadPackage(StorageObject object, File outputFile) {
        this(object, outputFile, false, null);
    }

    public DownloadPackage(StorageObject object, File outputFile, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputFile = outputFile;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public DownloadPackage(StorageObject object, OutputStream outputStream) {
        this(object, outputStream, false, null);
    }

    public DownloadPackage(StorageObject object, OutputStream outputStream, boolean isUnzipping, EncryptionUtil encryptionUtil) {
        this.object = object;
        this.outputStream = outputStream;
        this.isUnzipping = isUnzipping;
        this.encryptionUtil = encryptionUtil;
    }

    public StorageObject getObject() {
        return this.object;
    }

    public void setObject(StorageObject object) {
        this.object = object;
    }

    public File getDataFile() {
        return this.outputFile;
    }

    public boolean isAppendToFile() {
        return this.appendToFile;
    }

    public void setAppendToFile(boolean appendToFile) {
        this.appendToFile = appendToFile;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = null;
        if (this.outputFile != null) {
            if (this.outputFile.getParentFile() != null) {
                this.outputFile.getParentFile().mkdirs();
            }
            outputStream = new FileOutputStream(this.outputFile, this.appendToFile);
        } else {
            outputStream = this.outputStream;
        }
        if (this.isUnzipping) {
            log.debug((Object)("Inflating gzipped data for object: " + this.object.getKey()));
            outputStream = new GZipInflatingOutputStream(outputStream);
        }
        if (this.encryptionUtil != null) {
            log.debug((Object)("Decrypting encrypted data for object: " + this.object.getKey()));
            try {
                outputStream = this.encryptionUtil.decrypt(outputStream);
            }
            catch (InvalidKeyException e2) {
                IOException exception = new IOException(e2.getMessage());
                exception.initCause(e2);
                throw exception;
            }
            catch (InvalidAlgorithmParameterException e3) {
                IOException exception = new IOException(e3.getMessage());
                exception.initCause(e3);
                throw exception;
            }
            catch (NoSuchAlgorithmException e4) {
                IOException exception = new IOException(e4.getMessage());
                exception.initCause(e4);
                throw exception;
            }
            catch (NoSuchPaddingException e5) {
                IOException exception = new IOException(e5.getMessage());
                exception.initCause(e5);
                throw exception;
            }
        }
        return outputStream;
    }
}

