/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.InputStreamWrapper;

public class ProgressMonitoredInputStream
extends InputStream
implements InputStreamWrapper {
    private InputStream inputStream = null;
    protected BytesProgressWatcher progressWatcher = null;

    public ProgressMonitoredInputStream(InputStream inputStream, BytesProgressWatcher progressWatcher) {
        if (inputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredInputStream cannot run with a null InputStream");
        }
        this.inputStream = inputStream;
        this.progressWatcher = progressWatcher;
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        this.progressWatcher.updateBytesTransferred(bytesTransmitted);
    }

    public void resetProgressMonitor() {
        this.progressWatcher.resetWatcher();
    }

    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read != -1) {
            this.sendNotificationUpdate(1L);
        }
        return read;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int read = this.inputStream.read(b2, off, len);
        if (read != -1) {
            this.sendNotificationUpdate(read);
        }
        return read;
    }

    public int read(byte[] b2) throws IOException {
        int read = this.inputStream.read(b2);
        if (read != -1) {
            this.sendNotificationUpdate(read);
        }
        return read;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.inputStream.close();
        }
        finally {
            this.progressWatcher.clearHistory();
        }
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

