/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o.backends.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.h2o.backends.internal.RpcReferenceCache$;
import org.apache.spark.h2o.backends.internal.SpreadRDDBuilder$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\r\u001b\u0001\u00012\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011B\u001b\t\u0011}\u0002!\u0011!Q\u0001\nYB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0013A\u0006B\u0002/\u0001A\u0003%\u0011\fC\u0004^\u0001\t\u0007I\u0011\u00010\t\r\r\u0004\u0001\u0015!\u0003`\u0011\u001d!\u0007A1A\u0005\n\u0015DaA\u001a\u0001!\u0002\u0013)\u0005\"B4\u0001\t\u0003A\u0007\"B4\u0001\t\u0013\u0011\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t9\u0002\u0001C\u0005\u00033A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?9!\"!\u000b\u001b\u0003\u0003E\t\u0001IA\u0016\r%I\"$!A\t\u0002\u0001\ni\u0003\u0003\u0004L+\u0011\u0005\u0011Q\u0007\u0005\n\u0003o)\u0012\u0013!C\u0001\u0003sA\u0011\"a\u0013\u0016\u0003\u0003%I!!\u0014\u0003!M\u0003(/Z1e%\u0012#%)^5mI\u0016\u0014(BA\u000e\u001d\u0003!Ig\u000e^3s]\u0006d'BA\u000f\u001f\u0003!\u0011\u0017mY6f]\u0012\u001c(BA\u0010!\u0003\rA'g\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sON\u0019\u0001aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g!\tq\u0013'D\u00010\u0015\t\u0001\u0004%\u0001\u0004fqB|7/Z\u0005\u0003e=\u0012q\u0001T8hO&tw-\u0001\u0002iG\u000e\u0001Q#\u0001\u001c\u0011\u0005]jT\"\u0001\u001d\u000b\u0005eR\u0014!C:qCJ\\G.\u001b8h\u0015\ty2HC\u0001=\u0003\t\t\u0017.\u0003\u0002?q\tQ\u0001JM(D_:$X\r\u001f;\u0002\u0007!\u001c\u0007\u0005\u000b\u0002\u0003\u0003B\u0011\u0001FQ\u0005\u0003\u0007&\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001f9,X.\u0012=fGV$xN\u001d%j]R\u00042\u0001\u000b$I\u0013\t9\u0015F\u0001\u0004PaRLwN\u001c\t\u0003Q%K!AS\u0015\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004\u001b>\u0003\u0006C\u0001(\u0001\u001b\u0005Q\u0002\"B\u001a\u0005\u0001\u00041\u0004b\u0002#\u0005!\u0003\u0005\r!R\u0001\u0005G>tg-F\u0001T!\t9D+\u0003\u0002Vq\t9\u0001JM(D_:4\u0017!B2p]\u001a\u0004\u0013aB5t\u0019>\u001c\u0017\r\\\u000b\u00023B\u0011\u0001FW\u0005\u00037&\u0012qAQ8pY\u0016\fg.\u0001\u0005jg2{7-\u00197!\u0003%\u0019\b/\u0019:l\u0007>tg-F\u0001`!\t\u0001\u0017-D\u0001!\u0013\t\u0011\u0007EA\u0005Ta\u0006\u00148nQ8oM\u0006Q1\u000f]1sW\u000e{gN\u001a\u0011\u0002\u00199,X.\u0012=fGV$xN]:\u0016\u0003\u0015\u000bQB\\;n\u000bb,7-\u001e;peN\u0004\u0013!\u00022vS2$G#A5\u0011\u0007!RG.\u0003\u0002lS\t)\u0011I\u001d:bsB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eI\u0001\u0004eB\u001c\u0017BA9o\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a$B![:vo\")AO\u0004a\u0001\u0011\u0006AaN]3ue&,7\u000fC\u0003w\u001d\u0001\u0007\u0001*A\u0004nM\u0006\u001cGo\u001c:\t\u000bat\u0001\u0019\u0001%\u0002\u00199,X\u000e\u0016:jKN\u001c\u0016-\\3)\u00059Q\bCA>\u007f\u001b\u0005a(BA?*\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fr\u0014q\u0001^1jYJ,7-\u0001\buS6,w.\u001e;FqBL'/\u001a3\u0015\u000be\u000b)!a\u0004\t\u000f\u0005\u001dq\u00021\u0001\u0002\n\u0005I1\u000f^1siRKW.\u001a\t\u0004Q\u0005-\u0011bAA\u0007S\t!Aj\u001c8h\u0011\u0019\t\tb\u0004a\u0001\u0011\u00069A/[7f_V$\u0018a\u00058v[>37\u000b]1sW\u0016CXmY;u_J\u001cX#\u0001%\u0002\u001d%\u001c()Y2lK:$'+Z1esR\t\u0011,\u0001\u0002tGV\u0011\u0011q\u0004\t\u0004A\u0006\u0005\u0012bAA\u0012A\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00191o\u0019\u0011)\u0005M\t\u0015\u0001E*qe\u0016\fGM\u0015#E\u0005VLG\u000eZ3s!\tqUc\u0005\u0003\u0016O\u0005=\u0002c\u0001\u0015\u00022%\u0019\u00111G\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005-\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002<)\u001aQ)!\u0010,\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015C0A\u0005v]\u000eDWmY6fI&!\u0011\u0011JA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013\u0001\u00027b]\u001eT!!!\u0017\u0002\t)\fg/Y\u0005\u0005\u0003;\n\u0019F\u0001\u0004PE*,7\r\u001e")
public class SpreadRDDBuilder
implements org.apache.spark.expose.Logging {
    private final transient H2OContext hc;
    private final Option<Object> numExecutorHint;
    private final H2OConf conf;
    private final boolean isLocal;
    private final SparkConf sparkConf;
    private final Option<Object> numExecutors;
    private final transient SparkContext sc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Object> $lessinit$greater$default$2() {
        return SpreadRDDBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private H2OContext hc() {
        return this.hc;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private H2OConf conf() {
        return this.conf;
    }

    private boolean isLocal() {
        return this.isLocal;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    private Option<Object> numExecutors() {
        return this.numExecutors;
    }

    public RpcEndpointRef[] build() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Building SpreadRDD: numExecutors=").append(this.numExecutors()).append(", numExecutorHint=").append($this.numExecutorHint).toString());
        return this.build(this.conf().numRddRetries(), this.conf().drddMulFactor(), 0);
    }

    private RpcEndpointRef[] build(int nretries, int mfactor, int numTriesSame) {
        int currentWorkers;
        RpcEndpointRef[] endpoints;
        int expectedWorkers;
        while (true) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Creating RDD for launching H2O nodes (mretries=").append(nretries).append(", mfactor=").append(mfactor).append(", ").append("numTriesSame=").append(numTriesSame).append(", backend#isReady=").append(this.isBackendReady()).toString());
            int nSparkExecBefore = this.numOfSparkExecutors();
            expectedWorkers = BoxesRunTime.unboxToInt((Object)this.numExecutors().orElse((Function0 & Serializable & scala.Serializable)() -> $this.numExecutorHint).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> nSparkExecBefore > 0 ? nSparkExecBefore : this.conf().defaultCloudSize()));
            RDD spreadRDD = this.sc().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mfactor * expectedWorkers), mfactor * expectedWorkers + 1, ClassTag$.MODULE$.Int());
            endpoints = (RpcEndpointRef[])spreadRDD.mapPartitions((Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.Iterator().single((Object)RpcReferenceCache$.MODULE$.getRef(this.sparkConf())), spreadRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(RpcEndpointRef.class)).distinct().collect();
            currentWorkers = endpoints.length;
            int nSparkExecAfter = this.numOfSparkExecutors();
            int timeout = this.conf().spreadRddRetriesTimeout();
            long startTime = System.currentTimeMillis();
            if ((currentWorkers < expectedWorkers || nSparkExecAfter != nSparkExecBefore) && nretries <= 0 && this.timeoutExpired(startTime, timeout)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("Cannot execute H2O on all Spark executors:\n           | Expected number of H2O workers is ").append(this.numExecutorHint).append("\n           | Detected number of Spark workers is ").append(currentWorkers).append("\n           | Num of Spark executors before is ").append(nSparkExecBefore).append("\n           | Num of Spark executors after is ").append(nSparkExecAfter).append("\n           |").toString())).stripMargin());
            }
            if (nSparkExecAfter != nSparkExecBefore || nSparkExecAfter != currentWorkers) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Detected ").append(nSparkExecBefore).append(" before, and ").append(nSparkExecAfter).append(" Spark executors after, backend#isReady=").append(this.isBackendReady()).append("! Retrying again...").toString());
                numTriesSame = 0;
                mfactor = 2 * mfactor;
                --nretries;
                continue;
            }
            if (numTriesSame >= this.conf().subseqTries() && this.timeoutExpired(startTime, timeout) || this.numExecutors().isEmpty() && currentWorkers == expectedWorkers || this.numExecutors().isDefined() && BoxesRunTime.unboxToInt((Object)this.numExecutors().get()) == currentWorkers) break;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Detected ").append(currentWorkers).append(" spark executors for ").append(expectedWorkers).append(" H2O workers, backend#isReady=").append(this.isBackendReady()).append("! Retrying again...").toString());
            ++numTriesSame;
            --nretries;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Detected ").append(currentWorkers).append(" spark executors for ").append(expectedWorkers).append(" H2O workers!").toString());
        return endpoints;
    }

    private boolean timeoutExpired(long startTime, int timeout) {
        return System.currentTimeMillis() - startTime > (long)timeout;
    }

    private int numOfSparkExecutors() {
        int n2;
        if (this.isLocal()) {
            n2 = 1;
        } else {
            int n3;
            SchedulerBackend sb = this.sc().schedulerBackend();
            SchedulerBackend schedulerBackend = sb;
            if (schedulerBackend instanceof LocalSchedulerBackend) {
                n3 = 1;
            } else if (schedulerBackend instanceof CoarseGrainedSchedulerBackend) {
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = (CoarseGrainedSchedulerBackend)schedulerBackend;
                n3 = coarseGrainedSchedulerBackend.getExecutorIds().length();
            } else {
                n3 = SparkEnv$.MODULE$.get().blockManager().master().getStorageStatus().length - 1;
            }
            n2 = n3;
        }
        return n2;
    }

    private boolean isBackendReady() {
        return this.sc().schedulerBackend().isReady();
    }

    public SpreadRDDBuilder(H2OContext hc, Option<Object> numExecutorHint) {
        this.hc = hc;
        this.numExecutorHint = numExecutorHint;
        Logging.$init$((Logging)this);
        this.sc = hc.sparkContext();
        this.conf = hc.getConf();
        this.isLocal = this.sc().isLocal();
        this.sparkConf = this.sc().conf();
        this.numExecutors = this.conf().numH2OWorkers();
    }
}

